/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.jni;

import bleep.internal.FileUtils$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.package;
import bleep.package$;
import bleep.plugin.jni.BuildTool;
import bleep.plugin.jni.CMake;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Text;

public final class CMake$
implements BuildTool {
    public static final CMake$ MODULE$ = new CMake$();
    private static final String name = "CMake";

    @Override
    public String name() {
        return name;
    }

    public String template(String libName) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1537).append("################################################################\n      |# A minimal CMake file that is compatible with sbt-jni         #\n      |#                                                              #\n      |# All settings required by sbt-jni have been marked so, please #\n      |# add/modify/remove settings to build your specific library.   #\n      |################################################################\n      |\n      |cmake_minimum_required(VERSION 3.12)\n      |\n      |option(SBT \"Set if invoked from sbt-jni\" OFF)\n      |\n      |# Define project and related variables\n      |# (required by sbt-jni) please use semantic versioning\n      |#\n      |project (").append(libName).append(")\n      |set(PROJECT_VERSION_MAJOR 0)\n      |set(PROJECT_VERSION_MINOR 0)\n      |set(PROJECT_VERSION_PATCH 0)\n      |\n      |# Setup JNI\n      |find_package(JNI REQUIRED)\n      |if (JNI_FOUND)\n      |    message (STATUS \"JNI include directories: ${JNI_INCLUDE_DIRS}\")\n      |endif()\n      |\n      |# Include directories\n      |include_directories(.)\n      |include_directories(include)\n      |include_directories(${JNI_INCLUDE_DIRS})\n      |\n      |# Sources\n      |file(GLOB LIB_SRC\n      |  \"*.c\"\n      |  \"*.cc\"\n      |  \"*.cpp\"\n      |)\n      |\n      |# Setup installation targets\n      |# (required by sbt-jni) major version should always be appended to library name\n      |#\n      |set (LIB_NAME ${PROJECT_NAME}${PROJECT_VERSION_MAJOR})\n      |add_library(${LIB_NAME} SHARED ${LIB_SRC})\n      |install(TARGETS ${LIB_NAME} LIBRARY DESTINATION .)\n      |").toString()));
    }

    @Override
    public void ensureHasBuildFile(Path sourceDirectory, TypedLogger<BoxedUnit> logger, String libName) {
        Object object;
        Path buildScript = package.PathOps$.MODULE$.$div$extension(package$.MODULE$.PathOps(sourceDirectory), "CMakeLists.txt");
        if (FileUtils$.MODULE$.exists(buildScript)) {
            object = BoxedUnit.UNIT;
        } else {
            LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger.withContext(new Text((Object)buildScript, "buildScript"), Formatter$.MODULE$.PathFormatter())), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(35).append("Initialized empty build script for ").append(MODULE$.name()).toString(), "s\"Initialized empty build script for $name\""), Formatter$.MODULE$.StringFormatter(), new Line(64), new File("/home/runner/work/bleep/bleep/liberated/sbt-jni/plugin/src/main/scala/bleep/plugin/jni/CMake.scala"), new Enclosing("bleep.plugin.jni.CMake.ensureHasBuildFile"));
            Files.createDirectories(buildScript.getParent(), new FileAttribute[0]);
            object = Files.writeString(buildScript, (CharSequence)this.template(libName), new OpenOption[0]);
        }
    }

    @Override
    public BuildTool.Instance getInstance(Path baseDir, Path buildDir, TypedLogger<BoxedUnit> logger, List<Tuple2<String, String>> env) {
        return new CMake.Instance(baseDir, buildDir, logger, env);
    }

    private CMake$() {
    }
}

