/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.jni.javah.search;

import com.github.sbt.jni.javah.ClassName;
import com.github.sbt.jni.javah.search.SearchPath;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;

public class RuntimeSearchPath
implements SearchPath {
    public static final RuntimeSearchPath INSTANCE = new RuntimeSearchPath();

    private RuntimeSearchPath() {
    }

    @Override
    public Path search(ClassName className) {
        Objects.requireNonNull(className);
        URI uRI = null;
        try {
            Class<?> clazz = Class.forName(className.className());
            uRI = clazz.getResource(className.simpleName() + ".class").toURI();
            return Paths.get(uRI);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            if (uRI == null) {
                return null;
            }
            try {
                return FileSystems.newFileSystem(uRI, Collections.emptyMap()).getPath("/", className.relativePath());
            }
            catch (IOException | NullPointerException exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Path searchClass(String string) {
        return INSTANCE.search(string);
    }

    public static Path searchClass(ClassName className) {
        return INSTANCE.search(className);
    }
}

