/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.jni;

import bleep.internal.FileUtils$;
import bleep.logging.TypedLogger;
import bleep.package;
import bleep.package$;
import bleep.plugin.jni.BuildTool;
import bleep.plugin.jni.CMake;
import java.nio.file.Path;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class CMake$
implements BuildTool {
    public static CMake$ MODULE$;
    private final String name;

    static {
        new CMake$();
    }

    @Override
    public String name() {
        return this.name;
    }

    public String template(String libName) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1537).append("################################################################\n      |# A minimal CMake file that is compatible with sbt-jni         #\n      |#                                                              #\n      |# All settings required by sbt-jni have been marked so, please #\n      |# add/modify/remove settings to build your specific library.   #\n      |################################################################\n      |\n      |cmake_minimum_required(VERSION 3.12)\n      |\n      |option(SBT \"Set if invoked from sbt-jni\" OFF)\n      |\n      |# Define project and related variables\n      |# (required by sbt-jni) please use semantic versioning\n      |#\n      |project (").append(libName).append(")\n      |set(PROJECT_VERSION_MAJOR 0)\n      |set(PROJECT_VERSION_MINOR 0)\n      |set(PROJECT_VERSION_PATCH 0)\n      |\n      |# Setup JNI\n      |find_package(JNI REQUIRED)\n      |if (JNI_FOUND)\n      |    message (STATUS \"JNI include directories: ${JNI_INCLUDE_DIRS}\")\n      |endif()\n      |\n      |# Include directories\n      |include_directories(.)\n      |include_directories(include)\n      |include_directories(${JNI_INCLUDE_DIRS})\n      |\n      |# Sources\n      |file(GLOB LIB_SRC\n      |  \"*.c\"\n      |  \"*.cc\"\n      |  \"*.cpp\"\n      |)\n      |\n      |# Setup installation targets\n      |# (required by sbt-jni) major version should always be appended to library name\n      |#\n      |set (LIB_NAME ${PROJECT_NAME}${PROJECT_VERSION_MAJOR})\n      |add_library(${LIB_NAME} SHARED ${LIB_SRC})\n      |install(TARGETS ${LIB_NAME} LIBRARY DESTINATION .)\n      |").toString())).stripMargin();
    }

    @Override
    public void ensureHasBuildFile(Path sourceDirectory, TypedLogger<BoxedUnit> logger, String libName) {
        Path buildScript = package.PathOps$.MODULE$.$div$extension1(package$.MODULE$.PathOps(sourceDirectory), "CMakeLists.txt");
        if (!FileUtils$.MODULE$.exists(buildScript)) {
            FileUtils$.MODULE$.writeString(logger, (Option)new Some((Object)new StringBuilder(35).append("Initialized empty build script for ").append(this.name()).toString()), buildScript, this.template(libName));
        }
    }

    @Override
    public BuildTool.Instance getInstance(Path baseDir, Path buildDir, TypedLogger<BoxedUnit> logger, List<Tuple2<String, String>> env) {
        return new CMake.Instance(baseDir, buildDir, logger, env);
    }

    private CMake$() {
        MODULE$ = this;
        this.name = "CMake";
    }
}

