/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.versioning;

import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.plugin.versioning.BufferingProcessLogger;
import bleep.plugin.versioning.GitFetcher;
import bleep.plugin.versioning.GitFetcher$FetchResult$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.process.Process;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public final class GitFetcher$
implements Serializable {
    public static final GitFetcher$FetchResult$ FetchResult;
    private static final Regex tagResultRegex;
    public static final GitFetcher$ MODULE$;

    private GitFetcher$() {
    }

    static {
        MODULE$ = new GitFetcher$();
        tagResultRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(" \\* \\[new tag\\][ ]+([\\S]+).*"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitFetcher$.class);
    }

    public Seq<GitFetcher.FetchResult> fetchRemotes(Duration timeout, TypedLogger<BoxedUnit> logger) {
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int processResult = Process$.MODULE$.apply("git remote").$bang((ProcessLogger)outputLogger);
        int n = processResult;
        if (0 == n) {
            LoggerFn.Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger), this::fetchRemotes$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(30), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchRemotes"));
            Buffer<String> remotes = outputLogger.stdout();
            Buffer tagsToFetch = (Buffer)remotes.filter((Function1 & Serializable)elem -> remotes.contains(elem));
            if (tagsToFetch.nonEmpty()) {
                LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger), () -> this.fetchRemotes$$anonfun$2(tagsToFetch), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(35), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchRemotes"));
                return (Seq)tagsToFetch.toSeq().flatMap((Function1 & Serializable)remote -> this.fetchTagsFromRemote((String)remote, timeout, logger));
            }
            LoggerFn.Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger), this::fetchRemotes$$anonfun$4, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(38), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchRemotes"));
            return (Seq)package$.MODULE$.Seq().empty();
        }
        int exitCode = n;
        LoggerFn.Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(logger), () -> this.fetchRemotes$$anonfun$5(exitCode), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(43), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchRemotes"));
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private Seq<GitFetcher.FetchResult> fetchTagsFromRemote(String remote, Duration timeout, TypedLogger<BoxedUnit> logger) {
        Seq seq;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        Process process = Process$.MODULE$.apply(new StringBuilder(17).append("git fetch ").append(remote).append(" --tags").toString()).run((ProcessLogger)outputLogger);
        Future resultFuture = Future$.MODULE$.apply(() -> this.$anonfun$2(remote, logger, outputLogger, process), ExecutionContext.Implicits$.MODULE$.global());
        try {
            Seq result = (Seq)Await$.MODULE$.result((Awaitable)resultFuture, timeout);
            LoggerFn.Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger), () -> this.fetchTagsFromRemote$$anonfun$1(remote), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(70), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote"));
            seq = result;
        }
        catch (TimeoutException timeoutException) {
            process.destroy();
            LoggerFn.Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(logger), () -> this.fetchTagsFromRemote$$anonfun$2(remote, process), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(75), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote"));
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable exc = throwable3 = (Throwable)option.get();
                LoggerFn.Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(logger), () -> this.fetchTagsFromRemote$$anonfun$3(remote, process), exc, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(78), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote"));
                seq = (Seq)package$.MODULE$.Seq().empty();
            }
            throw throwable;
        }
        return seq;
    }

    private final String fetchRemotes$$anonfun$1() {
        return "Fetching remote sources...";
    }

    private final String fetchRemotes$$anonfun$2(Buffer tagsToFetch$1) {
        return new StringBuilder(20).append("Fetching tags from: ").append(tagsToFetch$1.mkString(", ")).toString();
    }

    private final String fetchRemotes$$anonfun$4() {
        return "No tags to fetch";
    }

    private final String fetchRemotes$$anonfun$5(int exitCode$1) {
        return new StringBuilder(59).append("Fetching remotes failed enumerating remotes [git exitCode=").append(exitCode$1).append("]").toString();
    }

    private final String $anonfun$2$$anonfun$2$$anonfun$1(String remote$3, String tag$1) {
        return new StringBuilder(25).append("Fetched from remote=").append(remote$3).append(" tag=").append(tag$1).toString();
    }

    private final String $anonfun$2$$anonfun$2$$anonfun$2(String line$1) {
        return new StringBuilder(37).append("Unable to parse git result=").append(line$1).append(", skipping").toString();
    }

    private final String $anonfun$2$$anonfun$3(String remote$4, Process process$2) {
        return new StringBuilder(39).append("Fetching remote=").append(remote$4).append(" failed [git exitCode=").append(process$2.exitValue()).append("]").toString();
    }

    private final Seq $anonfun$2(String remote$1, TypedLogger logger$2, BufferingProcessLogger outputLogger$1, Process process$1) {
        if (process$1.exitValue() == 0) {
            return (Seq)((IterableOps)outputLogger$1.stderr().toSeq().filter((Function1 & Serializable)_$1 -> _$1.contains("[new tag]"))).flatMap((Function1 & Serializable)x$1 -> {
                List list;
                Option option;
                String string = x$1;
                if (string != null && !(option = tagResultRegex.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                    String string2;
                    String tag = string2 = (String)list.apply(0);
                    LoggerFn.Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger$2), () -> this.$anonfun$2$$anonfun$2$$anonfun$1(remote$1, tag), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(56), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote resultFuture"));
                    return Some$.MODULE$.apply((Object)GitFetcher$FetchResult$.MODULE$.apply(remote$1, tag));
                }
                String line = string;
                LoggerFn.Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger$2), () -> this.$anonfun$2$$anonfun$2$$anonfun$2(line), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(59), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote resultFuture"));
                return None$.MODULE$;
            });
        }
        LoggerFn.Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger$2), () -> this.$anonfun$2$$anonfun$3(remote$1, process$1), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(63), File$.MODULE$.apply("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), Enclosing$.MODULE$.apply("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote resultFuture"));
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private final String fetchTagsFromRemote$$anonfun$1(String remote$5) {
        return new StringBuilder(21).append("Successfully fetched ").append(remote$5).toString();
    }

    private final String fetchTagsFromRemote$$anonfun$2(String remote$6, Process process$3) {
        return new StringBuilder(42).append("Fetching remote=").append(remote$6).append(" timed out [git exitCode=").append(process$3.exitValue()).append("]").toString();
    }

    private final String fetchTagsFromRemote$$anonfun$3(String remote$7, Process process$4) {
        return new StringBuilder(39).append("Fetching remote=").append(remote$7).append(" failed [git exitCode=").append(process$4.exitValue()).append("]").toString();
    }
}

