/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.versioning;

import bleep.plugin.versioning.BufferingProcessLogger;
import bleep.plugin.versioning.GitBranchState;
import bleep.plugin.versioning.GitBranchStateNoCommits$;
import bleep.plugin.versioning.GitBranchStateNoReleases$;
import bleep.plugin.versioning.GitBranchStateOneReleaseHead$;
import bleep.plugin.versioning.GitBranchStateOneReleaseNotHead$;
import bleep.plugin.versioning.GitBranchStateTwoReleases$;
import bleep.plugin.versioning.GitCommit;
import bleep.plugin.versioning.GitCommit$;
import bleep.plugin.versioning.GitCommitWithCount$;
import bleep.plugin.versioning.GitDriver;
import bleep.plugin.versioning.GitWorkingState;
import bleep.plugin.versioning.GitWorkingState$;
import bleep.plugin.versioning.ReleaseVersion;
import bleep.plugin.versioning.ReleaseVersion$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.matching.Regex;

public class GitDriverImpl
implements GitDriver {
    private final File dir;
    private final GitBranchState branchState;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public GitDriverImpl(File dir) {
        block9: {
            block7: {
                block8: {
                    this.dir = dir;
                    super();
                    Predef$.MODULE$.require(this.isGitRepo(dir), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$1(), ()Ljava/lang/Object;)());
                    Predef$.MODULE$.require(this.isGitCompatible(), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$2(), ()Ljava/lang/Object;)());
                    var2_2 = this.gitLog("--max-count=1").headOption();
                    if (!(var2_2 instanceof Some)) ** GOTO lbl53
                    headCommit = (GitCommit)((Some)var2_2).value();
                    releaseRefs = (Seq)this.gitForEachRef().collect((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(GitCommit x) {
                            Option<ReleaseVersion> option;
                            GitCommit gitCommit = x;
                            if (gitCommit != null && !(option = ReleaseVersion$.MODULE$.unapply(gitCommit)).isEmpty()) {
                                ReleaseVersion releaseVersion;
                                ReleaseVersion rv = releaseVersion = (ReleaseVersion)option.get();
                                GitCommit gc = gitCommit;
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(GitCommit x, Function1 function1) {
                            Option<ReleaseVersion> option;
                            GitCommit gitCommit = x;
                            if (gitCommit != null && !(option = ReleaseVersion$.MODULE$.unapply(gitCommit)).isEmpty()) {
                                ReleaseVersion releaseVersion;
                                ReleaseVersion rv = releaseVersion = (ReleaseVersion)option.get();
                                GitCommit gc = gitCommit;
                                return Tuple2$.MODULE$.apply((Object)gc, (Object)rv);
                            }
                            return function1.apply((Object)x);
                        }
                    });
                    releases = (Seq)((IterableOps)releaseRefs.take(2)).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)((GitDriverImpl)this));
                    maybeCurrRelease = releases.headOption();
                    var8_8 = Tuple2$.MODULE$.apply((Object)maybeCurrRelease, (Object)(maybePrevRelease = ((IterableOps)releases.drop(1)).headOption()));
                    if (var8_8 == null) ** GOTO lbl-1000
                    var9_9 = (Option)var8_8._1();
                    var10_10 = (Option)var8_8._2();
                    if (!(var9_9 instanceof Some) || (var11_11 = (Tuple2)((Some)var9_9).value()) == null) break block7;
                    var12_12 = (GitCommit)var11_11._1();
                    var13_13 = (ReleaseVersion)var11_11._2();
                    currCommit = var12_12;
                    if (!(var10_10 instanceof Some) || (var15_15 = (Tuple2)((Some)var10_10).value()) == null) break block8;
                    prevCommit = var16_16 = (GitCommit)var15_15._1();
                    v0 = currCommit;
                    var18_18 = prevCommit;
                    if (!(v0 != null ? v0.equals(var18_18) == false : var18_18 != null)) {
                        throw new IllegalStateException(new StringBuilder(36).append("currCommit=").append(currCommit).append(" cannot equal prevCommit=").append(prevCommit).toString());
                    }
                    currCommit = var12_12;
                    currVersion = var13_13;
                    prevCommit = var16_16;
                    prevVersion = (ReleaseVersion)var15_15._2();
                    v1 = currCommit;
                    var23_23 = headCommit;
                    if (v1 != null ? v1.equals(var23_23) == false : var23_23 != null) break block8;
                    v2 /* !! */  = GitBranchStateTwoReleases$.MODULE$.apply(currCommit, currVersion, prevCommit, prevVersion);
                    break block9;
                }
                currCommit = var12_12;
                currVersion = var13_13;
                if (!None$.MODULE$.equals(var10_10)) ** GOTO lbl-1000
                v3 = currCommit;
                var26_26 = headCommit;
                if (!(v3 != null ? v3.equals(var26_26) == false : var26_26 != null)) {
                    v2 /* !! */  = GitBranchStateOneReleaseHead$.MODULE$.apply(currCommit, currVersion);
                } else lbl-1000:
                // 2 sources

                {
                    currCommit = var12_12;
                    currVersion = var13_13;
                    headCommitWithCount = GitCommitWithCount$.MODULE$.apply(headCommit, this.getCommitCount((Option<String>)Some$.MODULE$.apply((Object)currCommit.fullHash())));
                    v2 /* !! */  = GitBranchStateOneReleaseNotHead$.MODULE$.apply(headCommitWithCount, currCommit, currVersion);
                }
                break block9;
            }
            if (None$.MODULE$.equals(var9_9)) {
                v2 /* !! */  = GitBranchStateNoReleases$.MODULE$.apply(GitCommitWithCount$.MODULE$.apply(headCommit, this.getCommitCount((Option<String>)None$.MODULE$)));
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var8_8);
lbl53:
                // 1 sources

                if (None$.MODULE$.equals(var2_2)) {
                    v2 /* !! */  = GitBranchStateNoCommits$.MODULE$;
                } else {
                    throw new MatchError((Object)var2_2);
                }
            }
        }
        this.branchState = v2 /* !! */ ;
    }

    public boolean isGitCompatible() {
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply("git --version", this.dir, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        Regex gitSemver = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("git version (\\d+)\\.(\\d+)\\.(\\d+).*"));
        int n = exitCode;
        if (0 == n) {
            List list;
            Option option;
            String gitVersion = outputLogger.stdout().mkString("").trim().toLowerCase();
            String string = gitVersion;
            if (string != null && !(option = gitSemver.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(3) == 0) {
                String string2 = (String)list.apply(0);
                String string3 = (String)list.apply(1);
                String string4 = (String)list.apply(2);
                String major = string2;
                String minor = string3;
                String patch = string4;
                return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(major)) > 1;
            }
            throw new GitException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(84).append("Version output was not of the form 'git version x.y.z'\n              |version was '").append(gitVersion).append("'").toString())));
        }
        int unexpected = n;
        throw new GitException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(unexpected).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())));
    }

    private boolean isGitRepo(File dir) {
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply("git rev-parse --is-inside-work-tree", dir, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        int n = exitCode;
        if (0 == n) {
            String string = outputLogger.stdout().mkString("").trim().toLowerCase();
            String string2 = "true";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        if (128 == n) {
            return false;
        }
        int unexpected = n;
        throw new GitException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(unexpected).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())));
    }

    @Override
    public GitBranchState branchState() {
        return this.branchState;
    }

    @Override
    public GitWorkingState workingState() {
        return GitWorkingState$.MODULE$.apply(!this.checkClean());
    }

    @Override
    public int getCommitCount(Option<String> hash) {
        String limitStr = (String)hash.map((Function1 & Serializable)_$1 -> new StringBuilder(1).append("^").append((String)_$1).toString()).getOrElse(GitDriverImpl::$anonfun$3);
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(new StringBuilder(41).append("git rev-list --first-parent --count HEAD ").append(limitStr).toString().trim(), this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq output = (Seq)tuple2._2();
        Seq output2 = output;
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(output2.mkString("").trim()));
    }

    private String gitBranch() {
        String cmd = "git rev-parse --abbrev-ref HEAD";
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = BoxesRunTime.unboxToInt((Object)tuple2._1());
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        Seq output2 = (Seq)tuple22._2();
        int n = exitCode2;
        if (0 == n) {
            Seq res = (Seq)output2.map((Function1 & Serializable)line -> line);
            return (String)res.head();
        }
        if (128 == n) {
            throw new IllegalStateException("Error 128: a git cmd was run in a dir that is not under git vcs or git rev-parse failed to run.");
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private Seq<GitCommit> gitForEachRef() {
        Predef$.MODULE$.require(this.isGitRepo(this.dir), GitDriverImpl::gitForEachRef$$anonfun$1);
        Predef$.MODULE$.require(this.isGitCompatible(), GitDriverImpl::gitForEachRef$$anonfun$2);
        String cmd = new StringBuilder(54).append("git for-each-ref --sort=-v:refname refs/tags --merged=").append(this.gitBranch()).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = BoxesRunTime.unboxToInt((Object)tuple2._1());
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        Seq output2 = (Seq)tuple22._2();
        int n = exitCode2;
        if (0 == n || 128 == n) {
            int abbreviatedHashLength = this.findAbbreviatedHashLength();
            return (Seq)output2.map((Function1 & Serializable)line -> GitCommit$.MODULE$.fromGitRef((String)line, abbreviatedHashLength));
        }
        int ret = n;
        throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(ret).toString());
    }

    private Seq<GitCommit> gitLog(String arguments) {
        Predef$.MODULE$.require(this.isGitRepo(this.dir), GitDriverImpl::gitLog$$anonfun$1);
        Predef$.MODULE$.require(this.isGitCompatible(), GitDriverImpl::gitLog$$anonfun$2);
        String cmd = new StringBuilder(79).append("git log --oneline --decorate=short --simplify-by-decoration --no-abbrev-commit ").append(arguments).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = BoxesRunTime.unboxToInt((Object)tuple2._1());
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        Seq output2 = (Seq)tuple22._2();
        int n = exitCode2;
        if (0 == n || 128 == n) {
            int abbreviatedHashLength = this.findAbbreviatedHashLength();
            return (Seq)output2.map((Function1 & Serializable)line -> GitCommit$.MODULE$.fromGitLog((String)line, abbreviatedHashLength));
        }
        int ret = n;
        throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(ret).toString());
    }

    private boolean checkClean() {
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git status --porcelain --untracked-files=no", this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq output = (Seq)tuple2._2();
        Seq output2 = output;
        return output2.mkString("").isEmpty();
    }

    private int findAbbreviatedHashLength() {
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git rev-parse --short HEAD", false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = BoxesRunTime.unboxToInt((Object)tuple2._1());
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        Seq output2 = (Seq)tuple22._2();
        int n = exitCode2;
        if (0 == n || 128 == n) {
            return package$.MODULE$.max(output2.mkString("").trim().length(), 7);
        }
        int ret = n;
        throw new IllegalStateException(new StringBuilder(47).append("Non-zero exit code when running git rev-parse: ").append(ret).toString());
    }

    private Tuple2<Object, Seq<String>> runCommand(String cmd, boolean throwIfNonZero) {
        Predef$.MODULE$.require(this.isGitRepo(this.dir), GitDriverImpl::runCommand$$anonfun$1);
        Predef$.MODULE$.require(this.isGitCompatible(), GitDriverImpl::runCommand$$anonfun$2);
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply(cmd, this.dir, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        Tuple2 result = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)outputLogger.stdout().toSeq());
        if (throwIfNonZero && exitCode != 0) {
            throw new IllegalStateException(new StringBuilder(36).append("Non-zero exit code when running '").append(cmd).append("': ").append(exitCode).toString());
        }
        return result;
    }

    private boolean runCommand$default$2() {
        return true;
    }

    private static final Object $init$$$anonfun$1() {
        return "Must be in a git repository";
    }

    private static final Object $init$$$anonfun$2() {
        return "Must be git version 2.X.X or greater";
    }

    private final /* synthetic */ Tuple2 $anonfun$1(Tuple2 tp) {
        return Tuple2$.MODULE$.apply(this.gitLog(new StringBuilder(14).append(((GitCommit)tp._1()).fullHash()).append(" --max-count=1").toString()).head(), tp._2());
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final Object gitForEachRef$$anonfun$1() {
        return "Must be in a git repository";
    }

    private static final Object gitForEachRef$$anonfun$2() {
        return "Must be git version 2.X.X or greater";
    }

    private static final Object gitLog$$anonfun$1() {
        return "Must be in a git repository";
    }

    private static final Object gitLog$$anonfun$2() {
        return "Must be git version 2.X.X or greater";
    }

    private static final Object runCommand$$anonfun$1() {
        return "Must be in a git repository";
    }

    private static final Object runCommand$$anonfun$2() {
        return "Must be git version 2.X.X or greater";
    }

    public class GitException
    extends Exception {
        public GitException(String msg) {
            super(msg);
        }
    }
}

