/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.semver.level.rule;

import bleep.plugin.semver.SemVerDiff;
import bleep.plugin.semver.SemVerDiff$;
import bleep.plugin.semver.level.SemVerEnforcementLevel;
import bleep.plugin.semver.level.SemVerLevelRule;
import bleep.plugin.semver.level.rule.DisabledBecauseNoPreviousRelease$;
import bleep.plugin.semver.level.rule.MinorOkayForSnapshot$;
import bleep.plugin.semver.level.rule.NormalVersionBump;
import bleep.plugin.semver.level.rule.VersionDiffRule$;
import bleep.plugin.versioning.ReleaseVersion;
import bleep.plugin.versioning.SemVerReleaseType;
import bleep.plugin.versioning.SemVerReleaseType$Major$;
import bleep.plugin.versioning.SemVerReleaseType$Minor$;
import bleep.plugin.versioning.SemVerReleaseType$Patch$;
import bleep.plugin.versioning.SemanticVersion;
import bleep.plugin.versioning.SnapshotVersion;
import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public class VersionDiffRule
implements SemVerLevelRule,
Product,
Serializable {
    private final SemanticVersion current;
    private final Option maybePrevRelease;

    public static VersionDiffRule apply(SemanticVersion semanticVersion, Option<ReleaseVersion> option) {
        return VersionDiffRule$.MODULE$.apply(semanticVersion, option);
    }

    public static VersionDiffRule fromProduct(Product product) {
        return VersionDiffRule$.MODULE$.fromProduct(product);
    }

    public static VersionDiffRule unapply(VersionDiffRule versionDiffRule) {
        return VersionDiffRule$.MODULE$.unapply(versionDiffRule);
    }

    public VersionDiffRule(SemanticVersion current, Option<ReleaseVersion> maybePrevRelease) {
        this.current = current;
        this.maybePrevRelease = maybePrevRelease;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof VersionDiffRule)) return false;
        VersionDiffRule versionDiffRule = (VersionDiffRule)object;
        SemanticVersion semanticVersion = this.current();
        SemanticVersion semanticVersion2 = versionDiffRule.current();
        if (semanticVersion == null) {
            if (semanticVersion2 != null) {
                return false;
            }
        } else if (!semanticVersion.equals(semanticVersion2)) return false;
        Option<ReleaseVersion> option = this.maybePrevRelease();
        Option<ReleaseVersion> option2 = versionDiffRule.maybePrevRelease();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!versionDiffRule.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof VersionDiffRule;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "VersionDiffRule";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "current";
        }
        if (1 == n2) {
            return "maybePrevRelease";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public SemanticVersion current() {
        return this.current;
    }

    public Option<ReleaseVersion> maybePrevRelease() {
        return this.maybePrevRelease;
    }

    @Override
    public Option<SemVerEnforcementLevel> calcLevel() {
        Option<ReleaseVersion> option = this.maybePrevRelease();
        if (None$.MODULE$.equals(option)) {
            return Some$.MODULE$.apply((Object)DisabledBecauseNoPreviousRelease$.MODULE$);
        }
        if (option instanceof Some) {
            SemVerReleaseType$Major$ releaseType;
            ReleaseVersion prevRelease;
            ReleaseVersion releaseVersion = prevRelease = (ReleaseVersion)((Some)option).value();
            SemanticVersion semanticVersion = this.current();
            if (!(releaseVersion != null ? !((Object)releaseVersion).equals(semanticVersion) : semanticVersion != null)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"Prev release and current version must be different.");
            }
            ReleaseVersion currentRelease = this.current().toRelease();
            SemVerDiff.Delta delta = SemVerDiff$.MODULE$.calc(prevRelease, currentRelease);
            SemVerReleaseType$Major$ semVerReleaseType$Major$ = releaseType = delta.major() > 0 ? SemVerReleaseType$Major$.MODULE$ : (SemVerReleaseType)(delta.minor() > 0 ? SemVerReleaseType$Minor$.MODULE$ : SemVerReleaseType$Patch$.MODULE$);
            SemVerReleaseType$Patch$ semVerReleaseType$Patch$ = SemVerReleaseType$Patch$.MODULE$;
            if (!(semVerReleaseType$Major$ != null ? !semVerReleaseType$Major$.equals(semVerReleaseType$Patch$) : semVerReleaseType$Patch$ != null) && this.current() instanceof SnapshotVersion) {
                return Some$.MODULE$.apply((Object)MinorOkayForSnapshot$.MODULE$.apply(this.current()));
            }
            return Some$.MODULE$.apply((Object)new NormalVersionBump(releaseType, prevRelease, currentRelease));
        }
        throw new MatchError(option);
    }

    public VersionDiffRule copy(SemanticVersion current, Option<ReleaseVersion> maybePrevRelease) {
        return new VersionDiffRule(current, maybePrevRelease);
    }

    public SemanticVersion copy$default$1() {
        return this.current();
    }

    public Option<ReleaseVersion> copy$default$2() {
        return this.maybePrevRelease();
    }

    public SemanticVersion _1() {
        return this.current();
    }

    public Option<ReleaseVersion> _2() {
        return this.maybePrevRelease();
    }
}

