/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.versioning;

import bleep.plugin.versioning.ReleaseVersion;
import bleep.plugin.versioning.SemVerIdentifierList;
import bleep.plugin.versioning.SemVerIdentifierList$;
import bleep.plugin.versioning.SemanticVersion$;
import scala.Option;
import scala.Predef$;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;
import scala.util.matching.Regex;

public interface SemanticVersion
extends Ordered<SemanticVersion> {
    public static Option<SemanticVersion> fromString(String string) {
        return SemanticVersion$.MODULE$.fromString(string);
    }

    public static int ordinal(SemanticVersion semanticVersion) {
        return SemanticVersion$.MODULE$.ordinal(semanticVersion);
    }

    public static Regex versionPrefix() {
        return SemanticVersion$.MODULE$.versionPrefix();
    }

    public static void $init$(SemanticVersion $this) {
    }

    public int major();

    public int minor();

    public int patch();

    public boolean isDirty();

    public SemVerIdentifierList identifiers();

    public SemVerIdentifierList versionIdentifiers();

    public boolean isRelease();

    public static boolean isSnapshot$(SemanticVersion $this) {
        return $this.isSnapshot();
    }

    default public boolean isSnapshot() {
        return !this.isRelease();
    }

    public static String toString$(SemanticVersion $this) {
        return $this.toString();
    }

    default public String toString() {
        String tagStr = this.identifiers().toString();
        return new StringBuilder(2).append(this.major()).append(".").append(this.minor()).append(".").append(this.patch()).append(tagStr.isEmpty() ? "" : new StringBuilder(0).append(BoxesRunTime.boxToCharacter((char)SemVerIdentifierList$.MODULE$.separatorChar()).toString()).append(tagStr).toString()).toString();
    }

    public static int compare$(SemanticVersion $this, SemanticVersion that) {
        return $this.compare(that);
    }

    default public int compare(SemanticVersion that) {
        int majorDelta = new RichInt(Predef$.MODULE$.intWrapper(this.major())).compare((Object)BoxesRunTime.boxToInteger((int)that.major()));
        if (majorDelta != 0) {
            return majorDelta;
        }
        int minorDelta = new RichInt(Predef$.MODULE$.intWrapper(this.minor())).compare((Object)BoxesRunTime.boxToInteger((int)that.minor()));
        if (minorDelta != 0) {
            return minorDelta;
        }
        int patchDelta = new RichInt(Predef$.MODULE$.intWrapper(this.patch())).compare((Object)BoxesRunTime.boxToInteger((int)that.patch()));
        if (patchDelta != 0) {
            return patchDelta;
        }
        int dirtyDelta = Predef$.MODULE$.boolean2Boolean(this.isDirty()).compareTo(Predef$.MODULE$.boolean2Boolean(that.isDirty()));
        if (dirtyDelta != 0) {
            return dirtyDelta;
        }
        int identifiersDelta = this.versionIdentifiers().compare(that.versionIdentifiers());
        if (identifiersDelta != 0) {
            return identifiersDelta;
        }
        return 0;
    }

    public SemanticVersion setDirty(boolean var1);

    public static boolean isInitialDevVersion$(SemanticVersion $this) {
        return $this.isInitialDevVersion();
    }

    default public boolean isInitialDevVersion() {
        return this.major() == 0;
    }

    public ReleaseVersion toRelease();
}

