/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.versioning;

import bleep.plugin.versioning.CommitsSemVerIdentifier;
import bleep.plugin.versioning.CommitsSemVerIdentifier$;
import bleep.plugin.versioning.GitCommitWithCount;
import bleep.plugin.versioning.HashSemVerIdentifier;
import bleep.plugin.versioning.HashSemVerIdentifier$;
import bleep.plugin.versioning.ReleaseVersion;
import bleep.plugin.versioning.SemVerIdentifierList;
import bleep.plugin.versioning.SemVerIdentifierList$;
import bleep.plugin.versioning.SemanticVersion$;
import bleep.plugin.versioning.SnapshotVersion;
import bleep.plugin.versioning.StringSemVerIdentifier$;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class SnapshotVersion$
implements Serializable {
    public static final SnapshotVersion$ MODULE$ = new SnapshotVersion$();
    private static final Regex regex;

    static {
        String dirtyIdentifierRegex = new StringBuilder(8).append("(?:-(").append(StringSemVerIdentifier$.MODULE$.dirty()).append("))?").toString();
        String commitCountAndHashPattern = new StringBuilder(6).append("-(").append(CommitsSemVerIdentifier$.MODULE$.regex()).append(")-(").append(HashSemVerIdentifier$.MODULE$.regex()).append(")").toString();
        regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(1).append(SemanticVersion$.MODULE$.versionPrefix().toString()).append(commitCountAndHashPattern).append(dirtyIdentifierRegex).append("-").append(StringSemVerIdentifier$.MODULE$.snapshot()).toString()));
    }

    public Regex regex() {
        return regex;
    }

    public SnapshotVersion createInitialVersion(GitCommitWithCount commit) {
        return new SnapshotVersion(0, 0, 1, SemVerIdentifierList$.MODULE$.empty(), false, HashSemVerIdentifier$.MODULE$.string2HashIdentifier(commit.commit().abbreviatedHash()), CommitsSemVerIdentifier$.MODULE$.int2IntegerIdentifier(commit.count()));
    }

    public SnapshotVersion createAfterRelease(ReleaseVersion release, GitCommitWithCount commit) {
        Predef$.MODULE$.require(!commit.commit().tags().contains((Object)release.toString()), (Function0 & Serializable)() -> "commit should NOT be tagged with version");
        return new SnapshotVersion(release.major(), release.minor(), release.patch() + 1, release.identifiers(), false, HashSemVerIdentifier$.MODULE$.string2HashIdentifier(commit.commit().abbreviatedHash()), CommitsSemVerIdentifier$.MODULE$.int2IntegerIdentifier(commit.count()));
    }

    public SnapshotVersion apply(int major, int minor, int patch, SemVerIdentifierList versionIdentifiers, boolean isDirty, HashSemVerIdentifier commitHash, CommitsSemVerIdentifier commitsSincePrevRelease) {
        return new SnapshotVersion(major, minor, patch, versionIdentifiers, isDirty, commitHash, commitsSincePrevRelease);
    }

    public Option<Tuple7<Object, Object, Object, SemVerIdentifierList, Object, HashSemVerIdentifier, CommitsSemVerIdentifier>> unapply(SnapshotVersion x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)BoxesRunTime.boxToInteger((int)x$0.major()), (Object)BoxesRunTime.boxToInteger((int)x$0.minor()), (Object)BoxesRunTime.boxToInteger((int)x$0.patch()), (Object)x$0.versionIdentifiers(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isDirty()), (Object)x$0.commitHash(), (Object)x$0.commitsSincePrevRelease()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SnapshotVersion$.class);
    }

    private SnapshotVersion$() {
    }
}

