/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.versioning;

import bleep.plugin.versioning.BufferingProcessLogger;
import bleep.plugin.versioning.GitBranchState;
import bleep.plugin.versioning.GitBranchStateNoCommits$;
import bleep.plugin.versioning.GitBranchStateNoReleases;
import bleep.plugin.versioning.GitBranchStateOneReleaseHead;
import bleep.plugin.versioning.GitBranchStateOneReleaseNotHead;
import bleep.plugin.versioning.GitBranchStateTwoReleases;
import bleep.plugin.versioning.GitCommit;
import bleep.plugin.versioning.GitCommit$;
import bleep.plugin.versioning.GitCommitWithCount;
import bleep.plugin.versioning.GitDriver;
import bleep.plugin.versioning.GitWorkingState;
import bleep.plugin.versioning.ReleaseVersion;
import bleep.plugin.versioning.ReleaseVersion$;
import bleep.plugin.versioning.SemanticVersion;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\n\u0015\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006_\u0001!\t\u0001\r\u0004\u0005g\u0001!A\u0007\u0003\u0005B\u0007\t\u0005\t\u0015!\u0003C\u0011\u0015y3\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0005P\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0011\u001d1\u0006A1A\u0005B]Caa\u0017\u0001!\u0002\u0013A\u0006\"\u0002/\u0001\t\u0003j\u0006\"B1\u0001\t\u0003\u0012\u0007\"B6\u0001\t\u0013a\u0007\"B7\u0001\t\u0013q\u0007\"B;\u0001\t\u00131\b\"B=\u0001\t\u0013Q\b\"B>\u0001\t\u0013a\b\"B?\u0001\t\u0013q\b\"CA\b\u0001E\u0005I\u0011BA\t\u000559\u0015\u000e\u001e#sSZ,'/S7qY*\u0011QCF\u0001\u000bm\u0016\u00148/[8oS:<'BA\f\u0019\u0003\u0019\u0001H.^4j]*\t\u0011$A\u0003cY\u0016,\u0007o\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G\u0011j\u0011\u0001F\u0005\u0003KQ\u0011\u0011bR5u\tJLg/\u001a:\u0002\u0007\u0011L'\u000f\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005\u0011\u0011n\u001c\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013F\u0001\u0003GS2,\u0017A\u0002\u001fj]&$h\b\u0006\u00022eA\u00111\u0005\u0001\u0005\u0006M\t\u0001\ra\n\u0002\r\u000f&$X\t_2faRLwN\\\n\u0003\u0007U\u0002\"A\u000e \u000f\u0005]bdB\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u001b\u0003\u0019a$o\\8u}%\tq$\u0003\u0002>=\u00059\u0001/Y2lC\u001e,\u0017BA A\u0005%)\u0005pY3qi&|gN\u0003\u0002>=\u0005\u0019Qn]4\u0011\u0005\r;eB\u0001#F!\tAd$\u0003\u0002G=\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1e\u0004\u0006\u0002L\u001bB\u0011AjA\u0007\u0002\u0001!)\u0011)\u0002a\u0001\u0005\u0006y\u0011n]$ji\u000e{W\u000e]1uS\ndW-F\u0001Q!\ti\u0012+\u0003\u0002S=\t9!i\\8mK\u0006t\u0017!C5t\u000f&$(+\u001a9p)\t\u0001V\u000bC\u0003'\u000f\u0001\u0007q%A\u0006ce\u0006t7\r[*uCR,W#\u0001-\u0011\u0005\rJ\u0016B\u0001.\u0015\u000599\u0015\u000e\u001e\"sC:\u001c\u0007n\u0015;bi\u0016\fAB\u0019:b]\u000eD7\u000b^1uK\u0002\nAb^8sW&twm\u0015;bi\u0016,\u0012A\u0018\t\u0003G}K!\u0001\u0019\u000b\u0003\u001f\u001dKGoV8sW&twm\u0015;bi\u0016\fabZ3u\u0007>lW.\u001b;D_VtG\u000f\u0006\u0002dMB\u0011Q\u0004Z\u0005\u0003Kz\u00111!\u00138u\u0011\u001597\u00021\u0001i\u0003\u0011A\u0017m\u001d5\u0011\u0007uI')\u0003\u0002k=\t1q\n\u001d;j_:\f\u0011bZ5u\u0005J\fgn\u00195\u0016\u0003\t\u000bQbZ5u\r>\u0014X)Y2i%\u00164W#A8\u0011\u0007Y\u0002(/\u0003\u0002r\u0001\n\u00191+Z9\u0011\u0005\r\u001a\u0018B\u0001;\u0015\u0005%9\u0015\u000e^\"p[6LG/\u0001\u0004hSRdun\u001a\u000b\u0003_^DQ\u0001\u001f\bA\u0002\t\u000b\u0011\"\u0019:hk6,g\u000e^:\u0002\u0015\rDWmY6DY\u0016\fg\u000eF\u0001Q\u0003e1\u0017N\u001c3BE\n\u0014XM^5bi\u0016$\u0007*Y:i\u0019\u0016tw\r\u001e5\u0015\u0003\r\f!B];o\u0007>lW.\u00198e)\u0015y\u0018qAA\u0006!\u0019i\u0012\u0011A2\u0002\u0006%\u0019\u00111\u0001\u0010\u0003\rQ+\b\u000f\\33!\r1\u0004O\u0011\u0005\u0007\u0003\u0013\t\u0002\u0019\u0001\"\u0002\u0007\rlG\r\u0003\u0005\u0002\u000eE\u0001\n\u00111\u0001Q\u00039!\bN]8x\u0013\u001atuN\u001c.fe>\fAC];o\u0007>lW.\u00198eI\u0011,g-Y;mi\u0012\u0012TCAA\nU\r\u0001\u0016QC\u0016\u0003\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0005\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0005m!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class GitDriverImpl
implements GitDriver {
    private final File dir;
    private final GitBranchState branchState;

    @Override
    public SemanticVersion calcCurrentVersion(boolean ignoreDirty) {
        return GitDriver.calcCurrentVersion$(this, ignoreDirty);
    }

    public boolean isGitCompatible() {
        boolean bl;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply("git --version", this.dir, (Seq)Nil$.MODULE$).$bang((ProcessLogger)outputLogger);
        Regex gitSemver = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("git version (\\d+)\\.(\\d+)\\.(\\d+).*"));
        int n = exitCode;
        switch (n) {
            case 0: {
                Option option;
                String gitVersion;
                String string = gitVersion = outputLogger.stdout().mkString("").trim().toLowerCase();
                if (string != null && !(option = gitSemver.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
                    String major = (String)((LinearSeqOps)option.get()).apply(0);
                    bl = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(major)) > 1;
                    break;
                }
                throw new GitException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(84).append("Version output was not of the form 'git version x.y.z'\n              |version was '").append(gitVersion).append("'").toString())));
            }
            default: {
                throw new GitException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(n).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())));
            }
        }
        return bl;
    }

    private boolean isGitRepo(File dir) {
        boolean bl;
        int exitCode;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int n = exitCode = Process$.MODULE$.apply("git rev-parse --is-inside-work-tree", dir, (Seq)Nil$.MODULE$).$bang((ProcessLogger)outputLogger);
        switch (n) {
            case 0: {
                String string = outputLogger.stdout().mkString("").trim().toLowerCase();
                String string2 = "true";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 128: {
                bl = false;
                break;
            }
            default: {
                throw new GitException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(n).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())));
            }
        }
        return bl;
    }

    @Override
    public GitBranchState branchState() {
        return this.branchState;
    }

    @Override
    public GitWorkingState workingState() {
        return new GitWorkingState(!this.checkClean());
    }

    @Override
    public int getCommitCount(Option<String> hash) {
        Seq output;
        String limitStr = (String)hash.map((Function1 & Serializable)x$1 -> new StringBuilder(1).append("^").append((String)x$1).toString()).getOrElse((Function0 & Serializable)() -> "");
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(new StringBuilder(41).append("git rev-list --first-parent --count HEAD ").append(limitStr).toString().trim(), this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq seq = output = (Seq)tuple2._2();
        Seq output2 = seq;
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(output2.mkString("").trim()));
    }

    private String gitBranch() {
        Seq res;
        String cmd = "git rev-parse --abbrev-ref HEAD";
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: {
                res = (Seq)output2.map((Function1 & Serializable)line -> line);
                break;
            }
            case 128: {
                throw new IllegalStateException("Error 128: a git cmd was run in a dir that is not under git vcs or git rev-parse failed to run.");
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return (String)res.head();
    }

    private Seq<GitCommit> gitForEachRef() {
        int abbreviatedHashLength;
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable)() -> "Must be git version 2.X.X or greater");
        String cmd = new StringBuilder(54).append("git for-each-ref --sort=-v:refname refs/tags --merged=").append(this.gitBranch()).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                abbreviatedHashLength = this.findAbbreviatedHashLength();
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(n).toString());
            }
        }
        return (Seq)output2.map((Function1 & Serializable)line -> GitCommit$.MODULE$.fromGitRef((String)line, abbreviatedHashLength));
    }

    private Seq<GitCommit> gitLog(String arguments) {
        int abbreviatedHashLength;
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable)() -> "Must be git version 2.X.X or greater");
        String cmd = new StringBuilder(79).append("git log --oneline --decorate=short --simplify-by-decoration --no-abbrev-commit ").append(arguments).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                abbreviatedHashLength = this.findAbbreviatedHashLength();
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(n).toString());
            }
        }
        return (Seq)output2.map((Function1 & Serializable)line -> GitCommit$.MODULE$.fromGitLog((String)line, abbreviatedHashLength));
    }

    private boolean checkClean() {
        Seq output;
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git status --porcelain --untracked-files=no", this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq seq = output = (Seq)tuple2._2();
        Seq output2 = seq;
        return output2.mkString("").isEmpty();
    }

    private int findAbbreviatedHashLength() {
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git rev-parse --short HEAD", false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        Tuple2 tuple23 = tuple22;
        int exitCode2 = tuple23._1$mcI$sp();
        Seq output2 = (Seq)tuple23._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(47).append("Non-zero exit code when running git rev-parse: ").append(n).toString());
            }
        }
        return package$.MODULE$.max(output2.mkString("").trim().length(), 7);
    }

    private Tuple2<Object, Seq<String>> runCommand(String cmd, boolean throwIfNonZero) {
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable)() -> "Must be git version 2.X.X or greater");
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply(cmd, this.dir, (Seq)Nil$.MODULE$).$bang((ProcessLogger)outputLogger);
        Tuple2 result = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)outputLogger.stdout().toSeq());
        if (throwIfNonZero && exitCode != 0) {
            throw new IllegalStateException(new StringBuilder(36).append("Non-zero exit code when running '").append(cmd).append("': ").append(exitCode).toString());
        }
        return result;
    }

    private boolean runCommand$default$2() {
        return true;
    }

    public static final /* synthetic */ String $anonfun$new$1() {
        return "Must be in a git repository";
    }

    public static final /* synthetic */ String $anonfun$new$2() {
        return "Must be git version 2.X.X or greater";
    }

    public static final /* synthetic */ Tuple2 $anonfun$branchState$1(GitDriverImpl $this, Tuple2 tp) {
        return new Tuple2($this.gitLog(new StringBuilder(14).append(((GitCommit)tp._1()).fullHash()).append(" --max-count=1").toString()).head(), tp._2());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public GitDriverImpl(File dir) {
        block15: {
            block12: {
                block14: {
                    block13: {
                        this.dir = dir;
                        super();
                        GitDriver.$init$(this);
                        Predef$.MODULE$.require(this.isGitRepo(dir), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$1(), ()Ljava/lang/String;)());
                        Predef$.MODULE$.require(this.isGitCompatible(), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$2(), ()Ljava/lang/String;)());
                        var4_2 = this.gitLog("--max-count=1").headOption();
                        if (!(var4_2 instanceof Some)) break block12;
                        var5_3 = (Some)var4_2;
                        headCommit = (GitCommit)var5_3.value();
                        releaseRefs = (Seq)this.gitForEachRef().collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends GitCommit, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                Option<ReleaseVersion> option;
                                A1 A1 = x1;
                                if (A1 != null && !(option = ReleaseVersion$.MODULE$.unapply(A1)).isEmpty()) {
                                    ReleaseVersion rv = (ReleaseVersion)option.get();
                                    object = new Tuple2(A1, (Object)rv);
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(GitCommit x1) {
                                Option<ReleaseVersion> option;
                                GitCommit gitCommit = x1;
                                boolean bl = gitCommit != null && !(option = ReleaseVersion$.MODULE$.unapply(gitCommit)).isEmpty();
                                return bl;
                            }
                        });
                        releases = (Seq)((IterableOps)releaseRefs.take(2)).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$branchState$1(bleep.plugin.versioning.GitDriverImpl scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)((GitDriverImpl)this));
                        maybeCurrRelease = releases.headOption();
                        var11_9 = new Tuple2((Object)maybeCurrRelease, (Object)(maybePrevRelease = ((IterableOps)releases.drop(1)).headOption()));
                        if (var11_9 != null) {
                            var12_10 = (Option)var11_9._1();
                            var13_11 = (Option)var11_9._2();
                            if (var12_10 instanceof Some && (var15_13 = (Tuple2)(var14_12 = (Some)var12_10).value()) != null) {
                                currCommit = (GitCommit)var15_13._1();
                                if (var13_11 instanceof Some && (var18_16 = (Tuple2)(var17_15 = (Some)var13_11).value()) != null) {
                                    prevCommit = (GitCommit)var18_16._1();
                                    v0 = currCommit;
                                    var20_18 = prevCommit;
                                    if (!(v0 != null ? v0.equals(var20_18) == false : var20_18 != null)) {
                                        throw new IllegalStateException(new StringBuilder(36).append("currCommit=").append(currCommit).append(" cannot equal prevCommit=").append(prevCommit).toString());
                                    }
                                }
                            }
                        }
                        if (var11_9 == null) break block13;
                        var21_19 = (Option)var11_9._1();
                        var22_20 = (Option)var11_9._2();
                        if (!(var21_19 instanceof Some) || (var24_22 = (Tuple2)(var23_21 = (Some)var21_19).value()) == null) break block13;
                        currCommit = (GitCommit)var24_22._1();
                        currVersion = (ReleaseVersion)var24_22._2();
                        if (!(var22_20 instanceof Some) || (var28_26 = (Tuple2)(var27_25 = (Some)var22_20).value()) == null) break block13;
                        prevCommit = (GitCommit)var28_26._1();
                        prevVersion = (ReleaseVersion)var28_26._2();
                        v1 = currCommit;
                        var31_29 = headCommit;
                        if (v1 != null ? v1.equals(var31_29) == false : var31_29 != null) break block13;
                        var3_30 /* !! */  = new GitBranchStateTwoReleases(currCommit, currVersion, prevCommit, prevVersion);
                        break block14;
                    }
                    if (var11_9 == null) ** GOTO lbl-1000
                    var32_31 = (Option)var11_9._1();
                    var33_32 = (Option)var11_9._2();
                    if (!(var32_31 instanceof Some) || (var35_34 = (Tuple2)(var34_33 = (Some)var32_31).value()) == null) ** GOTO lbl-1000
                    currCommit = (GitCommit)var35_34._1();
                    currVersion = (ReleaseVersion)var35_34._2();
                    if (!None$.MODULE$.equals(var33_32)) ** GOTO lbl-1000
                    v2 = currCommit;
                    var38_37 = headCommit;
                    if (!(v2 != null ? v2.equals(var38_37) == false : var38_37 != null)) {
                        var3_30 /* !! */  = new GitBranchStateOneReleaseHead(currCommit, currVersion);
                    } else if (var11_9 != null && (var39_38 = (Option)var11_9._1()) instanceof Some && (var41_40 = (Tuple2)(var40_39 = (Some)var39_38).value()) != null) {
                        currCommit = (GitCommit)var41_40._1();
                        currVersion = (ReleaseVersion)var41_40._2();
                        headCommitWithCount = new GitCommitWithCount(headCommit, this.getCommitCount((Option<String>)new Some((Object)currCommit.fullHash())));
                        var3_30 /* !! */  = new GitBranchStateOneReleaseNotHead(headCommitWithCount, currCommit, currVersion);
                    } else if (var11_9 != null && None$.MODULE$.equals(var45_44 = (Option)var11_9._1())) {
                        var3_30 /* !! */  = new GitBranchStateNoReleases(new GitCommitWithCount(headCommit, this.getCommitCount((Option<String>)None$.MODULE$)));
                    } else {
                        throw new MatchError((Object)var11_9);
                    }
                }
                var2_45 /* !! */  = var3_30 /* !! */ ;
                break block15;
            }
            if (None$.MODULE$.equals(var4_2)) {
                var2_45 /* !! */  = GitBranchStateNoCommits$.MODULE$;
            } else {
                throw new MatchError((Object)var4_2);
            }
        }
        this.branchState = var2_45 /* !! */ ;
    }

    private class GitException
    extends Exception {
        public /* synthetic */ GitDriverImpl bleep$plugin$versioning$GitDriverImpl$GitException$$$outer() {
            return GitDriverImpl.this;
        }

        public GitException(String msg) {
            if (GitDriverImpl.this == null) {
                throw null;
            }
            super(msg);
        }
    }
}

