/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.versioning;

import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.plugin.versioning.BufferingProcessLogger;
import bleep.plugin.versioning.GitFetcher;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;

public final class GitFetcher$ {
    public static GitFetcher$ MODULE$;
    private final Regex tagResultRegex;

    static {
        new GitFetcher$();
    }

    private Regex tagResultRegex() {
        return this.tagResultRegex;
    }

    public Seq<GitFetcher.FetchResult> fetchRemotes(Duration timeout, TypedLogger<BoxedUnit> logger) {
        int processResult;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int n = processResult = Process$.MODULE$.apply("git remote").$bang((ProcessLogger)outputLogger);
        switch (n) {
            case 0: {
                LoggerFn.Syntax$.MODULE$.debug$extension0(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable & scala.Serializable)() -> "Fetching remote sources...", Formatter$.MODULE$.StringFormatter(), new Line(30), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchRemotes"));
                Buffer<String> remotes = outputLogger.stdout();
                Buffer tagsToFetch = (Buffer)remotes.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)remotes.contains(elem)));
                if (tagsToFetch.nonEmpty()) {
                    LoggerFn.Syntax$.MODULE$.info$extension0(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Fetching tags from: ").append(tagsToFetch.mkString(", ")).toString(), Formatter$.MODULE$.StringFormatter(), new Line(35), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchRemotes"));
                    return (Seq)tagsToFetch.toSeq().flatMap((Function1 & Serializable & scala.Serializable)remote -> MODULE$.fetchTagsFromRemote((String)remote, timeout, logger), Seq$.MODULE$.canBuildFrom());
                }
                LoggerFn.Syntax$.MODULE$.debug$extension0(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable & scala.Serializable)() -> "No tags to fetch", Formatter$.MODULE$.StringFormatter(), new Line(38), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchRemotes"));
                return (Seq)Nil$.MODULE$;
            }
        }
        LoggerFn.Syntax$.MODULE$.error$extension0(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Fetching remotes failed enumerating remotes [git exitCode=").append(n).append("]").toString(), Formatter$.MODULE$.StringFormatter(), new Line(43), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchRemotes"));
        return (Seq)Nil$.MODULE$;
    }

    private Seq<GitFetcher.FetchResult> fetchTagsFromRemote(String remote, Duration timeout, TypedLogger<BoxedUnit> logger) {
        Seq seq;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        Process process = Process$.MODULE$.apply(new StringBuilder(17).append("git fetch ").append(remote).append(" --tags").toString()).run((ProcessLogger)outputLogger);
        Future resultFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            if (process.exitValue() == 0) {
                return (Seq)((TraversableLike)outputLogger.stderr().toSeq().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("[new tag]")))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    String string = x0$1;
                    Option option = MODULE$.tagResultRegex().unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String tag = (String)((LinearSeqOptimized)option.get()).apply(0);
                        LoggerFn.Syntax$.MODULE$.debug$extension0(LoggerFn$.MODULE$.Syntax((LoggerFn)logger), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Fetched from remote=").append(remote).append(" tag=").append(tag).toString(), Formatter$.MODULE$.StringFormatter(), new Line(56), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote resultFuture"));
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new GitFetcher.FetchResult(remote, tag)));
                    }
                    LoggerFn.Syntax$.MODULE$.warn$extension0(LoggerFn$.MODULE$.Syntax((LoggerFn)logger), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Unable to parse git result=").append(string).append(", skipping").toString(), Formatter$.MODULE$.StringFormatter(), new Line(59), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote resultFuture"));
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }, Seq$.MODULE$.canBuildFrom());
            }
            LoggerFn.Syntax$.MODULE$.error$extension0(LoggerFn$.MODULE$.Syntax((LoggerFn)logger), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Fetching remote=").append(remote).append(" failed [git exitCode=").append(process.exitValue()).append("]").toString(), Formatter$.MODULE$.StringFormatter(), new Line(63), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote resultFuture"));
            return (Seq)Nil$.MODULE$;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            Seq result = (Seq)Await$.MODULE$.result((Awaitable)resultFuture, timeout);
            LoggerFn.Syntax$.MODULE$.debug$extension0(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Successfully fetched ").append(remote).toString(), Formatter$.MODULE$.StringFormatter(), new Line(70), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote"));
            seq = result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof TimeoutException) {
                process.destroy();
                LoggerFn.Syntax$.MODULE$.error$extension0(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Fetching remote=").append(remote).append(" timed out [git exitCode=").append(process.exitValue()).append("]").toString(), Formatter$.MODULE$.StringFormatter(), new Line(75), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote"));
                seq = (Seq)Nil$.MODULE$;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable exc = (Throwable)option.get();
                LoggerFn.Syntax$.MODULE$.error$extension1(LoggerFn$.MODULE$.Syntax(logger), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Fetching remote=").append(remote).append(" failed [git exitCode=").append(process.exitValue()).append("]").toString(), exc, Formatter$.MODULE$.StringFormatter(), new Line(78), new File("/home/runner/work/bleep/bleep/liberated/sbt-git-versioning/src/main/scala/com/rallyhealth/sbt/versioning/GitFetcher.scala"), new Enclosing("bleep.plugin.versioning.GitFetcher.fetchTagsFromRemote"));
                seq = (Seq)Nil$.MODULE$;
            }
            throw throwable;
        }
        return seq;
    }

    private GitFetcher$() {
        MODULE$ = this;
        this.tagResultRegex = new StringOps(Predef$.MODULE$.augmentString(" \\* \\[new tag\\][ ]+([\\S]+).*")).r();
    }
}

