/*
 * Decompiled with CFR 0.152.
 */
package bleep.plugin.versioning;

import bleep.plugin.versioning.BufferingProcessLogger;
import bleep.plugin.versioning.GitBranchState;
import bleep.plugin.versioning.GitBranchStateNoCommits$;
import bleep.plugin.versioning.GitBranchStateNoReleases;
import bleep.plugin.versioning.GitBranchStateOneReleaseHead;
import bleep.plugin.versioning.GitBranchStateOneReleaseNotHead;
import bleep.plugin.versioning.GitBranchStateTwoReleases;
import bleep.plugin.versioning.GitCommit;
import bleep.plugin.versioning.GitCommit$;
import bleep.plugin.versioning.GitCommitWithCount;
import bleep.plugin.versioning.GitDriver;
import bleep.plugin.versioning.GitWorkingState;
import bleep.plugin.versioning.ReleaseVersion;
import bleep.plugin.versioning.ReleaseVersion$;
import bleep.plugin.versioning.SemanticVersion;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\n\u0015\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006_\u0001!\t\u0001\r\u0004\u0005g\u0001!A\u0007\u0003\u0005B\u0007\t\u0005\t\u0015!\u0003C\u0011\u0015y3\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0005P\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0011\u001d1\u0006A1A\u0005B]Caa\u0017\u0001!\u0002\u0013A\u0006\"\u0002/\u0001\t\u0003j\u0006\"B1\u0001\t\u0003\u0012\u0007\"B6\u0001\t\u0013a\u0007\"B7\u0001\t\u0013q\u0007\"B;\u0001\t\u00131\b\"B=\u0001\t\u0013Q\b\"B>\u0001\t\u0013a\b\"B?\u0001\t\u0013q\b\"CA\b\u0001E\u0005I\u0011BA\t\u000559\u0015\u000e\u001e#sSZ,'/S7qY*\u0011QCF\u0001\u000bm\u0016\u00148/[8oS:<'BA\f\u0019\u0003\u0019\u0001H.^4j]*\t\u0011$A\u0003cY\u0016,\u0007o\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G\u0011j\u0011\u0001F\u0005\u0003KQ\u0011\u0011bR5u\tJLg/\u001a:\u0002\u0007\u0011L'\u000f\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005\u0011\u0011n\u001c\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013F\u0001\u0003GS2,\u0017A\u0002\u001fj]&$h\b\u0006\u00022eA\u00111\u0005\u0001\u0005\u0006M\t\u0001\ra\n\u0002\r\u000f&$X\t_2faRLwN\\\n\u0003\u0007U\u0002\"A\u000e \u000f\u0005]bdB\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u001b\u0003\u0019a$o\\8u}%\tq$\u0003\u0002>=\u00059\u0001/Y2lC\u001e,\u0017BA A\u0005%)\u0005pY3qi&|gN\u0003\u0002>=\u0005\u0019Qn]4\u0011\u0005\r;eB\u0001#F!\tAd$\u0003\u0002G=\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1e\u0004\u0006\u0002L\u001bB\u0011AjA\u0007\u0002\u0001!)\u0011)\u0002a\u0001\u0005\u0006y\u0011n]$ji\u000e{W\u000e]1uS\ndW-F\u0001Q!\ti\u0012+\u0003\u0002S=\t9!i\\8mK\u0006t\u0017!C5t\u000f&$(+\u001a9p)\t\u0001V\u000bC\u0003'\u000f\u0001\u0007q%A\u0006ce\u0006t7\r[*uCR,W#\u0001-\u0011\u0005\rJ\u0016B\u0001.\u0015\u000599\u0015\u000e\u001e\"sC:\u001c\u0007n\u0015;bi\u0016\fAB\u0019:b]\u000eD7\u000b^1uK\u0002\nAb^8sW&twm\u0015;bi\u0016,\u0012A\u0018\t\u0003G}K!\u0001\u0019\u000b\u0003\u001f\u001dKGoV8sW&twm\u0015;bi\u0016\fabZ3u\u0007>lW.\u001b;D_VtG\u000f\u0006\u0002dMB\u0011Q\u0004Z\u0005\u0003Kz\u00111!\u00138u\u0011\u001597\u00021\u0001i\u0003\u0011A\u0017m\u001d5\u0011\u0007uI')\u0003\u0002k=\t1q\n\u001d;j_:\f\u0011bZ5u\u0005J\fgn\u00195\u0016\u0003\t\u000bQbZ5u\r>\u0014X)Y2i%\u00164W#A8\u0011\u0007Y\u0002(/\u0003\u0002r\u0001\n\u00191+Z9\u0011\u0005\r\u001a\u0018B\u0001;\u0015\u0005%9\u0015\u000e^\"p[6LG/\u0001\u0004hSRdun\u001a\u000b\u0003_^DQ\u0001\u001f\bA\u0002\t\u000b\u0011\"\u0019:hk6,g\u000e^:\u0002\u0015\rDWmY6DY\u0016\fg\u000eF\u0001Q\u0003e1\u0017N\u001c3BE\n\u0014XM^5bi\u0016$\u0007*Y:i\u0019\u0016tw\r\u001e5\u0015\u0003\r\f!B];o\u0007>lW.\u00198e)\u0015y\u0018qAA\u0006!\u0019i\u0012\u0011A2\u0002\u0006%\u0019\u00111\u0001\u0010\u0003\rQ+\b\u000f\\33!\r1\u0004O\u0011\u0005\u0007\u0003\u0013\t\u0002\u0019\u0001\"\u0002\u0007\rlG\r\u0003\u0005\u0002\u000eE\u0001\n\u00111\u0001Q\u00039!\bN]8x\u0013\u001atuN\u001c.fe>\fAC];o\u0007>lW.\u00198eI\u0011,g-Y;mi\u0012\u0012TCAA\nU\r\u0001\u0016QC\u0016\u0003\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0005\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0005m!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class GitDriverImpl
implements GitDriver {
    private final File dir;
    private final GitBranchState branchState;

    @Override
    public SemanticVersion calcCurrentVersion(boolean ignoreDirty) {
        return GitDriver.calcCurrentVersion$(this, ignoreDirty);
    }

    public boolean isGitCompatible() {
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply("git --version", this.dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        Regex gitSemver = new StringOps(Predef$.MODULE$.augmentString("git version (\\d+)\\.(\\d+)\\.(\\d+).*")).r();
        int n = exitCode;
        switch (n) {
            case 0: {
                String gitVersion;
                String string = gitVersion = outputLogger.stdout().mkString("").trim().toLowerCase();
                Option option = gitSemver.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                    String major = (String)((LinearSeqOptimized)option.get()).apply(0);
                    return new StringOps(Predef$.MODULE$.augmentString(major)).toInt() > 1;
                }
                throw new GitException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(84).append("Version output was not of the form 'git version x.y.z'\n              |version was '").append(gitVersion).append("'").toString())).stripMargin());
            }
        }
        throw new GitException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(n).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())).stripMargin());
    }

    private boolean isGitRepo(File dir) {
        int exitCode;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int n = exitCode = Process$.MODULE$.apply("git rev-parse --is-inside-work-tree", dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        switch (n) {
            case 0: {
                String string = outputLogger.stdout().mkString("").trim().toLowerCase();
                String string2 = "true";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            case 128: {
                return false;
            }
        }
        throw new GitException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Unexpected git exit status: ").append(n).append("\n             |stderr:\n             |").append(outputLogger.stderr().mkString("\n")).append("\n             |stdout:\n             |").append(outputLogger.stdout().mkString("\n")).toString())).stripMargin());
    }

    @Override
    public GitBranchState branchState() {
        return this.branchState;
    }

    @Override
    public GitWorkingState workingState() {
        return new GitWorkingState(!this.checkClean());
    }

    @Override
    public int getCommitCount(Option<String> hash) {
        String limitStr = (String)hash.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("^").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(new StringBuilder(41).append("git rev-list --first-parent --count HEAD ").append(limitStr).toString().trim(), this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq output = (Seq)tuple2._2();
        Seq output2 = output;
        return new StringOps(Predef$.MODULE$.augmentString(output2.mkString("").trim())).toInt();
    }

    private String gitBranch() {
        String cmd = "git rev-parse --abbrev-ref HEAD";
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = tuple22._1$mcI$sp();
        Seq output2 = (Seq)tuple22._2();
        int n = exitCode2;
        switch (n) {
            case 0: {
                Seq res = (Seq)output2.map((Function1 & Serializable & scala.Serializable)line -> line, Seq$.MODULE$.canBuildFrom());
                return (String)res.head();
            }
            case 128: {
                throw new IllegalStateException("Error 128: a git cmd was run in a dir that is not under git vcs or git rev-parse failed to run.");
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private Seq<GitCommit> gitForEachRef() {
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
        String cmd = new StringBuilder(54).append("git for-each-ref --sort=-v:refname refs/tags --merged=").append(this.gitBranch()).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = tuple22._1$mcI$sp();
        Seq output2 = (Seq)tuple22._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                int abbreviatedHashLength = this.findAbbreviatedHashLength();
                return (Seq)output2.map((Function1 & Serializable & scala.Serializable)line -> GitCommit$.MODULE$.fromGitRef((String)line, abbreviatedHashLength), Seq$.MODULE$.canBuildFrom());
            }
        }
        throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(n).toString());
    }

    private Seq<GitCommit> gitLog(String arguments) {
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
        String cmd = new StringBuilder(79).append("git log --oneline --decorate=short --simplify-by-decoration --no-abbrev-commit ").append(arguments).toString();
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand(cmd, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = tuple22._1$mcI$sp();
        Seq output2 = (Seq)tuple22._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                int abbreviatedHashLength = this.findAbbreviatedHashLength();
                return (Seq)output2.map((Function1 & Serializable & scala.Serializable)line -> GitCommit$.MODULE$.fromGitLog((String)line, abbreviatedHashLength), Seq$.MODULE$.canBuildFrom());
            }
        }
        throw new IllegalStateException(new StringBuilder(41).append("Non-zero exit code when running git log: ").append(n).toString());
    }

    private boolean checkClean() {
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git status --porcelain --untracked-files=no", this.runCommand$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq output = (Seq)tuple2._2();
        Seq output2 = output;
        return output2.mkString("").isEmpty();
    }

    private int findAbbreviatedHashLength() {
        Tuple2<Object, Seq<String>> tuple2 = this.runCommand("git rev-parse --short HEAD", false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = tuple22._1$mcI$sp();
        Seq output2 = (Seq)tuple22._2();
        int n = exitCode2;
        switch (n) {
            case 0: 
            case 128: {
                return package$.MODULE$.max(output2.mkString("").trim().length(), 7);
            }
        }
        throw new IllegalStateException(new StringBuilder(47).append("Non-zero exit code when running git rev-parse: ").append(n).toString());
    }

    private Tuple2<Object, Seq<String>> runCommand(String cmd, boolean throwIfNonZero) {
        Predef$.MODULE$.require(this.isGitRepo(this.dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int exitCode = Process$.MODULE$.apply(cmd, this.dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)outputLogger);
        Tuple2 result = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)outputLogger.stdout().toSeq());
        if (throwIfNonZero && exitCode != 0) {
            throw new IllegalStateException(new StringBuilder(36).append("Non-zero exit code when running '").append(cmd).append("': ").append(exitCode).toString());
        }
        return result;
    }

    private boolean runCommand$default$2() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public GitDriverImpl(File dir) {
        GitBranchState gitBranchState;
        block9: {
            Option option;
            block10: {
                Option option2;
                Some some;
                Tuple2 tuple2;
                Option option3;
                Tuple2 tuple22;
                GitCommit headCommit;
                block12: {
                    Some some2;
                    Tuple2 tuple23;
                    block11: {
                        Some some3;
                        Tuple2 tuple24;
                        Some some4;
                        Tuple2 tuple25;
                        Option maybePrevRelease;
                        this.dir = dir;
                        GitDriver.$init$(this);
                        Predef$.MODULE$.require(this.isGitRepo(dir), (Function0 & Serializable & scala.Serializable)() -> "Must be in a git repository");
                        Predef$.MODULE$.require(this.isGitCompatible(), (Function0 & Serializable & scala.Serializable)() -> "Must be git version 2.X.X or greater");
                        option = this.gitLog("--max-count=1").headOption();
                        if (!(option instanceof Some)) break block10;
                        Some some5 = (Some)option;
                        headCommit = (GitCommit)some5.value();
                        Seq releaseRefs = (Seq)this.gitForEachRef().collect((PartialFunction)new scala.Serializable(null){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends GitCommit, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                Option<ReleaseVersion> option = ReleaseVersion$.MODULE$.unapply(A1);
                                if (!option.isEmpty()) {
                                    ReleaseVersion rv = (ReleaseVersion)option.get();
                                    return (B1)new Tuple2(A1, (Object)rv);
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(GitCommit x1) {
                                GitCommit gitCommit = x1;
                                Option<ReleaseVersion> option = ReleaseVersion$.MODULE$.unapply(gitCommit);
                                return !option.isEmpty();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq releases = (Seq)((TraversableLike)releaseRefs.take(2)).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(this.gitLog(new StringBuilder(14).append(((GitCommit)tp._1()).fullHash()).append(" --max-count=1").toString()).head(), tp._2()), Seq$.MODULE$.canBuildFrom());
                        Option maybeCurrRelease = releases.headOption();
                        tuple22 = new Tuple2((Object)maybeCurrRelease, (Object)(maybePrevRelease = ((TraversableLike)releases.drop(1)).headOption()));
                        if (tuple22 != null) {
                            Some some6;
                            Tuple2 tuple26;
                            Option option4 = (Option)tuple22._1();
                            Option option5 = (Option)tuple22._2();
                            if (option4 instanceof Some && (tuple26 = (Tuple2)(some6 = (Some)option4).value()) != null) {
                                Some some7;
                                Tuple2 tuple27;
                                GitCommit currCommit = (GitCommit)tuple26._1();
                                if (option5 instanceof Some && (tuple27 = (Tuple2)(some7 = (Some)option5).value()) != null) {
                                    GitCommit prevCommit = (GitCommit)tuple27._1();
                                    GitCommit gitCommit = currCommit;
                                    GitCommit gitCommit2 = prevCommit;
                                    if (!(gitCommit != null ? !((Object)gitCommit).equals(gitCommit2) : gitCommit2 != null)) {
                                        throw new IllegalStateException(new StringBuilder(36).append("currCommit=").append(currCommit).append(" cannot equal prevCommit=").append(prevCommit).toString());
                                    }
                                }
                            }
                        }
                        if (tuple22 == null) break block11;
                        Option option6 = (Option)tuple22._1();
                        Option option7 = (Option)tuple22._2();
                        if (!(option6 instanceof Some) || (tuple25 = (Tuple2)(some4 = (Some)option6).value()) == null) break block11;
                        GitCommit currCommit = (GitCommit)tuple25._1();
                        ReleaseVersion currVersion = (ReleaseVersion)tuple25._2();
                        if (!(option7 instanceof Some) || (tuple24 = (Tuple2)(some3 = (Some)option7).value()) == null) break block11;
                        GitCommit prevCommit = (GitCommit)tuple24._1();
                        ReleaseVersion prevVersion = (ReleaseVersion)tuple24._2();
                        GitCommit gitCommit = currCommit;
                        GitCommit gitCommit3 = headCommit;
                        if (gitCommit != null ? !((Object)gitCommit).equals(gitCommit3) : gitCommit3 != null) break block11;
                        gitBranchState = new GitBranchStateTwoReleases(currCommit, currVersion, prevCommit, prevVersion);
                        break block9;
                    }
                    if (tuple22 == null) break block12;
                    Option option8 = (Option)tuple22._1();
                    Option option9 = (Option)tuple22._2();
                    if (!(option8 instanceof Some) || (tuple23 = (Tuple2)(some2 = (Some)option8).value()) == null) break block12;
                    GitCommit currCommit = (GitCommit)tuple23._1();
                    ReleaseVersion currVersion = (ReleaseVersion)tuple23._2();
                    if (!None$.MODULE$.equals(option9)) break block12;
                    GitCommit gitCommit = currCommit;
                    GitCommit gitCommit4 = headCommit;
                    if (gitCommit != null ? !((Object)gitCommit).equals(gitCommit4) : gitCommit4 != null) break block12;
                    gitBranchState = new GitBranchStateOneReleaseHead(currCommit, currVersion);
                    break block9;
                }
                if (tuple22 != null && (option3 = (Option)tuple22._1()) instanceof Some && (tuple2 = (Tuple2)(some = (Some)option3).value()) != null) {
                    GitCommit currCommit = (GitCommit)tuple2._1();
                    ReleaseVersion currVersion = (ReleaseVersion)tuple2._2();
                    GitCommitWithCount headCommitWithCount = new GitCommitWithCount(headCommit, this.getCommitCount((Option<String>)new Some((Object)currCommit.fullHash())));
                    gitBranchState = new GitBranchStateOneReleaseNotHead(headCommitWithCount, currCommit, currVersion);
                    break block9;
                } else if (tuple22 != null && None$.MODULE$.equals(option2 = (Option)tuple22._1())) {
                    gitBranchState = new GitBranchStateNoReleases(new GitCommitWithCount(headCommit, this.getCommitCount((Option<String>)None$.MODULE$)));
                    break block9;
                } else {
                    throw new MatchError((Object)tuple22);
                }
            }
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
            gitBranchState = GitBranchStateNoCommits$.MODULE$;
        }
        this.branchState = gitBranchState;
    }

    private class GitException
    extends Exception {
        public /* synthetic */ GitDriverImpl bleep$plugin$versioning$GitDriverImpl$GitException$$$outer() {
            return GitDriverImpl.this;
        }

        public GitException(String msg) {
            if (GitDriverImpl.this == null) {
                throw null;
            }
            super(msg);
        }
    }
}

