/*
 * Decompiled with CFR 0.152.
 */
package bleep.logging;

import bleep.logging.Formatter;
import bleep.logging.Formatter$;
import bleep.logging.LogLevel;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.Metadata;
import bleep.logging.Pattern;
import bleep.logging.TypedLogger$;
import bleep.logging.TypedLogger$ConsoleLogger$;
import bleep.logging.TypedLogger$LoggerAuxSyntax$;
import bleep.logging.TypedLogger$Stored$;
import fansi.Str;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import sourcecode.Text;
import sourcecode.Text$;

public interface TypedLogger<Underlying>
extends LoggerFn {
    public static <U> TypedLogger LoggerAuxSyntax(TypedLogger<U> typedLogger) {
        return TypedLogger$.MODULE$.LoggerAuxSyntax(typedLogger);
    }

    public Underlying underlying();

    public <T> TypedLogger<Underlying> withContext(String var1, T var2, Formatter<T> var3);

    public TypedLogger<Underlying> withPath(String var1);

    public static TypedLogger withContext$(TypedLogger $this, Text value, Formatter evidence$1) {
        return $this.withContext(value, evidence$1);
    }

    default public <T> TypedLogger<Underlying> withContext(Text<T> value, Formatter<T> evidence$1) {
        return this.withContext(value.source(), value.value(), evidence$1);
    }

    public static TypedLogger withOptContext$(TypedLogger $this, String key, Option maybeValue, Formatter evidence$1) {
        return $this.withOptContext(key, maybeValue, evidence$1);
    }

    default public <T> TypedLogger<Underlying> withOptContext(String key, Option<T> maybeValue, Formatter<T> evidence$1) {
        Option<T> option = maybeValue;
        if (option instanceof Some) {
            Object value = ((Some)option).value();
            return this.withContext(key, value, evidence$1);
        }
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        throw new MatchError(option);
    }

    public Option<LoggerFn> progressMonitor();

    public static final class ConsoleLogger<U extends PrintStream>
    implements TypedLogger<U> {
        private final U underlying;
        public final Pattern bleep$logging$TypedLogger$ConsoleLogger$$pattern;
        private final Map<String, Str> context;
        public final List<String> bleep$logging$TypedLogger$ConsoleLogger$$path;
        private final boolean disableProgress;
        public final AtomicBoolean bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress;
        private final String CleanCurrentLine;

        public static <U extends PrintStream> AtomicBoolean $lessinit$greater$default$6() {
            return TypedLogger$ConsoleLogger$.MODULE$.$lessinit$greater$default$6();
        }

        public ConsoleLogger(U underlying, Pattern pattern, Map<String, Str> context, List<String> path, boolean disableProgress, AtomicBoolean lastWasProgress) {
            this.underlying = underlying;
            this.bleep$logging$TypedLogger$ConsoleLogger$$pattern = pattern;
            this.context = context;
            this.bleep$logging$TypedLogger$ConsoleLogger$$path = path;
            this.disableProgress = disableProgress;
            this.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress = lastWasProgress;
            this.CleanCurrentLine = "\u001b[K";
        }

        @Override
        public U underlying() {
            return this.underlying;
        }

        public Map<String, Str> context() {
            return this.context;
        }

        public String CleanCurrentLine() {
            return this.CleanCurrentLine;
        }

        @Override
        public <T> void log(Function0<T> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$1) {
            Str formatted = this.bleep$logging$TypedLogger$ConsoleLogger$$pattern.apply(() -> this.$anonfun$2(t), throwable, metadata, this.context(), this.bleep$logging$TypedLogger$ConsoleLogger$$path, evidence$1);
            if (this.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress.get()) {
                ((PrintStream)this.underlying()).println(new StringBuilder(0).append(this.CleanCurrentLine()).append(formatted.render()).toString());
            } else {
                ((PrintStream)this.underlying()).println(formatted.render());
            }
            this.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress.set(false);
        }

        @Override
        public <T> ConsoleLogger<U> withContext(String key, T value, Formatter<T> evidence$1) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
            return new ConsoleLogger<Object>(this.underlying(), this.bleep$logging$TypedLogger$ConsoleLogger$$pattern, (Map<String, Str>)((Map)this.context().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Formatter$.MODULE$.apply(value, evidence$1)))), this.bleep$logging$TypedLogger$ConsoleLogger$$path, this.disableProgress, this.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress);
        }

        @Override
        public ConsoleLogger<U> withPath(String fragment) {
            return new ConsoleLogger<Object>(this.underlying(), this.bleep$logging$TypedLogger$ConsoleLogger$$pattern, this.context(), (List<String>)this.bleep$logging$TypedLogger$ConsoleLogger$$path.$colon$colon((Object)fragment), this.disableProgress, this.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress);
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            if (this.disableProgress) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)new LoggerFn(this){
                private final /* synthetic */ ConsoleLogger $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void log(Function0 text, Option throwable, Metadata metadata, Formatter evidence$1) {
                    Str formatted = this.$outer.bleep$logging$TypedLogger$ConsoleLogger$$pattern.apply(() -> TypedLogger$.bleep$logging$TypedLogger$ConsoleLogger$$anon$1$$_$_$$anonfun$3(text), (Option<Throwable>)throwable, metadata, this.$outer.context(), this.$outer.bleep$logging$TypedLogger$ConsoleLogger$$path, evidence$1);
                    if (this.$outer.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress.get()) {
                        ((PrintStream)this.$outer.underlying()).print(new StringBuilder(1).append(this.$outer.CleanCurrentLine()).append(formatted.render()).append("\r").toString());
                        return;
                    }
                    ((PrintStream)this.$outer.underlying()).print(new StringBuilder(1).append(formatted.render()).append("\r").toString());
                    this.$outer.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress.set(true);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{bleep$logging$TypedLogger$ConsoleLogger$$anon$1$$_$_$$anonfun$3(scala.Function0 )}, serializedLambda);
                }
            });
        }

        private final Object v$proxy2$1(Function0 t$4) {
            return t$4.apply();
        }

        private final Text $anonfun$2(Function0 t$3) {
            return Text$.MODULE$.apply(this.v$proxy2$1(t$3), "t");
        }
    }

    public static final class LoggerAuxSyntax<U> {
        private final TypedLogger<U> self;

        public static <U> boolean equals$extension(TypedLogger typedLogger, Object object) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.equals$extension(typedLogger, object);
        }

        public static <U> int hashCode$extension(TypedLogger typedLogger) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.hashCode$extension(typedLogger);
        }

        public static <UU, U> TypedLogger<Tuple2<U, Option<UU>>> maybeZipWith$extension(TypedLogger typedLogger, Option<TypedLogger<UU>> option) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.maybeZipWith$extension(typedLogger, option);
        }

        public static <U> TypedLogger<U> minLogLevel$extension(TypedLogger typedLogger, LogLevel logLevel) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.minLogLevel$extension(typedLogger, logLevel);
        }

        public static <U> TypedLogger<U> syncAccess$extension(TypedLogger typedLogger) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.syncAccess$extension(typedLogger);
        }

        public static <U> TypedLogger<BoxedUnit> untyped$extension(TypedLogger typedLogger) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.untyped$extension(typedLogger);
        }

        public static <UU, U> TypedLogger<Tuple2<U, UU>> zipWith$extension(TypedLogger typedLogger, TypedLogger<UU> typedLogger2) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.zipWith$extension(typedLogger, typedLogger2);
        }

        public LoggerAuxSyntax(TypedLogger<U> self) {
            this.self = self;
        }

        public int hashCode() {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.hashCode$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self());
        }

        public boolean equals(Object x$0) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.equals$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self(), x$0);
        }

        public TypedLogger<U> bleep$logging$TypedLogger$LoggerAuxSyntax$$self() {
            return this.self;
        }

        public <UU> TypedLogger<Tuple2<U, UU>> zipWith(TypedLogger<UU> other) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.zipWith$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self(), other);
        }

        public <UU> TypedLogger<Tuple2<U, Option<UU>>> maybeZipWith(Option<TypedLogger<UU>> other) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.maybeZipWith$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self(), other);
        }

        public TypedLogger<U> minLogLevel(LogLevel minLogLevel) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.minLogLevel$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self(), minLogLevel);
        }

        public TypedLogger<BoxedUnit> untyped() {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.untyped$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self());
        }

        public TypedLogger<U> syncAccess() {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.syncAccess$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self());
        }
    }

    public static final class Mapped<U, UU>
    implements TypedLogger<UU> {
        private final TypedLogger<U> wrapped;
        private final Function1<U, UU> f;

        public Mapped(TypedLogger<U> wrapped, Function1<U, UU> f) {
            this.wrapped = wrapped;
            this.f = f;
        }

        @Override
        public UU underlying() {
            return (UU)this.f.apply(this.wrapped.underlying());
        }

        @Override
        public <T> void log(Function0<T> t, Option<Throwable> throwable, Metadata m, Formatter<T> evidence$1) {
            this.wrapped.log(t, throwable, m, evidence$1);
        }

        public <T> Mapped<U, UU> withContext(String key, T value, Formatter<T> evidence$1) {
            return new Mapped<U, UU>(this.wrapped.withContext(key, value, evidence$1), this.f);
        }

        public Mapped<U, UU> withPath(String fragment) {
            return new Mapped<U, UU>(this.wrapped.withPath(fragment), this.f);
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return this.wrapped.progressMonitor();
        }
    }

    public static final class MaybeZipped<U1, U2>
    implements TypedLogger<Tuple2<U1, Option<U2>>> {
        private final TypedLogger<U1> one;
        private final Option<TypedLogger<U2>> two;
        private final LoggerFn both;

        public MaybeZipped(TypedLogger<U1> one, Option<TypedLogger<U2>> two) {
            LoggerFn loggerFn;
            this.one = one;
            this.two = two;
            Option<TypedLogger<U2>> option = two;
            if (option instanceof Some) {
                TypedLogger two2 = (TypedLogger)((Some)option).value();
                loggerFn = LoggerFn$Syntax$.MODULE$.and$extension(LoggerFn$.MODULE$.Syntax(one), two2);
            } else if (None$.MODULE$.equals(option)) {
                loggerFn = one;
            } else {
                throw new MatchError(option);
            }
            this.both = loggerFn;
        }

        @Override
        public Tuple2<U1, Option<U2>> underlying() {
            return Tuple2$.MODULE$.apply(this.one.underlying(), (Object)this.two.map(TypedLogger$::bleep$logging$TypedLogger$MaybeZipped$$_$underlying$$anonfun$1));
        }

        @Override
        public <T> void log(Function0<T> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$1) {
            this.both.log(t, throwable, metadata, evidence$1);
        }

        public <T> MaybeZipped<U1, U2> withContext(String key, T value, Formatter<T> evidence$1) {
            return new MaybeZipped<U1, U2>(this.one.withContext(key, value, evidence$1), this.two.map(arg_0 -> TypedLogger$.bleep$logging$TypedLogger$MaybeZipped$$_$withContext$$anonfun$1(key, value, evidence$1, arg_0)));
        }

        public MaybeZipped<U1, U2> withPath(String fragment) {
            return new MaybeZipped<U1, U2>(this.one.withPath(fragment), this.two.map(arg_0 -> TypedLogger$.bleep$logging$TypedLogger$MaybeZipped$$_$withPath$$anonfun$1(fragment, arg_0)));
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            Option<LoggerFn> option = this.one.progressMonitor();
            if (option instanceof Some) {
                Some some = (Some)option;
                return some;
            }
            if (None$.MODULE$.equals(option)) {
                Option<TypedLogger<U2>> option2 = this.two;
                if (option2 instanceof Some) {
                    TypedLogger two = (TypedLogger)((Some)option2).value();
                    return two.progressMonitor();
                }
                if (None$.MODULE$.equals(option2)) {
                    return None$.MODULE$;
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
    }

    public static final class MinLogLevel<U>
    implements TypedLogger<U> {
        private final TypedLogger<U> wrapped;
        private final LogLevel minLogLevel;

        public MinLogLevel(TypedLogger<U> wrapped, LogLevel minLogLevel) {
            this.wrapped = wrapped;
            this.minLogLevel = minLogLevel;
        }

        @Override
        public U underlying() {
            return this.wrapped.underlying();
        }

        @Override
        public <T> void log(Function0<T> t, Option<Throwable> throwable, Metadata m, Formatter<T> evidence$1) {
            if (m.logLevel().level() >= this.minLogLevel.level()) {
                this.wrapped.log(t, throwable, m, evidence$1);
                return;
            }
        }

        @Override
        public <T> MinLogLevel<U> withContext(String key, T value, Formatter<T> evidence$1) {
            return new MinLogLevel<U>(this.wrapped.withContext(key, value, evidence$1), this.minLogLevel);
        }

        @Override
        public MinLogLevel<U> withPath(String fragment) {
            return new MinLogLevel<U>(this.wrapped.withPath(fragment), this.minLogLevel);
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return this.wrapped.progressMonitor();
        }
    }

    public static class Store {
        private List<Stored> reversed = package$.MODULE$.Nil();

        public void store(Stored s) {
            this.reversed = this.reversed.$colon$colon((Object)s);
        }

        public Stored[] normal() {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.reversed.toArray(ClassTag$.MODULE$.apply(Stored.class)));
            return (Stored[])ArrayOps$.MODULE$.reverse$extension(object);
        }
    }

    public static class Stored
    implements Product,
    Serializable {
        private final Str message;
        private final Option<Throwable> throwable;
        private final Metadata metadata;
        private final Map<String, Str> ctx;
        private final List<String> path;

        public static Stored apply(Str str, Option<Throwable> option, Metadata metadata, Map<String, Str> map, List<String> list) {
            return TypedLogger$Stored$.MODULE$.apply(str, option, metadata, map, list);
        }

        public static Stored fromProduct(Product product) {
            return TypedLogger$Stored$.MODULE$.fromProduct(product);
        }

        public static Stored unapply(Stored stored) {
            return TypedLogger$Stored$.MODULE$.unapply(stored);
        }

        public Stored(Str message, Option<Throwable> throwable, Metadata metadata, Map<String, Str> ctx, List<String> path) {
            this.message = message;
            this.throwable = throwable;
            this.metadata = metadata;
            this.ctx = ctx;
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Stored)) return false;
            Stored stored = (Stored)object;
            Str str = this.message();
            Str str2 = stored.message();
            if (str == null) {
                if (str2 != null) {
                    return false;
                }
            } else if (!str.equals(str2)) return false;
            Option<Throwable> option = this.throwable();
            Option<Throwable> option2 = stored.throwable();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Metadata metadata = this.metadata();
            Metadata metadata2 = stored.metadata();
            if (metadata == null) {
                if (metadata2 != null) {
                    return false;
                }
            } else if (!metadata.equals(metadata2)) return false;
            Map<String, Str> map = this.ctx();
            Map<String, Str> map2 = stored.ctx();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            List<String> list = this.path();
            List<String> list2 = stored.path();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!stored.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Stored;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Stored";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "message";
                }
                case 1: {
                    return "throwable";
                }
                case 2: {
                    return "metadata";
                }
                case 3: {
                    return "ctx";
                }
                case 4: {
                    return "path";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Str message() {
            return this.message;
        }

        public Option<Throwable> throwable() {
            return this.throwable;
        }

        public Metadata metadata() {
            return this.metadata;
        }

        public Map<String, Str> ctx() {
            return this.ctx;
        }

        public List<String> path() {
            return this.path;
        }

        public Stored copy(Str message, Option<Throwable> throwable, Metadata metadata, Map<String, Str> ctx, List<String> path) {
            return new Stored(message, throwable, metadata, ctx, path);
        }

        public Str copy$default$1() {
            return this.message();
        }

        public Option<Throwable> copy$default$2() {
            return this.throwable();
        }

        public Metadata copy$default$3() {
            return this.metadata();
        }

        public Map<String, Str> copy$default$4() {
            return this.ctx();
        }

        public List<String> copy$default$5() {
            return this.path();
        }

        public Str _1() {
            return this.message();
        }

        public Option<Throwable> _2() {
            return this.throwable();
        }

        public Metadata _3() {
            return this.metadata();
        }

        public Map<String, Str> _4() {
            return this.ctx();
        }

        public List<String> _5() {
            return this.path();
        }
    }

    public static final class StoringLogger
    implements TypedLogger<Stored[]> {
        private final Store store;
        private final Map<String, Str> ctx;
        private final List<String> path;

        public StoringLogger(Store store, Map<String, Str> ctx, List<String> path) {
            this.store = store;
            this.ctx = ctx;
            this.path = path;
        }

        public Map<String, Str> ctx() {
            return this.ctx;
        }

        @Override
        public <T> void log(Function0<T> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$1) {
            this.store.store(TypedLogger$Stored$.MODULE$.apply(Formatter$.MODULE$.apply(t.apply(), evidence$1), throwable, metadata, this.ctx(), this.path));
        }

        public <T> StoringLogger withContext(String key, T value, Formatter<T> evidence$1) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
            return new StoringLogger(this.store, (Map<String, Str>)((Map)this.ctx().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Formatter$.MODULE$.apply(value, evidence$1)))), this.path);
        }

        @Override
        public TypedLogger<Stored[]> withPath(String fragment) {
            return new StoringLogger(this.store, this.ctx(), (List<String>)this.path.$colon$colon((Object)fragment));
        }

        @Override
        public Stored[] underlying() {
            return this.store.normal();
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return None$.MODULE$;
        }
    }

    public static final class Synchronized<U>
    implements TypedLogger<U> {
        private final TypedLogger<U> wrapped;

        public Synchronized(TypedLogger<U> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public U underlying() {
            return this.wrapped.underlying();
        }

        @Override
        public <T> void log(Function0<T> t, Option<Throwable> throwable, Metadata m, Formatter<T> evidence$1) {
            Synchronized synchronized_ = this;
            synchronized (synchronized_) {
                this.wrapped.log(t, throwable, m, evidence$1);
            }
        }

        @Override
        public <T> Synchronized<U> withContext(String key, T value, Formatter<T> evidence$1) {
            return new Synchronized<U>(this.wrapped.withContext(key, value, evidence$1));
        }

        @Override
        public Synchronized<U> withPath(String fragment) {
            return new Synchronized<U>(this.wrapped.withPath(fragment));
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return this.wrapped.progressMonitor();
        }
    }

    public static final class WriterLogger<U extends Writer>
    implements TypedLogger<U> {
        private final U underlying;
        private final boolean flush;
        private final Pattern pattern;
        private final Map<String, Str> context;
        private final List<String> path;

        public WriterLogger(U underlying, boolean flush, Pattern pattern, Map<String, Str> context, List<String> path) {
            this.underlying = underlying;
            this.flush = flush;
            this.pattern = pattern;
            this.context = context;
            this.path = path;
        }

        @Override
        public U underlying() {
            return this.underlying;
        }

        public Map<String, Str> context() {
            return this.context;
        }

        public List<String> path() {
            return this.path;
        }

        @Override
        public <T> void log(Function0<T> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$1) {
            Str formatted = this.pattern.apply(() -> this.$anonfun$1(t), throwable, metadata, this.context(), this.path(), evidence$1);
            ((Writer)this.underlying()).append(new StringBuilder(1).append(formatted.render()).append("\n").toString());
            if (this.flush) {
                ((Writer)this.underlying()).flush();
            }
        }

        @Override
        public <T> WriterLogger<U> withContext(String key, T value, Formatter<T> evidence$1) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
            return new WriterLogger<Object>(this.underlying(), this.flush, this.pattern, (Map<String, Str>)((Map)this.context().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Formatter$.MODULE$.apply(value, evidence$1)))), this.path());
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return None$.MODULE$;
        }

        @Override
        public WriterLogger<U> withPath(String fragment) {
            return new WriterLogger<Object>(this.underlying(), this.flush, this.pattern, this.context(), (List<String>)this.path().$colon$colon((Object)fragment));
        }

        private final Object v$proxy1$1(Function0 t$2) {
            return t$2.apply();
        }

        private final Text $anonfun$1(Function0 t$1) {
            return Text$.MODULE$.apply(this.v$proxy1$1(t$1), "t");
        }
    }

    public static final class Zipped<U1, U2>
    implements TypedLogger<Tuple2<U1, U2>> {
        private final TypedLogger<U1> one;
        private final TypedLogger<U2> two;
        private final LoggerFn both;

        public Zipped(TypedLogger<U1> one, TypedLogger<U2> two) {
            this.one = one;
            this.two = two;
            this.both = LoggerFn$Syntax$.MODULE$.and$extension(LoggerFn$.MODULE$.Syntax(one), two);
        }

        @Override
        public Tuple2<U1, U2> underlying() {
            return Tuple2$.MODULE$.apply(this.one.underlying(), this.two.underlying());
        }

        @Override
        public <T> void log(Function0<T> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$1) {
            this.both.log(t, throwable, metadata, evidence$1);
        }

        public <T> Zipped<U1, U2> withContext(String key, T value, Formatter<T> evidence$1) {
            return new Zipped<U1, U2>(this.one.withContext(key, value, evidence$1), this.two.withContext(key, value, evidence$1));
        }

        public Zipped<U1, U2> withPath(String fragment) {
            return new Zipped<U1, U2>(this.one.withPath(fragment), this.two.withPath(fragment));
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return ((IterableOnceOps)((StrictOptimizedIterableOps)new .colon.colon(this.one.progressMonitor(), (List)new .colon.colon(this.two.progressMonitor(), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())).reduceOption(TypedLogger$::bleep$logging$TypedLogger$Zipped$$_$progressMonitor$$anonfun$1);
        }
    }
}

