/*
 * Decompiled with CFR 0.152.
 */
package bleep.internal;

import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Properties$;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;
import sourcecode.Text$;

public final class FileUtils$
implements Serializable {
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(FileUtils$.class.getDeclaredField("cwd$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(FileUtils$.class.getDeclaredField("Home$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(FileUtils$.class.getDeclaredField("TempDir$lzy1"));
    private volatile Object TempDir$lzy1;
    private volatile Object Home$lzy1;
    private volatile Object cwd$lzy1;
    public static final FileUtils$ MODULE$ = new FileUtils$();

    private FileUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileUtils$.class);
    }

    public Path TempDir() {
        Object object = this.TempDir$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.TempDir$lzyINIT1();
    }

    private Object TempDir$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.TempDir$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        path = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.TempDir$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Path Home() {
        Object object = this.Home$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.Home$lzyINIT1();
    }

    private Object Home$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Home$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        path = Path.of(System.getProperty("user.home"), new String[0]);
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Home$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Path cwd() {
        Object object = this.cwd$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.cwd$lzyINIT1();
    }

    private Object cwd$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cwd$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        Path base = Paths.get(System.getProperty("user.dir"), new String[0]);
                        Path path2 = path = Properties$.MODULE$.isWin() ? base.toFile().getCanonicalFile().toPath() : base;
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cwd$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void writeBytes(Path path, byte[] newContent) {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, newContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public void writeGzippedBytes(Path path, byte[] newContent) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        gos.write(newContent);
        gos.close();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, bos.toByteArray(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public byte[] readGzippedBytes(Path path) {
        GZIPInputStream is = new GZIPInputStream((InputStream)new ByteArrayInputStream(Files.readAllBytes(path)), 1024);
        byte[] ret = is.readAllBytes();
        is.close();
        return ret;
    }

    public void writeString(TypedLogger<BoxedUnit> logger, Option<String> message, Path path, String newContent) {
        this.writeBytes(path, newContent.getBytes(StandardCharsets.UTF_8));
        Option<String> option = message;
        if (option instanceof Some) {
            String message2 = (String)((Some)option).value();
            LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger.withContext(Text$.MODULE$.apply((Object)path, "path"), Formatter$.MODULE$.PathFormatter())), () -> FileUtils$.writeString$$anonfun$1(message2), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(51), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/internal/FileUtils.scala"), Enclosing$.MODULE$.apply("bleep.internal.FileUtils.writeString"));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger.withContext(Text$.MODULE$.apply((Object)path, "path"), Formatter$.MODULE$.PathFormatter())), FileUtils$::writeString$$anonfun$2, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(52), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/internal/FileUtils.scala"), Enclosing$.MODULE$.apply("bleep.internal.FileUtils.writeString"));
            return;
        }
        throw new MatchError(option);
    }

    public void deleteDirectory(Path dir) {
        if (this.exists(dir)) {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            return;
        }
    }

    public boolean exists(Path path) {
        return path.toFile().exists();
    }

    private static final String writeString$$anonfun$1(String message$1) {
        return message$1;
    }

    private static final String writeString$$anonfun$2() {
        return "wrote file";
    }
}

