/*
 * Decompiled with CFR 0.152.
 */
package bleep.bsp;

import bleep.BleepException;
import bleep.BuildPaths;
import bleep.Prebootstrapped;
import bleep.Started;
import bleep.bsp.BuildChangeTracker$;
import bleep.bsp.BuildChangeTracker$State$;
import bleep.bsp.BuildChangeTracker$State$No$;
import bleep.bsp.BuildChangeTracker$State$Yes$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.model.BleepConfig;
import bleep.rewrites.BuildRewrite;
import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.DidChangeBuildTarget;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public interface BuildChangeTracker {
    public static BuildChangeTracker make(BleepConfig bleepConfig, Prebootstrapped prebootstrapped, BuildClient buildClient) {
        return BuildChangeTracker$.MODULE$.make(bleepConfig, prebootstrapped, buildClient);
    }

    public static Either<BleepException, List<BuildRewrite>> rewriteFor(BuildPaths buildPaths) {
        return BuildChangeTracker$.MODULE$.rewriteFor(buildPaths);
    }

    public Either<BleepException, Started> ensureBloopUpToDate();

    public Either<BleepException, Started> current();

    public static class Impl
    implements BuildChangeTracker {
        private final AtomicReference<State> atomicState;
        private final BuildClient buildClient;

        public Impl(AtomicReference<State> atomicState, BuildClient buildClient) {
            this.atomicState = atomicState;
            this.buildClient = buildClient;
        }

        @Override
        public Either<BleepException, Started> ensureBloopUpToDate() {
            return this.atomicState.updateAndGet(currentState -> {
                State state;
                Either reloaded = BuildChangeTracker$.MODULE$.rewriteFor(currentState.pre().buildPaths()).flatMap(arg_0 -> BuildChangeTracker$.bleep$bsp$BuildChangeTracker$Impl$$_$_$$anonfun$2(currentState, arg_0));
                Either either = reloaded;
                if (either instanceof Left) {
                    BleepException bleepException = (BleepException)((Left)either).value();
                    state = BuildChangeTracker$State$No$.MODULE$.apply(currentState.bleepConfig(), currentState.pre(), bleepException);
                } else {
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    Option option = (Option)((Right)either).value();
                    if (None$.MODULE$.equals(option)) {
                        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(currentState.pre().logger()), BuildChangeTracker$::bleep$bsp$BuildChangeTracker$Impl$$_$_$$anonfun$3, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(66), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BuildChangeTracker.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BuildChangeTracker.Impl#ensureBloopUpToDate newState"));
                        state = currentState;
                    } else {
                        if (!(option instanceof Some)) throw new MatchError((Object)either);
                        Started newStarted = (Started)((Some)option).value();
                        state = BuildChangeTracker$State$Yes$.MODULE$.apply(newStarted);
                    }
                }
                State.No newState = state;
                Option<DidChangeBuildTarget> option = BuildChangeTracker$.MODULE$.bleep$bsp$BuildChangeTracker$$$computeBuildTargetChanges((State)currentState, newState);
                if (option instanceof Some) {
                    DidChangeBuildTarget changes = (DidChangeBuildTarget)((Some)option).value();
                    LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(newState.pre().logger()), () -> BuildChangeTracker$.bleep$bsp$BuildChangeTracker$Impl$$_$ensureBloopUpToDate$$anonfun$1$$anonfun$1(changes), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(74), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BuildChangeTracker.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BuildChangeTracker.Impl#ensureBloopUpToDate"));
                    LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(newState.pre().logger()), () -> BuildChangeTracker$.bleep$bsp$BuildChangeTracker$Impl$$_$ensureBloopUpToDate$$anonfun$1$$anonfun$2(changes), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(75), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BuildChangeTracker.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BuildChangeTracker.Impl#ensureBloopUpToDate"));
                    this.buildClient.onBuildTargetDidChange(changes);
                    return newState;
                } else {
                    if (None$.MODULE$.equals(option)) return newState;
                    throw new MatchError(option);
                }
            }).toEither();
        }

        @Override
        public Either<BleepException, Started> current() {
            return this.atomicState.get().toEither();
        }
    }

    public static interface State {
        public static int ordinal(State state) {
            return BuildChangeTracker$State$.MODULE$.ordinal(state);
        }

        public Prebootstrapped pre();

        public BleepConfig bleepConfig();

        public static Either toEither$(State $this) {
            return $this.toEither();
        }

        default public Either<BleepException, Started> toEither() {
            State state = this;
            if (state instanceof Yes) {
                Started started;
                Yes yes = BuildChangeTracker$State$Yes$.MODULE$.unapply((Yes)state);
                Started started2 = started = yes._1();
                return package$.MODULE$.Right().apply((Object)started2);
            }
            if (state instanceof No) {
                BleepException bleepException;
                No no = BuildChangeTracker$State$No$.MODULE$.unapply((No)state);
                BleepConfig bleepConfig = no._1();
                Prebootstrapped prebootstrapped = no._2();
                BleepException bleepException2 = bleepException = no._3();
                return package$.MODULE$.Left().apply((Object)bleepException2);
            }
            throw new MatchError((Object)state);
        }

        public static class No
        implements State,
        Product,
        Serializable {
            private final BleepConfig bleepConfig;
            private final Prebootstrapped pre;
            private final BleepException bleepException;

            public static No apply(BleepConfig bleepConfig, Prebootstrapped prebootstrapped, BleepException bleepException) {
                return BuildChangeTracker$State$No$.MODULE$.apply(bleepConfig, prebootstrapped, bleepException);
            }

            public static No fromProduct(Product product) {
                return BuildChangeTracker$State$No$.MODULE$.fromProduct(product);
            }

            public static No unapply(No no) {
                return BuildChangeTracker$State$No$.MODULE$.unapply(no);
            }

            public No(BleepConfig bleepConfig, Prebootstrapped pre, BleepException bleepException) {
                this.bleepConfig = bleepConfig;
                this.pre = pre;
                this.bleepException = bleepException;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof No)) return false;
                No no = (No)object;
                BleepConfig bleepConfig = this.bleepConfig();
                BleepConfig bleepConfig2 = no.bleepConfig();
                if (bleepConfig == null) {
                    if (bleepConfig2 != null) {
                        return false;
                    }
                } else if (!bleepConfig.equals(bleepConfig2)) return false;
                Prebootstrapped prebootstrapped = this.pre();
                Prebootstrapped prebootstrapped2 = no.pre();
                if (prebootstrapped == null) {
                    if (prebootstrapped2 != null) {
                        return false;
                    }
                } else if (!((Object)prebootstrapped).equals(prebootstrapped2)) return false;
                BleepException bleepException = this.bleepException();
                BleepException bleepException2 = no.bleepException();
                if (bleepException == null) {
                    if (bleepException2 != null) {
                        return false;
                    }
                } else if (!bleepException.equals(bleepException2)) return false;
                if (!no.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof No;
            }

            public int productArity() {
                return 3;
            }

            public String productPrefix() {
                return "No";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "bleepConfig";
                    }
                    case 1: {
                        return "pre";
                    }
                    case 2: {
                        return "bleepException";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            @Override
            public BleepConfig bleepConfig() {
                return this.bleepConfig;
            }

            @Override
            public Prebootstrapped pre() {
                return this.pre;
            }

            public BleepException bleepException() {
                return this.bleepException;
            }

            public No copy(BleepConfig bleepConfig, Prebootstrapped pre, BleepException bleepException) {
                return new No(bleepConfig, pre, bleepException);
            }

            public BleepConfig copy$default$1() {
                return this.bleepConfig();
            }

            public Prebootstrapped copy$default$2() {
                return this.pre();
            }

            public BleepException copy$default$3() {
                return this.bleepException();
            }

            public BleepConfig _1() {
                return this.bleepConfig();
            }

            public Prebootstrapped _2() {
                return this.pre();
            }

            public BleepException _3() {
                return this.bleepException();
            }
        }

        public static class Yes
        implements State,
        Product,
        Serializable {
            private final Started started;

            public static Yes apply(Started started) {
                return BuildChangeTracker$State$Yes$.MODULE$.apply(started);
            }

            public static Yes fromProduct(Product product) {
                return BuildChangeTracker$State$Yes$.MODULE$.fromProduct(product);
            }

            public static Yes unapply(Yes yes) {
                return BuildChangeTracker$State$Yes$.MODULE$.unapply(yes);
            }

            public Yes(Started started) {
                this.started = started;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Yes)) return false;
                Yes yes = (Yes)object;
                Started started = this.started();
                Started started2 = yes.started();
                if (started == null) {
                    if (started2 != null) {
                        return false;
                    }
                } else if (!((Object)started).equals(started2)) return false;
                if (!yes.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Yes;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Yes";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "started";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Started started() {
                return this.started;
            }

            @Override
            public Prebootstrapped pre() {
                return this.started().pre();
            }

            @Override
            public BleepConfig bleepConfig() {
                return this.started().config();
            }

            public Yes copy(Started started) {
                return new Yes(started);
            }

            public Started copy$default$1() {
                return this.started();
            }

            public Started _1() {
                return this.started();
            }
        }
    }
}

