/*
 * Decompiled with CFR 0.152.
 */
package bleep.bsp;

import bleep.BleepException;
import bleep.BuildPaths;
import bleep.internal.FileUtils$;
import bleep.internal.writeYamlLogged$;
import bleep.logging.TypedLogger;
import bleep.yaml$;
import io.circe.Decoder$;
import io.circe.Encoder$;
import io.circe.Error;
import java.io.Serializable;
import java.nio.file.Files;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BspProjectSelection$
implements Serializable {
    public static final BspProjectSelection$ MODULE$ = new BspProjectSelection$();

    private BspProjectSelection$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BspProjectSelection$.class);
    }

    public void store(TypedLogger<BoxedUnit> logger, BuildPaths buildPaths, Option<List<String>> maybeSelectedProjectGlobs) {
        Option<List<String>> option = maybeSelectedProjectGlobs;
        if (option instanceof Some) {
            List selectedProjectGlobs = (List)((Some)option).value();
            writeYamlLogged$.MODULE$.apply(logger, "Wrote update BSP project selection file", selectedProjectGlobs, buildPaths.bspProjectSelectionYaml(), Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Files.deleteIfExists(buildPaths.bspProjectSelectionYaml());
            return;
        }
        throw new MatchError(option);
    }

    public Either<BleepException, Option<List<String>>> load(BuildPaths buildPaths) {
        if (FileUtils$.MODULE$.exists(buildPaths.bspProjectSelectionYaml())) {
            Either either = yaml$.MODULE$.decode(Files.readString(buildPaths.bspProjectSelectionYaml()), Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString()));
            if (either instanceof Left) {
                Error err = (Error)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)new BleepException.InvalidJson(buildPaths.bspProjectSelectionYaml(), (Throwable)err));
            }
            if (either instanceof Right) {
                List selected = (List)((Right)either).value();
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)selected));
            }
            throw new MatchError((Object)either);
        }
        return package$.MODULE$.Right().apply((Object)None$.MODULE$);
    }
}

