/*
 * Decompiled with CFR 0.152.
 */
package bleep.bsp;

import bleep.BleepCommandRemote$;
import bleep.BleepException;
import bleep.Started;
import bleep.bsp.BuildChangeTracker;
import bleep.internal.DoSourceGen$;
import bleep.internal.Throwables$;
import bleep.internal.TransitiveProjects$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import bleep.model.BleepVersion$;
import bleep.model.CrossProjectName;
import bleep.package;
import bleep.package$;
import bloop.rifle.BuildServer;
import bloop.rifle.internal.BuildInfo$;
import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildClientCapabilities;
import ch.epfl.scala.bsp4j.BuildServerCapabilities;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.CleanCacheParams;
import ch.epfl.scala.bsp4j.CleanCacheResult;
import ch.epfl.scala.bsp4j.CompileParams;
import ch.epfl.scala.bsp4j.CompileProvider;
import ch.epfl.scala.bsp4j.CompileResult;
import ch.epfl.scala.bsp4j.DebugProvider;
import ch.epfl.scala.bsp4j.DebugSessionAddress;
import ch.epfl.scala.bsp4j.DebugSessionParams;
import ch.epfl.scala.bsp4j.DependencyModulesParams;
import ch.epfl.scala.bsp4j.DependencyModulesResult;
import ch.epfl.scala.bsp4j.DependencySourcesParams;
import ch.epfl.scala.bsp4j.DependencySourcesResult;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import ch.epfl.scala.bsp4j.InverseSourcesParams;
import ch.epfl.scala.bsp4j.InverseSourcesResult;
import ch.epfl.scala.bsp4j.JavacOptionsParams;
import ch.epfl.scala.bsp4j.JavacOptionsResult;
import ch.epfl.scala.bsp4j.JvmRunEnvironmentParams;
import ch.epfl.scala.bsp4j.JvmRunEnvironmentResult;
import ch.epfl.scala.bsp4j.JvmTestEnvironmentParams;
import ch.epfl.scala.bsp4j.JvmTestEnvironmentResult;
import ch.epfl.scala.bsp4j.MessageType;
import ch.epfl.scala.bsp4j.OutputPathsParams;
import ch.epfl.scala.bsp4j.OutputPathsResult;
import ch.epfl.scala.bsp4j.ResourcesParams;
import ch.epfl.scala.bsp4j.ResourcesResult;
import ch.epfl.scala.bsp4j.RunParams;
import ch.epfl.scala.bsp4j.RunProvider;
import ch.epfl.scala.bsp4j.RunResult;
import ch.epfl.scala.bsp4j.ScalaMainClassesParams;
import ch.epfl.scala.bsp4j.ScalaMainClassesResult;
import ch.epfl.scala.bsp4j.ScalaTestClassesParams;
import ch.epfl.scala.bsp4j.ScalaTestClassesResult;
import ch.epfl.scala.bsp4j.ScalacOptionsParams;
import ch.epfl.scala.bsp4j.ScalacOptionsResult;
import ch.epfl.scala.bsp4j.ShowMessageParams;
import ch.epfl.scala.bsp4j.SourcesParams;
import ch.epfl.scala.bsp4j.SourcesResult;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TestParams;
import ch.epfl.scala.bsp4j.TestProvider;
import ch.epfl.scala.bsp4j.TestResult;
import ch.epfl.scala.bsp4j.WorkspaceBuildTargetsResult;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public class BleepBspServer
implements BuildServer {
    private final TypedLogger<BoxedUnit> logger;
    private BuildClient sendToIdeClient;
    private BuildServer bloopServer;
    private BuildChangeTracker buildChangeTracker;
    private final java.util.List<String> supportedLanguages;
    private final Promise<BoxedUnit> shutdownPromise;

    public BleepBspServer(TypedLogger<BoxedUnit> logger, BuildClient sendToIdeClient, BuildServer bloopServer, BuildChangeTracker buildChangeTracker) {
        this.logger = logger;
        this.sendToIdeClient = sendToIdeClient;
        this.bloopServer = bloopServer;
        this.buildChangeTracker = buildChangeTracker;
        this.supportedLanguages = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"scala", (List)new .colon.colon((Object)"java", (List)Nil$.MODULE$))).asJava();
        this.shutdownPromise = Promise$.MODULE$.apply();
    }

    public TypedLogger<BoxedUnit> logger() {
        return this.logger;
    }

    public BuildClient sendToIdeClient() {
        return this.sendToIdeClient;
    }

    public void sendToIdeClient_$eq(BuildClient x$1) {
        this.sendToIdeClient = x$1;
    }

    public BuildServer bloopServer() {
        return this.bloopServer;
    }

    public void bloopServer_$eq(BuildServer x$1) {
        this.bloopServer = x$1;
    }

    public BuildChangeTracker buildChangeTracker() {
        return this.buildChangeTracker;
    }

    public void buildChangeTracker_$eq(BuildChangeTracker x$1) {
        this.buildChangeTracker = x$1;
    }

    public java.util.List<String> supportedLanguages() {
        return this.supportedLanguages;
    }

    public void warn(String msg, Throwable th) {
        String message = new StringBuilder(2).append(msg).append(": ").append(Throwables$.MODULE$.messagesFrom(th).mkString(": ")).toString();
        this.sendToIdeClient().onBuildShowMessage(new ShowMessageParams(MessageType.ERROR, message));
        LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.warn$$anonfun$1(msg), th, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(32), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#warn"));
    }

    public void error(String msg, Throwable th) {
        String message = new StringBuilder(2).append(msg).append(": ").append(Throwables$.MODULE$.messagesFrom(th).mkString(": ")).toString();
        this.sendToIdeClient().onBuildShowMessage(new ShowMessageParams(MessageType.ERROR, message));
        LoggerFn$Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.error$$anonfun$1(msg), th, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(37), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#error"));
    }

    public Nothing$ onFatalError(Throwable throwable, String context) {
        this.error(new StringBuilder(58).append("Shutting down Bleep after encountering fatal error within ").append(context).toString(), throwable);
        int timeout = Random$.MODULE$.nextInt(400);
        TimeUnit.MILLISECONDS.sleep(100L + (long)timeout);
        return scala.sys.package$.MODULE$.exit(1);
    }

    public <T> BiFunction<T, Throwable, T> fatalExceptionHandler(String methodName, scala.collection.immutable.Seq<Object> params) {
        return (maybeValue, maybeException) -> {
            Throwable throwable = maybeException;
            if (throwable == null) {
                return maybeValue;
            }
            Throwable error = throwable;
            String methodContext = new StringBuilder(26).append("bloop bsp server, method: ").append(methodName).toString();
            String context = params.isEmpty() ? methodContext : params.mkString(new StringBuilder(15).append(methodContext).append(", with params: ").toString(), ", ", "");
            throw this.onFatalError(error, context);
        };
    }

    private BuildServerCapabilities capabilities() {
        BuildServerCapabilities ret = new BuildServerCapabilities();
        ret.setCompileProvider(new CompileProvider(this.supportedLanguages()));
        ret.setTestProvider(new TestProvider(this.supportedLanguages()));
        ret.setRunProvider(new RunProvider(this.supportedLanguages()));
        ret.setDebugProvider(new DebugProvider(this.supportedLanguages()));
        ret.setInverseSourcesProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setDependencySourcesProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setResourcesProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setBuildTargetChangedProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setJvmRunEnvironmentProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setJvmTestEnvironmentProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setCanReload(Predef$.MODULE$.boolean2Boolean(true));
        ret.setDependencyModulesProvider(Predef$.MODULE$.boolean2Boolean(true));
        return ret;
    }

    public CompletableFuture<InitializeBuildResult> buildInitialize(InitializeBuildParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildInitialize$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(78), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildInitialize"));
        Either<BleepException, Started> either = this.buildChangeTracker().ensureBloopUpToDate();
        if (either instanceof Left) {
            BleepException th = (BleepException)((Left)either).value();
            this.warn("couldn't refresh the build", (Throwable)th);
            return CompletableFuture.failedFuture((Throwable)new ResponseErrorException(new ResponseError(ResponseErrorCode.jsonrpcReservedErrorRangeEnd, "couldn't refresh the build", new Object())));
        }
        if (either instanceof Right) {
            Started started = (Started)((Right)either).value();
            Path workspaceDir = started.buildPaths().buildVariantDir();
            InitializeBuildParams initParams = new InitializeBuildParams(new StringBuilder(8).append("bleep / ").append(params.getDisplayName()).toString(), new StringBuilder(3).append(BleepVersion$.MODULE$.current()).append(" / ").append(params.getVersion()).toString(), BuildInfo$.MODULE$.bspVersion(), workspaceDir.toUri().toASCIIString(), new BuildClientCapabilities(this.supportedLanguages()));
            JsonObject data = new JsonObject();
            data.add("clientClassesRootDir", (JsonElement)new JsonPrimitive(package.PathOps$.MODULE$.$div$extension(package$.MODULE$.PathOps(workspaceDir), "classes").toUri().toASCIIString()));
            data.add("ownsBuildFiles", (JsonElement)new JsonPrimitive(Predef$.MODULE$.boolean2Boolean(true)));
            Object object = params.getData();
            if (object instanceof JsonObject) {
                JsonObject dataFromIDE = (JsonObject)object;
                data.add("semanticdbVersion", dataFromIDE.get("semanticdbVersion"));
                data.add("javaSemanticdbVersion", dataFromIDE.get("javaSemanticdbVersion"));
                data.add("supportedScalaVersions", dataFromIDE.get("supportedScalaVersions"));
            } else {
                Object unexpected = object;
                LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildInitialize$$anonfun$2(unexpected), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(108), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildInitialize"));
            }
            initParams.setData((Object)data);
            LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::buildInitialize$$anonfun$3, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(113), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildInitialize"));
            return ((CompletableFuture)this.bloopServer().buildInitialize(initParams).handle(this.fatalExceptionHandler("buildInitialize", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{initParams})))).thenApply(_$1 -> {
                this.bloopServer().onBuildInitialized();
                return new InitializeBuildResult("bleep", BleepVersion$.MODULE$.current(), BuildInfo$.MODULE$.bspVersion(), this.capabilities());
            });
        }
        throw new MatchError(either);
    }

    public CompletableFuture<WorkspaceBuildTargetsResult> workspaceBuildTargets() {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::workspaceBuildTargets$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(125), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#workspaceBuildTargets"));
        Either either = Try$.MODULE$.apply(this::workspaceBuildTargets$$anonfun$2).toEither().flatMap((Function1 & Serializable)x -> (Either)Predef$.MODULE$.identity(x));
        if (either instanceof Left) {
            Throwable th = (Throwable)((Left)either).value();
            this.warn("Couldn't refresh the build", th);
            return CompletableFuture.failedFuture((Throwable)new ResponseErrorException(new ResponseError(ResponseErrorCode.jsonrpcReservedErrorRangeEnd, "couldn't refresh the build", new Object())));
        }
        if (either instanceof Right) {
            return this.bloopServer().workspaceBuildTargets().handle(this.fatalExceptionHandler("workspaceBuildTargets", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
        }
        throw new MatchError((Object)either);
    }

    public void onBuildInitialized() {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::onBuildInitialized$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(139), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#onBuildInitialized"));
    }

    public CompletableFuture<Object> workspaceReload() {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::workspaceReload$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(144), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#workspaceReload"));
        return CompletableFuture.completedFuture(new Object()).handle(this.fatalExceptionHandler("workspaceReload", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
    }

    public CompletableFuture<CleanCacheResult> buildTargetCleanCache(CleanCacheParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetCleanCache$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(150), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetCleanCache"));
        return this.bloopServer().buildTargetCleanCache(params).handle(this.fatalExceptionHandler("buildTargetCleanCache", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<CompileResult> buildTargetCompile(CompileParams params) {
        Right maybeStarted;
        Right right;
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetCompile$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(155), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetCompile"));
        Either<BleepException, Started> either = this.buildChangeTracker().current();
        if (either instanceof Left) {
            right = this.buildChangeTracker().ensureBloopUpToDate();
        } else if (either instanceof Right) {
            Right ok;
            right = ok = (Right)either;
        } else {
            throw new MatchError(either);
        }
        Right right2 = maybeStarted = right;
        if (right2 instanceof Left) {
            BleepException bleepException = (BleepException)((Left)right2).value();
            this.warn("bleep was not able to refresh the build", (Throwable)bleepException);
            return CompletableFuture.completedFuture(new CompileResult(StatusCode.ERROR));
        }
        if (right2 instanceof Right) {
            Started started = (Started)right2.value();
            Object object = Predef$.MODULE$.refArrayOps((Object[])CollectionConverters$.MODULE$.ListHasAsScala(params.getTargets()).asScala().toArray(ClassTag$.MODULE$.apply(BuildTargetIdentifier.class)));
            CrossProjectName[] projects = (CrossProjectName[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)target -> BleepCommandRemote$.MODULE$.projectFromBuildTarget(started, (BuildTargetIdentifier)target).orElse(() -> this.$anonfun$1$$anonfun$1(target)), ClassTag$.MODULE$.apply(CrossProjectName.class));
            Either<BleepException, BoxedUnit> either2 = DoSourceGen$.MODULE$.apply(started, this.bloopServer(), TransitiveProjects$.MODULE$.apply(started.build(), projects));
            if (either2 instanceof Left) {
                BleepException bleepException = (BleepException)((Left)either2).value();
                this.warn("Bleep was not able to run source generators", (Throwable)bleepException);
                return CompletableFuture.completedFuture(new CompileResult(StatusCode.ERROR));
            }
            if (either2 instanceof Right) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object2 = ((Right)either2).value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object2) : object2 != null)) {
                    return this.bloopServer().buildTargetCompile(params).handle(this.fatalExceptionHandler("buildTargetCompile", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
                }
            }
            throw new MatchError(either2);
        }
        throw new MatchError((Object)right2);
    }

    public CompletableFuture<DependencySourcesResult> buildTargetDependencySources(DependencySourcesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetDependencySources$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(186), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetDependencySources"));
        return this.bloopServer().buildTargetDependencySources(params).handle(this.fatalExceptionHandler("buildTargetDependencySources", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<InverseSourcesResult> buildTargetInverseSources(InverseSourcesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetInverseSources$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(190), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetInverseSources"));
        return this.bloopServer().buildTargetInverseSources(params).handle(this.fatalExceptionHandler("buildTargetInverseSources", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<ResourcesResult> buildTargetResources(ResourcesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetResources$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(194), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetResources"));
        return this.bloopServer().buildTargetResources(params).handle(this.fatalExceptionHandler("buildTargetResources", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<RunResult> buildTargetRun(RunParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetRun$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(198), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetRun"));
        return this.bloopServer().buildTargetRun(params).handle(this.fatalExceptionHandler("buildTargetRun", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<SourcesResult> buildTargetSources(SourcesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetSources$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(202), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetSources"));
        return this.bloopServer().buildTargetSources(params).handle(this.fatalExceptionHandler("buildTargetSources", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<TestResult> buildTargetTest(TestParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetTest$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(206), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetTest"));
        return this.bloopServer().buildTargetTest(params).handle(this.fatalExceptionHandler("buildTargetTest", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<DependencyModulesResult> buildTargetDependencyModules(DependencyModulesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetDependencyModules$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(210), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetDependencyModules"));
        return this.bloopServer().buildTargetDependencyModules(params).handle(this.fatalExceptionHandler("buildTargetDependencyModules", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<JavacOptionsResult> buildTargetJavacOptions(JavacOptionsParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetJavacOptions$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(214), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetJavacOptions"));
        return this.bloopServer().buildTargetJavacOptions(params).handle(this.fatalExceptionHandler("buildTargetJavacOptions", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<ScalaMainClassesResult> buildTargetScalaMainClasses(ScalaMainClassesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetScalaMainClasses$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(218), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetScalaMainClasses"));
        return this.bloopServer().buildTargetScalaMainClasses(params).handle(this.fatalExceptionHandler("buildTargetScalaMainClasses", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<ScalaTestClassesResult> buildTargetScalaTestClasses(ScalaTestClassesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetScalaTestClasses$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(222), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetScalaTestClasses"));
        return this.bloopServer().buildTargetScalaTestClasses(params).handle(this.fatalExceptionHandler("buildTargetScalaTestClasses", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<ScalacOptionsResult> buildTargetScalacOptions(ScalacOptionsParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetScalacOptions$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(226), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetScalacOptions"));
        return this.bloopServer().buildTargetScalacOptions(params).handle(this.fatalExceptionHandler("buildTargetScalacOptions", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<DebugSessionAddress> debugSessionStart(DebugSessionParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.debugSessionStart$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(230), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#debugSessionStart"));
        return this.bloopServer().debugSessionStart(params).handle(this.fatalExceptionHandler("debugSessionStart", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<OutputPathsResult> buildTargetOutputPaths(OutputPathsParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetOutputPaths$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(234), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetOutputPaths"));
        return this.bloopServer().buildTargetOutputPaths(params).handle(this.fatalExceptionHandler("buildTargetOutputPaths", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<JvmRunEnvironmentResult> buildTargetJvmRunEnvironment(JvmRunEnvironmentParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetJvmRunEnvironment$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(238), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetJvmRunEnvironment"));
        return this.bloopServer().buildTargetJvmRunEnvironment(params).handle(this.fatalExceptionHandler("jvmRunEnvironment", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<JvmTestEnvironmentResult> buildTargetJvmTestEnvironment(JvmTestEnvironmentParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetJvmTestEnvironment$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(242), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetJvmTestEnvironment"));
        return this.bloopServer().buildTargetJvmTestEnvironment(params).handle(this.fatalExceptionHandler("jvmTestEnvironment", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params})));
    }

    public CompletableFuture<Object> buildShutdown() {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::buildShutdown$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(249), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildShutdown"));
        if (!this.shutdownPromise.isCompleted()) {
            this.shutdownPromise.success((Object)BoxedUnit.UNIT);
        }
        return (CompletableFuture)Try$.MODULE$.apply(this::buildShutdown$$anonfun$2).getOrElse(BleepBspServer::buildShutdown$$anonfun$3);
    }

    public void onBuildExit() {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::onBuildExit$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(256), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#onBuildExit"));
    }

    public Future<BoxedUnit> initiateShutdown() {
        return this.shutdownPromise.future();
    }

    private static final String warn$$anonfun$1(String msg$1) {
        return msg$1;
    }

    private static final String error$$anonfun$1(String msg$2) {
        return msg$2;
    }

    private static final Tuple2 buildInitialize$$anonfun$1(InitializeBuildParams params$2) {
        return Tuple2$.MODULE$.apply((Object)"buildInitialize", (Object)params$2.toString());
    }

    private static final String buildInitialize$$anonfun$2(Object unexpected$1) {
        return new StringBuilder(29).append("got unexpected data element: ").append(unexpected$1).toString();
    }

    private static final String buildInitialize$$anonfun$3() {
        return "Sending buildInitialize BSP command to Bloop";
    }

    private static final String workspaceBuildTargets$$anonfun$1() {
        return "workspaceBuildTargets";
    }

    private final Either workspaceBuildTargets$$anonfun$2() {
        return this.buildChangeTracker().ensureBloopUpToDate();
    }

    private static final String onBuildInitialized$$anonfun$1() {
        return "onBuildInitialized";
    }

    private static final String workspaceReload$$anonfun$1() {
        return "workspaceReload";
    }

    private static final Tuple2 buildTargetCleanCache$$anonfun$1(CleanCacheParams params$3) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetCleanCache", (Object)params$3.toString());
    }

    private static final Tuple2 buildTargetCompile$$anonfun$1(CompileParams params$4) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetCompile", (Object)params$4.toString());
    }

    private static final String $anonfun$1$$anonfun$1$$anonfun$1(BuildTargetIdentifier target$2) {
        return new StringBuilder(109).append("Couldn't find project for target ").append(target$2.getUri()).append(". Bleep may have picked up a change you IDE hasn't. Try to reload the build.").toString();
    }

    private final Option $anonfun$1$$anonfun$1(BuildTargetIdentifier target$1) {
        LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.$anonfun$1$$anonfun$1$$anonfun$1(target$1), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(170), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetCompile projects"));
        return None$.MODULE$;
    }

    private static final Tuple2 buildTargetDependencySources$$anonfun$1(DependencySourcesParams params$5) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetDependencySources", (Object)params$5.toString());
    }

    private static final Tuple2 buildTargetInverseSources$$anonfun$1(InverseSourcesParams params$6) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetInverseSources", (Object)params$6.toString());
    }

    private static final Tuple2 buildTargetResources$$anonfun$1(ResourcesParams params$7) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetResources", (Object)params$7.toString());
    }

    private static final Tuple2 buildTargetRun$$anonfun$1(RunParams params$8) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetRun", (Object)params$8.toString());
    }

    private static final Tuple2 buildTargetSources$$anonfun$1(SourcesParams params$9) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetSources", (Object)params$9.toString());
    }

    private static final Tuple2 buildTargetTest$$anonfun$1(TestParams params$10) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetTest", (Object)params$10.toString());
    }

    private static final Tuple2 buildTargetDependencyModules$$anonfun$1(DependencyModulesParams params$11) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetDependencyModules", (Object)params$11.toString());
    }

    private static final Tuple2 buildTargetJavacOptions$$anonfun$1(JavacOptionsParams params$12) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetJavacOptions", (Object)params$12.toString());
    }

    private static final Tuple2 buildTargetScalaMainClasses$$anonfun$1(ScalaMainClassesParams params$13) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetScalaMainClasses", (Object)params$13.toString());
    }

    private static final Tuple2 buildTargetScalaTestClasses$$anonfun$1(ScalaTestClassesParams params$14) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetScalaTestClasses", (Object)params$14.toString());
    }

    private static final Tuple2 buildTargetScalacOptions$$anonfun$1(ScalacOptionsParams params$15) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetScalacOptions", (Object)params$15.toString());
    }

    private static final Tuple2 debugSessionStart$$anonfun$1(DebugSessionParams params$16) {
        return Tuple2$.MODULE$.apply((Object)"debugSessionStart", (Object)params$16.toString());
    }

    private static final Tuple2 buildTargetOutputPaths$$anonfun$1(OutputPathsParams params$17) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetOutputPaths", (Object)params$17.toString());
    }

    private static final Tuple2 buildTargetJvmRunEnvironment$$anonfun$1(JvmRunEnvironmentParams params$18) {
        return Tuple2$.MODULE$.apply((Object)"jvmRunEnvironment", (Object)params$18.toString());
    }

    private static final Tuple2 buildTargetJvmTestEnvironment$$anonfun$1(JvmTestEnvironmentParams params$19) {
        return Tuple2$.MODULE$.apply((Object)"jvmTestEnvironment", (Object)params$19.toString());
    }

    private static final String buildShutdown$$anonfun$1() {
        return "buildShutdown";
    }

    private final CompletableFuture buildShutdown$$anonfun$2() {
        return this.bloopServer().buildShutdown();
    }

    private static final CompletableFuture buildShutdown$$anonfun$3() {
        return null;
    }

    private static final String onBuildExit$$anonfun$1() {
        return "onBuildExit";
    }
}

