/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BleepConfigOps$;
import bleep.BleepException;
import bleep.BleepExecutable;
import bleep.BleepExecutable$;
import bleep.BuildLoader;
import bleep.BuildLoader$;
import bleep.BuildPaths;
import bleep.BuildPaths$;
import bleep.Commands;
import bleep.CommonOpts;
import bleep.CoursierResolver;
import bleep.CoursierResolver$Factory$default$;
import bleep.ExitCode;
import bleep.ExitCode$Failure$;
import bleep.ExitCode$Success$;
import bleep.GenBloopFiles;
import bleep.GenBloopFiles$;
import bleep.Lazy;
import bleep.Lazy$;
import bleep.Prebootstrapped;
import bleep.Prebootstrapped$;
import bleep.ProjectPaths;
import bleep.Started;
import bleep.Started$;
import bleep.UserPaths;
import bleep.UserPaths$;
import bleep.internal.FileUtils$;
import bleep.internal.bleepLoggers$;
import bleep.internal.fatal$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import bleep.logging.TypedLoggerResource;
import bleep.logging.TypedLoggerResource$;
import bleep.logging.TypedLoggerResource$Ops$;
import bleep.model.BleepConfig;
import bleep.model.Build;
import bleep.model.BuildFile;
import bleep.model.BuildVariant;
import bleep.model.BuildVariant$;
import bleep.model.CrossProjectName;
import bleep.model.Project;
import bleep.package$;
import bleep.rewrites.BuildRewrite;
import bloop.config.Config;
import java.io.Serializable;
import java.nio.file.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.SortedMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public final class bootstrap$
implements Serializable {
    public static final bootstrap$ MODULE$ = new bootstrap$();

    private bootstrap$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(bootstrap$.class);
    }

    public void forScript(String scriptName, CommonOpts commonOpts, List<BuildRewrite> rewrites, Function2<Started, Commands, BoxedUnit> f) {
        UserPaths userPaths = UserPaths$.MODULE$.fromAppDirs();
        Either either = package$.MODULE$.bleepExceptionOps(BleepConfigOps$.MODULE$.loadOrDefault(userPaths));
        BleepConfig bleepConfig = (BleepConfig)BleepException.ExpectOps$.MODULE$.orThrow$extension(either, (.less.colon.less)$less$colon$less$.MODULE$.refl());
        BuildLoader buildLoader = BuildLoader$.MODULE$.find(FileUtils$.MODULE$.cwd());
        BuildVariant buildVariant = BuildVariant$.MODULE$.apply(rewrites.map((Function1 & Serializable)_$1 -> _$1.name()));
        BuildPaths buildPaths = BuildPaths$.MODULE$.apply(FileUtils$.MODULE$.cwd(), buildLoader, buildVariant);
        TypedLoggerResource typedLoggerResource = TypedLoggerResource$.MODULE$.Ops(bleepLoggers$.MODULE$.stdoutNoLogFile(bleepConfig, commonOpts));
        TypedLoggerResource typedLoggerResource2 = TypedLoggerResource$.MODULE$.Ops(TypedLoggerResource$Ops$.MODULE$.map$extension(typedLoggerResource, (Function1 & Serializable)l -> l.withPath(new StringBuilder(9).append("[script ").append(scriptName).append("]").toString())));
        ExitCode exitCode = (ExitCode)TypedLoggerResource$Ops$.MODULE$.untyped$extension(typedLoggerResource2).use((Function1 & Serializable)logger -> {
            ExitCode exitCode;
            ExecutionContextExecutor ec = ExecutionContext$.MODULE$.global();
            Either maybeStarted = buildLoader.existing().map((Function1 & Serializable)existingBuild -> {
                Prebootstrapped pre = Prebootstrapped$.MODULE$.apply((TypedLogger<BoxedUnit>)logger, userPaths, buildPaths, (BuildLoader.Existing)existingBuild, (ExecutionContext)ec);
                GenBloopFiles genBloopFiles = GenBloopFiles$.MODULE$.SyncToDisk();
                return Tuple3$.MODULE$.apply(existingBuild, (Object)pre, (Object)genBloopFiles);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    BuildLoader.Existing existingBuild = (BuildLoader.Existing)tuple3._1();
                    Prebootstrapped pre = (Prebootstrapped)tuple3._2();
                    GenBloopFiles genBloopFiles = (GenBloopFiles)tuple3._3();
                    return MODULE$.from(pre, genBloopFiles, rewrites, bleepConfig, CoursierResolver$Factory$default$.MODULE$).map((Function1 & Serializable)started -> started);
                }
                throw new MatchError((Object)tuple3);
            });
            Either either = maybeStarted;
            if (either instanceof Left) {
                BleepException buildException = (BleepException)((Left)either).value();
                exitCode = fatal$.MODULE$.apply("Couldn't initialize bleep", (TypedLogger<BoxedUnit>)logger, buildException);
                return exitCode;
            } else {
                if (!(either instanceof Right)) throw new MatchError((Object)either);
                Started started = (Started)((Right)either).value();
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    bootstrap$.$anonfun$3$$anonfun$1(f, started);
                    return BoxedUnit.UNIT;
                });
                if (try_ instanceof Failure) {
                    Throwable th = ((Failure)try_).exception();
                    exitCode = fatal$.MODULE$.apply(new StringBuilder(25).append("Failed to run script: `").append(scriptName).append("`.").toString(), (TypedLogger<BoxedUnit>)logger, th);
                    return exitCode;
                } else {
                    if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                    exitCode = ExitCode$Success$.MODULE$;
                }
            }
            return exitCode;
        });
        ExitCode exitCode2 = exitCode;
        if (ExitCode$Success$.MODULE$.equals(exitCode2)) {
            return;
        }
        if (ExitCode$Failure$.MODULE$.equals(exitCode2)) {
            System.exit(exitCode.value());
            return;
        }
        throw new MatchError((Object)exitCode2);
    }

    public List<BuildRewrite> forScript$default$3() {
        return scala.package$.MODULE$.Nil();
    }

    public Either<BleepException, Started> from(Prebootstrapped pre, GenBloopFiles genBloopFiles, List<BuildRewrite> rewrites, BleepConfig config, CoursierResolver.Factory resolverFactory) {
        return this.go$1(resolverFactory, genBloopFiles, pre, config, rewrites);
    }

    private static final void $anonfun$3$$anonfun$1(Function2 f$2, Started started$1) {
        f$2.apply((Object)started$1, (Object)new Commands(started$1));
    }

    private static final BleepExecutable $anonfun$7(CoursierResolver resolver$1, Prebootstrapped pre$2) {
        return BleepExecutable$.MODULE$.getCommand(resolver$1, pre$2, false);
    }

    private final boolean underSources$1(ProjectPaths projectPaths$1, Prebootstrapped pre$4) {
        return projectPaths$1.sourcesDirs().all().exists((Function1 & Serializable)_$2 -> _$2.startsWith(pre$4.buildPaths().cwd()));
    }

    private final boolean underResources$1(ProjectPaths projectPaths$2, Prebootstrapped pre$6) {
        return projectPaths$2.resourcesDirs().all().exists((Function1 & Serializable)_$3 -> _$3.startsWith(pre$6.buildPaths().cwd()));
    }

    private static final String $anonfun$9(CrossProjectName[] chosen$1, Build build$1, Prebootstrapped pre$8) {
        return new StringBuilder(61).append(chosen$1.length).append(" of ").append(build$1.explodedProjects().size()).append(" projects active from ").append(pre$8.buildPaths().cwd()).append(". run `bleep projects` to see which").toString();
    }

    private static final String go$1$$anonfun$1$$anonfun$1(long td$1) {
        return new StringBuilder(19).append("bootstrapped in ").append(td$1).append(" ms").toString();
    }

    private final Either go$1(CoursierResolver.Factory resolverFactory$1, GenBloopFiles genBloopFiles$1, Prebootstrapped pre, BleepConfig config, List rewrites) {
        Left left;
        long t0 = System.currentTimeMillis();
        try {
            left = ((Either)pre.existingBuild().buildFile().forceGet()).map((Function1 & Serializable)buildFile -> {
                None$ none$;
                CoursierResolver resolver = resolverFactory$1.apply(pre, config, (BuildFile)buildFile);
                Build build = (Build)rewrites.foldLeft((Object)Build.FileBacked$.MODULE$.apply(buildFile), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Build b = (Build)tuple2._1();
                        BuildRewrite rewrite = (BuildRewrite)tuple2._2();
                        return rewrite.apply(b);
                    }
                    throw new MatchError((Object)tuple2);
                });
                Lazy bleepExecutable = Lazy$.MODULE$.apply(() -> bootstrap$.$anonfun$7(resolver, pre));
                Path path = pre.buildPaths().cwd();
                Path path2 = pre.buildPaths().buildDir();
                if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                    none$ = None$.MODULE$;
                } else {
                    CrossProjectName[] chosen = (CrossProjectName[])((IterableOnceOps)build.explodedProjects().flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            boolean underAny;
                            CrossProjectName crossProjectName = (CrossProjectName)tuple2._1();
                            Project p = (Project)tuple2._2();
                            ProjectPaths projectPaths = pre.buildPaths().project(crossProjectName, p);
                            boolean underFolder = projectPaths.dir().startsWith(pre.buildPaths().cwd());
                            boolean bl = underAny = underFolder || this.underSources$1(projectPaths, pre) || this.underResources$1(projectPaths, pre);
                            if (underAny) {
                                return Some$.MODULE$.apply((Object)crossProjectName);
                            }
                            return None$.MODULE$;
                        }
                        throw new MatchError((Object)tuple2);
                    })).toArray(ClassTag$.MODULE$.apply(CrossProjectName.class));
                    if (chosen.length > 0 && chosen.length != build.explodedProjects().size()) {
                        LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(pre.logger()), () -> bootstrap$.$anonfun$9(chosen, build, pre), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(76), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bootstrap.scala"), Enclosing$.MODULE$.apply("bleep.bootstrap.from go activeProjects"));
                    }
                    none$ = Some$.MODULE$.apply((Object)chosen).filter((Function1 & Serializable)_$4 -> {
                        Object object = Predef$.MODULE$.refArrayOps((Object[])_$4);
                        return ArrayOps$.MODULE$.nonEmpty$extension(object);
                    });
                }
                None$ activeProjects = none$;
                SortedMap<CrossProjectName, Lazy<Config.File>> bloopFiles = genBloopFiles$1.apply(pre, resolver, build);
                long td = System.currentTimeMillis() - t0;
                LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(pre.logger()), () -> bootstrap$.go$1$$anonfun$1$$anonfun$1(td), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(85), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/bootstrap.scala"), Enclosing$.MODULE$.apply("bleep.bootstrap.from go"));
                return Started$.MODULE$.apply(pre, (List<BuildRewrite>)rewrites, build, bloopFiles, (Option<CrossProjectName[]>)activeProjects, config, resolver, (Lazy<BleepExecutable>)bleepExecutable, (Function3<Prebootstrapped, BleepConfig, List<BuildRewrite>, Either<BleepException, Started>>)(Function3 & Serializable)(pre, config, rewrites) -> this.go$1(resolverFactory$1, genBloopFiles$1, (Prebootstrapped)pre, (BleepConfig)config, (List)rewrites));
            });
        }
        catch (BleepException x) {
            left = scala.package$.MODULE$.Left().apply((Object)x);
        }
        catch (Throwable th) {
            left = scala.package$.MODULE$.Left().apply((Object)new BleepException.Cause(th, "couldn't initialize bleep", BleepException.Not$.MODULE$.not()));
        }
        return left;
    }
}

