/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BleepException;
import bleep.FileWatching$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import bleep.package;
import bleep.package$;
import com.swoval.files.FileTreeViews;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import com.swoval.functional.Either;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;
import sourcecode.Text$;

public final class FileWatching {
    public static <K> TypedWatcher<K> apply(TypedLogger<BoxedUnit> typedLogger, Map<Path, Seq<K>> map, Function1<scala.collection.immutable.Set<K>, BoxedUnit> function1) {
        return FileWatching$.MODULE$.apply(typedLogger, map, function1);
    }

    public static class Combined
    implements Watcher {
        private final Watcher w1;
        private final Watcher w2;

        public Combined(Watcher w1, Watcher w2) {
            this.w1 = w1;
            this.w2 = w2;
        }

        @Override
        public boolean isShutdown() {
            return this.w1.isShutdown() || this.w2.isShutdown();
        }

        @Override
        public void close() {
            this.w1.close();
            this.w2.close();
        }

        @Override
        public void step() {
            this.w1.step();
            this.w2.step();
        }
    }

    public static interface StopWhen {
        public boolean shouldContinue();
    }

    public static class TypedWatcher<K>
    implements Watcher {
        private final TypedLogger<BoxedUnit> logger;
        private final Function1<scala.collection.immutable.Set<K>, BoxedUnit> onChange;
        private final PathWatcher<PathWatchers.Event> watcher;
        private final Set<K> changedKeys;
        private boolean isShutdown;
        private Map<Path, Seq<K>> mapping;

        public TypedWatcher(TypedLogger<BoxedUnit> logger, Function1<scala.collection.immutable.Set<K>, BoxedUnit> onChange) {
            this.logger = logger;
            this.onChange = onChange;
            this.watcher = PathWatchers.get((boolean)true);
            this.changedKeys = (Set)Set$.MODULE$.empty();
            this.isShutdown = false;
            this.mapping = Predef$.MODULE$.Map().empty();
        }

        public PathWatcher<PathWatchers.Event> watcher() {
            return this.watcher;
        }

        public Set<K> changedKeys() {
            return this.changedKeys;
        }

        @Override
        public boolean isShutdown() {
            return this.isShutdown;
        }

        public void isShutdown_$eq(boolean x$1) {
            this.isShutdown = x$1;
        }

        public Map<Path, Seq<K>> mapping() {
            return this.mapping;
        }

        public void mapping_$eq(Map<Path, Seq<K>> x$1) {
            this.mapping = x$1;
        }

        public void addObserver(FileTreeViews.Observer<PathWatchers.Event> observer) {
            Integer n = (Integer)package$.MODULE$.DiscardOps((Object)BoxesRunTime.boxToInteger((int)this.watcher().addObserver(observer)));
            package.DiscardOps$.MODULE$.discard$extension((Object)n);
        }

        public void updateMapping(Map<Path, Seq<K>> newMapping) {
            Map newMapping1 = (Map)newMapping.filter(FileWatching$::bleep$FileWatching$TypedWatcher$$_$_$$anonfun$1);
            Map newMapping2 = (Map)newMapping1.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Either maybeRegistered;
                    Path path = (Path)tuple2._1();
                    Seq keys = (Seq)tuple2._2();
                    Either either = maybeRegistered = Files.isRegularFile(path, new LinkOption[0]) ? this.watcher().register(path.getParent(), 0) : this.watcher().register(path, Integer.MAX_VALUE);
                    if (maybeRegistered.isLeft()) {
                        IOException th = (IOException)Either.leftProjection((Either)maybeRegistered).getValue();
                        throw new BleepException.Cause((Throwable)th, new StringBuilder(42).append("Couldn't register ").append(path).append(" for ").append(keys).append(" for file watching ").toString(), BleepException.Not$.MODULE$.not());
                    }
                    return Tuple2$.MODULE$.apply((Object)path, (Object)keys);
                }
                throw new MatchError((Object)tuple2);
            });
            scala.collection.immutable.Set unregister = (scala.collection.immutable.Set)this.mapping().keys().toSet().$minus$minus((IterableOnce)newMapping2.keys());
            unregister.foreach((Function1)(JProcedure1 & Serializable)path -> {
                this.watcher().unregister(path);
                LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger.withContext(Text$.MODULE$.apply(path, "path"), Formatter$.MODULE$.PathFormatter())), FileWatching$::bleep$FileWatching$TypedWatcher$$_$updateMapping$$anonfun$1$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(134), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/FileWatching.scala"), Enclosing$.MODULE$.apply("bleep.FileWatching.TypedWatcher#updateMapping"));
            });
            this.mapping_$eq(newMapping2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void step() {
            void var2_4;
            void consumeChanges;
            void var6_6;
            void empty;
            scala.collection.immutable.Set set;
            TypedWatcher typedWatcher = this;
            synchronized (typedWatcher) {
                scala.collection.immutable.Set res = this.changedKeys().toSet();
                this.changedKeys().clear();
                set = res;
            }
            scala.collection.immutable.Set changes = set;
            if (changes.nonEmpty()) {
                LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(this.logger), () -> FileWatching$.bleep$FileWatching$TypedWatcher$$_$_$$anonfun$3(changes), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(147), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/FileWatching.scala"), Enclosing$.MODULE$.apply("bleep.FileWatching.TypedWatcher#step consumeChanges"));
            }
            if ((empty = (var6_6 = (consumeChanges = var2_4))).isEmpty()) {
                return;
            }
            void nonEmpty = var6_6;
            this.onChange.apply((Object)nonEmpty);
        }

        @Override
        public void close() {
            this.isShutdown_$eq(true);
            this.watcher().close();
        }
    }

    public static interface Watcher {
        public boolean isShutdown();

        public void close();

        public void step();

        public static void run$(Watcher $this, StopWhen stopWhen, long waitMillis) {
            $this.run(stopWhen, waitMillis);
        }

        default public void run(StopWhen stopWhen, long waitMillis) {
            while (this.continue$1(stopWhen)) {
                this.step();
                Thread.sleep(waitMillis);
            }
            this.close();
        }

        public static long run$default$2$(Watcher $this) {
            return $this.run$default$2();
        }

        default public long run$default$2() {
            return 10L;
        }

        public static Watcher combine$(Watcher $this, Watcher other) {
            return $this.combine(other);
        }

        default public Watcher combine(Watcher other) {
            return new Combined(this, other);
        }

        private boolean continue$1(StopWhen stopWhen$1) {
            return stopWhen$1.shouldContinue() && !this.isShutdown();
        }
    }
}

