/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BleepException;
import bleep.BleepExecutable;
import bleep.BleepExecutable$CurrentBinary$;
import bleep.BleepExecutable$CurrentJava$;
import bleep.BleepExecutable$DownloadedBinary$;
import bleep.BleepExecutable$DownloadedJava$;
import bleep.BleepExecutable$InheritedBinary$;
import bleep.CoursierResolver;
import bleep.FetchBleepRelease$;
import bleep.OsArch;
import bleep.OsArch$;
import bleep.Prebootstrapped;
import bleep.ResolvedJvm;
import bleep.internal.compat;
import bleep.internal.compat$;
import bleep.internal.jvmRunCommand$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import bleep.model.BleepVersion$;
import bleep.model.Dep;
import bleep.model.LibraryVersionScheme;
import bleep.model.LibraryVersionScheme$;
import bleep.model.VersionCombo;
import bleep.model.VersionScala$;
import bleep.package$;
import coursier.cache.CacheLogger;
import coursier.core.ModuleName$;
import coursier.core.Organization$;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.deriving.Mirror;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;
import sourcecode.Text$;

public final class BleepExecutable$
implements Mirror.Sum,
Serializable {
    private static final String BleepMain;
    public static final BleepExecutable$CurrentBinary$ CurrentBinary;
    public static final BleepExecutable$DownloadedBinary$ DownloadedBinary;
    public static final BleepExecutable$InheritedBinary$ InheritedBinary;
    public static final BleepExecutable$CurrentJava$ CurrentJava;
    public static final BleepExecutable$DownloadedJava$ DownloadedJava;
    public static final BleepExecutable$ MODULE$;

    private BleepExecutable$() {
    }

    static {
        MODULE$ = new BleepExecutable$();
        BleepMain = "bleep.Main";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BleepExecutable$.class);
    }

    public BleepExecutable getCommand(CoursierResolver resolver, Prebootstrapped pre, boolean forceJvm) {
        return (BleepExecutable)this.findCurrentBleep(pre.logger()).getOrElse(() -> BleepExecutable$.getCommand$$anonfun$1(forceJvm, pre, resolver));
    }

    public Option<BleepExecutable> findCurrentBleep(TypedLogger<BoxedUnit> logger) {
        ProcessHandle.Info currentInfo = ProcessHandle.current().info();
        Optional optional = compat$.MODULE$.OptionalCompatOps(currentInfo.command());
        Option ret = compat.OptionalCompatOps$.MODULE$.toScalaCompat$extension(optional).flatMap((Function1 & Serializable)commandString -> {
            Path path = Path.of(commandString, new String[0]).toAbsolutePath();
            Path cmd = path;
            if (!Files.exists(cmd, new LinkOption[0])) {
                return this.complain$1(logger, new StringBuilder(38).append("Obtained command ").append((String)commandString).append(" which does not exist").toString(), (Option)Some$.MODULE$.apply((Object)currentInfo));
            }
            Path command = path;
            if (command.getFileName().toString().contains("java")) {
                RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
                String cp = mxBean.getClassPath();
                Object object = Predef$.MODULE$.refArrayOps((Object[])cp.split(File.pathSeparator));
                if (ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)_$2 -> _$2.contains("bleep-cli"))) {
                    java.util.List list = compat$.MODULE$.JavaListCompatOps(mxBean.getInputArguments());
                    List filteredArgs = compat.JavaListCompatOps$.MODULE$.toScalaCompat$extension(list).filterNot((Function1 & Serializable)_$3 -> _$3.contains("-agentlib:")).filterNot((Function1 & Serializable)_$4 -> _$4.contains("-javaagent:")).filterNot((Function1 & Serializable)_$5 -> _$5.contains("-Duser.dir"));
                    List args = (List)filteredArgs.$plus$plus((IterableOnce)new .colon.colon((Object)"-cp", (List)new .colon.colon((Object)cp, (List)new .colon.colon((Object)BleepMain, (List)Nil$.MODULE$))));
                    return Some$.MODULE$.apply((Object)BleepExecutable$CurrentJava$.MODULE$.apply(command, (List<String>)args));
                }
                return this.complain$1(logger, "Obtained JVM class path which didn't include bleep-cli", this.complain$default$2$1());
            }
            Path command2 = path;
            return Some$.MODULE$.apply((Object)BleepExecutable$CurrentBinary$.MODULE$.apply(command2));
        });
        ret.foreach((Function1)(JProcedure1 & Serializable)cmd -> LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger.withContext(Text$.MODULE$.apply((Object)this.v$proxy1$1((BleepExecutable)cmd), "cmd.whole"), Formatter$.MODULE$.IterableFormatter(Formatter$.MODULE$.StringFormatter()))), BleepExecutable$::findCurrentBleep$$anonfun$1$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(101), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), Enclosing$.MODULE$.apply("bleep.BleepExecutable.findCurrentBleep")));
        return ret;
    }

    public int ordinal(BleepExecutable x$0) {
        BleepExecutable bleepExecutable = x$0;
        if (bleepExecutable instanceof BleepExecutable.Binary) {
            return 0;
        }
        if (bleepExecutable instanceof BleepExecutable.CurrentJava) {
            return 1;
        }
        if (bleepExecutable instanceof BleepExecutable.DownloadedJava) {
            return 2;
        }
        throw new MatchError((Object)bleepExecutable);
    }

    private static final String getCommand$$anonfun$1$$anonfun$1(String latestRelease$1) {
        return new StringBuilder(72).append("couldn't determine name of current Bleep executable. Setting up version ").append(latestRelease$1).toString();
    }

    private static final String getCommand$$anonfun$1$$anonfun$2() {
        return "Setting up Bleep through a JVM as requested";
    }

    private static final String getCommand$$anonfun$1$$anonfun$3(OsArch other$1) {
        return new StringBuilder(79).append("There is no published graalvm native-image for ").append(other$1).append(". Setting up Bleep through a JVM").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final BleepExecutable getCommand$$anonfun$1(boolean forceJvm$1, Prebootstrapped pre$1, CoursierResolver resolver$1) {
        Product product;
        String latestRelease = BleepVersion$.MODULE$.latestRelease$extension(BleepVersion$.MODULE$.current());
        OsArch osArch = OsArch$.MODULE$.current();
        if (osArch instanceof OsArch.HasNativeImage) {
            OsArch.HasNativeImage image = (OsArch.HasNativeImage)osArch;
            if (!forceJvm$1) {
                LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(pre$1.logger()), () -> BleepExecutable$.getCommand$$anonfun$1$$anonfun$1(latestRelease), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(37), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), Enclosing$.MODULE$.apply("bleep.BleepExecutable.getCommand"));
                Either either = package$.MODULE$.bleepExceptionOps(FetchBleepRelease$.MODULE$.apply(latestRelease, (CacheLogger)pre$1.cacheLogger(), pre$1.ec(), image));
                Path bin = (Path)BleepException.ExpectOps$.MODULE$.orThrow$extension(either, (.less.colon.less)$less$colon$less$.MODULE$.refl());
                product = BleepExecutable$DownloadedBinary$.MODULE$.apply(bin);
                return product;
            }
        }
        OsArch other = osArch;
        if (forceJvm$1) {
            LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(pre$1.logger()), BleepExecutable$::getCommand$$anonfun$1$$anonfun$2, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(41), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), Enclosing$.MODULE$.apply("bleep.BleepExecutable.getCommand"));
        } else {
            LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(pre$1.logger()), () -> BleepExecutable$.getCommand$$anonfun$1$$anonfun$3(other), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(42), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), Enclosing$.MODULE$.apply("bleep.BleepExecutable.getCommand"));
        }
        Dep.ScalaDependency bleepCliDep = Dep.ScalaDependency$.MODULE$.apply(Organization$.MODULE$.apply("build.bleep"), ModuleName$.MODULE$.apply("bleep-cli"), latestRelease, false, Dep.ScalaDependency$.MODULE$.$lessinit$greater$default$5(), Dep.ScalaDependency$.MODULE$.$lessinit$greater$default$6(), Dep.ScalaDependency$.MODULE$.$lessinit$greater$default$7(), Dep.ScalaDependency$.MODULE$.$lessinit$greater$default$8(), Dep.ScalaDependency$.MODULE$.$lessinit$greater$default$9(), Dep.ScalaDependency$.MODULE$.$lessinit$greater$default$10(), Dep.ScalaDependency$.MODULE$.$lessinit$greater$default$11(), Dep.ScalaDependency$.MODULE$.$lessinit$greater$default$12());
        CoursierResolver.Result resolvedBleep = resolver$1.force((Set<Dep>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Dep[]{bleepCliDep}))), (VersionCombo)VersionCombo.Jvm$.MODULE$.apply(VersionScala$.MODULE$.Scala213()), (SortedSet<LibraryVersionScheme>)((SortedSet)SortedSet$.MODULE$.empty((Object)LibraryVersionScheme$.MODULE$.ordering())), new StringBuilder(35).append("resolving bleep ").append(latestRelease).append(" from maven central").toString());
        product = BleepExecutable$DownloadedJava$.MODULE$.apply(((ResolvedJvm)pre$1.resolvedJvm().forceGet()).javaBin(), jvmRunCommand$.MODULE$.cmdArgs((List<String>)scala.package$.MODULE$.Nil(), resolvedBleep.jars(), BleepMain, (List<String>)scala.package$.MODULE$.Nil()));
        return product;
    }

    private static final String complain$1$$anonfun$2(String msg$1) {
        return new StringBuilder(105).append("Problem while discovering how to run the bleep you started: ").append(msg$1).append(". Falling back to downloading latest release.").toString();
    }

    private final None$ complain$1(TypedLogger logger$1, String msg, Option currentInfo) {
        LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(logger$1.withOptContext("processHandle.info", currentInfo.map((Function1 & Serializable)_$1 -> _$1.toString()), Formatter$.MODULE$.StringFormatter())), () -> BleepExecutable$.complain$1$$anonfun$2(msg), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(63), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), Enclosing$.MODULE$.apply("bleep.BleepExecutable.findCurrentBleep complain"));
        return None$.MODULE$;
    }

    private final Option complain$default$2$1() {
        return None$.MODULE$;
    }

    private final List v$proxy1$1(BleepExecutable cmd$1) {
        return cmd$1.whole();
    }

    private static final String findCurrentBleep$$anonfun$1$$anonfun$1() {
        return "Can run your current bleep with this command";
    }
}

