/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BleepBuildCommand;
import bleep.BleepCommandRemote$;
import bleep.BleepCommandRemote$FailedToStartBloop$;
import bleep.BleepException;
import bleep.BleepException$;
import bleep.BleepFileWatching$;
import bleep.BuildPaths;
import bleep.FileWatching;
import bleep.FileWatching$StopWhen$OnStdInput$;
import bleep.ResolvedJvm;
import bleep.Started;
import bleep.bsp.BleepRifleLogger;
import bleep.bsp.BspCommandFailed;
import bleep.bsp.BspCommandFailed$NoDetails$;
import bleep.bsp.SetupBloopRifle$;
import bleep.internal.BspClientDisplayProgress;
import bleep.internal.BspClientDisplayProgress$;
import bleep.internal.Throwables$;
import bleep.internal.TransitiveProjects;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.model.BleepVersion$;
import bleep.model.CompileServerMode;
import bleep.model.CrossProjectName;
import bleep.package;
import bleep.package$;
import bloop.rifle.BloopRifleConfig;
import bloop.rifle.BloopRifleLogger;
import bloop.rifle.BloopServer;
import bloop.rifle.BloopServer$;
import bloop.rifle.BloopThreads$;
import bloop.rifle.BuildServer;
import bloop.rifle.FailedToStartServerException;
import bloop.rifle.internal.Operations$;
import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public abstract class BleepCommandRemote
implements BleepBuildCommand {
    private final boolean watch;

    public static BuildTargetIdentifier buildTarget(BuildPaths buildPaths, CrossProjectName crossProjectName) {
        return BleepCommandRemote$.MODULE$.buildTarget(buildPaths, crossProjectName);
    }

    public static List<BuildTargetIdentifier> buildTargets(BuildPaths buildPaths, CrossProjectName[] crossProjectNameArray) {
        return BleepCommandRemote$.MODULE$.buildTargets(buildPaths, crossProjectNameArray);
    }

    public static Option<CrossProjectName> projectFromBuildTarget(Started started, BuildTargetIdentifier buildTargetIdentifier) {
        return BleepCommandRemote$.MODULE$.projectFromBuildTarget(started, buildTargetIdentifier);
    }

    public BleepCommandRemote(boolean watch) {
        this.watch = watch;
    }

    public abstract TransitiveProjects watchableProjects(Started var1);

    public abstract Either<BleepException, BoxedUnit> runWithServer(Started var1, BuildServer var2);

    @Override
    public final Either<BleepException, BoxedUnit> run(Started started) {
        Either either;
        BloopServer bloopServer;
        CompileServerMode compileServerMode = started.config().compileServerModeOrDefault();
        if (CompileServerMode.NewEachInvocation$.MODULE$.equals(compileServerMode)) {
            LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(started.logger()), BleepCommandRemote::run$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(21), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepCommandRemote.scala"), Enclosing$.MODULE$.apply("bleep.BleepCommandRemote#run"));
        } else if (!CompileServerMode.Shared$.MODULE$.equals(compileServerMode)) {
            throw new MatchError((Object)compileServerMode);
        }
        BleepRifleLogger bleepRifleLogger = new BleepRifleLogger(started.logger());
        BloopRifleConfig bloopRifleConfig = SetupBloopRifle$.MODULE$.apply(started.config().compileServerModeOrDefault(), (ResolvedJvm)started.resolvedJvm().forceGet(), started.pre().userPaths(), started.resolver(), bleepRifleLogger);
        BspClientDisplayProgress buildClient = BspClientDisplayProgress$.MODULE$.apply(started.logger());
        try {
            bloopServer = BloopServer$.MODULE$.buildServer(bloopRifleConfig, "bleep", BleepVersion$.MODULE$.current(), started.buildPaths().buildVariantDir(), package.PathOps$.MODULE$.$div$extension(package$.MODULE$.PathOps(started.buildPaths().buildVariantDir()), "classes"), (BuildClient)buildClient, BloopThreads$.MODULE$.create(), (BloopRifleLogger)bleepRifleLogger);
        }
        catch (FailedToStartServerException th) {
            None$ none$;
            BloopRifleConfig.Address address = bloopRifleConfig.address();
            if (address instanceof BloopRifleConfig.Address$.Tcp) {
                none$ = None$.MODULE$;
            } else if (address instanceof BloopRifleConfig.Address.DomainSocket) {
                BloopRifleConfig.Address.DomainSocket ds = (BloopRifleConfig.Address.DomainSocket)address;
                none$ = Try$.MODULE$.apply(() -> BleepCommandRemote.$anonfun$1(ds)).toOption();
            } else {
                throw new MatchError((Object)address);
            }
            None$ readLog = none$;
            throw BleepCommandRemote$FailedToStartBloop$.MODULE$.apply(th, (Option<String>)readLog);
        }
        BloopServer server = bloopServer;
        try {
            if (this.watch) {
                Either either2 = (Either)package$.MODULE$.DiscardOps(this.runWithServer(started, server.server()));
                package.DiscardOps$.MODULE$.discard$extension((Object)either2);
                ObjectRef currentStarted = ObjectRef.create((Object)started);
                FileWatching.TypedWatcher<CrossProjectName> codeWatcher = BleepFileWatching$.MODULE$.projects((Started)currentStarted.elem, this.watchableProjects((Started)currentStarted.elem), (Function1<Set<CrossProjectName>, BoxedUnit>)(JProcedure1 & Serializable)changedProjects -> {
                    block6: {
                        Either<BleepException, BoxedUnit> either;
                        block7: {
                            Object object;
                            BoxedUnit boxedUnit;
                            block8: {
                                block5: {
                                    BleepCommandRemote bleepCommandRemote;
                                    BleepCommandRemote bleepCommandRemote2 = this;
                                    if (bleepCommandRemote2 instanceof OnlyChanged) {
                                        BleepCommandRemote x = (BleepCommandRemote)((Object)((OnlyChanged)((Object)bleepCommandRemote2)));
                                        bleepCommandRemote = ((OnlyChanged)((Object)x)).onlyChangedProjects((Started)currentStarted$1.elem, (Function1<CrossProjectName, Object>)changedProjects);
                                    } else {
                                        BleepCommandRemote other;
                                        bleepCommandRemote = other = bleepCommandRemote2;
                                    }
                                    BleepCommandRemote patchedCmd = bleepCommandRemote;
                                    either = patchedCmd.runWithServer((Started)currentStarted$1.elem, server.server());
                                    if (!(either instanceof Left)) break block5;
                                    BleepException bleepException = (BleepException)((Left)either).value();
                                    LoggerFn$Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(((Started)currentStarted$1.elem).logger()), () -> BleepCommandRemote.$anonfun$2$$anonfun$1(bleepException), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(74), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepCommandRemote.scala"), Enclosing$.MODULE$.apply("bleep.BleepCommandRemote#run codeWatcher"));
                                    break block6;
                                }
                                if (!(either instanceof Right)) break block7;
                                boxedUnit = BoxedUnit.UNIT;
                                object = ((Right)either).value();
                                if (boxedUnit != null) break block8;
                                if (object == null) break block6;
                                break block7;
                            }
                            if (boxedUnit.equals(object)) break block6;
                        }
                        throw new MatchError(either);
                    }
                });
                FileWatching.Watcher buildWatcher = BleepFileWatching$.MODULE$.build(started.pre(), (Function1<Set<String>, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> {
                    Either<BleepException, Option<Started>> either = started.reloadFromDisk();
                    if (either instanceof Left) {
                        BleepException bleepException = (BleepException)((Left)either).value();
                        Throwables$.MODULE$.log("build changed, but it didn't work :(", started.logger(), (Throwable)bleepException, Line$.MODULE$.apply(83), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepCommandRemote.scala"), Enclosing$.MODULE$.apply("bleep.BleepCommandRemote#run buildWatcher"));
                        codeWatcher.updateMapping(Predef$.MODULE$.Map().empty());
                        return;
                    }
                    if (either instanceof Right) {
                        Option option = (Option)((Right)either).value();
                        if (None$.MODULE$.equals(option)) {
                            return;
                        }
                        if (option instanceof Some) {
                            Started newStarted = (Started)((Some)option).value();
                            currentStarted$2.elem = newStarted;
                            codeWatcher.updateMapping(BleepFileWatching$.MODULE$.projectPathsMapping((Started)currentStarted$2.elem, this.watchableProjects((Started)currentStarted$2.elem)));
                            return;
                        }
                    }
                    throw new MatchError(either);
                });
                LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(started.logger()), BleepCommandRemote::run$$anonfun$2, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(93), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepCommandRemote.scala"), Enclosing$.MODULE$.apply("bleep.BleepCommandRemote#run"));
                FileWatching.Watcher watcher = codeWatcher.combine(buildWatcher);
                watcher.run(FileWatching$StopWhen$OnStdInput$.MODULE$, watcher.run$default$2());
                either = scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                either = this.runWithServer(started, server.server()).flatMap((Function1 & Serializable)x$1 -> {
                    Right right;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    ListBuffer<BuildTargetIdentifier> listBuffer = buildClient.failed();
                    ListBuffer<BuildTargetIdentifier> empty = listBuffer;
                    if (empty.isEmpty()) {
                        right = scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    } else {
                        ListBuffer<BuildTargetIdentifier> failed = listBuffer;
                        CrossProjectName[] projects = (CrossProjectName[])((IterableOnceOps)failed.flatMap((Function1 & Serializable)name -> BleepCommandRemote$.MODULE$.projectFromBuildTarget(started, (BuildTargetIdentifier)name))).toArray(ClassTag$.MODULE$.apply(CrossProjectName.class));
                        right = scala.package$.MODULE$.Left().apply((Object)new BspCommandFailed("Failed", projects, BspCommandFailed$NoDetails$.MODULE$));
                    }
                    return right.map((Function1)(JProcedure1 & Serializable)res -> {});
                });
            }
        }
        finally {
            CompileServerMode compileServerMode2 = started.config().compileServerModeOrDefault();
            if (CompileServerMode.NewEachInvocation$.MODULE$.equals(compileServerMode2)) {
                server.shutdown();
                if (Operations$.MODULE$.exit(bloopRifleConfig.address(), started.buildPaths().dotBleepDir(), (OutputStream)System.out, (OutputStream)System.err, (BloopRifleLogger)bleepRifleLogger) != 0) {
                    LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(started.logger()), BleepCommandRemote::run$$anonfun$4, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(114), File$.MODULE$.apply("/Users/oyvind/bleep/bleep-core/src/scala/bleep/BleepCommandRemote.scala"), Enclosing$.MODULE$.apply("bleep.BleepCommandRemote#run"));
                }
            } else if (!CompileServerMode.Shared$.MODULE$.equals(compileServerMode2)) {
                throw new MatchError((Object)compileServerMode2);
            }
        }
        return either;
    }

    private static final String run$$anonfun$1() {
        return "TIP: run `bleep config compile-server auto-shutdown-disable` so you'll get a warm/fast compile server";
    }

    private static final String $anonfun$1(BloopRifleConfig.Address.DomainSocket ds$1) {
        return Files.readString(ds$1.outputPath());
    }

    private static final String $anonfun$2$$anonfun$1(BleepException bleepException$1) {
        return Throwables$.MODULE$.messagesFrom((Throwable)bleepException$1).mkString(": ");
    }

    private static final String run$$anonfun$2() {
        return "Running in watch mode";
    }

    private static final String run$$anonfun$4() {
        return "Failed to shutdown the compile server";
    }

    public static class FailedToStartBloop
    extends BleepException
    implements Product {
        private final FailedToStartServerException cause;
        private final Option<String> readLog;

        public static FailedToStartBloop apply(FailedToStartServerException failedToStartServerException, Option<String> option) {
            return BleepCommandRemote$FailedToStartBloop$.MODULE$.apply(failedToStartServerException, option);
        }

        public static FailedToStartBloop fromProduct(Product product) {
            return BleepCommandRemote$FailedToStartBloop$.MODULE$.fromProduct(product);
        }

        public static FailedToStartBloop unapply(FailedToStartBloop failedToStartBloop) {
            return BleepCommandRemote$FailedToStartBloop$.MODULE$.unapply(failedToStartBloop);
        }

        public FailedToStartBloop(FailedToStartServerException cause, Option<String> readLog) {
            this.cause = cause;
            this.readLog = readLog;
            super(BleepCommandRemote$.MODULE$.bleep$BleepCommandRemote$$$FailedToStartBloop$superArg$1(cause, readLog), BleepException$.MODULE$.$lessinit$greater$default$2());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FailedToStartBloop)) return false;
            FailedToStartBloop failedToStartBloop = (FailedToStartBloop)((Object)object);
            FailedToStartServerException failedToStartServerException = this.cause();
            FailedToStartServerException failedToStartServerException2 = failedToStartBloop.cause();
            if (failedToStartServerException == null) {
                if (failedToStartServerException2 != null) {
                    return false;
                }
            } else if (!failedToStartServerException.equals(failedToStartServerException2)) return false;
            Option<String> option = this.readLog();
            Option<String> option2 = failedToStartBloop.readLog();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!failedToStartBloop.canEqual((Object)this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof FailedToStartBloop;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "FailedToStartBloop";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            if (1 == n2) {
                return "readLog";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FailedToStartServerException cause() {
            return this.cause;
        }

        public Option<String> readLog() {
            return this.readLog;
        }

        public FailedToStartBloop copy(FailedToStartServerException cause, Option<String> readLog) {
            return new FailedToStartBloop(cause, readLog);
        }

        public FailedToStartServerException copy$default$1() {
            return this.cause();
        }

        public Option<String> copy$default$2() {
            return this.readLog();
        }

        public FailedToStartServerException _1() {
            return this.cause();
        }

        public Option<String> _2() {
            return this.readLog();
        }
    }

    public static interface OnlyChanged {
        public BleepCommandRemote onlyChangedProjects(Started var1, Function1<CrossProjectName, Object> var2);
    }
}

