/*
 * Decompiled with CFR 0.152.
 */
package bleep.logging;

import bleep.logging.Formatter;
import bleep.logging.Formatter$;
import bleep.logging.LogLevel;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.Metadata;
import bleep.logging.Pattern;
import bleep.logging.TypedLogger$;
import bleep.logging.TypedLogger$ConsoleLogger$;
import bleep.logging.TypedLogger$LoggerAuxSyntax$;
import bleep.logging.TypedLogger$LoggerFlushableSyntax$;
import bleep.logging.TypedLogger$Stored$;
import fansi.Str;
import fansi.Str$;
import java.io.Flushable;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sourcecode.Text;

public interface TypedLogger<Underlying>
extends LoggerFn {
    public static <U> TypedLogger LoggerAuxSyntax(TypedLogger<U> typedLogger) {
        return TypedLogger$.MODULE$.LoggerAuxSyntax(typedLogger);
    }

    public static <U extends Flushable> TypedLogger LoggerFlushableSyntax(TypedLogger<U> typedLogger) {
        return TypedLogger$.MODULE$.LoggerFlushableSyntax(typedLogger);
    }

    public Underlying underlying();

    public <T> TypedLogger<Underlying> withContext(String var1, T var2, Formatter<T> var3);

    public static TypedLogger withContext$(TypedLogger $this, Text value, Formatter evidence$2) {
        return $this.withContext(value, evidence$2);
    }

    default public <T> TypedLogger<Underlying> withContext(Text<T> value, Formatter<T> evidence$2) {
        return this.withContext(value.source(), value.value(), evidence$2);
    }

    public static TypedLogger withOptContext$(TypedLogger $this, String key, Option maybeValue, Formatter evidence$3) {
        return $this.withOptContext(key, maybeValue, evidence$3);
    }

    default public <T> TypedLogger<Underlying> withOptContext(String key, Option<T> maybeValue, Formatter<T> evidence$3) {
        TypedLogger<Underlying> typedLogger;
        Option<T> option = maybeValue;
        if (option instanceof Some) {
            Object value = ((Some)option).value();
            typedLogger = this.withContext(key, value, evidence$3);
        } else if (None$.MODULE$.equals(option)) {
            typedLogger = this;
        } else {
            throw new MatchError(option);
        }
        return typedLogger;
    }

    public Option<LoggerFn> progressMonitor();

    public static final class AppendableLogger<U extends Appendable>
    implements TypedLogger<U> {
        private final Appendable underlying;
        private final Pattern pattern;
        private final Map context;

        public AppendableLogger(U underlying, Pattern pattern, Map<Str, Str> context) {
            this.underlying = underlying;
            this.pattern = pattern;
            this.context = context;
        }

        @Override
        public U underlying() {
            return (U)this.underlying;
        }

        public Map<Str, Str> context() {
            return this.context;
        }

        @Override
        public <T> void log(Function0<Text<T>> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$6) {
            Str formatted = this.pattern.apply(t, throwable, metadata, this.context(), evidence$6);
            this.underlying().append(new StringBuilder(1).append(formatted.render()).append("\n").toString());
        }

        @Override
        public <T> AppendableLogger<U> withContext(String key, T value, Formatter<T> evidence$7) {
            Str str = (Str)Predef$.MODULE$.ArrowAssoc((Object)Str$.MODULE$.apply((CharSequence)key, Str$.MODULE$.apply$default$2()));
            return new AppendableLogger<Object>(this.underlying(), this.pattern, (Map<Str, Str>)((Map)this.context().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)str, (Object)Formatter$.MODULE$.apply(value, evidence$7)))));
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return None$.MODULE$;
        }
    }

    public static final class ConsoleLogger<U extends PrintStream>
    implements TypedLogger<U> {
        private final PrintStream underlying;
        public final Pattern bleep$logging$TypedLogger$ConsoleLogger$$pattern;
        private final Map context;
        public final AtomicBoolean bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress;
        private final String CleanCurrentLine;

        public static <U extends PrintStream> AtomicBoolean $lessinit$greater$default$4() {
            return TypedLogger$ConsoleLogger$.MODULE$.$lessinit$greater$default$4();
        }

        public ConsoleLogger(U underlying, Pattern pattern, Map<Str, Str> context, AtomicBoolean lastWasProgress) {
            this.underlying = underlying;
            this.bleep$logging$TypedLogger$ConsoleLogger$$pattern = pattern;
            this.context = context;
            this.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress = lastWasProgress;
            this.CleanCurrentLine = "\u001b[K";
        }

        @Override
        public U underlying() {
            return (U)this.underlying;
        }

        public Map<Str, Str> context() {
            return this.context;
        }

        public String CleanCurrentLine() {
            return this.CleanCurrentLine;
        }

        @Override
        public <T> void log(Function0<Text<T>> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$8) {
            Str formatted = this.bleep$logging$TypedLogger$ConsoleLogger$$pattern.apply(t, throwable, metadata, this.context(), evidence$8);
            PrintStream printStream = this.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress.get() ? ((PrintStream)this.underlying()).append(new StringBuilder(1).append(this.CleanCurrentLine()).append(formatted.render()).append("\n").toString()) : ((PrintStream)this.underlying()).append(new StringBuilder(1).append(formatted.render()).append("\n").toString());
            this.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress.set(false);
        }

        @Override
        public <T> ConsoleLogger<U> withContext(String key, T value, Formatter<T> evidence$9) {
            Str str = (Str)Predef$.MODULE$.ArrowAssoc((Object)Str$.MODULE$.apply((CharSequence)key, Str$.MODULE$.apply$default$2()));
            return new ConsoleLogger<Object>(this.underlying(), this.bleep$logging$TypedLogger$ConsoleLogger$$pattern, (Map<Str, Str>)((Map)this.context().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)str, (Object)Formatter$.MODULE$.apply(value, evidence$9)))), this.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress);
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return Some$.MODULE$.apply((Object)new LoggerFn(this){
                private final ConsoleLogger $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void log(Function0 text, Option throwable, Metadata metadata, Formatter evidence$10) {
                    Str formatted = this.$outer.bleep$logging$TypedLogger$ConsoleLogger$$pattern.apply(text, (Option<Throwable>)throwable, metadata, this.$outer.context(), evidence$10);
                    if (this.$outer.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress.get()) {
                        ((PrintStream)this.$outer.underlying()).append(new StringBuilder(1).append(this.$outer.CleanCurrentLine()).append(formatted.render()).append("\r").toString());
                    } else {
                        ((PrintStream)this.$outer.underlying()).append(new StringBuilder(1).append(formatted.render()).append("\r").toString());
                        this.$outer.bleep$logging$TypedLogger$ConsoleLogger$$lastWasProgress.set(true);
                    }
                }
            });
        }
    }

    public static final class Flushing<U extends Flushable>
    implements TypedLogger<U> {
        private final TypedLogger<U> wrapped;

        public Flushing(TypedLogger<U> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public U underlying() {
            return (U)((Flushable)this.wrapped.underlying());
        }

        @Override
        public <T> void log(Function0<Text<T>> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$11) {
            this.wrapped.log(t, throwable, metadata, evidence$11);
            ((Flushable)this.wrapped.underlying()).flush();
        }

        @Override
        public <T> Flushing<U> withContext(String key, T value, Formatter<T> evidence$12) {
            return new Flushing<U>(this.wrapped.withContext(key, value, evidence$12));
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return this.wrapped.progressMonitor();
        }
    }

    public static final class LoggerAuxSyntax<U> {
        private final TypedLogger self;

        public static <U> boolean equals$extension(TypedLogger typedLogger, Object object) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.equals$extension(typedLogger, object);
        }

        public static <U> TypedLogger<U> filter$extension(TypedLogger typedLogger, LogLevel logLevel) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.filter$extension(typedLogger, logLevel);
        }

        public static <U> int hashCode$extension(TypedLogger typedLogger) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.hashCode$extension(typedLogger);
        }

        public static <U> TypedLogger<U> syncAccess$extension(TypedLogger typedLogger) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.syncAccess$extension(typedLogger);
        }

        public static <U> TypedLogger<BoxedUnit> untyped$extension(TypedLogger typedLogger) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.untyped$extension(typedLogger);
        }

        public static <UU, U> TypedLogger<Tuple2<U, UU>> zipWith$extension(TypedLogger typedLogger, TypedLogger<UU> typedLogger2) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.zipWith$extension(typedLogger, typedLogger2);
        }

        public LoggerAuxSyntax(TypedLogger<U> self) {
            this.self = self;
        }

        public int hashCode() {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.hashCode$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self());
        }

        public boolean equals(Object x$0) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.equals$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self(), x$0);
        }

        public TypedLogger<U> bleep$logging$TypedLogger$LoggerAuxSyntax$$self() {
            return this.self;
        }

        public <UU> TypedLogger<Tuple2<U, UU>> zipWith(TypedLogger<UU> other) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.zipWith$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self(), other);
        }

        public TypedLogger<U> filter(LogLevel minLogLevel) {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.filter$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self(), minLogLevel);
        }

        public TypedLogger<BoxedUnit> untyped() {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.untyped$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self());
        }

        public TypedLogger<U> syncAccess() {
            return TypedLogger$LoggerAuxSyntax$.MODULE$.syncAccess$extension(this.bleep$logging$TypedLogger$LoggerAuxSyntax$$self());
        }
    }

    public static final class LoggerFlushableSyntax<U extends Flushable> {
        private final TypedLogger self;

        public static <U extends Flushable> boolean equals$extension(TypedLogger typedLogger, Object object) {
            return TypedLogger$LoggerFlushableSyntax$.MODULE$.equals$extension(typedLogger, object);
        }

        public static <U extends Flushable> TypedLogger<U> flushing$extension(TypedLogger typedLogger) {
            return TypedLogger$LoggerFlushableSyntax$.MODULE$.flushing$extension(typedLogger);
        }

        public static <U extends Flushable> int hashCode$extension(TypedLogger typedLogger) {
            return TypedLogger$LoggerFlushableSyntax$.MODULE$.hashCode$extension(typedLogger);
        }

        public LoggerFlushableSyntax(TypedLogger<U> self) {
            this.self = self;
        }

        public int hashCode() {
            return TypedLogger$LoggerFlushableSyntax$.MODULE$.hashCode$extension(this.bleep$logging$TypedLogger$LoggerFlushableSyntax$$self());
        }

        public boolean equals(Object x$0) {
            return TypedLogger$LoggerFlushableSyntax$.MODULE$.equals$extension(this.bleep$logging$TypedLogger$LoggerFlushableSyntax$$self(), x$0);
        }

        public TypedLogger<U> bleep$logging$TypedLogger$LoggerFlushableSyntax$$self() {
            return this.self;
        }

        public TypedLogger<U> flushing() {
            return TypedLogger$LoggerFlushableSyntax$.MODULE$.flushing$extension(this.bleep$logging$TypedLogger$LoggerFlushableSyntax$$self());
        }
    }

    public static final class Mapped<U, UU>
    implements TypedLogger<UU> {
        private final TypedLogger<U> wrapped;
        private final Function1<U, UU> f;

        public Mapped(TypedLogger<U> wrapped, Function1<U, UU> f) {
            this.wrapped = wrapped;
            this.f = f;
        }

        @Override
        public UU underlying() {
            return (UU)this.f.apply(this.wrapped.underlying());
        }

        @Override
        public <T> void log(Function0<Text<T>> t, Option<Throwable> throwable, Metadata m, Formatter<T> evidence$17) {
            this.wrapped.log(t, throwable, m, evidence$17);
        }

        @Override
        public <T> TypedLogger<UU> withContext(String key, T value, Formatter<T> evidence$18) {
            return new Mapped<U, UU>(this.wrapped.withContext(key, value, evidence$18), this.f);
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return this.wrapped.progressMonitor();
        }
    }

    public static class Store {
        private List<Stored> reversed = package$.MODULE$.Nil();

        public void store(Stored s) {
            this.reversed = this.reversed.$colon$colon((Object)s);
        }

        public Stored[] normal() {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.reversed.toArray(ClassTag$.MODULE$.apply(Stored.class)));
            return (Stored[])ArrayOps$.MODULE$.reverse$extension(object);
        }
    }

    public static class Stored
    implements Product,
    Serializable {
        private final Str message;
        private final Option throwable;
        private final Metadata metadata;
        private final Map ctx;

        public static Stored apply(Str str, Option<Throwable> option, Metadata metadata, Map<Str, Str> map) {
            return TypedLogger$Stored$.MODULE$.apply(str, option, metadata, map);
        }

        public static Stored fromProduct(Product product) {
            return TypedLogger$Stored$.MODULE$.fromProduct(product);
        }

        public static Stored unapply(Stored stored) {
            return TypedLogger$Stored$.MODULE$.unapply(stored);
        }

        public Stored(Str message, Option<Throwable> throwable, Metadata metadata, Map<Str, Str> ctx) {
            this.message = message;
            this.throwable = throwable;
            this.metadata = metadata;
            this.ctx = ctx;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Stored)) return false;
            Stored stored = (Stored)object;
            Str str = this.message();
            Str str2 = stored.message();
            if (str == null) {
                if (str2 != null) {
                    return false;
                }
            } else if (!str.equals(str2)) return false;
            Option<Throwable> option = this.throwable();
            Option<Throwable> option2 = stored.throwable();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Metadata metadata = this.metadata();
            Metadata metadata2 = stored.metadata();
            if (metadata == null) {
                if (metadata2 != null) {
                    return false;
                }
            } else if (!metadata.equals(metadata2)) return false;
            Map<Str, Str> map = this.ctx();
            Map<Str, Str> map2 = stored.ctx();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!stored.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Stored;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Stored";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "message";
                    break;
                }
                case 1: {
                    string = "throwable";
                    break;
                }
                case 2: {
                    string = "metadata";
                    break;
                }
                case 3: {
                    string = "ctx";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Str message() {
            return this.message;
        }

        public Option<Throwable> throwable() {
            return this.throwable;
        }

        public Metadata metadata() {
            return this.metadata;
        }

        public Map<Str, Str> ctx() {
            return this.ctx;
        }

        public Stored copy(Str message, Option<Throwable> throwable, Metadata metadata, Map<Str, Str> ctx) {
            return new Stored(message, throwable, metadata, ctx);
        }

        public Str copy$default$1() {
            return this.message();
        }

        public Option<Throwable> copy$default$2() {
            return this.throwable();
        }

        public Metadata copy$default$3() {
            return this.metadata();
        }

        public Map<Str, Str> copy$default$4() {
            return this.ctx();
        }

        public Str _1() {
            return this.message();
        }

        public Option<Throwable> _2() {
            return this.throwable();
        }

        public Metadata _3() {
            return this.metadata();
        }

        public Map<Str, Str> _4() {
            return this.ctx();
        }
    }

    public static final class StoringLogger
    implements TypedLogger<Stored[]> {
        private final Store store;
        private final Map ctx;

        public StoringLogger(Store store, Map<Str, Str> ctx) {
            this.store = store;
            this.ctx = ctx;
        }

        public Map<Str, Str> ctx() {
            return this.ctx;
        }

        @Override
        public <T> void log(Function0<Text<T>> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$4) {
            this.store.store(TypedLogger$Stored$.MODULE$.apply(Formatter$.MODULE$.apply(((Text)t.apply()).value(), evidence$4), throwable, metadata, this.ctx()));
        }

        public <T> StoringLogger withContext(String key, T value, Formatter<T> evidence$5) {
            Str str = (Str)Predef$.MODULE$.ArrowAssoc((Object)Str$.MODULE$.apply((CharSequence)key, Str$.MODULE$.apply$default$2()));
            return new StoringLogger(this.store, (Map<Str, Str>)((Map)this.ctx().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)str, (Object)Formatter$.MODULE$.apply(value, evidence$5)))));
        }

        @Override
        public Stored[] underlying() {
            return this.store.normal();
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return None$.MODULE$;
        }
    }

    public static final class Synchronized<U>
    implements TypedLogger<U> {
        private final TypedLogger<U> wrapped;

        public Synchronized(TypedLogger<U> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public U underlying() {
            return this.wrapped.underlying();
        }

        @Override
        public <T> void log(Function0<Text<T>> t, Option<Throwable> throwable, Metadata m, Formatter<T> evidence$19) {
            Synchronized synchronized_ = this;
            synchronized (synchronized_) {
                this.wrapped.log(t, throwable, m, evidence$19);
            }
        }

        @Override
        public <T> Synchronized<U> withContext(String key, T value, Formatter<T> evidence$20) {
            return new Synchronized<U>(this.wrapped.withContext(key, value, evidence$20));
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return this.wrapped.progressMonitor();
        }
    }

    public static final class WithFilter<U>
    implements TypedLogger<U> {
        private final TypedLogger<U> wrapped;
        private final LogLevel minLogLevel;

        public WithFilter(TypedLogger<U> wrapped, LogLevel minLogLevel) {
            this.wrapped = wrapped;
            this.minLogLevel = minLogLevel;
        }

        @Override
        public U underlying() {
            return this.wrapped.underlying();
        }

        @Override
        public <T> void log(Function0<Text<T>> t, Option<Throwable> throwable, Metadata m, Formatter<T> evidence$15) {
            if (m.logLevel().level() >= this.minLogLevel.level()) {
                this.wrapped.log(t, throwable, m, evidence$15);
            }
        }

        @Override
        public <T> TypedLogger<U> withContext(String key, T value, Formatter<T> evidence$16) {
            return new WithFilter<U>(this.wrapped.withContext(key, value, evidence$16), this.minLogLevel);
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return this.wrapped.progressMonitor();
        }
    }

    public static final class Zipped<U1, U2>
    implements TypedLogger<Tuple2<U1, U2>> {
        private final TypedLogger<U1> one;
        private final TypedLogger<U2> two;
        private final LoggerFn both;

        public Zipped(TypedLogger<U1> one, TypedLogger<U2> two) {
            this.one = one;
            this.two = two;
            this.both = LoggerFn$Syntax$.MODULE$.and$extension(LoggerFn$.MODULE$.Syntax(one), two);
        }

        @Override
        public Tuple2<U1, U2> underlying() {
            return Tuple2$.MODULE$.apply(this.one.underlying(), this.two.underlying());
        }

        @Override
        public <T> void log(Function0<Text<T>> t, Option<Throwable> throwable, Metadata metadata, Formatter<T> evidence$13) {
            this.both.log(t, throwable, metadata, evidence$13);
        }

        public <T> Zipped<U1, U2> withContext(String key, T value, Formatter<T> evidence$14) {
            return new Zipped<U1, U2>(this.one.withContext(key, value, evidence$14), this.two.withContext(key, value, evidence$14));
        }

        @Override
        public Option<LoggerFn> progressMonitor() {
            return ((IterableOnceOps)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.one.progressMonitor(), this.two.progressMonitor()}))).flatten(Predef$.MODULE$.$conforms())).reduceOption((Function2 & Serializable)(_$1, _$2) -> LoggerFn$Syntax$.MODULE$.and$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)_$1), (LoggerFn)_$2));
        }
    }
}

