/*
 * Decompiled with CFR 0.152.
 */
package bleep.bsp;

import bleep.BleepVersion$;
import bleep.BuildException;
import bleep.Started;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import bleep.package$;
import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildClientCapabilities;
import ch.epfl.scala.bsp4j.BuildServerCapabilities;
import ch.epfl.scala.bsp4j.CleanCacheParams;
import ch.epfl.scala.bsp4j.CleanCacheResult;
import ch.epfl.scala.bsp4j.CompileParams;
import ch.epfl.scala.bsp4j.CompileProvider;
import ch.epfl.scala.bsp4j.CompileResult;
import ch.epfl.scala.bsp4j.DebugProvider;
import ch.epfl.scala.bsp4j.DebugSessionAddress;
import ch.epfl.scala.bsp4j.DebugSessionParams;
import ch.epfl.scala.bsp4j.DependencyModulesParams;
import ch.epfl.scala.bsp4j.DependencyModulesResult;
import ch.epfl.scala.bsp4j.DependencySourcesParams;
import ch.epfl.scala.bsp4j.DependencySourcesResult;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import ch.epfl.scala.bsp4j.InverseSourcesParams;
import ch.epfl.scala.bsp4j.InverseSourcesResult;
import ch.epfl.scala.bsp4j.JavacOptionsParams;
import ch.epfl.scala.bsp4j.JavacOptionsResult;
import ch.epfl.scala.bsp4j.MessageType;
import ch.epfl.scala.bsp4j.ResourcesParams;
import ch.epfl.scala.bsp4j.ResourcesResult;
import ch.epfl.scala.bsp4j.RunParams;
import ch.epfl.scala.bsp4j.RunProvider;
import ch.epfl.scala.bsp4j.RunResult;
import ch.epfl.scala.bsp4j.ScalaMainClassesParams;
import ch.epfl.scala.bsp4j.ScalaMainClassesResult;
import ch.epfl.scala.bsp4j.ScalaTestClassesParams;
import ch.epfl.scala.bsp4j.ScalaTestClassesResult;
import ch.epfl.scala.bsp4j.ScalacOptionsParams;
import ch.epfl.scala.bsp4j.ScalacOptionsResult;
import ch.epfl.scala.bsp4j.ShowMessageParams;
import ch.epfl.scala.bsp4j.SourcesParams;
import ch.epfl.scala.bsp4j.SourcesResult;
import ch.epfl.scala.bsp4j.TestParams;
import ch.epfl.scala.bsp4j.TestProvider;
import ch.epfl.scala.bsp4j.TestResult;
import ch.epfl.scala.bsp4j.WorkspaceBuildTargetsResult;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.build.bloop.BuildServer;
import scala.build.blooprifle.internal.Constants$;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public class BleepBspServer
implements ch.epfl.scala.bsp4j.BuildServer,
BuildServer {
    private final TypedLogger logger;
    private BuildClient sendToIdeClient;
    private BuildServer bloopServer;
    private Function0 ensureBloopUpToDate;
    private final List supportedLanguages;
    private final Promise<BoxedUnit> shutdownPromise;

    public BleepBspServer(TypedLogger<BoxedUnit> logger, BuildClient sendToIdeClient, BuildServer bloopServer, Function0<Either<BuildException, Started>> ensureBloopUpToDate) {
        this.logger = logger;
        this.sendToIdeClient = sendToIdeClient;
        this.bloopServer = bloopServer;
        this.ensureBloopUpToDate = ensureBloopUpToDate;
        this.supportedLanguages = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"scala", "java"}))).asJava();
        this.shutdownPromise = Promise$.MODULE$.apply();
    }

    public TypedLogger<BoxedUnit> logger() {
        return this.logger;
    }

    public BuildClient sendToIdeClient() {
        return this.sendToIdeClient;
    }

    public void sendToIdeClient_$eq(BuildClient x$1) {
        this.sendToIdeClient = x$1;
    }

    public BuildServer bloopServer() {
        return this.bloopServer;
    }

    public void bloopServer_$eq(BuildServer x$1) {
        this.bloopServer = x$1;
    }

    public Function0<Either<BuildException, Started>> ensureBloopUpToDate() {
        return this.ensureBloopUpToDate;
    }

    public void ensureBloopUpToDate_$eq(Function0<Either<BuildException, Started>> x$1) {
        this.ensureBloopUpToDate = x$1;
    }

    public List<String> supportedLanguages() {
        return this.supportedLanguages;
    }

    /*
     * WARNING - void declaration
     */
    private BuildServerCapabilities capabilities() {
        void var1_1;
        BuildServerCapabilities ret = new BuildServerCapabilities();
        ret.setCompileProvider(new CompileProvider(this.supportedLanguages()));
        ret.setTestProvider(new TestProvider(this.supportedLanguages()));
        ret.setRunProvider(new RunProvider(this.supportedLanguages()));
        ret.setDebugProvider(new DebugProvider(this.supportedLanguages()));
        ret.setInverseSourcesProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setDependencySourcesProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setResourcesProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setBuildTargetChangedProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setJvmRunEnvironmentProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setJvmTestEnvironmentProvider(Predef$.MODULE$.boolean2Boolean(true));
        ret.setCanReload(Predef$.MODULE$.boolean2Boolean(true));
        ret.setDependencyModulesProvider(Predef$.MODULE$.boolean2Boolean(true));
        return var1_1;
    }

    public CompletableFuture<InitializeBuildResult> buildInitialize(InitializeBuildParams params) {
        CompletionStage<Object> completionStage;
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildInitialize$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(42), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildInitialize"));
        Either either = (Either)this.ensureBloopUpToDate().apply();
        if (either instanceof Left) {
            BuildException th = (BuildException)((Left)either).value();
            this.sendToIdeClient().onBuildShowMessage(new ShowMessageParams(MessageType.ERROR, bleep.internal.package$.MODULE$.throwableMessages(th).mkString(": ")));
            LoggerFn$Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::buildInitialize$$anonfun$2, th, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(48), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildInitialize"));
            completionStage = CompletableFuture.failedFuture(th);
        } else if (either instanceof Right) {
            Started started = (Started)((Right)either).value();
            Path workspaceDir = started.buildPaths().dotBleepModeDir();
            InitializeBuildParams initParams = new InitializeBuildParams(new StringBuilder(8).append("bleep / ").append(params.getDisplayName()).toString(), new StringBuilder(3).append(BleepVersion$.MODULE$.version()).append(" / ").append(params.getVersion()).toString(), Constants$.MODULE$.bspVersion(), workspaceDir.toUri().toASCIIString(), new BuildClientCapabilities(this.supportedLanguages()));
            JsonObject data = new JsonObject();
            data.add("clientClassesRootDir", (JsonElement)new JsonPrimitive(package$.MODULE$.PathOps(workspaceDir).$div("classes").toUri().toASCIIString()));
            data.add("ownsBuildFiles", (JsonElement)new JsonPrimitive(Predef$.MODULE$.boolean2Boolean(true)));
            Object object = params.getData();
            if (object instanceof JsonObject) {
                JsonObject dataFromIDE = (JsonObject)object;
                data.add("semanticdbVersion", dataFromIDE.get("semanticdbVersion"));
                data.add("javaSemanticdbVersion", dataFromIDE.get("javaSemanticdbVersion"));
                data.add("supportedScalaVersions", dataFromIDE.get("supportedScalaVersions"));
            } else {
                Object unexpected = object;
                LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildInitialize$$anonfun$3(unexpected), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(72), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildInitialize"));
            }
            initParams.setData((Object)data);
            LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::buildInitialize$$anonfun$4, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(77), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildInitialize"));
            completionStage = this.bloopServer().buildInitialize(initParams).thenApply(_$1 -> {
                this.bloopServer().onBuildInitialized();
                return new InitializeBuildResult("bleep", BleepVersion$.MODULE$.version(), Constants$.MODULE$.bspVersion(), this.capabilities());
            });
        } else {
            throw new MatchError((Object)either);
        }
        return completionStage;
    }

    public CompletableFuture<WorkspaceBuildTargetsResult> workspaceBuildTargets() {
        CompletableFuture completableFuture;
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::workspaceBuildTargets$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(86), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#workspaceBuildTargets"));
        Either either = (Either)this.ensureBloopUpToDate().apply();
        if (either instanceof Left) {
            BuildException th = (BuildException)((Left)either).value();
            LoggerFn$Syntax$.MODULE$.error$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::workspaceBuildTargets$$anonfun$2, th, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(90), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#workspaceBuildTargets"));
            completableFuture = CompletableFuture.failedFuture(th);
        } else if (either instanceof Right) {
            completableFuture = this.bloopServer().workspaceBuildTargets();
        } else {
            throw new MatchError((Object)either);
        }
        return completableFuture;
    }

    public void onBuildInitialized() {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::onBuildInitialized$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(97), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#onBuildInitialized"));
    }

    public CompletableFuture<Object> workspaceReload() {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::workspaceReload$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(102), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#workspaceReload"));
        return CompletableFuture.completedFuture(new Object());
    }

    public CompletableFuture<CleanCacheResult> buildTargetCleanCache(CleanCacheParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetCleanCache$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(108), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetCleanCache"));
        return this.bloopServer().buildTargetCleanCache(params);
    }

    public CompletableFuture<CompileResult> buildTargetCompile(CompileParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetCompile$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(112), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetCompile"));
        return this.bloopServer().buildTargetCompile(params);
    }

    public CompletableFuture<DependencySourcesResult> buildTargetDependencySources(DependencySourcesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetDependencySources$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(116), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetDependencySources"));
        return this.bloopServer().buildTargetDependencySources(params);
    }

    public CompletableFuture<InverseSourcesResult> buildTargetInverseSources(InverseSourcesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetInverseSources$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(120), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetInverseSources"));
        return this.bloopServer().buildTargetInverseSources(params);
    }

    public CompletableFuture<ResourcesResult> buildTargetResources(ResourcesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetResources$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(124), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetResources"));
        return this.bloopServer().buildTargetResources(params);
    }

    public CompletableFuture<RunResult> buildTargetRun(RunParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetRun$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(128), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetRun"));
        return this.bloopServer().buildTargetRun(params);
    }

    public CompletableFuture<SourcesResult> buildTargetSources(SourcesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetSources$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(132), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetSources"));
        return this.bloopServer().buildTargetSources(params);
    }

    public CompletableFuture<TestResult> buildTargetTest(TestParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetTest$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(136), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetTest"));
        return this.bloopServer().buildTargetTest(params);
    }

    public CompletableFuture<DependencyModulesResult> buildTargetDependencyModules(DependencyModulesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetDependencyModules$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(140), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetDependencyModules"));
        return this.bloopServer().buildTargetDependencyModules(params);
    }

    public CompletableFuture<JavacOptionsResult> buildTargetJavacOptions(JavacOptionsParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetJavacOptions$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(144), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetJavacOptions"));
        return this.bloopServer().buildTargetJavacOptions(params);
    }

    public CompletableFuture<ScalaMainClassesResult> buildTargetScalaMainClasses(ScalaMainClassesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetScalaMainClasses$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(148), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetScalaMainClasses"));
        return this.bloopServer().buildTargetScalaMainClasses(params);
    }

    public CompletableFuture<ScalaTestClassesResult> buildTargetScalaTestClasses(ScalaTestClassesParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetScalaTestClasses$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(152), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetScalaTestClasses"));
        return this.bloopServer().buildTargetScalaTestClasses(params);
    }

    public CompletableFuture<ScalacOptionsResult> buildTargetScalacOptions(ScalacOptionsParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetScalacOptions$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(156), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetScalacOptions"));
        return this.bloopServer().buildTargetScalacOptions(params);
    }

    public CompletableFuture<DebugSessionAddress> buildTargetDebugSession(DebugSessionParams params) {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), () -> BleepBspServer.buildTargetDebugSession$$anonfun$1(params), Formatter$.MODULE$.Tuple2Formatter(Formatter$.MODULE$.StringFormatter(), Formatter$.MODULE$.StringFormatter()), Line$.MODULE$.apply(160), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildTargetDebugSession"));
        return this.bloopServer().buildTargetDebugSession(params);
    }

    public CompletableFuture<Object> buildShutdown() {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::buildShutdown$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(167), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#buildShutdown"));
        if (!this.shutdownPromise.isCompleted()) {
            this.shutdownPromise.success((Object)BoxedUnit.UNIT);
        }
        return this.bloopServer().buildShutdown();
    }

    public void onBuildExit() {
        LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(this.logger()), BleepBspServer::onBuildExit$$anonfun$1, Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(174), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bsp/BleepBspServer.scala"), Enclosing$.MODULE$.apply("bleep.bsp.BleepBspServer#onBuildExit"));
    }

    public Future<BoxedUnit> initiateShutdown() {
        return this.shutdownPromise.future();
    }

    private static final Tuple2 v$proxy1$1(InitializeBuildParams params$2) {
        return Tuple2$.MODULE$.apply((Object)"onBuildInitialized", (Object)params$2.toString());
    }

    private static final Text buildInitialize$$anonfun$1(InitializeBuildParams params$1) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy1$1(params$1), "(\"onBuildInitialized\", params.toString)");
    }

    private static final Text buildInitialize$$anonfun$2() {
        return Text$.MODULE$.apply((Object)"couldn't refresh build", "\"couldn't refresh build\"");
    }

    private static final String v$proxy2$1(Object unexpected$2) {
        return new StringBuilder(29).append("got unexpected data element: ").append(unexpected$2).toString();
    }

    private static final Text buildInitialize$$anonfun$3(Object unexpected$1) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy2$1(unexpected$1), "s\"got unexpected data element: $unexpected\"");
    }

    private static final Text buildInitialize$$anonfun$4() {
        return Text$.MODULE$.apply((Object)"Sending buildInitialize BSP command to Bloop", "\"Sending buildInitialize BSP command to Bloop\"");
    }

    private static final Text workspaceBuildTargets$$anonfun$1() {
        return Text$.MODULE$.apply((Object)"workspaceBuildTargets", "\"workspaceBuildTargets\"");
    }

    private static final Text workspaceBuildTargets$$anonfun$2() {
        return Text$.MODULE$.apply((Object)"couldn't refresh build", "\"couldn't refresh build\"");
    }

    private static final Text onBuildInitialized$$anonfun$1() {
        return Text$.MODULE$.apply((Object)"onBuildInitialized", "\"onBuildInitialized\"");
    }

    private static final Text workspaceReload$$anonfun$1() {
        return Text$.MODULE$.apply((Object)"workspaceReload", "\"workspaceReload\"");
    }

    private static final Tuple2 v$proxy3$1(CleanCacheParams params$4) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetCleanCache", (Object)params$4.toString());
    }

    private static final Text buildTargetCleanCache$$anonfun$1(CleanCacheParams params$3) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy3$1(params$3), "(\"buildTargetCleanCache\", params.toString)");
    }

    private static final Tuple2 v$proxy4$1(CompileParams params$6) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetCompile", (Object)params$6.toString());
    }

    private static final Text buildTargetCompile$$anonfun$1(CompileParams params$5) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy4$1(params$5), "(\"buildTargetCompile\", params.toString)");
    }

    private static final Tuple2 v$proxy5$1(DependencySourcesParams params$8) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetDependencySources", (Object)params$8.toString());
    }

    private static final Text buildTargetDependencySources$$anonfun$1(DependencySourcesParams params$7) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy5$1(params$7), "(\"buildTargetDependencySources\", params.toString)");
    }

    private static final Tuple2 v$proxy6$1(InverseSourcesParams params$10) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetInverseSources", (Object)params$10.toString());
    }

    private static final Text buildTargetInverseSources$$anonfun$1(InverseSourcesParams params$9) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy6$1(params$9), "(\"buildTargetInverseSources\", params.toString)");
    }

    private static final Tuple2 v$proxy7$1(ResourcesParams params$12) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetResources", (Object)params$12.toString());
    }

    private static final Text buildTargetResources$$anonfun$1(ResourcesParams params$11) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy7$1(params$11), "(\"buildTargetResources\", params.toString)");
    }

    private static final Tuple2 v$proxy8$1(RunParams params$14) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetRun", (Object)params$14.toString());
    }

    private static final Text buildTargetRun$$anonfun$1(RunParams params$13) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy8$1(params$13), "(\"buildTargetRun\", params.toString)");
    }

    private static final Tuple2 v$proxy9$1(SourcesParams params$16) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetSources", (Object)params$16.toString());
    }

    private static final Text buildTargetSources$$anonfun$1(SourcesParams params$15) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy9$1(params$15), "(\"buildTargetSources\", params.toString)");
    }

    private static final Tuple2 v$proxy10$1(TestParams params$18) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetTest", (Object)params$18.toString());
    }

    private static final Text buildTargetTest$$anonfun$1(TestParams params$17) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy10$1(params$17), "(\"buildTargetTest\", params.toString)");
    }

    private static final Tuple2 v$proxy11$1(DependencyModulesParams params$20) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetDependencyModules", (Object)params$20.toString());
    }

    private static final Text buildTargetDependencyModules$$anonfun$1(DependencyModulesParams params$19) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy11$1(params$19), "(\"buildTargetDependencyModules\", params.toString)");
    }

    private static final Tuple2 v$proxy12$1(JavacOptionsParams params$22) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetJavacOptions", (Object)params$22.toString());
    }

    private static final Text buildTargetJavacOptions$$anonfun$1(JavacOptionsParams params$21) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy12$1(params$21), "(\"buildTargetJavacOptions\", params.toString)");
    }

    private static final Tuple2 v$proxy13$1(ScalaMainClassesParams params$24) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetScalaMainClasses", (Object)params$24.toString());
    }

    private static final Text buildTargetScalaMainClasses$$anonfun$1(ScalaMainClassesParams params$23) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy13$1(params$23), "(\"buildTargetScalaMainClasses\", params.toString)");
    }

    private static final Tuple2 v$proxy14$1(ScalaTestClassesParams params$26) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetScalaTestClasses", (Object)params$26.toString());
    }

    private static final Text buildTargetScalaTestClasses$$anonfun$1(ScalaTestClassesParams params$25) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy14$1(params$25), "(\"buildTargetScalaTestClasses\", params.toString)");
    }

    private static final Tuple2 v$proxy15$1(ScalacOptionsParams params$28) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetScalacOptions", (Object)params$28.toString());
    }

    private static final Text buildTargetScalacOptions$$anonfun$1(ScalacOptionsParams params$27) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy15$1(params$27), "(\"buildTargetScalacOptions\", params.toString)");
    }

    private static final Tuple2 v$proxy16$1(DebugSessionParams params$30) {
        return Tuple2$.MODULE$.apply((Object)"buildTargetDebugSession", (Object)params$30.toString());
    }

    private static final Text buildTargetDebugSession$$anonfun$1(DebugSessionParams params$29) {
        return Text$.MODULE$.apply((Object)BleepBspServer.v$proxy16$1(params$29), "(\"buildTargetDebugSession\", params.toString)");
    }

    private static final Text buildShutdown$$anonfun$1() {
        return Text$.MODULE$.apply((Object)"buildShutdown", "\"buildShutdown\"");
    }

    private static final Text onBuildExit$$anonfun$1() {
        return Text$.MODULE$.apply((Object)"onBuildExit", "\"onBuildExit\"");
    }
}

