/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BleepConfigOps$;
import bleep.BleepException;
import bleep.BleepExecutable;
import bleep.BleepExecutable$;
import bleep.BuildLoader;
import bleep.BuildLoader$;
import bleep.BuildPaths;
import bleep.BuildPaths$;
import bleep.Commands;
import bleep.CommonOpts;
import bleep.CoursierResolver;
import bleep.CoursierResolver$Factory$default$;
import bleep.ExitCode;
import bleep.ExitCode$Failure$;
import bleep.ExitCode$Success$;
import bleep.GenBloopFiles;
import bleep.GenBloopFiles$;
import bleep.Lazy;
import bleep.Lazy$;
import bleep.Prebootstrapped;
import bleep.Started;
import bleep.UserPaths;
import bleep.UserPaths$;
import bleep.internal.FileUtils$;
import bleep.internal.bleepLoggers$;
import bleep.internal.fatal$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import bleep.logging.TypedLoggerResource$;
import bleep.logging.TypedLoggerResource$Ops$;
import bleep.model.BleepConfig;
import bleep.model.Build;
import bleep.model.BuildFile;
import bleep.model.BuildVariant;
import bleep.model.BuildVariant$;
import bleep.model.CrossProjectName;
import bleep.model.Project;
import bleep.package$;
import bleep.rewrites.BuildRewrite;
import bloop.config.Config;
import java.io.Serializable;
import java.nio.file.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;

public final class bootstrap$ {
    public static final bootstrap$ MODULE$ = new bootstrap$();

    public void forScript(String scriptName, CommonOpts commonOpts, List<BuildRewrite> rewrites, Function2<Started, Commands, BoxedUnit> f) {
        UserPaths userPaths = UserPaths$.MODULE$.fromAppDirs();
        BleepConfig bleepConfig = (BleepConfig)BleepException.ExpectOps$.MODULE$.orThrow$extension(package$.MODULE$.bleepExceptionOps(BleepConfigOps$.MODULE$.loadOrDefault(userPaths)), (.less.colon.less)$less$colon$less$.MODULE$.refl());
        BuildLoader buildLoader = BuildLoader$.MODULE$.find(FileUtils$.MODULE$.cwd());
        BuildVariant buildVariant = BuildVariant$.MODULE$.apply(rewrites.map((Function1 & Serializable)x$1 -> x$1.name()));
        BuildPaths buildPaths = BuildPaths$.MODULE$.apply(FileUtils$.MODULE$.cwd(), buildLoader, buildVariant);
        ExitCode exitCode = (ExitCode)TypedLoggerResource$Ops$.MODULE$.untyped$extension(TypedLoggerResource$.MODULE$.Ops(TypedLoggerResource$Ops$.MODULE$.map$extension(TypedLoggerResource$.MODULE$.Ops(bleepLoggers$.MODULE$.stdoutNoLogFile(bleepConfig, commonOpts)), (Function1 & Serializable)l -> l.withPath(new StringBuilder(9).append("[script ").append(scriptName).append("]").toString())))).use((Function1 & Serializable)logger -> {
            ExecutionContextExecutor ec = ExecutionContext$.MODULE$.global();
            Either maybeStarted = buildLoader.existing().map((Function1 & Serializable)existingBuild -> {
                Prebootstrapped pre = new Prebootstrapped((TypedLogger<BoxedUnit>)logger, userPaths, buildPaths, (BuildLoader.Existing)existingBuild, (ExecutionContext)ec);
                GenBloopFiles genBloopFiles = GenBloopFiles$.MODULE$.SyncToDisk();
                return new Tuple3(existingBuild, (Object)pre, (Object)genBloopFiles);
            }).flatMap((Function1 & Serializable)x$2 -> {
                Tuple3 tuple3 = x$2;
                if (tuple3 != null) {
                    Prebootstrapped pre = (Prebootstrapped)tuple3._2();
                    GenBloopFiles genBloopFiles = (GenBloopFiles)tuple3._3();
                    return MODULE$.from(pre, genBloopFiles, rewrites, bleepConfig, CoursierResolver$Factory$default$.MODULE$).map((Function1 & Serializable)started -> started);
                }
                throw new MatchError((Object)tuple3);
            });
            Either either = maybeStarted;
            if (either instanceof Left) {
                Left left = (Left)either;
                BleepException buildException = (BleepException)left.value();
                return fatal$.MODULE$.apply("Couldn't initialize bleep", (TypedLogger<BoxedUnit>)logger, buildException);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Started started = (Started)right.value();
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)started, (Object)new Commands(started)));
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable th = failure.exception();
                    return fatal$.MODULE$.apply(new StringBuilder(25).append("Failed to run script: `").append(scriptName).append("`.").toString(), (TypedLogger<BoxedUnit>)logger, th);
                }
                if (try_ instanceof Success) {
                    return ExitCode$Success$.MODULE$;
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError((Object)either);
        });
        ExitCode exitCode2 = exitCode;
        if (ExitCode$Success$.MODULE$.equals(exitCode2)) {
            return;
        }
        if (ExitCode$Failure$.MODULE$.equals(exitCode2)) {
            System.exit(exitCode.value());
            return;
        }
        throw new MatchError((Object)exitCode2);
    }

    public List<BuildRewrite> forScript$default$3() {
        return Nil$.MODULE$;
    }

    public Either<BleepException, Started> from(Prebootstrapped pre, GenBloopFiles genBloopFiles, List<BuildRewrite> rewrites, BleepConfig config, CoursierResolver.Factory resolverFactory) {
        return bootstrap$.go$1(pre, config, rewrites, resolverFactory, genBloopFiles);
    }

    private static final Either go$1(Prebootstrapped pre, BleepConfig config, List rewrites, CoursierResolver.Factory resolverFactory$1, GenBloopFiles genBloopFiles$1) {
        Left left;
        long t0 = System.currentTimeMillis();
        try {
            left = ((Either)pre.existingBuild().buildFile().forceGet()).map((Function1 & Serializable)buildFile -> {
                None$ none$;
                CoursierResolver resolver = resolverFactory$1.apply(pre, config, (BuildFile)buildFile);
                Build build = (Build)rewrites.foldLeft((Object)new Build.FileBacked(buildFile), (Function2 & Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null) {
                        Build b = (Build)tuple2._1();
                        BuildRewrite rewrite = (BuildRewrite)tuple2._2();
                        return rewrite.apply(b);
                    }
                    throw new MatchError((Object)tuple2);
                });
                Lazy bleepExecutable = Lazy$.MODULE$.apply((Function0 & Serializable)() -> BleepExecutable$.MODULE$.getCommand(resolver, pre, false));
                Path path = pre.buildPaths().cwd();
                Path path2 = pre.buildPaths().buildDir();
                if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                    none$ = None$.MODULE$;
                } else {
                    CrossProjectName[] chosen = (CrossProjectName[])((IterableOnceOps)build.explodedProjects().flatMap((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            CrossProjectName crossProjectName = (CrossProjectName)tuple2._1();
                            Project p = (Project)tuple2._2();
                            Path folder = pre.buildPaths().project(crossProjectName, p).dir();
                            if (folder.startsWith(pre.buildPaths().cwd())) {
                                return new Some((Object)crossProjectName);
                            }
                            return None$.MODULE$;
                        }
                        throw new MatchError((Object)tuple2);
                    })).toArray(ClassTag$.MODULE$.apply(CrossProjectName.class));
                    if (chosen.length > 0 && chosen.length != build.explodedProjects().size()) {
                        LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(pre.logger()), (Function0 & Serializable)() -> new StringBuilder(61).append(chosen.length).append(" of ").append(build.explodedProjects().size()).append(" projects active from ").append(pre.buildPaths().cwd()).append(". run `bleep projects` to see which").toString(), Formatter$.MODULE$.StringFormatter(), new Line(70), new File("/home/runner/work/bleep/bleep/bleep-core/src/scala/bleep/bootstrap.scala"), new Enclosing("bleep.bootstrap.from go activeProjects"));
                    }
                    none$ = new Some((Object)chosen).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])x$3))));
                }
                None$ activeProjects = none$;
                SortedMap<CrossProjectName, Lazy<Config.File>> bloopFiles = genBloopFiles$1.apply(pre, resolver, build);
                long td = System.currentTimeMillis() - t0;
                LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(pre.logger()), (Function0 & Serializable)() -> new StringBuilder(19).append("bootstrapped in ").append(td).append(" ms").toString(), Formatter$.MODULE$.StringFormatter(), new Line(81), new File("/home/runner/work/bleep/bleep/bleep-core/src/scala/bleep/bootstrap.scala"), new Enclosing("bleep.bootstrap.from go"));
                return new Started(pre, (List<BuildRewrite>)rewrites, build, bloopFiles, (Option<CrossProjectName[]>)activeProjects, config, resolver, (Lazy<BleepExecutable>)bleepExecutable, (Function3<Prebootstrapped, BleepConfig, List<BuildRewrite>, Either<BleepException, Started>>)(Function3 & Serializable)(pre, config, rewrites) -> bootstrap$.go$1(pre, config, rewrites, resolverFactory$1, genBloopFiles$1));
            });
        }
        catch (BleepException x) {
            left = scala.package$.MODULE$.Left().apply((Object)x);
        }
        catch (Throwable th) {
            left = scala.package$.MODULE$.Left().apply((Object)new BleepException.Cause(th, "couldn't initialize bleep", BleepException.Not$.MODULE$.not()));
        }
        return left;
    }

    private bootstrap$() {
    }
}

