/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BleepException;
import bleep.BleepExecutable;
import bleep.CoursierResolver;
import bleep.FetchBleepRelease$;
import bleep.OsArch;
import bleep.OsArch$;
import bleep.Prebootstrapped;
import bleep.ResolvedJvm;
import bleep.internal.compat;
import bleep.internal.compat$;
import bleep.internal.jvmRunCommand$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import bleep.model.BleepVersion$;
import bleep.model.Dep;
import bleep.model.LibraryVersionScheme;
import bleep.model.LibraryVersionScheme$;
import bleep.model.VersionCombo;
import bleep.model.VersionScala$;
import bleep.package$;
import coursier.cache.CacheLogger;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sourcecode.Enclosing;
import sourcecode.Line;
import sourcecode.Text;

public final class BleepExecutable$ {
    public static final BleepExecutable$ MODULE$ = new BleepExecutable$();
    private static final String BleepMain = "bleep.Main";

    private String BleepMain() {
        return BleepMain;
    }

    public BleepExecutable getCommand(CoursierResolver resolver, Prebootstrapped pre, boolean forceJvm) {
        return (BleepExecutable)this.findCurrentBleep(pre.logger()).getOrElse((Function0 & Serializable)() -> {
            String latestRelease = BleepVersion$.MODULE$.latestRelease$extension(BleepVersion$.MODULE$.current());
            OsArch osArch = OsArch$.MODULE$.current();
            if (osArch instanceof OsArch.HasNativeImage) {
                OsArch.HasNativeImage hasNativeImage = (OsArch.HasNativeImage)osArch;
                if (!forceJvm) {
                    LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(pre.logger()), (Function0 & Serializable)() -> new StringBuilder(72).append("couldn't determine name of current Bleep executable. Setting up version ").append(latestRelease).toString(), Formatter$.MODULE$.StringFormatter(), new Line(37), new sourcecode.File("/home/runner/work/bleep/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), new Enclosing("bleep.BleepExecutable.getCommand"));
                    Path bin = (Path)BleepException.ExpectOps$.MODULE$.orThrow$extension(package$.MODULE$.bleepExceptionOps(FetchBleepRelease$.MODULE$.apply(latestRelease, (CacheLogger)pre.cacheLogger(), pre.ec(), hasNativeImage)), (.less.colon.less)$less$colon$less$.MODULE$.refl());
                    return new BleepExecutable.DownloadedBinary(bin);
                }
            }
            if (forceJvm) {
                LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(pre.logger()), (Function0 & Serializable)() -> "Setting up Bleep through a JVM as requested", Formatter$.MODULE$.StringFormatter(), new Line(41), new sourcecode.File("/home/runner/work/bleep/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), new Enclosing("bleep.BleepExecutable.getCommand"));
            } else {
                LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(pre.logger()), (Function0 & Serializable)() -> new StringBuilder(79).append("There is no published graalvm native-image for ").append(osArch).append(". Setting up Bleep through a JVM").toString(), Formatter$.MODULE$.StringFormatter(), new Line(42), new sourcecode.File("/home/runner/work/bleep/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), new Enclosing("bleep.BleepExecutable.getCommand"));
            }
            Dep.ScalaDependency bleepCliDep = new Dep.ScalaDependency("build.bleep", "bleep-cli", latestRelease, false, Dep.ScalaDependency$.MODULE$.apply$default$5(), Dep.ScalaDependency$.MODULE$.apply$default$6(), Dep.ScalaDependency$.MODULE$.apply$default$7(), Dep.ScalaDependency$.MODULE$.apply$default$8(), Dep.ScalaDependency$.MODULE$.apply$default$9(), Dep.ScalaDependency$.MODULE$.apply$default$10(), Dep.ScalaDependency$.MODULE$.apply$default$11(), Dep.ScalaDependency$.MODULE$.apply$default$12());
            CoursierResolver.Result resolvedBleep = resolver.force((Set<Dep>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Dep[]{bleepCliDep}))), (VersionCombo)new VersionCombo.Jvm(VersionScala$.MODULE$.Scala213()), (SortedSet<LibraryVersionScheme>)((SortedSet)SortedSet$.MODULE$.empty((Object)LibraryVersionScheme$.MODULE$.ordering())), new StringBuilder(35).append("resolving bleep ").append(latestRelease).append(" from maven central").toString());
            return new BleepExecutable.DownloadedJava(((ResolvedJvm)pre.resolvedJvm().forceGet()).javaBin(), jvmRunCommand$.MODULE$.cmdArgs((List<String>)Nil$.MODULE$, resolvedBleep.jars(), MODULE$.BleepMain(), (List<String>)Nil$.MODULE$));
        });
    }

    public Option<BleepExecutable> findCurrentBleep(TypedLogger<BoxedUnit> logger) {
        ProcessHandle.Info currentInfo = ProcessHandle.current().info();
        Option ret = compat.OptionalCompatOps$.MODULE$.toScalaCompat$extension(compat$.MODULE$.OptionalCompatOps(currentInfo.command())).flatMap((Function1 & Serializable)commandString -> {
            Path path = Path.of(commandString, new String[0]).toAbsolutePath();
            if (!Files.exists(path, new LinkOption[0])) {
                return BleepExecutable$.complain$1(new StringBuilder(38).append("Obtained command ").append((String)commandString).append(" which does not exist").toString(), (Option)new Some((Object)currentInfo), logger);
            }
            if (((Object)path.getFileName()).toString().contains("java")) {
                RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
                String cp = mxBean.getClassPath();
                if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])cp.split(File.pathSeparator)), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("bleep-cli")))) {
                    List filteredArgs = compat.JavaListCompatOps$.MODULE$.toScalaCompat$extension(compat$.MODULE$.JavaListCompatOps(mxBean.getInputArguments())).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("-agentlib:"))).filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains("-javaagent:"))).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("-Duser.dir")));
                    List args = (List)filteredArgs.$plus$plus((IterableOnce)new .colon.colon((Object)"-cp", (List)new .colon.colon((Object)cp, (List)new .colon.colon((Object)MODULE$.BleepMain(), (List)Nil$.MODULE$))));
                    return new Some((Object)new BleepExecutable.CurrentJava(path, (List<String>)args));
                }
                return BleepExecutable$.complain$1("Obtained JVM class path which didn't include bleep-cli", BleepExecutable$.complain$default$2$1(), logger);
            }
            return new Some((Object)new BleepExecutable.CurrentBinary(path));
        });
        ret.foreach((Function1 & Serializable)cmd -> {
            LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger.withContext(new Text(((BleepExecutable)cmd).whole(), "cmd.whole"), Formatter$.MODULE$.IterableFormatter(Formatter$.MODULE$.StringFormatter()))), (Function0 & Serializable)() -> "Can run your current bleep with this command", Formatter$.MODULE$.StringFormatter(), new Line(101), new sourcecode.File("/home/runner/work/bleep/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), new Enclosing("bleep.BleepExecutable.findCurrentBleep"));
            return BoxedUnit.UNIT;
        });
        return ret;
    }

    private static final None$ complain$1(String msg, Option currentInfo, TypedLogger logger$1) {
        LoggerFn$Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(logger$1.withOptContext("processHandle.info", currentInfo.map((Function1 & Serializable)x$1 -> x$1.toString()), Formatter$.MODULE$.StringFormatter())), (Function0 & Serializable)() -> new StringBuilder(105).append("Problem while discovering how to run the bleep you started: ").append(msg).append(". Falling back to downloading latest release.").toString(), Formatter$.MODULE$.StringFormatter(), new Line(63), new sourcecode.File("/home/runner/work/bleep/bleep/bleep-core/src/scala/bleep/BleepExecutable.scala"), new Enclosing("bleep.BleepExecutable.findCurrentBleep complain"));
        return None$.MODULE$;
    }

    private static final Option complain$default$2$1() {
        return None$.MODULE$;
    }

    private BleepExecutable$() {
    }
}

