/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BleepConfig;
import bleep.BleepConfig$;
import bleep.BuildException;
import bleep.BuildException$;
import bleep.BuildLoader;
import bleep.BuildLoader$;
import bleep.BuildPaths;
import bleep.BuildPaths$;
import bleep.BuildPaths$Mode$Normal$;
import bleep.Commands;
import bleep.CoursierResolver;
import bleep.CoursierResolver$;
import bleep.ExplodedBuild;
import bleep.ExplodedBuild$;
import bleep.GenBloopFiles;
import bleep.GenBloopFiles$SyncToDisk$;
import bleep.LogPatterns;
import bleep.Prebootstrapped;
import bleep.Prebootstrapped$;
import bleep.RelPath;
import bleep.RelPath$;
import bleep.Rewrite;
import bleep.Started;
import bleep.internal.Lazy;
import bleep.internal.Os$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import bleep.logging.TypedLogger$;
import bleep.logging.TypedLogger$LoggerAuxSyntax$;
import bleep.model;
import bleep.package$;
import bloop.config.Config;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.SortedMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Text;

public final class bootstrap$ {
    public static final bootstrap$ MODULE$ = new bootstrap$();

    public void forScript(String scriptName, Function2<Started, Commands, BoxedUnit> f) {
        TypedLogger<BoxedUnit> logger = TypedLogger$LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(bleep.logging.package$.MODULE$.stdout(new LogPatterns.interface(Instant.now(), (Option<String>)new Some((Object)scriptName), false), bleep.logging.package$.MODULE$.stdout$default$2())));
        BuildLoader buildLoader = BuildLoader$.MODULE$.find(Os$.MODULE$.cwd());
        BuildPaths buildPaths = BuildPaths$.MODULE$.apply(Os$.MODULE$.cwd(), buildLoader, (BuildPaths.Mode)BuildPaths$Mode$Normal$.MODULE$);
        Either maybeStarted = buildLoader.existing().map((Function1 & Serializable)existingBuild -> {
            Prebootstrapped pre = Prebootstrapped$.MODULE$.apply(buildPaths, logger, (BuildLoader.Existing)existingBuild);
            return new Tuple2(existingBuild, (Object)pre);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Prebootstrapped pre = (Prebootstrapped)tuple2._2();
            Either either = MODULE$.from(pre, GenBloopFiles$SyncToDisk$.MODULE$, (List<Rewrite>)scala.package$.MODULE$.Nil(), BleepConfig$.MODULE$.lazyForceLoad(pre.userPaths())).map((Function1 & Serializable)started -> started);
            return either;
        });
        Either either = maybeStarted;
        if (either instanceof Left) {
            Left left = (Left)either;
            BuildException buildException = (BuildException)left.value();
            throw BuildException$.MODULE$.fatal("Couldn't initialize bleep", logger, buildException);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Started started = (Started)right.value();
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)started, (Object)new Commands(started)));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable th = failure.exception();
                throw BuildException$.MODULE$.fatal("failed :(", logger, th);
            }
            if (!(try_ instanceof Success)) {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Either<BuildException, Started> from(Prebootstrapped pre, GenBloopFiles genBloopFiles, List<Rewrite> rewrites, Lazy<BleepConfig> lazyConfig) {
        Left left;
        long t0 = System.currentTimeMillis();
        try {
            left = pre.build().forceGet().map((Function1 & Serializable)build -> {
                Lazy<CoursierResolver> lazyResolver = lazyConfig.map((Function1 & Serializable)bleepConfig -> CoursierResolver$.MODULE$.apply(build.resolvers().values(), pre.logger(), true, pre.userPaths().coursierCacheDir(), bleepConfig.authentications(), (Option<model.Version>)new Some((Object)new model.Version(build.$version()))));
                ExplodedBuild explodedBuild = (ExplodedBuild)rewrites.foldLeft((Object)ExplodedBuild$.MODULE$.of((model.Build)build), (Function2 & Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ExplodedBuild b = (ExplodedBuild)tuple2._1();
                    Rewrite patch = (Rewrite)tuple2._2();
                    ExplodedBuild explodedBuild = patch.apply(b);
                    return explodedBuild;
                });
                Path path = pre.buildPaths().cwd();
                Path path2 = pre.buildPaths().buildDir();
                List activeProjects = !(path != null ? !((Object)path).equals(path2) : path2 != null) ? explodedBuild.projects().keys().toList() : ((IterableOnceOps)explodedBuild.projects().flatMap((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    model.CrossProjectName crossProjectName = (model.CrossProjectName)tuple2._1();
                    model.Project p = (model.Project)tuple2._2();
                    Path folder = package$.MODULE$.PathOps(pre.buildPaths().buildDir()).$div((RelPath)p.folder().getOrElse((Function0 & Serializable)() -> RelPath$.MODULE$.force(crossProjectName.name())));
                    None$ none$ = folder.startsWith(pre.buildPaths().cwd()) ? new Some((Object)crossProjectName) : None$.MODULE$;
                    return none$;
                })).toList();
                SortedMap<model.CrossProjectName, Lazy<Config.File>> bloopFiles = genBloopFiles.apply(pre.logger(), pre.buildPaths(), lazyResolver, explodedBuild);
                long td = System.currentTimeMillis() - t0;
                LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(pre.logger()), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(19).append("bootstrapped in ").append(td).append(" ms").toString(), "s\"bootstrapped in $td ms\""), Formatter$.MODULE$.StringFormatter(), new Line(62), new File("/home/runner/work/bleep/bleep/bleep-core/src/main/scala/bleep/bootstrap.scala"), new Enclosing("bleep.bootstrap.from"));
                return new Started(pre, rewrites, explodedBuild, bloopFiles, (List<model.CrossProjectName>)activeProjects, lazyConfig, lazyResolver, (ExecutionContext)ExecutionContext$.MODULE$.global());
            });
        }
        catch (BuildException x) {
            left = scala.package$.MODULE$.Left().apply((Object)x);
        }
        catch (Throwable th) {
            left = scala.package$.MODULE$.Left().apply((Object)new BuildException.Cause(th, "couldn't initialize bleep"));
        }
        return left;
    }

    private bootstrap$() {
    }
}

