/*
 * Decompiled with CFR 0.152.
 */
package bleep.logging;

import bleep.logging.Pattern;
import bleep.logging.TypedLogger;
import bleep.logging.TypedLogger$ConsoleLogger$;
import bleep.logging.TypedLoggerResource;
import bleep.logging.TypedLoggerResource$;
import bleep.logging.jsonEvents;
import fansi.Str;
import java.io.BufferedWriter;
import java.io.Flushable;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.package$;

public final class Loggers$ {
    public static final Loggers$ MODULE$ = new Loggers$();
    private static final Map<String, Str> emptyContext = Predef$.MODULE$.Map().empty();

    public Map<String, Str> emptyContext() {
        return emptyContext;
    }

    public TypedLoggerResource<PrintStream> stdout(Pattern pattern, boolean disableProgress, Map<String, Str> ctx) {
        return TypedLoggerResource$.MODULE$.flushable((Function0 & Serializable)() -> new TypedLogger.ConsoleLogger<PrintStream>(System.out, pattern, ctx, (List<String>)package$.MODULE$.Nil(), disableProgress, TypedLogger$ConsoleLogger$.MODULE$.$lessinit$greater$default$6()));
    }

    public Map<String, Str> stdout$default$3() {
        return this.emptyContext();
    }

    public TypedLogger<PrintStream> stderr(Pattern pattern, Map<String, Str> ctx) {
        return new TypedLogger.ConsoleLogger<PrintStream>(System.err, pattern, ctx, (List<String>)package$.MODULE$.Nil(), true, TypedLogger$ConsoleLogger$.MODULE$.$lessinit$greater$default$6());
    }

    public Map<String, Str> stderr$default$2() {
        return this.emptyContext();
    }

    public TypedLoggerResource<BufferedWriter> path(Path logFile, Pattern pattern, Map<String, Str> ctx) {
        return TypedLoggerResource$.MODULE$.autoCloseable((Function0 & Serializable)() -> {
            Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(logFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return MODULE$.appendable(writer, pattern, ctx);
        });
    }

    public Map<String, Str> path$default$3() {
        return this.emptyContext();
    }

    public <A extends Appendable> TypedLogger<A> appendable(A appendable, Pattern pattern, Map<String, Str> ctx) {
        return new TypedLogger.AppendableLogger<A>(appendable, pattern, ctx, (List<String>)package$.MODULE$.Nil());
    }

    public <A extends Appendable> Map<String, Str> appendable$default$3() {
        return this.emptyContext();
    }

    public TypedLogger<StringWriter> stringWriter(Pattern pattern, Map<String, Str> ctx) {
        return this.appendable(new StringWriter(), pattern, ctx);
    }

    public Map<String, Str> stringWriter$default$2() {
        return this.emptyContext();
    }

    public TypedLogger<TypedLogger.Stored[]> storing(Map<String, Str> ctx) {
        return new TypedLogger.StoringLogger(new TypedLogger.Store(), ctx, (List<String>)package$.MODULE$.Nil());
    }

    public Map<String, Str> storing$default$1() {
        return this.emptyContext();
    }

    public <U extends Flushable & Appendable> TypedLogger<U> printJsonStream(U to, Map<String, Str> ctx) {
        return new jsonEvents.SerializeLogEvents<Appendable>(to, ctx, (List<String>)package$.MODULE$.Nil());
    }

    public <U extends Flushable & Appendable> Map<String, Str> printJsonStream$default$2() {
        return this.emptyContext();
    }

    public <U> TypedLogger<U> decodeJsonStream(TypedLogger<U> next) {
        return new jsonEvents.DeserializeLogEvents<U>(next);
    }

    private Loggers$() {
    }
}

