/*
 * Decompiled with CFR 0.152.
 */
package bleep.internal;

import bleep.logging.Formatter$;
import bleep.logging.LoggerFn$;
import bleep.logging.LoggerFn$Syntax$;
import bleep.logging.TypedLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.util.Properties$;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Text;

public final class FileUtils$ {
    public static final FileUtils$ MODULE$ = new FileUtils$();
    private static Path TempDir;
    private static Path cwd;
    private static volatile byte bitmap$0;

    private Path TempDir$lzycompute() {
        FileUtils$ fileUtils$ = this;
        synchronized (fileUtils$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                TempDir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return TempDir;
    }

    public Path TempDir() {
        return (byte)(bitmap$0 & 1) == 0 ? this.TempDir$lzycompute() : TempDir;
    }

    /*
     * WARNING - void declaration
     */
    private Path cwd$lzycompute() {
        FileUtils$ fileUtils$ = this;
        synchronized (fileUtils$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                void var2_2;
                Path base = Paths.get(System.getProperty("user.dir"), new String[0]);
                cwd = Properties$.MODULE$.isWin() ? base.toFile().getCanonicalFile().toPath() : var2_2;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return cwd;
    }

    public Path cwd() {
        return (byte)(bitmap$0 & 2) == 0 ? this.cwd$lzycompute() : cwd;
    }

    public void writeBytes(Path path, byte[] newContent) {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, newContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public void writeGzippedBytes(Path path, byte[] newContent) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        gos.write(newContent);
        gos.close();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, bos.toByteArray(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readGzippedBytes(Path path) {
        void var3_3;
        GZIPInputStream is = new GZIPInputStream((InputStream)new ByteArrayInputStream(Files.readAllBytes(path)), 1024);
        byte[] ret = is.readAllBytes();
        is.close();
        return var3_3;
    }

    public void writeString(TypedLogger<BoxedUnit> logger, Option<String> message, Path path, String newContent) {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        this.writeBytes(path, newContent.getBytes(StandardCharsets.UTF_8));
        Option<String> option = message;
        if (option instanceof Some) {
            Some some = (Some)option;
            String message2 = (String)some.value();
            LoggerFn$Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger.withContext(new Text((Object)path, "path"), Formatter$.MODULE$.PathFormatter())), (Function0 & Serializable)() -> new Text((Object)message2, "message"), Formatter$.MODULE$.StringFormatter(), new Line(51), new File("/home/runner/work/bleep/bleep/bleep-core/src/scala/bleep/internal/FileUtils.scala"), new Enclosing("bleep.internal.FileUtils.writeString"));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            LoggerFn$Syntax$.MODULE$.debug$extension(LoggerFn$.MODULE$.Syntax(logger.withContext(new Text((Object)path, "path"), Formatter$.MODULE$.PathFormatter())), (Function0 & Serializable)() -> new Text((Object)"wrote file", "\"wrote file\""), Formatter$.MODULE$.StringFormatter(), new Line(52), new File("/home/runner/work/bleep/bleep/bleep-core/src/scala/bleep/internal/FileUtils.scala"), new Enclosing("bleep.internal.FileUtils.writeString"));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void deleteDirectory(Path dir) {
        block0: {
            if (!this.exists(dir)) break block0;
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public boolean exists(Path path) {
        return path.toFile().exists();
    }

    private FileUtils$() {
    }
}

