/*
 * Decompiled with CFR 0.152.
 */
package bleep.commands;

import bleep.BleepCommand;
import bleep.BleepException;
import bleep.BuildPaths;
import bleep.FetchJvm;
import bleep.FileSync;
import bleep.FileSync$;
import bleep.RelPath$;
import bleep.ResolvedJvm;
import bleep.commands.Import$;
import bleep.logging.TypedLogger;
import bleep.model.BleepVersion;
import bleep.model.BleepVersion$;
import bleep.model.BuildFile;
import bleep.model.Jvm$;
import bleep.model.Replacements;
import bleep.sbtimport.ImportInputData;
import bleep.sbtimport.ImportInputData$;
import bleep.sbtimport.ImportOptions;
import bleep.sbtimport.generateBuild$;
import bleep.sbtimport.runSbt$;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public class Import
implements BleepCommand,
Product,
Serializable {
    private final Option existingBuild;
    private final Path sbtBuildDir;
    private final FetchJvm fetchJvm;
    private final BuildPaths destinationPaths;
    private final TypedLogger logger;
    private final ImportOptions options;
    private final String bleepVersion;

    public static Import apply(Option<BuildFile> option, Path path, FetchJvm fetchJvm, BuildPaths buildPaths, TypedLogger<BoxedUnit> typedLogger, ImportOptions importOptions, String string) {
        return Import$.MODULE$.apply(option, path, fetchJvm, buildPaths, typedLogger, importOptions, string);
    }

    public static Import fromProduct(Product product) {
        return Import$.MODULE$.fromProduct(product);
    }

    public static Import unapply(Import import_) {
        return Import$.MODULE$.unapply(import_);
    }

    public Import(Option<BuildFile> existingBuild, Path sbtBuildDir, FetchJvm fetchJvm, BuildPaths destinationPaths, TypedLogger<BoxedUnit> logger, ImportOptions options, String bleepVersion) {
        this.existingBuild = existingBuild;
        this.sbtBuildDir = sbtBuildDir;
        this.fetchJvm = fetchJvm;
        this.destinationPaths = destinationPaths;
        this.logger = logger;
        this.options = options;
        this.bleepVersion = bleepVersion;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Import)) return false;
        Import import_ = (Import)object;
        Option<BuildFile> option = this.existingBuild();
        Option<BuildFile> option2 = import_.existingBuild();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Path path = this.sbtBuildDir();
        Path path2 = import_.sbtBuildDir();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        FetchJvm fetchJvm = this.fetchJvm();
        FetchJvm fetchJvm2 = import_.fetchJvm();
        if (fetchJvm == null) {
            if (fetchJvm2 != null) {
                return false;
            }
        } else if (!fetchJvm.equals(fetchJvm2)) return false;
        BuildPaths buildPaths = this.destinationPaths();
        BuildPaths buildPaths2 = import_.destinationPaths();
        if (buildPaths == null) {
            if (buildPaths2 != null) {
                return false;
            }
        } else if (!buildPaths.equals(buildPaths2)) return false;
        TypedLogger<BoxedUnit> typedLogger = this.logger();
        TypedLogger<BoxedUnit> typedLogger2 = import_.logger();
        if (typedLogger == null) {
            if (typedLogger2 != null) {
                return false;
            }
        } else if (!typedLogger.equals(typedLogger2)) return false;
        ImportOptions importOptions = this.options();
        ImportOptions importOptions2 = import_.options();
        if (importOptions == null) {
            if (importOptions2 != null) {
                return false;
            }
        } else if (!((Object)importOptions).equals(importOptions2)) return false;
        String string = this.bleepVersion();
        String string2 = import_.bleepVersion();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!import_.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Import;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "Import";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return new BleepVersion(this._7());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "existingBuild";
            }
            case 1: {
                return "sbtBuildDir";
            }
            case 2: {
                return "fetchJvm";
            }
            case 3: {
                return "destinationPaths";
            }
            case 4: {
                return "logger";
            }
            case 5: {
                return "options";
            }
            case 6: {
                return "bleepVersion";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<BuildFile> existingBuild() {
        return this.existingBuild;
    }

    public Path sbtBuildDir() {
        return this.sbtBuildDir;
    }

    public FetchJvm fetchJvm() {
        return this.fetchJvm;
    }

    public BuildPaths destinationPaths() {
        return this.destinationPaths;
    }

    public TypedLogger<BoxedUnit> logger() {
        return this.logger;
    }

    public ImportOptions options() {
        return this.options;
    }

    public String bleepVersion() {
        return this.bleepVersion;
    }

    public Either<BleepException, BoxedUnit> run() {
        if (!this.options().skipSbt()) {
            ResolvedJvm resolvedJvm = this.fetchJvm().apply(Jvm$.MODULE$.system());
            runSbt$.MODULE$.apply(this.logger(), this.sbtBuildDir(), this.destinationPaths(), resolvedJvm);
        }
        ImportInputData inputData = ImportInputData$.MODULE$.collectFromFileSystem(this.destinationPaths());
        Map generatedBuildFiles = (Map)generateBuild$.MODULE$.apply(this.sbtBuildDir(), this.destinationPaths(), this.logger(), this.options(), this.bleepVersion(), inputData, BleepVersion$.MODULE$.apply(Replacements.known$.MODULE$.BleepVersion()), this.existingBuild()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                String content = (String)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)RelPath$.MODULE$.relativeTo(this.destinationPaths().buildDir(), path), (Object)content);
            }
            throw new MatchError((Object)tuple2);
        });
        FileSync.Synced$.SyncedOps$.MODULE$.log$extension(FileSync.Synced$.MODULE$.SyncedOps(FileSync$.MODULE$.syncStrings(this.destinationPaths().buildDir(), generatedBuildFiles, (FileSync.DeleteUnknowns)FileSync.DeleteUnknowns$.No$.MODULE$, false)), this.logger(), "Wrote build files", Line$.MODULE$.apply(40), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/commands/Import.scala"), Enclosing$.MODULE$.apply("bleep.commands.Import#run"));
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public Import copy(Option<BuildFile> existingBuild, Path sbtBuildDir, FetchJvm fetchJvm, BuildPaths destinationPaths, TypedLogger<BoxedUnit> logger, ImportOptions options, String bleepVersion) {
        return new Import(existingBuild, sbtBuildDir, fetchJvm, destinationPaths, logger, options, bleepVersion);
    }

    public Option<BuildFile> copy$default$1() {
        return this.existingBuild();
    }

    public Path copy$default$2() {
        return this.sbtBuildDir();
    }

    public FetchJvm copy$default$3() {
        return this.fetchJvm();
    }

    public BuildPaths copy$default$4() {
        return this.destinationPaths();
    }

    public TypedLogger<BoxedUnit> copy$default$5() {
        return this.logger();
    }

    public ImportOptions copy$default$6() {
        return this.options();
    }

    public String copy$default$7() {
        return this.bleepVersion();
    }

    public Option<BuildFile> _1() {
        return this.existingBuild();
    }

    public Path _2() {
        return this.sbtBuildDir();
    }

    public FetchJvm _3() {
        return this.fetchJvm();
    }

    public BuildPaths _4() {
        return this.destinationPaths();
    }

    public TypedLogger<BoxedUnit> _5() {
        return this.logger();
    }

    public ImportOptions _6() {
        return this.options();
    }

    public String _7() {
        return this.bleepVersion();
    }
}

