/*
 * Decompiled with CFR 0.152.
 */
package bleep.commands;

import bleep.BleepBuildCommand;
import bleep.BleepException;
import bleep.ProjectPaths;
import bleep.Started;
import bleep.commands.BuildCreateDirectories$;
import bleep.internal.FileUtils$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.model.CrossProjectName;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;

public class BuildCreateDirectories
implements BleepBuildCommand,
Product,
Serializable {
    private final CrossProjectName[] projects;

    public static BuildCreateDirectories apply(CrossProjectName[] crossProjectNameArray) {
        return BuildCreateDirectories$.MODULE$.apply(crossProjectNameArray);
    }

    public static BuildCreateDirectories fromProduct(Product product) {
        return BuildCreateDirectories$.MODULE$.fromProduct(product);
    }

    public static BuildCreateDirectories unapply(BuildCreateDirectories buildCreateDirectories) {
        return BuildCreateDirectories$.MODULE$.unapply(buildCreateDirectories);
    }

    public BuildCreateDirectories(CrossProjectName[] projects) {
        this.projects = projects;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BuildCreateDirectories)) return false;
        BuildCreateDirectories buildCreateDirectories = (BuildCreateDirectories)object;
        if (this.projects() != buildCreateDirectories.projects()) return false;
        if (!buildCreateDirectories.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BuildCreateDirectories;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "BuildCreateDirectories";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "projects";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CrossProjectName[] projects() {
        return this.projects;
    }

    public Either<BleepException, BoxedUnit> run(Started started) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.projects());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)crossName -> {
            ProjectPaths paths = started.projectPaths(crossName);
            List dirs = (List)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{paths.sourcesDirs().fromSourceLayout(), paths.sourcesDirs().fromJson().values(), paths.resourcesDirs().fromSourceLayout(), paths.resourcesDirs().fromJson().values()}))).flatten(Predef$.MODULE$.$conforms());
            return dirs.map((Function1 & Serializable)dir -> Tuple2$.MODULE$.apply(dir, crossName));
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        Map dirsWithProject = (Map)ArrayOps$.MODULE$.groupBy$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path dir = (Path)tuple2._1();
                return dir;
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Path dir = (Path)tuple2._1();
                Object[] tuples = (Tuple2[])tuple2._2();
                Object object = Predef$.MODULE$.refArrayOps(tuples);
                return Tuple2$.MODULE$.apply((Object)dir, ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        CrossProjectName crossName = (CrossProjectName)tuple2._2();
                        return crossName;
                    }
                    throw new MatchError((Object)tuple2);
                }, ClassTag$.MODULE$.apply(CrossProjectName.class)));
            }
            throw new MatchError((Object)tuple2);
        });
        dirsWithProject.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path dir = (Path)tuple2._1();
                CrossProjectName[] crossNames = (CrossProjectName[])tuple2._2();
                TypedLogger logger = started.logger().withContext("for projects", (Object)crossNames, Formatter$.MODULE$.ArrayFormatter(Formatter$.MODULE$.formatsCrossProjectName()));
                if (FileUtils$.MODULE$.exists(dir)) {
                    LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger), () -> BuildCreateDirectories.run$$anonfun$1$$anonfun$1(dir), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(30), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/commands/BuildCreateDirectories.scala"), Enclosing$.MODULE$.apply("bleep.commands.BuildCreateDirectories#run"));
                    return;
                }
                Files.createDirectories(dir, new FileAttribute[0]);
                LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger), () -> BuildCreateDirectories.run$$anonfun$1$$anonfun$2(dir), Formatter$.MODULE$.StringFormatter(), Line$.MODULE$.apply(33), File$.MODULE$.apply("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/commands/BuildCreateDirectories.scala"), Enclosing$.MODULE$.apply("bleep.commands.BuildCreateDirectories#run"));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public BuildCreateDirectories copy(CrossProjectName[] projects) {
        return new BuildCreateDirectories(projects);
    }

    public CrossProjectName[] copy$default$1() {
        return this.projects();
    }

    public CrossProjectName[] _1() {
        return this.projects();
    }

    private static final String run$$anonfun$1$$anonfun$1(Path dir$1) {
        return new StringBuilder(16).append("Already exists: ").append(dir$1).toString();
    }

    private static final String run$$anonfun$1$$anonfun$2(Path dir$2) {
        return new StringBuilder(8).append("Created ").append(dir$2).toString();
    }
}

