/*
 * Decompiled with CFR 0.152.
 */
package bleep.internal;

import bleep.BuildException;
import bleep.BuildPaths;
import bleep.Dep;
import bleep.Dep$;
import bleep.ExplodedBuild;
import bleep.JsonList;
import bleep.JsonList$;
import bleep.JsonMap;
import bleep.JsonMap$;
import bleep.JsonSet;
import bleep.JsonSet$;
import bleep.Options;
import bleep.Options$;
import bleep.RelPath;
import bleep.RelPath$;
import bleep.SourceLayout;
import bleep.SourceLayout$;
import bleep.Versions;
import bleep.Versions$;
import bleep.constants$;
import bleep.internal.ReadSbtExportFile;
import bleep.internal.Replacements;
import bleep.internal.Replacements$;
import bleep.internal.ScalaVersions;
import bleep.internal.ScalaVersions$;
import bleep.internal.findOriginalTargetDir$;
import bleep.internal.importBloopFilesFromSbt;
import bleep.internal.importBloopFilesFromSbt$ProjectType$;
import bleep.internal.importBloopFilesFromSbt$ProjectType$It$;
import bleep.internal.importModuleId$;
import bleep.logging.Formatter$;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.TypedLogger;
import bleep.model;
import bleep.package$;
import bloop.config.Config;
import coursier.core.Configuration$;
import coursier.core.Publication;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import sbt.librarymanagement.ModuleID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Text;

public final class importBloopFilesFromSbt$ {
    public static final importBloopFilesFromSbt$ MODULE$ = new importBloopFilesFromSbt$();
    private static final Set<String> includedTestFramework = Config.Test$.MODULE$.defaultConfiguration().frameworks().flatMap((Function1 & Serializable)x$1 -> x$1.names()).toSet();
    private static final Set<String> Suffixes;
    private static final Set<String> crossProjectDirNames;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        Suffixes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"JS", "JVM", "Native", "3", "2_13", "2_12", "2_11"}));
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        crossProjectDirNames = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"jvm", "js", "native"}))).flatMap((Function1 & Serializable)str -> (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{str, new StringBuilder(1).append(".").append((String)str).toString()})));
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    public Set<String> includedTestFramework() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/bleep/bleep/bleep-cli/src/main/scala/bleep/internal/importBloopFilesFromSbt.scala: 14");
        }
        return includedTestFramework;
    }

    public Set<String> Suffixes() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/bleep/bleep/bleep-cli/src/main/scala/bleep/internal/importBloopFilesFromSbt.scala: 18");
        }
        return Suffixes;
    }

    public Set<String> crossProjectDirNames() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/bleep/bleep/bleep-cli/src/main/scala/bleep/internal/importBloopFilesFromSbt.scala: 21");
        }
        return crossProjectDirNames;
    }

    public String projectName(String name) {
        ObjectRef ret = ObjectRef.create((Object)name);
        boolean isTest = false;
        if (((String)ret.elem).endsWith("-test")) {
            ret.elem = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString((String)ret.elem), "-test".length());
            isTest = true;
        }
        boolean isIt = false;
        if (((String)ret.elem).endsWith("-it")) {
            ret.elem = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString((String)ret.elem), "-it".length());
            isIt = true;
        }
        BooleanRef booleanRef = BooleanRef.create((boolean)true);
        while (booleanRef.elem) {
            booleanRef.elem = false;
            this.Suffixes().foreach((Function1 & Serializable)s -> {
                importBloopFilesFromSbt$.$anonfun$projectName$1(ret, booleanRef, s);
                return BoxedUnit.UNIT;
            });
        }
        return isTest ? new StringBuilder(5).append((String)ret.elem).append("-test").toString() : (isIt ? new StringBuilder(3).append((String)ret.elem).append("-it").toString() : (String)ret.elem);
    }

    public <In, Out> Function1<In, Out> cachedFn(Function1<In, Out> f) {
        Map cache = (Map)Map$.MODULE$.empty();
        return (Function1 & Serializable)in -> cache.getOrElseUpdate(in, (Function0 & Serializable)() -> f.apply(in));
    }

    public scala.collection.immutable.Map<model.CrossProjectName, Config.File> projectsWithSourceFilesByName(Iterable<Config.File> bloopFiles) {
        Function1 hasSources = this.cachedFn((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$projectsWithSourceFilesByName$1(path)));
        return (scala.collection.immutable.Map)((IterableOps)bloopFiles.filter((Function1 & Serializable)bloopFile -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$projectsWithSourceFilesByName$3(hasSources, bloopFile)))).groupBy((Function1 & Serializable)file -> new model.ProjectName(importBloopFilesFromSbt$.MODULE$.projectName(file.project().name()))).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = ((model.ProjectName)tuple2._1()).value();
                Iterable one = (Iterable)tuple2._2();
                if (one.size() == 1) {
                    return (IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new model.CrossProjectName(name, (Option)None$.MODULE$), one.head())}));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String name = ((model.ProjectName)tuple2._1()).value();
            Iterable files = (Iterable)tuple2._2();
            return (IterableOnce)files.map((Function1 & Serializable)file -> {
                Option maybeCrossId = model.CrossId$.MODULE$.defaultFrom(file.project().scala().map((Function1 & Serializable)s -> new Versions.Scala(s.version())), file.project().platform().flatMap((Function1 & Serializable)p -> model.PlatformId$.MODULE$.fromName(p.name())));
                return new Tuple2((Object)new model.CrossProjectName(name, maybeCrossId), file);
            });
        });
    }

    public ExplodedBuild apply(TypedLogger<BoxedUnit> logger, Path sbtBuildDir, BuildPaths destinationPaths, scala.collection.immutable.Map<model.CrossProjectName, Config.File> crossBloopProjectFiles, Iterable<ReadSbtExportFile.ExportedProject> sbtExportFiles, String bleepVersion) {
        Set projectNames = ((IterableOnceOps)crossBloopProjectFiles.keys().map((Function1 & Serializable)x$2 -> new model.ProjectName(x$2.name()))).toSet();
        scala.collection.immutable.Map projects = (scala.collection.immutable.Map)crossBloopProjectFiles.map(arg_0 -> importBloopFilesFromSbt$.$anonfun$apply$2(this, sbtExportFiles, sbtBuildDir, destinationPaths, projectNames, logger, arg_0));
        JsonList buildResolvers = new JsonList(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])crossBloopProjectFiles.toArray(ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Config.File bloopFile = (Config.File)tuple2._2();
            Option option = bloopFile.project().resolution();
            return option;
        }, ClassTag$.MODULE$.apply(Config.Resolution.class))), (Function1 & Serializable)x$14 -> x$14.modules(), ClassTag$.MODULE$.apply(Config.Module.class))))), (Function1 & Serializable)mod -> MODULE$.resolverUsedFor((Config.Module)mod), ClassTag$.MODULE$.apply(model.Repository.class))), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$apply$31(elem)))))).toList());
        model.Build qual$1 = model.Build$.MODULE$.empty(bleepVersion);
        JsonList x$15 = buildResolvers;
        String x$16 = qual$1.copy$default$1();
        String x$17 = qual$1.copy$default$2();
        JsonMap x$18 = qual$1.copy$default$3();
        JsonMap x$19 = qual$1.copy$default$4();
        JsonMap x$20 = qual$1.copy$default$6();
        Option x$21 = qual$1.copy$default$7();
        return new ExplodedBuild(qual$1.copy(x$16, x$17, x$18, x$19, x$15, x$20, x$21), Predef$.MODULE$.Map().empty(), projects);
    }

    public Tuple2<Seq<Dep>, Seq<Dep>> importDeps(TypedLogger<BoxedUnit> logger, importBloopFilesFromSbt.ProjectType projectType, ReadSbtExportFile.ExportedProject sbtExportFile, model.CrossProjectName crossName, Option<model.PlatformId> platformName, Seq<Dep> providedDeps) {
        Set providedDepReprs = ((IterableOnceOps)providedDeps.map((Function1 & Serializable)x$15 -> x$15.repr())).toSet();
        TypedLogger ctxLogger = logger.withContext(new Text((Object)crossName, "crossName"), model.CrossProjectName$.MODULE$.formats());
        Seq all = (Seq)sbtExportFile.dependencies().flatMap((Function1 & Serializable)moduleId -> {
            boolean bl = false;
            Right right = null;
            Either<String, Dep> either = importModuleId$.MODULE$.apply((TypedLogger<BoxedUnit>)ctxLogger, (ModuleID)moduleId, platformName);
            if (either instanceof Left) {
                Left left = (Left)either;
                String err = (String)left.value();
                LoggerFn.Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)ctxLogger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(47).append("Couldn't import dependency ").append(moduleId).append(". Dropping. Reason: ").append(err).toString(), "s\"Couldn't import dependency $moduleId. Dropping. Reason: $err\""), Formatter$.MODULE$.StringFormatter(), new Line(277), new File("/home/runner/work/bleep/bleep/bleep-cli/src/main/scala/bleep/internal/importBloopFilesFromSbt.scala"), new Enclosing("bleep.internal.importBloopFilesFromSbt.importDeps all"));
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                Dep dep = (Dep)right.value();
                if (providedDepReprs.apply((Object)dep.repr())) {
                    return None$.MODULE$;
                }
            }
            if (!bl) throw new MatchError(either);
            Dep dep = (Dep)right.value();
            return new Some((Object)dep);
        });
        String CompilerPluginConfig = "plugin->default(compile)";
        Seq plugins = (Seq)all.collect((PartialFunction)new Serializable(CompilerPluginConfig){
            private static final long serialVersionUID = 0L;
            private final String CompilerPluginConfig$1;

            public final <A1 extends Dep, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                String string = A1.configuration();
                String string2 = this.CompilerPluginConfig$1;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Dep.JavaDependency javaDependency;
                    Dep dep = A1.withConfiguration(Configuration$.MODULE$.empty());
                    if (dep instanceof Dep.JavaDependency) {
                        Dep.JavaDependency javaDependency2;
                        javaDependency = javaDependency2 = (Dep.JavaDependency)dep;
                    } else if (dep instanceof Dep.ScalaDependency) {
                        Dep.ScalaDependency scalaDependency = (Dep.ScalaDependency)dep;
                        boolean x$1 = false;
                        String x$2 = scalaDependency.copy$default$1();
                        String x$3 = scalaDependency.copy$default$2();
                        String x$4 = scalaDependency.copy$default$3();
                        boolean x$5 = scalaDependency.copy$default$4();
                        boolean x$6 = scalaDependency.copy$default$6();
                        boolean x$7 = scalaDependency.copy$default$7();
                        scala.collection.immutable.Map x$8 = scalaDependency.copy$default$8();
                        String x$9 = scalaDependency.copy$default$9();
                        JsonMap x$10 = scalaDependency.copy$default$10();
                        Publication x$11 = scalaDependency.copy$default$11();
                        boolean x$12 = scalaDependency.copy$default$12();
                        javaDependency = scalaDependency.copy(x$2, x$3, x$4, x$5, false, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
                    } else {
                        throw new MatchError((Object)dep);
                    }
                    object = javaDependency;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Dep x1) {
                Dep dep = x1;
                String string = dep.configuration();
                String string2 = this.CompilerPluginConfig$1;
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                return bl;
            }
            {
                this.CompilerPluginConfig$1 = CompilerPluginConfig$1;
            }
        });
        String ItConf = "it";
        Seq rewritten = (Seq)all.flatMap((Function1 & Serializable)dep -> {
            None$ none$;
            String string = dep.configuration();
            String string2 = CompilerPluginConfig;
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                none$ = None$.MODULE$;
            } else {
                String string4 = Configuration$.MODULE$.empty();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    none$ = projectType.testLike() ? None$.MODULE$ : new Some(dep);
                } else {
                    boolean bl;
                    String string6 = Configuration$.MODULE$.optional();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        bl = true;
                    } else {
                        String string8 = Configuration$.MODULE$.provided();
                        String string9 = string;
                        bl = !(string8 != null ? !string8.equals(string9) : string9 != null);
                    }
                    if (bl) {
                        none$ = new Some(dep);
                    } else {
                        String string10 = Configuration$.MODULE$.runtime();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            none$ = new Some((Object)dep.withConfiguration(Configuration$.MODULE$.empty()));
                        } else {
                            String string12 = Configuration$.MODULE$.test();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                none$ = projectType.testLike() ? new Some((Object)dep.withConfiguration(Configuration$.MODULE$.empty())) : None$.MODULE$;
                            } else {
                                String string14 = ItConf;
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    importBloopFilesFromSbt.ProjectType projectType = projectType;
                                    importBloopFilesFromSbt$ProjectType$It$ importBloopFilesFromSbt$ProjectType$It$2 = importBloopFilesFromSbt$ProjectType$It$.MODULE$;
                                    none$ = !(projectType != null ? !projectType.equals(importBloopFilesFromSbt$ProjectType$It$2) : importBloopFilesFromSbt$ProjectType$It$2 != null) ? new Some((Object)dep.withConfiguration(Configuration$.MODULE$.empty())) : None$.MODULE$;
                                } else {
                                    String scalaTool = string;
                                    if (scalaTool.startsWith("scala-tool->") || scalaTool.startsWith("scala-doc-tool->")) {
                                        none$ = None$.MODULE$;
                                    } else {
                                        String other = string;
                                        LoggerFn.Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)ctxLogger), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(43).append("dropping because unknown configuration '").append(other).append("': ").append(dep).toString(), "s\"dropping because unknown configuration '$other': $dep\""), Formatter$.MODULE$.StringFormatter(), new Line(329), new File("/home/runner/work/bleep/bleep/bleep-cli/src/main/scala/bleep/internal/importBloopFilesFromSbt.scala"), new Enclosing("bleep.internal.importBloopFilesFromSbt.importDeps rewritten"));
                                        none$ = None$.MODULE$;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return none$;
        });
        return new Tuple2((Object)plugins, (Object)rewritten);
    }

    public Option<model.Repository> resolverUsedFor(Config.Module mod) {
        None$ none$;
        Path https = Path.of("https", new String[0]);
        Path jars = Path.of("jars", new String[0]);
        List allAfterHttps = (List)((StrictOptimizedLinearSeqOps)CollectionConverters$.MODULE$.IteratorHasAsScala(((Config.Artifact)mod.artifacts().head()).path().iterator()).asScala().toList().dropWhile((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$resolverUsedFor$1(https, x$16)))).drop(1);
        if (allAfterHttps.isEmpty()) {
            none$ = None$.MODULE$;
        } else if (allAfterHttps.contains((Object)jars)) {
            Path fullOrg = Path.of(mod.organization(), new String[0]);
            URI uri = URI.create(allAfterHttps.takeWhile((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$resolverUsedFor$2(fullOrg, x$17))).map((Function1 & Serializable)x$18 -> ((Object)x$18).toString()).mkString("https://", "/", "/"));
            none$ = new Some((Object)new model.Repository$.Ivy((Option)None$.MODULE$, uri));
        } else {
            Path initialOrg = Path.of((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])mod.organization().split("\\."))), new String[0]);
            URI uri = URI.create(allAfterHttps.takeWhile((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$resolverUsedFor$4(initialOrg, x$19))).map((Function1 & Serializable)x$20 -> ((Object)x$20).toString()).mkString("https://", "/", ""));
            none$ = new Some((Object)new model.Repository$.Maven((Option)None$.MODULE$, uri));
        }
        return none$;
    }

    public model.Java translateJava(Replacements templateDirs, Config.Java java) {
        return new model.Java(Options$.MODULE$.parse(java.options(), (Option)new Some((Object)templateDirs)));
    }

    public model.Platform translatePlatform(Config.Platform platform, Replacements templateDirs, Option<Config.Resolution> resolution) {
        model.Platform platform2;
        Config.Platform platform3 = platform;
        if (platform3 instanceof Config.Platform$.Js) {
            model.Platform translatedPlatform;
            Config.Platform$.Js js = (Config.Platform$.Js)platform3;
            Config.JsConfig config = js.config();
            Option mainClass = js.mainClass();
            Versions.ScalaJs jsVersion = (Versions.ScalaJs)resolution.flatMap((Function1 & Serializable)x$21 -> x$21.modules().find((Function1 & Serializable)mod -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$translatePlatform$2(mod)))).map((Function1 & Serializable)mod -> new Versions.ScalaJs(mod.version())).getOrElse((Function0 & Serializable)() -> {
                throw new BuildException.Text("Couldn't find scalajs-library jar to determine version");
            });
            platform2 = translatedPlatform = model.Platform$.Js$.MODULE$.apply(jsVersion, (Option)new Some((Object)config.mode()), (Option)new Some((Object)config.kind()), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.emitSourceMaps())), config.jsdom(), mainClass);
        } else if (platform3 instanceof Config.Platform$.Jvm) {
            model.Platform translatedPlatform;
            Config.Platform$.Jvm jvm = (Config.Platform$.Jvm)platform3;
            Config.JvmConfig config = jvm.config();
            Option mainClass = jvm.mainClass();
            Option runtimeConfig = jvm.runtimeConfig();
            platform2 = translatedPlatform = model.Platform$.Jvm$.MODULE$.apply(Options$.MODULE$.parse(config.options(), (Option)new Some((Object)templateDirs)), mainClass, (Options)runtimeConfig.map((Function1 & Serializable)rc -> Options$.MODULE$.parse(rc.options(), (Option)new Some((Object)templateDirs))).getOrElse((Function0 & Serializable)() -> Options$.MODULE$.empty()));
        } else if (platform3 instanceof Config.Platform$.Native) {
            model.Platform translatedPlatform;
            Config.Platform$.Native native_ = (Config.Platform$.Native)platform3;
            Config.NativeConfig config = native_.config();
            Option mainClass = native_.mainClass();
            platform2 = translatedPlatform = model.Platform$.Native$.MODULE$.apply((Option)new Some((Object)new Versions.ScalaNative(config.version())), (Option)new Some((Object)config.mode()), (Option)new Some((Object)config.gc()), mainClass);
        } else {
            throw new MatchError((Object)platform3);
        }
        return platform2;
    }

    public model.Scala translateScala(Seq<Dep> compilerPlugins, Replacements replacementsDirs, Replacements replacementsVersions, ScalaVersions scalaVersions, Config.Scala s) {
        Options options = Options$.MODULE$.parse(s.options(), (Option)new Some((Object)replacementsDirs));
        Set notCompilerPlugins = (Set)options.values().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$translateScala$1(x0$1)));
        Seq filteredCompilerPlugins = (Seq)Option$.MODULE$.option2Iterable(scalaVersions.compilerPlugin()).foldLeft(compilerPlugins, (Function2 & Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq all = (Seq)tuple2._1();
            Dep fromPlatform = (Dep)tuple2._2();
            Seq seq = (Seq)all.filterNot((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$translateScala$3(fromPlatform, x$22)));
            return seq;
        });
        return new model.Scala((Option)new Some((Object)new Versions.Scala(s.version())), replacementsVersions.templatize().opts(new Options(notCompilerPlugins)), s.setup().map((Function1 & Serializable)setup -> new model.CompileSetup((Option)new Some((Object)setup.order()), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)setup.addLibraryToBootClasspath())), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)setup.addCompilerToClasspath())), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)setup.addExtraJarsToClasspath())), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)setup.manageBootClasspath())), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)setup.filterLibraryFromClasspath())))), JsonSet$.MODULE$.fromIterable((Iterable)filteredCompilerPlugins, Dep$.MODULE$.ordering()));
    }

    public static final /* synthetic */ void $anonfun$projectName$1(ObjectRef ret$1, BooleanRef continue$1, String s) {
        block0: {
            if (!((String)ret$1.elem).endsWith(s)) break block0;
            continue$1.elem = true;
            ret$1.elem = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString((String)ret$1.elem), s.length());
        }
    }

    private static final boolean isSource$1(Path path) {
        String string = ((Object)path).toString();
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        boolean bl = string.endsWith(".scala") ? true : string.endsWith(".java");
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$projectsWithSourceFilesByName$1(Path path2) {
        return Files.exists(path2, new LinkOption[0]) && Files.walk(path2, new FileVisitOption[0]).filter(path -> importBloopFilesFromSbt$.isSource$1(path)).findFirst().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$projectsWithSourceFilesByName$4(Function1 hasSources$1, Path v1) {
        return BoxesRunTime.unboxToBoolean((Object)hasSources$1.apply((Object)v1));
    }

    public static final /* synthetic */ boolean $anonfun$projectsWithSourceFilesByName$3(Function1 hasSources$1, Config.File bloopFile) {
        return bloopFile.project().sources().exists((Function1 & Serializable)v1 -> BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$projectsWithSourceFilesByName$4(hasSources$1, v1)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Config.Project bloopProject$1, ReadSbtExportFile.ExportedProject f) {
        String string = f.bloopName();
        String string2 = bloopProject$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null) && bloopProject$1.scala().map((Function1 & Serializable)x$3 -> x$3.version()).contains((Object)f.scalaVersion().full());
    }

    public static final /* synthetic */ Nothing$ $anonfun$apply$5(Config.Project bloopProject$1) {
        return scala.sys.package$.MODULE$.error(new StringBuilder(43).append("Expected to find a sbt dependency file for ").append(bloopProject$1.name()).toString());
    }

    private final Option aboveSrc$1(Path p, Path src$1) {
        None$ none$;
        while (true) {
            if (p == null) {
                none$ = None$.MODULE$;
                break;
            }
            Path path = p.getFileName();
            Path path2 = src$1;
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                none$ = new Some((Object)p.getParent());
                break;
            }
            p = p.getParent();
        }
        return none$;
    }

    public static final /* synthetic */ int $anonfun$apply$8(Tuple2 x$4) {
        return ((List)x$4._2()).length();
    }

    private final Path inferDirectory$1(List sources) {
        Path src = Paths.get("src", new String[0]);
        return (Path)((Tuple2)sources.flatMap((Function1 & Serializable)p -> this.aboveSrc$1((Path)p, src)).groupBy((Function1 & Serializable)x -> (Path)Predef$.MODULE$.identity(x)).maxBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)importBloopFilesFromSbt$.$anonfun$apply$8(x$4)), (Ordering)Ordering.Int$.MODULE$))._1();
    }

    public static final /* synthetic */ Versions.Scala $anonfun$apply$10(Config.Scala s) {
        return new Versions.Scala(s.version());
    }

    public static final /* synthetic */ String $anonfun$apply$11(Config.Platform x$5) {
        return x$5.name();
    }

    public static final /* synthetic */ model.Platform $anonfun$apply$12(Replacements replacements$1, Config.Project bloopProject$1, Config.Platform x$6) {
        return MODULE$.translatePlatform(x$6, replacements$1, (Option<Config.Resolution>)bloopProject$1.resolution());
    }

    public static final /* synthetic */ RelPath $anonfun$apply$14(Path directory$1, Path absoluteDir) {
        return RelPath$.MODULE$.relativeTo(directory$1, absoluteDir);
    }

    public static final /* synthetic */ Nil$ $anonfun$apply$15() {
        return scala.package$.MODULE$.Nil();
    }

    public static final /* synthetic */ RelPath $anonfun$apply$17(Path directory$1, Path absoluteDir) {
        return RelPath$.MODULE$.relativeTo(directory$1, absoluteDir);
    }

    public static final /* synthetic */ Option $anonfun$apply$18(model.Platform x$9) {
        return x$9.name();
    }

    public static final /* synthetic */ Tuple2 $anonfun$apply$19(Option scalaVersion$1, Option maybePlatformId$1, importBloopFilesFromSbt.ProjectType projectType$1, JsonSet sourcesRelPaths$1, SourceLayout layout) {
        JsonSet fromLayout = layout.sources(scalaVersion$1, maybePlatformId$1, (Option)new Some((Object)projectType$1.sbtScope()));
        JsonSet fromProject = sourcesRelPaths$1;
        int matching = fromLayout.intersect(fromProject).size();
        int notMatching = fromLayout.removeAll(fromProject).size();
        return new Tuple2.mcII.sp(matching, -notMatching);
    }

    public static final /* synthetic */ RelPath $anonfun$apply$20(Replacements replacementsVersions$1, RelPath relPath) {
        return replacementsVersions$1.templatize().relPath(relPath);
    }

    public static final /* synthetic */ RelPath $anonfun$apply$21(Replacements replacementsVersions$1, RelPath relPath) {
        return replacementsVersions$1.templatize().relPath(relPath);
    }

    public static final /* synthetic */ Option $anonfun$apply$22(model.Platform x$10) {
        return x$10.name();
    }

    public static final /* synthetic */ model.Java $anonfun$apply$23(Replacements replacements$1, Config.Java java) {
        return MODULE$.translateJava(replacements$1, java);
    }

    public static final /* synthetic */ model.Scala $anonfun$apply$24(Seq compilerPlugins$1, Replacements replacementsDirs$1, Replacements replacementsVersions$1, ScalaVersions scalaVersions$1, Config.Scala s) {
        return MODULE$.translateScala((Seq<Dep>)compilerPlugins$1, replacementsDirs$1, replacementsVersions$1, scalaVersions$1, s);
    }

    public static final /* synthetic */ List $anonfun$apply$25(Config.Test x$12) {
        return x$12.frameworks();
    }

    public static final /* synthetic */ List $anonfun$apply$26(Config.TestFramework x$13) {
        return x$13.names();
    }

    public static final /* synthetic */ model.TestFrameworkName $anonfun$apply$27(String value) {
        return new model.TestFrameworkName(value);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$apply$2(importBloopFilesFromSbt$ $this, Iterable sbtExportFiles$1, Path sbtBuildDir$1, BuildPaths destinationPaths$1, Set projectNames$1, TypedLogger logger$1, Tuple2 x0$1) {
        block8: {
            block7: {
                var11_7 = x0$1;
                if (var11_7 == null) break block7;
                crossName = (model.CrossProjectName)var11_7._1();
                bloopFile = (Config.File)var11_7._2();
                bloopProject = bloopFile.project();
                sbtExportFile = (ReadSbtExportFile.ExportedProject)sbtExportFiles$1.find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$3$adapted(bloop.config.Config$Project bleep.internal.ReadSbtExportFile$ExportedProject ), (Lbleep/internal/ReadSbtExportFile$ExportedProject;)Ljava/lang/Object;)((Config.Project)bloopProject)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$apply$5(bloop.config.Config$Project ), ()Lscala/runtime/Nothing$;)((Config.Project)bloopProject));
                projectType = importBloopFilesFromSbt$ProjectType$.MODULE$.of(crossName.name());
                directory = bloopProject.directory().startsWith(package$.MODULE$.PathOps(sbtBuildDir$1).$div(".sbt/matrix")) != false ? $this.inferDirectory$1(bloopProject.sources()) : (importBloopFilesFromSbt$.MODULE$.crossProjectDirNames().apply((Object)bloopProject.directory().getFileName().toString()) != false ? bloopProject.directory().getParent() : bloopProject.directory());
                var19_14 = RelPath$.MODULE$.relativeTo(destinationPaths$1.buildDir(), directory);
                if (var19_14 == null || (var20_15 = var19_14.segments()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var21_16 = scala.package$.MODULE$.List().unapplySeq((SeqOps)var20_15)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var21_16)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var21_16), 1) != 0) ** GOTO lbl-1000
                var22_17 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var21_16), 0);
                v0 = crossName.name();
                var23_18 = var22_17;
                if (!(v0 != null ? v0.equals(var23_18) == false : var23_18 != null)) {
                    var10_19 = None$.MODULE$;
                } else lbl-1000:
                // 2 sources

                {
                    var10_19 = new Some((Object)var19_14);
                }
                folder = var10_19;
                dependsOn = JsonSet$.MODULE$.fromIterable((Iterable)bloopProject.dependencies().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$9$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).filter((Function1)projectNames$1), model.ProjectName$.MODULE$.ordering());
                scalaVersion = bloopProject.scala().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$10(bloop.config.Config$Scala ), (Lbloop/config/Config$Scala;)Lbleep/Versions$Scala;)());
                originalTarget = findOriginalTargetDir$.MODULE$.force(crossName, bloopProject);
                replacementsTarget = Replacements$.MODULE$.targetDir(originalTarget);
                replacementsDirs = Replacements$.MODULE$.paths(sbtBuildDir$1, directory).$plus$plus(replacementsTarget);
                replacementsVersions = Replacements$.MODULE$.versions(scalaVersion, bloopProject.platform().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$11(bloop.config.Config$Platform ), (Lbloop/config/Config$Platform;)Ljava/lang/String;)()));
                replacements = replacementsDirs.$plus$plus(replacementsVersions);
                configuredPlatform = bloopProject.platform().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$12(bleep.internal.Replacements bloop.config.Config$Project bloop.config.Config$Platform ), (Lbloop/config/Config$Platform;)Lbleep/model$Platform;)((Replacements)replacements, (Config.Project)bloopProject));
                var33_29 = ScalaVersions$.MODULE$.fromExplodedScalaAndPlatform(scalaVersion, configuredPlatform);
                if (var33_29 instanceof Left) {
                    var34_30 = (Left)var33_29;
                    value = (String)var34_30.value();
                    throw new BuildException.Text(crossName, value);
                }
                if (!(var33_29 instanceof Right)) {
                    throw new MatchError((Object)var33_29);
                }
                var36_32 = (Right)var33_29;
                var9_34 = value = (ScalaVersions)var36_32.value();
                scalaVersions = var9_34;
                sources = bloopProject.sources().filterNot((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$13$adapted(java.nio.file.Path java.nio.file.Path ), (Ljava/nio/file/Path;)Ljava/lang/Object;)((Path)originalTarget));
                sourcesRelPaths = JsonSet$.MODULE$.fromIterable((Iterable)sources.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$14(java.nio.file.Path java.nio.file.Path ), (Ljava/nio/file/Path;)Lbleep/RelPath;)((Path)directory)), RelPath$.MODULE$.ordering());
                resources = ((List)bloopProject.resources().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$apply$15(), ()Lscala/collection/immutable/Nil$;)())).filterNot((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$16$adapted(java.nio.file.Path java.nio.file.Path ), (Ljava/nio/file/Path;)Ljava/lang/Object;)((Path)originalTarget));
                resourcesRelPaths = JsonSet$.MODULE$.fromIterable((Iterable)resources.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$17(java.nio.file.Path java.nio.file.Path ), (Ljava/nio/file/Path;)Lbleep/RelPath;)((Path)directory)), RelPath$.MODULE$.ordering());
                maybePlatformId = configuredPlatform.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$18(bleep.model$Platform ), (Lbleep/model$Platform;)Lscala/Option;)());
                inferredSourceLayout = (SourceLayout)SourceLayout$.MODULE$.All().values().maxBy((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$19(scala.Option scala.Option bleep.internal.importBloopFilesFromSbt$ProjectType bleep.JsonSet bleep.SourceLayout ), (Lbleep/SourceLayout;)Lscala/Tuple2;)((Option)scalaVersion, (Option)maybePlatformId, (importBloopFilesFromSbt.ProjectType)projectType, (JsonSet)sourcesRelPaths), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
                shortenedSourcesRelPaths = sourcesRelPaths.filterNot((Function1)inferredSourceLayout.sources(scalaVersion, maybePlatformId, (Option)new Some((Object)projectType.sbtScope()))).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$20(bleep.internal.Replacements bleep.RelPath ), (Lbleep/RelPath;)Lbleep/RelPath;)((Replacements)replacementsVersions), RelPath$.MODULE$.ordering());
                shortenedResourcesRelPaths = resourcesRelPaths.filterNot((Function1)inferredSourceLayout.resources(scalaVersion, maybePlatformId, (Option)new Some((Object)projectType.sbtScope()))).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$21(bleep.internal.Replacements bleep.RelPath ), (Lbleep/RelPath;)Lbleep/RelPath;)((Replacements)replacementsVersions), RelPath$.MODULE$.ordering());
                sources = new importBloopFilesFromSbt.Sources(inferredSourceLayout, (JsonSet<RelPath>)shortenedSourcesRelPaths, (JsonSet<RelPath>)shortenedResourcesRelPaths);
                providedDeps = scalaVersions.libraries(projectType.testLike());
                var48_46 = importBloopFilesFromSbt$.MODULE$.importDeps((TypedLogger<BoxedUnit>)logger$1, projectType, sbtExportFile, crossName, (Option<model.PlatformId>)configuredPlatform.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$22(bleep.model$Platform ), (Lbleep/model$Platform;)Lscala/Option;)()), (Seq<Dep>)providedDeps);
                if (var48_46 == null) {
                    throw new MatchError(var48_46);
                }
                compilerPlugins = (Seq)var48_46._1();
                dependencies = (Seq)var48_46._2();
                var8_49 = new Tuple2((Object)compilerPlugins, (Object)dependencies);
                var47_50 = var8_49;
                compilerPlugins = (Seq)var47_50._1();
                dependencies = (Seq)var47_50._2();
                configuredJava = bloopProject.java().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$23(bleep.internal.Replacements bloop.config.Config$Java ), (Lbloop/config/Config$Java;)Lbleep/model$Java;)((Replacements)replacements));
                configuredScala = bloopProject.scala().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$24(scala.collection.immutable.Seq bleep.internal.Replacements bleep.internal.Replacements bleep.internal.ScalaVersions bloop.config.Config$Scala ), (Lbloop/config/Config$Scala;)Lbleep/model$Scala;)((Seq)compilerPlugins, (Replacements)replacementsDirs, (Replacements)replacementsVersions, (ScalaVersions)scalaVersions));
                if (projectType.testLike()) {
                    names = bloopProject.test().toList().flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$25(bloop.config.Config$Test ), (Lbloop/config/Config$Test;)Lscala/collection/immutable/List;)()).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$26(bloop.config.Config$TestFramework ), (Lbloop/config/Config$TestFramework;)Lscala/collection/immutable/List;)()).filterNot(importBloopFilesFromSbt$.MODULE$.includedTestFramework());
                    v1 = JsonSet$.MODULE$.fromIterable((Iterable)names.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$27(java.lang.String ), (Ljava/lang/String;)Lbleep/model$TestFrameworkName;)()), model.TestFrameworkName$.MODULE$.ordering());
                } else {
                    v1 = JsonSet$.MODULE$.empty(model.TestFrameworkName$.MODULE$.ordering());
                }
                break block8;
            }
            throw new MatchError((Object)var11_7);
        }
        testFrameworks = v1;
        x$1 = JsonList$.MODULE$.empty();
        x$2 = JsonMap$.MODULE$.empty();
        x$3 = folder;
        x$4 = dependsOn;
        x$5 = sources.sources();
        x$6 = sources.resources();
        x$7 = JsonSet$.MODULE$.fromIterable((Iterable)dependencies, Dep$.MODULE$.ordering());
        x$8 = configuredJava;
        x$9 = configuredScala;
        x$10 = configuredPlatform;
        x$11 = new Some((Object)sources.sourceLayout());
        x$12 = new Some((Object)projectType.sbtScope());
        x$13 = projectType.testLike() != false ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : None$.MODULE$;
        x$14 = testFrameworks;
        var7_71 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)crossName), (Object)new model.Project(x$1, x$2, (Option)x$3, x$4, (Option)x$11, (Option)x$12, x$5, x$6, x$7, x$8, x$9, x$10, (Option)x$13, x$14));
        return var7_71;
    }

    public static final /* synthetic */ boolean $anonfun$apply$31(Object elem) {
        return constants$.MODULE$.DefaultRepos().contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$resolverUsedFor$1(Path https$1, Path x$16) {
        Path path = x$16;
        Path path2 = https$1;
        return path == null ? path2 != null : !((Object)path).equals(path2);
    }

    public static final /* synthetic */ boolean $anonfun$resolverUsedFor$2(Path fullOrg$1, Path x$17) {
        Path path = x$17;
        Path path2 = fullOrg$1;
        return path == null ? path2 != null : !((Object)path).equals(path2);
    }

    public static final /* synthetic */ boolean $anonfun$resolverUsedFor$4(Path initialOrg$1, Path x$19) {
        Path path = x$19;
        Path path2 = initialOrg$1;
        return path == null ? path2 != null : !((Object)path).equals(path2);
    }

    public static final /* synthetic */ boolean $anonfun$translatePlatform$2(Config.Module mod) {
        String string = mod.organization();
        String string2 = Versions$.MODULE$.scalaJsOrganization();
        return !(string != null ? !string.equals(string2) : string2 != null) && mod.name().startsWith("scalajs-library");
    }

    public static final /* synthetic */ boolean $anonfun$translateScala$1(Options.Opt x0$1) {
        Options.Opt$.Flag flag;
        String name;
        Options.Opt opt = x0$1;
        boolean bl = !(opt instanceof Options.Opt$.Flag) || !(name = (flag = (Options.Opt$.Flag)opt).name()).startsWith(constants$.MODULE$.ScalaPluginPrefix());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$translateScala$3(Dep fromPlatform$1, Dep x$22) {
        Dep dep = x$22;
        Dep dep2 = fromPlatform$1;
        return !(dep != null ? !dep.equals(dep2) : dep2 != null);
    }

    private importBloopFilesFromSbt$() {
    }

    public static final /* synthetic */ Object $anonfun$apply$3$adapted(Config.Project bloopProject$1, ReadSbtExportFile.ExportedProject f) {
        return BoxesRunTime.boxToBoolean((boolean)importBloopFilesFromSbt$.$anonfun$apply$3(bloopProject$1, f));
    }

    public static final /* synthetic */ Object $anonfun$apply$9$adapted(String name) {
        return new model.ProjectName(importBloopFilesFromSbt$.MODULE$.projectName(name));
    }

    public static final /* synthetic */ Object $anonfun$apply$13$adapted(Path originalTarget$1, Path x$7) {
        return BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(originalTarget$1));
    }

    public static final /* synthetic */ Object $anonfun$apply$16$adapted(Path originalTarget$1, Path x$8) {
        return BoxesRunTime.boxToBoolean((boolean)x$8.startsWith(originalTarget$1));
    }
}

