/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BleepBuildCommand;
import bleep.BleepCacheLogger;
import bleep.BleepCommand;
import bleep.BleepConfigOps$;
import bleep.BleepException;
import bleep.BleepNoBuildCommand;
import bleep.BuildLoader;
import bleep.BuildLoader$;
import bleep.BuildPaths;
import bleep.BuildPaths$;
import bleep.CommonOpts;
import bleep.CommonOpts$;
import bleep.CoursierResolver;
import bleep.FetchBleepRelease$;
import bleep.FileWatching;
import bleep.FileWatching$;
import bleep.GenBloopFiles$;
import bleep.LogPatterns;
import bleep.Main$metavars$;
import bleep.OsArch;
import bleep.OsArch$;
import bleep.Prebootstrapped;
import bleep.Started;
import bleep.UserPaths;
import bleep.UserPaths$;
import bleep.bootstrap$;
import bleep.bsp.BspImpl$;
import bleep.commands.BuildCreateDirectories;
import bleep.commands.BuildCreateNew;
import bleep.commands.BuildDiff;
import bleep.commands.BuildDiff$;
import bleep.commands.BuildDiffBloop;
import bleep.commands.BuildMoveFilesIntoBleepLayout$;
import bleep.commands.BuildNormalize$;
import bleep.commands.BuildReapplyTemplates$;
import bleep.commands.BuildReinferTemplates;
import bleep.commands.BuildShow;
import bleep.commands.BuildUpdateDeps$;
import bleep.commands.Clean;
import bleep.commands.Compile;
import bleep.commands.CompileServerSetMode;
import bleep.commands.CompileServerStopAll;
import bleep.commands.Dist;
import bleep.commands.Import;
import bleep.commands.InstallTabCompletions;
import bleep.commands.PublishLocal;
import bleep.commands.Run;
import bleep.commands.Scalafmt;
import bleep.commands.Script;
import bleep.commands.SetupIde;
import bleep.commands.Test;
import bleep.internal.FileUtils$;
import bleep.internal.fatal$;
import bleep.logging.Formatter$;
import bleep.logging.LogLevel;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.Pattern;
import bleep.logging.TypedLogger;
import bleep.logging.TypedLogger$;
import bleep.logging.TypedLoggerResource;
import bleep.logging.TypedLoggerResource$;
import bleep.logging.jsonEvents$;
import bleep.logging.package$;
import bleep.model.BleepConfig;
import bleep.model.BleepVersion;
import bleep.model.BleepVersion$;
import bleep.model.BuildFile;
import bleep.model.BuildVariant;
import bleep.model.CompileServerMode;
import bleep.model.CrossProjectName;
import bleep.model.Os;
import bleep.model.PlatformId;
import bleep.model.PlatformId$;
import bleep.model.ProjectName;
import bleep.model.Repository;
import bleep.model.ScriptName;
import bleep.model.VersionScala;
import bleep.model.VersionScala$;
import bleep.package;
import bleep.sbtimport.ImportOptions;
import bleep.sbtimport.ImportOptions$;
import cats.Apply;
import cats.Foldable;
import cats.Functor;
import cats.MonoidK;
import cats.Semigroupal;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.syntax.NestedFoldableOps$;
import cats.syntax.package;
import com.monovore.decline.Argument;
import com.monovore.decline.Argument$;
import com.monovore.decline.Command$;
import com.monovore.decline.Completer;
import com.monovore.decline.Completer$;
import com.monovore.decline.Help;
import com.monovore.decline.Opts;
import com.monovore.decline.Opts$;
import com.monovore.decline.Visibility;
import coursier.cache.CacheLogger;
import coursier.jniutils.LoadWindowsLibrary;
import coursier.jvm.Execve;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Text;

public final class Main$ {
    public static final Main$ MODULE$ = new Main$();
    private static final Opts<List<String>> stringArgs;
    private static final Map<String, VersionScala> possibleScalaVersions;
    private static final Opts<CommonOpts> commonOpts;

    static {
        if (Properties$.MODULE$.isWin() && MODULE$.isGraalvmNativeImage()) {
            LoadWindowsLibrary.assumeInitialized();
        }
        stringArgs = Opts$.MODULE$.arguments(Opts$.MODULE$.arguments$default$1(), Argument$.MODULE$.readString()).orNone().map((Function1 & Serializable)args -> (List)args.fold((Function0 & Serializable)() -> scala.package$.MODULE$.List().empty(), (Function1 & Serializable)x$1 -> x$1.toList()));
        possibleScalaVersions = ((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new VersionScala[]{VersionScala$.MODULE$.Scala3(), VersionScala$.MODULE$.Scala213(), VersionScala$.MODULE$.Scala212()}))).map((Function1 & Serializable)v -> new Tuple2((Object)v.binVersion().replace("\\.", ""), v)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        commonOpts = (Opts)package.apply$.MODULE$.catsSyntaxTuple5Semigroupal(new Tuple5((Object)Opts$.MODULE$.flag("no-color", "enable CI-friendly output", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4()).orFalse((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Opts$.MODULE$.flag("debug", "enable more output", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4()).orFalse((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Opts$.MODULE$.option("directory", "enable more output", "d", Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readString()).orNone(), (Object)Opts$.MODULE$.flag("dev", "use the current bleep binary and don't launch the one specified in bleep.yaml", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4()).orFalse((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Opts$.MODULE$.flag("no-bsp-progress", "don't show compilation progress. good for CI", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4()).orFalse((.less.colon.less)$less$colon$less$.MODULE$.refl()))).mapN((Function5 & Serializable)(noColor, debug, directory, dev, noBspProgress) -> Main$.$anonfun$commonOpts$1(BoxesRunTime.unboxToBoolean((Object)noColor), BoxesRunTime.unboxToBoolean((Object)debug), directory, BoxesRunTime.unboxToBoolean((Object)dev), BoxesRunTime.unboxToBoolean((Object)noBspProgress)), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative());
    }

    private boolean isGraalvmNativeImage() {
        return scala.sys.package$.MODULE$.props().contains("org.graalvm.nativeimage.imagecode");
    }

    public Opts<List<String>> stringArgs() {
        return stringArgs;
    }

    public Map<String, VersionScala> possibleScalaVersions() {
        return possibleScalaVersions;
    }

    public Opts<CommonOpts> commonOpts() {
        return commonOpts;
    }

    public Opts<BleepNoBuildCommand> noBuildOpts(TypedLogger<BoxedUnit> logger, UserPaths userPaths, BuildPaths buildPaths, BuildLoader.NonExisting buildLoader) {
        return (Opts)package.apply$.MODULE$.catsSyntaxApply(this.commonOpts(), (Apply)Opts$.MODULE$.alternative()).$times$greater(NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("build", "create new build", Opts$.MODULE$.subcommand$default$3(), this.newCommand(logger, userPaths, buildPaths.cwd())), this.importCmd((BuildLoader)buildLoader, buildPaths, logger), this.configCommand(logger, userPaths), this.installTabCompletions(logger)})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative()));
    }

    public <A> Argument<A> argumentFrom(String defmeta, Option<Map<String, A>> nameToValue) {
        return Argument$.MODULE$.fromMap(defmeta, (Map)nameToValue.getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()));
    }

    public Opts<BleepBuildCommand> hasBuildOpts(Started started) {
        LazyRef ret$lzy = new LazyRef();
        Opts projectNamesNoCross = Opts$.MODULE$.arguments(Main$metavars$.MODULE$.projectNameNoCross(), this.argumentFrom(Main$metavars$.MODULE$.projectNameNoCross(), (Option)new Some((Object)started.globs().projectNamesNoCrossMap())));
        Opts projectNames = Opts$.MODULE$.arguments(Main$metavars$.MODULE$.projectName(), this.argumentFrom(Main$metavars$.MODULE$.projectName(), (Option)new Some((Object)started.globs().projectNameMap()))).map((Function1 & Serializable)x$2 -> (CrossProjectName[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])x$2.toList().toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(CrossProjectName.class)))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(CrossProjectName.class))).orNone().map((Function1 & Serializable)maybeFromCommandLine -> started.chosenProjects(maybeFromCommandLine));
        Opts projectName = Opts$.MODULE$.argument(Main$metavars$.MODULE$.projectNameExact(), this.argumentFrom(Main$metavars$.MODULE$.projectNameExact(), (Option)new Some((Object)started.globs().exactProjectMap())));
        Opts testProjectNames = Opts$.MODULE$.arguments(Main$metavars$.MODULE$.testProjectName(), this.argumentFrom(Main$metavars$.MODULE$.testProjectName(), (Option)new Some((Object)started.globs().testProjectNameMap()))).map((Function1 & Serializable)x$3 -> (CrossProjectName[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])x$3.toList().toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(CrossProjectName.class)))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(CrossProjectName.class))).orNone().map((Function1 & Serializable)maybeFromCommandLine -> started.chosenTestProjects(maybeFromCommandLine));
        Opts mainClass = Opts$.MODULE$.option("class", "explicitly override main class. If not set, bleep will first look in the build file, then fall back to looking into compiled class files", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readString()).orNone();
        Opts watch = Opts$.MODULE$.flag("watch", "start in watch mode", "w", Opts$.MODULE$.flag$default$4()).orFalse((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return this.ret$1(ret$lzy, projectNames, projectNamesNoCross, watch, testProjectNames, projectName, mainClass, started);
    }

    public Opts<BleepCommand> configCommand(TypedLogger<BoxedUnit> logger, UserPaths userPaths) {
        return Opts$.MODULE$.subcommand("config", "configure bleep here", Opts$.MODULE$.subcommand$default$3(), (Opts)NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("file", "show configuration file location", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new BleepCommand(logger, userPaths){
            private final TypedLogger logger$1;
            private final UserPaths userPaths$1;

            public final Either<BleepException, BoxedUnit> run(Started started) {
                return BleepCommand.run$((BleepCommand)this, (Started)started);
            }

            public final Either<BleepException, BoxedUnit> run() {
                return Main$.bleep$Main$$$anonfun$configCommand$2(this.logger$1, this.userPaths$1);
            }
            {
                this.logger$1 = logger$1;
                this.userPaths$1 = userPaths$1;
                BleepCommand.$init$((BleepCommand)this);
            }
        })), Opts$.MODULE$.subcommand("log-timing-enable", "enable timing info in logs", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new BleepCommand(logger, userPaths){
            private final TypedLogger logger$1;
            private final UserPaths userPaths$1;

            public final Either<BleepException, BoxedUnit> run(Started started) {
                return BleepCommand.run$((BleepCommand)this, (Started)started);
            }

            public final Either<BleepException, BoxedUnit> run() {
                return Main$.bleep$Main$$$anonfun$configCommand$5(this.logger$1, this.userPaths$1);
            }
            {
                this.logger$1 = logger$1;
                this.userPaths$1 = userPaths$1;
                BleepCommand.$init$((BleepCommand)this);
            }
        })), Opts$.MODULE$.subcommand("log-timing-disable", "disable timing info in logs", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new BleepCommand(logger, userPaths){
            private final TypedLogger logger$1;
            private final UserPaths userPaths$1;

            public final Either<BleepException, BoxedUnit> run(Started started) {
                return BleepCommand.run$((BleepCommand)this, (Started)started);
            }

            public final Either<BleepException, BoxedUnit> run() {
                return Main$.bleep$Main$$$anonfun$configCommand$9(this.logger$1, this.userPaths$1);
            }
            {
                this.logger$1 = logger$1;
                this.userPaths$1 = userPaths$1;
                BleepCommand.$init$((BleepCommand)this);
            }
        })), Opts$.MODULE$.subcommand("compile-server", "You can speed up normal usage by keeping the bloop compile server running between invocations. This is where you control it", Opts$.MODULE$.subcommand$default$3(), (Opts)NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("auto-shutdown-disable", "leave compile servers running between bleep invocations. this gets much better performance at the cost of memory", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new CompileServerSetMode(logger, userPaths, (CompileServerMode)CompileServerMode.Shared$.MODULE$))), Opts$.MODULE$.subcommand("auto-shutdown-enable", "shuts down compile server after between bleep invocation. this is slower, but conserves memory", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new CompileServerSetMode(logger, userPaths, (CompileServerMode)CompileServerMode.NewEachInvocation$.MODULE$))), Opts$.MODULE$.subcommand("stop-all", "will stop all shared bloop compile servers", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new CompileServerStopAll(logger, userPaths)))})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative()))})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative()));
    }

    public Opts<BleepNoBuildCommand> importCmd(BuildLoader buildLoader, BuildPaths buildPaths, TypedLogger<BoxedUnit> logger) {
        return Opts$.MODULE$.subcommand("import", "import existing build from files in .bloop", Opts$.MODULE$.subcommand$default$3(), ImportOptions$.MODULE$.opts().map((Function1 & Serializable)opts -> {
            Option existingBuild = buildLoader.existing().flatMap((Function1 & Serializable)x$15 -> (Either)x$15.buildFile().forceGet()).toOption();
            return new Import((Option<BuildFile>)existingBuild, buildPaths.cwd(), buildPaths, logger, (ImportOptions)opts, BleepVersion$.MODULE$.current());
        }));
    }

    public Opts<BleepCommand> installTabCompletions(TypedLogger<BoxedUnit> logger) {
        return Opts$.MODULE$.subcommand("install-tab-completions-bash", "Install tab completions for bash", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new InstallTabCompletions(logger)));
    }

    public Opts<BleepCommand> setupIdeCmd(BuildPaths buildPaths, TypedLogger<BoxedUnit> logger, Option<Map<String, CrossProjectName[]>> projectNameMap, ExecutionContext ec) {
        Opts projectNamesNoExpand = Opts$.MODULE$.arguments(Main$metavars$.MODULE$.projectName(), this.argumentFrom(Main$metavars$.MODULE$.projectName(), projectNameMap.map((Function1 & Serializable)x$16 -> (Map)x$16.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String s = (String)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)s, (Object)s);
            return tuple22;
        })))).map((Function1 & Serializable)x$17 -> x$17.toList()).orNone();
        return Opts$.MODULE$.subcommand("setup-ide", "generate ./bsp/bleep.json so IDEs can import build", Opts$.MODULE$.subcommand$default$3(), projectNamesNoExpand.map((Function1 & Serializable)projectNames -> new SetupIde(buildPaths, logger, (Option<List<String>>)projectNames, ec)));
    }

    public Opts<BleepNoBuildCommand> newCommand(TypedLogger<BoxedUnit> logger, UserPaths userPaths, Path cwd) {
        String x$1 = "platform";
        String x$2 = "specify wanted platform(s)";
        String x$3 = Main$metavars$.MODULE$.platformName();
        String x$4 = "p";
        Visibility x$5 = Opts$.MODULE$.options$default$5();
        Argument x$6 = Argument$.MODULE$.fromMap(Main$metavars$.MODULE$.platformName(), PlatformId$.MODULE$.All().map((Function1 & Serializable)p -> new Tuple2((Object)p.value(), p)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return Opts$.MODULE$.subcommand("new", "create new build in current directory", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3((Object)Opts$.MODULE$.options("platform", "specify wanted platform(s)", "p", x$3, x$5, x$6).withDefault((Object)NonEmptyList$.MODULE$.of((Object)PlatformId.Jvm$.MODULE$, (Seq)Nil$.MODULE$)), (Object)Opts$.MODULE$.options("scala", "specify scala version(s)", "s", Main$metavars$.MODULE$.scalaVersion(), Opts$.MODULE$.options$default$5(), Argument$.MODULE$.fromMap(Main$metavars$.MODULE$.scalaVersion(), this.possibleScalaVersions())).withDefault((Object)NonEmptyList$.MODULE$.of((Object)VersionScala$.MODULE$.Scala3(), (Seq)Nil$.MODULE$)), (Object)Opts$.MODULE$.argument("wanted project name", Argument$.MODULE$.readString()))).mapN((Function3 & Serializable)(x0$1, x1$1, x2$1) -> {
            Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            NonEmptyList platforms = (NonEmptyList)tuple3._1();
            NonEmptyList scalas = (NonEmptyList)tuple3._2();
            String name = (String)tuple3._3();
            BuildCreateNew buildCreateNew = new BuildCreateNew(logger, userPaths, cwd, (NonEmptyList<PlatformId>)platforms, (NonEmptyList<VersionScala>)scalas, name, BleepVersion$.MODULE$.current(), (CoursierResolver.Factory)CoursierResolver.Factory$.default$.MODULE$);
            return buildCreateNew;
        }, (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path cwdFor(CommonOpts opts) {
        boolean bl = false;
        Some some = null;
        Option option = opts.directory();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String str = (String)some.value();
            if (str.startsWith("/")) {
                return Paths.get(str, new String[0]);
            }
        }
        if (bl) {
            String str = (String)some.value();
            return package.PathOps$.MODULE$.$div$extension(bleep.package$.MODULE$.PathOps(FileUtils$.MODULE$.cwd()), str);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        return FileUtils$.MODULE$.cwd();
    }

    /*
     * Unable to fully structure code
     */
    public void maybeRunWithDifferentVersion(String[] args, BuildLoader buildLoader, TypedLogger<BoxedUnit> logger, CommonOpts opts) {
        block6: {
            block7: {
                block10: {
                    block12: {
                        block11: {
                            block8: {
                                block9: {
                                    block5: {
                                        var8_5 = buildLoader;
                                        if (!(var8_5 instanceof BuildLoader.NonExisting)) break block5;
                                        var5_6 = BoxedUnit.UNIT;
                                        break block6;
                                    }
                                    if (!(var8_5 instanceof BuildLoader.Existing)) break block7;
                                    var9_8 = (BuildLoader.Existing)var8_5;
                                    var11_9 = OsArch$.MODULE$.current();
                                    var7_12 = var11_9 instanceof OsArch.MacosArm64 != false ? (freedFromJail = (var12_10 = (OsArch.MacosArm64)var11_9).freedFromJail()) == false : true;
                                    correctPlatform = var7_12;
                                    var14_14 = false;
                                    var15_15 = null;
                                    var16_16 = (Either)var9_8.wantedVersion().forceGet();
                                    if (!(var16_16 instanceof Right)) break block8;
                                    var14_14 = true;
                                    var15_15 = (Right)var16_16;
                                    wantedVersion = ((BleepVersion)var15_15.value()).value();
                                    v0 = BleepVersion$.MODULE$.current();
                                    var18_18 = wantedVersion;
                                    if (!(v0 != null ? v0.equals(var18_18) == false : var18_18 != null) && correctPlatform) break block9;
                                    v1 = wantedVersion;
                                    var19_19 = BleepVersion$.MODULE$.dev();
                                    if (v1 != null ? v1.equals(var19_19) == false : var19_19 != null) break block8;
                                }
                                var6_20 = BoxedUnit.UNIT;
                                break block10;
                            }
                            if (!var14_14) break block11;
                            wantedVersion = ((BleepVersion)var15_15.value()).value();
                            if (!BleepVersion$.MODULE$.isDevelopment$extension(BleepVersion$.MODULE$.current())) break block11;
                            LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$maybeRunWithDifferentVersion$2(java.lang.String bleep.BuildLoader$Existing ), ()Lsourcecode/Text;)((String)wantedVersion, (BuildLoader.Existing)var9_8), Formatter$.MODULE$.StringFormatter(), new Line(362), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.maybeRunWithDifferentVersion"));
                            var6_21 = BoxedUnit.UNIT;
                            break block10;
                        }
                        if (!var14_14) break block12;
                        wantedVersion = ((BleepVersion)var15_15.value()).value();
                        if (!opts.dev()) break block12;
                        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$maybeRunWithDifferentVersion$3(java.lang.String bleep.BuildLoader$Existing ), ()Lsourcecode/Text;)((String)wantedVersion, (BuildLoader.Existing)var9_8), Formatter$.MODULE$.StringFormatter(), new Line(364), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.maybeRunWithDifferentVersion"));
                        var6_22 = BoxedUnit.UNIT;
                        break block10;
                    }
                    if (!var14_14) ** GOTO lbl-1000
                    wantedVersion = ((BleepVersion)var15_15.value()).value();
                    if (!correctPlatform) {
                        LoggerFn.Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$maybeRunWithDifferentVersion$4(java.lang.String ), ()Lsourcecode/Text;)((String)wantedVersion), Formatter$.MODULE$.StringFormatter(), new Line(366), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.maybeRunWithDifferentVersion"));
                        this.go$1(wantedVersion, logger, args);
                        var6_23 = BoxedUnit.UNIT;
                    } else if (var14_14) {
                        wantedVersion = ((BleepVersion)var15_15.value()).value();
                        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$maybeRunWithDifferentVersion$5(java.lang.String bleep.BuildLoader$Existing ), ()Lsourcecode/Text;)((String)wantedVersion, (BuildLoader.Existing)var9_8), Formatter$.MODULE$.StringFormatter(), new Line(371), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.maybeRunWithDifferentVersion"));
                        this.go$1(wantedVersion, logger, args);
                        var6_24 = BoxedUnit.UNIT;
                    } else {
                        if (var16_16 instanceof Left) {
                            var24_29 = (Left)var16_16;
                            throwable = (Exception)var24_29.value();
                            throw fatal$.MODULE$.apply("Couldn't load build", logger, (Throwable)throwable);
                        }
                        throw new MatchError((Object)var16_16);
                    }
                }
                var5_7 = BoxedUnit.UNIT;
                break block6;
            }
            throw new MatchError((Object)var8_5);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void main(String[] _args) {
        TypedLogger typedLogger;
        UserPaths userPaths = UserPaths$.MODULE$.fromAppDirs();
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = Predef$.MODULE$.wrapRefArray((Object[])_args).toList();
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list2 = colon2.next$access$1();
            if ("_complete".equals(string) && list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                String compLine = (String)colon3.head();
                List list3 = colon3.next$access$1();
                if (list3 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list3;
                    String compCword = (String)colon4.head();
                    List list4 = colon4.next$access$1();
                    if (list4 instanceof .colon.colon) {
                        Completer.Res res;
                        CommonOpts commonOpts;
                        List restArgs;
                        .colon.colon colon5 = (.colon.colon)list4;
                        String compPoint = (String)colon5.head();
                        List<String> args = Completer$.MODULE$.bashToArgs(compLine, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(compCword)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(compPoint)));
                        Tuple2 tuple2 = CommonOpts$.MODULE$.parse(args);
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        List list5 = restArgs = (List)tuple2._2();
                        List restArgs2 = list5;
                        Tuple2 tuple22 = CommonOpts$.MODULE$.parse(Predef$.MODULE$.wrapRefArray((Object[])compLine.split(" ")).toList());
                        if (tuple22 == null) throw new MatchError((Object)tuple22);
                        CommonOpts commonOpts2 = commonOpts = (CommonOpts)tuple22._1();
                        CommonOpts commonOpts3 = commonOpts2;
                        Path cwd = this.cwdFor(commonOpts3);
                        TypedLogger logger2 = TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(TypedLogger.LoggerAuxSyntax$.MODULE$.minLogLevel$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(package$.MODULE$.stderr((Pattern)LogPatterns.logFile$.MODULE$, package$.MODULE$.stderr$default$2())), (LogLevel)LogLevel.warn$.MODULE$)));
                        BuildLoader buildLoader = BuildLoader$.MODULE$.find(cwd);
                        this.maybeRunWithDifferentVersion(_args, buildLoader, (TypedLogger<BoxedUnit>)logger2, commonOpts3);
                        BuildPaths buildPaths = BuildPaths$.MODULE$.apply(cwd, buildLoader, (BuildVariant)BuildVariant.Normal$.MODULE$);
                        BuildLoader buildLoader2 = buildLoader;
                        if (buildLoader2 instanceof BuildLoader.NonExisting) {
                            BuildLoader.NonExisting nonExisting = (BuildLoader.NonExisting)buildLoader2;
                            Completer completer = new Completer((Function1<String, List<String>>)(Function1 & Serializable)x0$1 -> {
                                Object object;
                                String string = x0$1;
                                String string2 = Main$metavars$.MODULE$.platformName();
                                String string3 = string;
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    object = PlatformId$.MODULE$.All().map((Function1 & Serializable)x$18 -> x$18.value());
                                } else {
                                    String string4 = Main$metavars$.MODULE$.scalaVersion();
                                    String string5 = string;
                                    object = !(string4 != null ? !string4.equals(string5) : string5 != null) ? MODULE$.possibleScalaVersions().keys().toList() : scala.package$.MODULE$.Nil();
                                }
                                return object;
                            });
                            res = completer.completeOpts((List<String>)restArgs2, this.noBuildOpts((TypedLogger<BoxedUnit>)logger2, userPaths, buildPaths, nonExisting));
                        } else {
                            if (!(buildLoader2 instanceof BuildLoader.Existing)) throw new MatchError((Object)buildLoader2);
                            BuildLoader.Existing existing = (BuildLoader.Existing)buildLoader2;
                            Prebootstrapped pre = new Prebootstrapped(logger2, userPaths, buildPaths, existing);
                            BleepConfig config = (BleepConfig)BleepException.ExpectOps$.MODULE$.orThrow$extension(bleep.package$.MODULE$.bleepExceptionOps(BleepConfigOps$.MODULE$.loadOrDefault(pre.userPaths())), (.less.colon.less)$less$colon$less$.MODULE$.refl());
                            Either either = bootstrap$.MODULE$.from(pre, GenBloopFiles$.MODULE$.SyncToDisk(), (List)scala.package$.MODULE$.Nil(), config, (CoursierResolver.Factory)CoursierResolver.Factory$.default$.MODULE$, (ExecutionContext)ExecutionContext$.MODULE$.global());
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                BleepException th = (BleepException)left.value();
                                throw fatal$.MODULE$.apply("couldn't load build", logger2, (Throwable)th);
                            }
                            if (!(either instanceof Right)) throw new MatchError((Object)either);
                            Right right = (Right)either;
                            Started started = (Started)right.value();
                            Completer completer = new Completer((Function1<String, List<String>>)(Function1 & Serializable)x0$2 -> {
                                Object object;
                                String string = x0$2;
                                String string2 = Main$metavars$.MODULE$.platformName();
                                String string3 = string;
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    object = PlatformId$.MODULE$.All().map((Function1 & Serializable)x$19 -> x$19.value());
                                } else {
                                    String string4 = Main$metavars$.MODULE$.scalaVersion();
                                    String string5 = string;
                                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                                        object = MODULE$.possibleScalaVersions().keys().toList();
                                    } else {
                                        String string6 = Main$metavars$.MODULE$.projectNameExact();
                                        String string7 = string;
                                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                            object = started.globs().exactProjectMap().keys().toList();
                                        } else {
                                            String string8 = Main$metavars$.MODULE$.projectNameNoCross();
                                            String string9 = string;
                                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                                object = started.globs().projectNamesNoCrossMap().keys().toList();
                                            } else {
                                                String string10 = Main$metavars$.MODULE$.projectName();
                                                String string11 = string;
                                                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                                    object = started.globs().projectNameMap().keys().toList();
                                                } else {
                                                    String string12 = Main$metavars$.MODULE$.testProjectName();
                                                    String string13 = string;
                                                    object = !(string12 != null ? !string12.equals(string13) : string13 != null) ? started.globs().testProjectNameMap().keys().toList() : scala.package$.MODULE$.Nil();
                                                }
                                            }
                                        }
                                    }
                                }
                                return object;
                            });
                            Completer.Res res2 = completer.completeOpts((List<String>)restArgs2, this.hasBuildOpts(started));
                            res = res2;
                        }
                        Completer.Res completions = res;
                        completions.value().foreach((Function1 & Serializable)c -> {
                            Predef$.MODULE$.println((Object)c.value());
                            return BoxedUnit.UNIT;
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
        }
        if (bl) {
            String string = (String)colon2.head();
            List list6 = colon2.next$access$1();
            if ("selftest".equals(string)) {
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                List list7 = list6;
                if (!(nil$ != null ? !nil$.equals(list7) : list7 != null)) {
                    FileWatching.TypedWatcher qual$1 = FileWatching$.MODULE$.apply((TypedLogger)TypedLogger.DevNull$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FileUtils$.MODULE$.cwd()), scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapUnitArray(new BoxedUnit[]{BoxedUnit.UNIT})))})), (Function1 & Serializable)x$20 -> {
                        Predef$.MODULE$.println((Object)x$20);
                        return BoxedUnit.UNIT;
                    });
                    FileWatching.StopWhen$.Immediately$ x$1 = FileWatching.StopWhen$.Immediately$.MODULE$;
                    long x$2 = qual$1.run$default$2();
                    qual$1.run((FileWatching.StopWhen)x$1, x$2);
                    Predef$.MODULE$.println((Object)"OK");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (bl) {
            String string = (String)colon2.head();
            List args = colon2.next$access$1();
            if ("bsp".equals(string)) {
                CommonOpts commonOpts;
                Tuple2 tuple2 = CommonOpts$.MODULE$.parse(args);
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                CommonOpts commonOpts4 = commonOpts = (CommonOpts)tuple2._1();
                CommonOpts commonOpts5 = commonOpts4;
                Path cwd = this.cwdFor(commonOpts5);
                TypedLogger stderr = TypedLogger.LoggerAuxSyntax$.MODULE$.minLogLevel$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(package$.MODULE$.stderr((Pattern)LogPatterns.logFile$.MODULE$, package$.MODULE$.stderr$default$2())), (LogLevel)LogLevel.warn$.MODULE$);
                BuildLoader buildLoader = BuildLoader$.MODULE$.find(cwd);
                this.maybeRunWithDifferentVersion(_args, buildLoader, (TypedLogger<BoxedUnit>)TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(stderr)), commonOpts5);
                BuildVariant.BSP$ buildVariant = BuildVariant.BSP$.MODULE$;
                BuildPaths buildPaths = BuildPaths$.MODULE$.apply(cwd, buildLoader, (BuildVariant)buildVariant);
                TypedLoggerResource logFileResource = package$.MODULE$.path(buildPaths.logFile(), (Pattern)LogPatterns.logFile$.MODULE$, package$.MODULE$.path$default$3());
                TypedLoggerResource logResource = TypedLoggerResource.Ops$.MODULE$.untyped$extension(TypedLoggerResource$.MODULE$.Ops(TypedLoggerResource.Ops$.MODULE$.map$extension(TypedLoggerResource$.MODULE$.Ops(logFileResource), (Function1 & Serializable)logFile -> TypedLogger.LoggerAuxSyntax$.MODULE$.zipWith$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(TypedLogger.LoggerFlushableSyntax$.MODULE$.flushing$extension(TypedLogger$.MODULE$.LoggerFlushableSyntax(logFile))), stderr))));
                BoxedUnit boxedUnit = (BoxedUnit)logResource.use((Function1 & Serializable)logger -> {
                    Main$.$anonfun$main$8(buildLoader, userPaths, buildPaths, logger);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        boolean logAsJson = scala.sys.package$.MODULE$.env().contains((Object)jsonEvents$.MODULE$.CallerProcessAcceptsJsonEvents());
        Tuple2 tuple2 = CommonOpts$.MODULE$.parse(list);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        CommonOpts commonOpts = (CommonOpts)tuple2._1();
        List restArgs = (List)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)commonOpts, (Object)restArgs);
        Tuple2 tuple24 = tuple23;
        CommonOpts commonOpts6 = (CommonOpts)tuple24._1();
        List restArgs3 = (List)tuple24._2();
        Path cwd = this.cwdFor(commonOpts6);
        BleepConfig config = (BleepConfig)BleepException.ExpectOps$.MODULE$.orThrow$extension(bleep.package$.MODULE$.bleepExceptionOps(BleepConfigOps$.MODULE$.loadOrDefault(userPaths)), (.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (logAsJson) {
            typedLogger = package$.MODULE$.stdoutJson(package$.MODULE$.stdoutJson$default$1());
        } else {
            None$ startRun = BoxesRunTime.unboxToBoolean((Object)config.logTiming().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) ? new Some((Object)Instant.now()) : None$.MODULE$;
            LogPatterns.interface pattern = new LogPatterns.interface((Option)startRun, commonOpts6.noColor());
            typedLogger = TypedLogger.LoggerAuxSyntax$.MODULE$.minLogLevel$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(package$.MODULE$.stdout((Pattern)pattern, commonOpts6.noBspProgress(), package$.MODULE$.stdout$default$3())), (LogLevel)(commonOpts6.debug() ? LogLevel.debug$.MODULE$ : LogLevel.info$.MODULE$));
        }
        TypedLogger stdout = typedLogger;
        BuildLoader buildLoader = BuildLoader$.MODULE$.find(cwd);
        this.maybeRunWithDifferentVersion(_args, buildLoader, (TypedLogger<BoxedUnit>)TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(stdout)), commonOpts6);
        BuildPaths buildPaths = BuildPaths$.MODULE$.apply(cwd, buildLoader, (BuildVariant)BuildVariant.Normal$.MODULE$);
        BuildLoader buildLoader3 = buildLoader;
        if (buildLoader3 instanceof BuildLoader.NonExisting) {
            BuildLoader.NonExisting nonExisting = (BuildLoader.NonExisting)buildLoader3;
            BoxedUnit boxedUnit = (BoxedUnit)Main$.stdoutAndFileLogging$1(buildPaths, logAsJson, stdout).use((Function1 & Serializable)logger -> {
                Main$.MODULE$.run((TypedLogger<BoxedUnit>)logger, Main$.MODULE$.noBuildOpts((TypedLogger<BoxedUnit>)TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(stdout)), userPaths, buildPaths, nonExisting), (List<String>)restArgs3);
                return BoxedUnit.UNIT;
            });
        } else {
            if (!(buildLoader3 instanceof BuildLoader.Existing)) throw new MatchError((Object)buildLoader3);
            BuildLoader.Existing existing = (BuildLoader.Existing)buildLoader3;
            BoxedUnit boxedUnit = (BoxedUnit)Main$.stdoutAndFileLogging$1(buildPaths, logAsJson, stdout).use((Function1 & Serializable)logger -> {
                Main$.$anonfun$main$13(userPaths, buildPaths, existing, config, restArgs3, logger);
                return BoxedUnit.UNIT;
            });
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(TypedLogger<BoxedUnit> logger, Opts<BleepBuildCommand> opts, Started started, List<String> restArgs) {
        Either either = Command$.MODULE$.apply("bleep", new StringBuilder(31).append("Bleeping fast build! (version ").append(BleepVersion$.MODULE$.current()).append(")").toString(), Command$.MODULE$.apply$default$3(), opts).parse(restArgs, scala.sys.package$.MODULE$.env());
        if (either instanceof Left) {
            Left left = (Left)either;
            Help help = (Help)left.value();
            System.err.println(help);
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Either either2;
            Right right = (Right)either;
            BleepBuildCommand cmd = (BleepBuildCommand)right.value();
            boolean bl = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> cmd.run(started));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable th = failure.exception();
                throw fatal$.MODULE$.apply("command failed", logger, th);
            }
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Either either3 = (Either)success.value();
                if (either3 instanceof Left) {
                    Left left = (Left)either3;
                    BleepException th = (BleepException)left.value();
                    throw fatal$.MODULE$.apply("command failed", logger, (Throwable)th);
                }
            }
            if (!bl || !((either2 = (Either)success.value()) instanceof Right)) {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    public void run(TypedLogger<BoxedUnit> logger, Opts<BleepNoBuildCommand> opts, List<String> restArgs) {
        Either either = Command$.MODULE$.apply("bleep", new StringBuilder(31).append("Bleeping fast build! (version ").append(BleepVersion$.MODULE$.current()).append(")").toString(), Command$.MODULE$.apply$default$3(), opts).parse(restArgs, scala.sys.package$.MODULE$.env());
        if (either instanceof Left) {
            Left left = (Left)either;
            Help help = (Help)left.value();
            System.err.println(help);
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Either either2;
            Right right = (Right)either;
            BleepNoBuildCommand cmd = (BleepNoBuildCommand)right.value();
            boolean bl = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> cmd.run());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable th = failure.exception();
                throw fatal$.MODULE$.apply("command failed", logger, th);
            }
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Either either3 = (Either)success.value();
                if (either3 instanceof Left) {
                    Left left = (Left)either3;
                    BleepException th = (BleepException)left.value();
                    throw fatal$.MODULE$.apply("command failed", logger, (Throwable)th);
                }
            }
            if (!bl || !((either2 = (Either)success.value()) instanceof Right)) {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    public static final /* synthetic */ CommonOpts $anonfun$commonOpts$1(boolean noColor, boolean debug, Option directory, boolean dev, boolean noBspProgress) {
        return new CommonOpts(noColor, debug, directory, dev, noBspProgress);
    }

    public static final /* synthetic */ BleepBuildCommand $anonfun$hasBuildOpts$18(boolean x0$3, CrossProjectName[] x1$3) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$3), (Object)x1$3);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean watch = tuple2._1$mcZ$sp();
        CrossProjectName[] projectNames = (CrossProjectName[])tuple2._2();
        Compile compile = new Compile(watch, projectNames);
        return compile;
    }

    public static final /* synthetic */ BleepBuildCommand $anonfun$hasBuildOpts$19(boolean x0$4, CrossProjectName[] x1$4) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$4), (Object)x1$4);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean watch = tuple2._1$mcZ$sp();
        CrossProjectName[] projectNames = (CrossProjectName[])tuple2._2();
        Test test = new Test(watch, projectNames);
        return test;
    }

    public static final /* synthetic */ BleepBuildCommand $anonfun$hasBuildOpts$21(CrossProjectName x0$5, Option x1$5, List x2$1, boolean x3$1) {
        Tuple4 tuple4 = new Tuple4((Object)x0$5, (Object)x1$5, (Object)x2$1, (Object)BoxesRunTime.boxToBoolean((boolean)x3$1));
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        CrossProjectName projectName = (CrossProjectName)tuple4._1();
        Option mainClass = (Option)tuple4._2();
        List arguments = (List)tuple4._3();
        boolean watch = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
        Run run = new Run(projectName, mainClass, arguments, true, watch);
        return run;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ BleepBuildCommand $anonfun$hasBuildOpts$33(String x0$6, String x1$6, Option x2$2, CrossProjectName[] x3$2, boolean x4$1) {
        PublishLocal.LocalIvy$ localIvy$;
        Tuple5 tuple5 = new Tuple5((Object)x0$6, (Object)x1$6, (Object)x2$2, (Object)x3$2, (Object)BoxesRunTime.boxToBoolean((boolean)x4$1));
        if (tuple5 == null) throw new MatchError((Object)tuple5);
        String groupId = (String)tuple5._1();
        String version = (String)tuple5._2();
        Option to = (Option)tuple5._3();
        CrossProjectName[] projects = (CrossProjectName[])tuple5._4();
        boolean watch = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
        Option option = to;
        if (option instanceof Some) {
            Some some = (Some)option;
            Path path = (Path)some.value();
            localIvy$ = new PublishLocal.CustomMaven(new Repository.MavenFolder((Option)None$.MODULE$, path));
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            localIvy$ = PublishLocal.LocalIvy$.MODULE$;
        }
        PublishLocal.LocalIvy$ publishTarget = localIvy$;
        PublishLocal.Options options = new PublishLocal.Options(groupId, version, (PublishLocal.PublishTarget)publishTarget, projects);
        return new PublishLocal(watch, options);
    }

    public static final /* synthetic */ BleepBuildCommand $anonfun$hasBuildOpts$34(Started started$1, CrossProjectName x0$7, Option x1$7, Option x2$3, boolean x3$3) {
        Tuple4 tuple4 = new Tuple4((Object)x0$7, (Object)x1$7, (Object)x2$3, (Object)BoxesRunTime.boxToBoolean((boolean)x3$3));
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        CrossProjectName projectName = (CrossProjectName)tuple4._1();
        Option mainClass = (Option)tuple4._2();
        Option overridePath = (Option)tuple4._3();
        boolean watch = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
        Dist.Options options = new Dist.Options(projectName, mainClass, overridePath);
        Dist dist = new Dist(started$1, watch, options);
        return dist;
    }

    public static final /* synthetic */ Scalafmt $anonfun$hasBuildOpts$35(boolean check) {
        return new Scalafmt(check);
    }

    public static final /* synthetic */ Script $anonfun$hasBuildOpts$37(String scriptName$1, boolean x0$9, List x1$8) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$9), (Object)x1$8);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean watch = tuple2._1$mcZ$sp();
        List args = (List)tuple2._2();
        Script script = new Script(scriptName$1, args, watch);
        return script;
    }

    private final /* synthetic */ Opts ret$lzycompute$1(LazyRef ret$lzy$1, Opts projectNames$1, Opts projectNamesNoCross$1, Opts watch$1, Opts testProjectNames$1, Opts projectName$1, Opts mainClass$1, Started started$1) {
        Opts opts;
        LazyRef lazyRef = ret$lzy$1;
        synchronized (lazyRef) {
            Opts opts2;
            if (ret$lzy$1.initialized()) {
                opts2 = (Opts)ret$lzy$1.value();
            } else {
                List allCommands = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{(Iterable)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("build", "rewrite build", Opts$.MODULE$.subcommand$default$3(), (Opts)NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("create-directories", "create all source and resource folders for project(s)", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)names -> new BuildCreateDirectories((CrossProjectName[])names))), Opts$.MODULE$.subcommand("normalize", "normalize build (deduplicate, sort, etc)", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> BuildNormalize$.MODULE$)), Opts$.MODULE$.subcommand("templates-reapply", "apply existing templates again", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> BuildReapplyTemplates$.MODULE$)), Opts$.MODULE$.subcommand("templates-generate-new", "throw away existing templates and infer new", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new BuildReinferTemplates((Set<ProjectName>)Predef$.MODULE$.Set().empty()))), Opts$.MODULE$.subcommand("update-deps", "updates to newest versions of all dependencies", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> BuildUpdateDeps$.MODULE$)), Opts$.MODULE$.subcommand("move-files-into-bleep-layout", "move source files around from sbt file layout to bleep layout. Your build will no longer have any `sbt-scope` or `folder` set.", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> BuildMoveFilesIntoBleepLayout$.MODULE$)), Opts$.MODULE$.subcommand("diff", "diff exploded projects compared to git HEAD or wanted revision", Opts$.MODULE$.subcommand$default$3(), (Opts)NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("exploded", "show projects after applying templates", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)projectNames$1, BuildDiff$.MODULE$.opts())).mapN((Function2 & Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    CrossProjectName[] names = (CrossProjectName[])tuple2._1();
                    BuildDiff.Options opts = (BuildDiff.Options)tuple2._2();
                    BuildDiff buildDiff = new BuildDiff(opts, names);
                    return buildDiff;
                }, (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("bloop", "show projects as seen by bloop", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)projectNames$1, BuildDiff$.MODULE$.opts())).mapN((Function2 & Serializable)(x0$2, x1$2) -> {
                    Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    CrossProjectName[] names = (CrossProjectName[])tuple2._1();
                    BuildDiff.Options opts = (BuildDiff.Options)tuple2._2();
                    BuildDiffBloop buildDiffBloop = new BuildDiffBloop(opts, names);
                    return buildDiffBloop;
                }, (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative()))})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("show", "show projects in their different versions.", Opts$.MODULE$.subcommand$default$3(), (Opts)NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("short", "the projects as you wrote it in YAML", Opts$.MODULE$.subcommand$default$3(), projectNamesNoCross$1.map((Function1 & Serializable)projects -> new BuildShow.Short((NonEmptyList<ProjectName>)projects))), Opts$.MODULE$.subcommand("exploded", "the cross projects as you wrote it in YAML after templates have been applied", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)projects -> new BuildShow.Exploded((CrossProjectName[])projects))), Opts$.MODULE$.subcommand("bloop", "the cross projects as they appear to bloop, that is with all absolute paths and so on", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)projects -> new BuildShow.Bloop((CrossProjectName[])projects)))})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative()))})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("compile", "compile projects", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)watch$1, (Object)projectNames$1)).mapN((Function2 & Serializable)(x0$3, x1$3) -> Main$.$anonfun$hasBuildOpts$18(BoxesRunTime.unboxToBoolean((Object)x0$3), x1$3), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("test", "test projects", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)watch$1, (Object)testProjectNames$1)).mapN((Function2 & Serializable)(x0$4, x1$4) -> Main$.$anonfun$hasBuildOpts$19(BoxesRunTime.unboxToBoolean((Object)x0$4), x1$4), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("run", "run project", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple4Semigroupal(new Tuple4((Object)projectName$1, (Object)mainClass$1, (Object)Opts$.MODULE$.arguments("arguments", Argument$.MODULE$.readString()).map((Function1 & Serializable)x$4 -> x$4.toList()).withDefault((Object)scala.package$.MODULE$.List().empty()), (Object)watch$1)).mapN((Function4 & Serializable)(x0$5, x1$5, x2$1, x3$1) -> Main$.$anonfun$hasBuildOpts$21(x0$5, x1$5, x2$1, BoxesRunTime.unboxToBoolean((Object)x3$1)), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative())), this.setupIdeCmd(started$1.buildPaths(), (TypedLogger<BoxedUnit>)started$1.logger(), (Option<Map<String, CrossProjectName[]>>)new Some((Object)started$1.globs().projectNameMap()), started$1.executionContext()), Opts$.MODULE$.subcommand("clean", "clean", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)projectNames -> new Clean(projectNames))), Opts$.MODULE$.subcommand("projects", "show projects under current directory", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)projectNames -> x$5 -> {
                    Right$ right$ = scala.package$.MODULE$.Right();
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])projectNames), (Function1 & Serializable)x$6 -> x$6.value(), ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)x$7 -> {
                        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)started$1.logger()), (Function0 & Serializable)() -> new Text((Object)x$7, "_"), Formatter$.MODULE$.StringFormatter(), new Line(173), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.hasBuildOpts ret allCommands"));
                        return BoxedUnit.UNIT;
                    });
                    return right$.apply((Object)BoxedUnit.UNIT);
                })), Opts$.MODULE$.subcommand("projects-test", "show test projects under current directory", Opts$.MODULE$.subcommand$default$3(), testProjectNames$1.map((Function1 & Serializable)projectNames -> x$8 -> {
                    Right$ right$ = scala.package$.MODULE$.Right();
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])projectNames), (Function1 & Serializable)x$9 -> x$9.value(), ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)x$10 -> {
                        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)started$1.logger()), (Function0 & Serializable)() -> new Text((Object)x$10, "_"), Formatter$.MODULE$.StringFormatter(), new Line(176), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.hasBuildOpts ret allCommands"));
                        return BoxedUnit.UNIT;
                    });
                    return right$.apply((Object)BoxedUnit.UNIT);
                })), this.configCommand((TypedLogger<BoxedUnit>)started$1.pre().logger(), started$1.pre().userPaths()), this.installTabCompletions((TypedLogger<BoxedUnit>)started$1.pre().logger()), Opts$.MODULE$.subcommand("publish-local", "publishes your project locally", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple5Semigroupal(new Tuple5((Object)Opts$.MODULE$.option("groupId", "organization you will publish under", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readString()), (Object)Opts$.MODULE$.option("version", "version you will publish", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readString()), (Object)Opts$.MODULE$.option("to", "publish to a maven repository at given path", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readPath()).orNone(), (Object)projectNames$1, (Object)watch$1)).mapN((Function5 & Serializable)(x0$6, x1$6, x2$2, x3$2, x4$1) -> Main$.$anonfun$hasBuildOpts$33(x0$6, x1$6, x2$2, x3$2, BoxesRunTime.unboxToBoolean((Object)x4$1)), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("dist", "creates a folder with a runnable distribution", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple4Semigroupal(new Tuple4((Object)projectName$1, (Object)mainClass$1, (Object)Opts$.MODULE$.argument("path", Argument$.MODULE$.readPath()).orNone(), (Object)watch$1)).mapN((Function4 & Serializable)(x0$7, x1$7, x2$3, x3$3) -> Main$.$anonfun$hasBuildOpts$34(started$1, x0$7, x1$7, x2$3, BoxesRunTime.unboxToBoolean((Object)x3$3)), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("fmt", "runs scalafmt", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.flag("check", "ensure that all files are already formatted", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4()).orFalse((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)check -> Main$.$anonfun$hasBuildOpts$35(BoxesRunTime.unboxToBoolean((Object)check))))})), (Iterable)started$1.build().scripts().map((Function1 & Serializable)x0$8 -> {
                    Tuple2 tuple2 = x0$8;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String scriptName = ((ScriptName)tuple2._1()).value();
                    Opts opts = Opts$.MODULE$.subcommand(scriptName, new StringBuilder(11).append("run script ").append(scriptName).toString(), Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)watch$1, MODULE$.stringArgs())).mapN((Function2 & Serializable)(x0$9, x1$8) -> Main$.$anonfun$hasBuildOpts$37(scriptName, BoxesRunTime.unboxToBoolean((Object)x0$9), x1$8), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative()));
                    return opts;
                })}));
                opts2 = (Opts)ret$lzy$1.initialize(package.apply$.MODULE$.catsSyntaxApply(this.commonOpts(), (Apply)Opts$.MODULE$.alternative()).$times$greater(NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(allCommands.flatten(Predef$.MODULE$.$conforms()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative())));
            }
            opts = opts2;
        }
        return opts;
    }

    private final Opts ret$1(LazyRef ret$lzy$1, Opts projectNames$1, Opts projectNamesNoCross$1, Opts watch$1, Opts testProjectNames$1, Opts projectName$1, Opts mainClass$1, Started started$1) {
        return ret$lzy$1.initialized() ? (Opts)ret$lzy$1.value() : this.ret$lzycompute$1(ret$lzy$1, projectNames$1, projectNamesNoCross$1, watch$1, testProjectNames$1, projectName$1, mainClass$1, started$1);
    }

    public static final /* synthetic */ Either bleep$Main$$$anonfun$configCommand$2(TypedLogger logger$1, UserPaths userPaths$1) {
        Right$ right$ = scala.package$.MODULE$.Right();
        LoggerFn.Syntax$.MODULE$.warn$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)logger$1), (Function0 & Serializable)() -> new Text((Object)new StringBuilder(24).append("Config file is found in ").append(userPaths$1.configYaml()).toString(), "s\"Config file is found in ${userPaths.configYaml}\""), Formatter$.MODULE$.StringFormatter(), new Line(237), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.configCommand"));
        return right$.apply((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$configCommand$7(BleepConfig x$12) {
    }

    public static final /* synthetic */ Either bleep$Main$$$anonfun$configCommand$5(TypedLogger logger$1, UserPaths userPaths$1) {
        return BleepConfigOps$.MODULE$.rewritePersisted(logger$1, userPaths$1, (Function1 & Serializable)x$11 -> {
            Some x$1 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Option x$2 = x$11.copy$default$1();
            Option x$3 = x$11.copy$default$2();
            return x$11.copy(x$2, x$3, (Option)x$1);
        }).map((Function1 & Serializable)x$12 -> {
            Main$.$anonfun$configCommand$7(x$12);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$configCommand$11(BleepConfig x$14) {
    }

    public static final /* synthetic */ Either bleep$Main$$$anonfun$configCommand$9(TypedLogger logger$1, UserPaths userPaths$1) {
        return BleepConfigOps$.MODULE$.rewritePersisted(logger$1, userPaths$1, (Function1 & Serializable)x$13 -> {
            Some x$4 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Option x$5 = x$13.copy$default$1();
            Option x$6 = x$13.copy$default$2();
            return x$13.copy(x$5, x$6, (Option)x$4);
        }).map((Function1 & Serializable)x$14 -> {
            Main$.$anonfun$configCommand$11(x$14);
            return BoxedUnit.UNIT;
        });
    }

    private final void go$1(String wantedVersion, TypedLogger logger$6, String[] args$1) {
        BleepCacheLogger cacheLogger = new BleepCacheLogger(logger$6);
        OsArch osArch = OsArch$.MODULE$.current();
        if (osArch instanceof OsArch.HasNativeImage) {
            OsArch.HasNativeImage hasNativeImage = (OsArch.HasNativeImage)osArch;
            boolean bl = false;
            Right right = null;
            Either either = FetchBleepRelease$.MODULE$.apply(wantedVersion, (CacheLogger)cacheLogger, (ExecutionContext)ExecutionContext$.MODULE$.global(), hasNativeImage);
            if (either instanceof Left) {
                Left left = (Left)either;
                BleepException buildException = (BleepException)left.value();
                throw fatal$.MODULE$.apply("couldn't download bleep release", logger$6, (Throwable)buildException);
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                Path binaryPath = (Path)right.value();
                Os os = OsArch$.MODULE$.current().os();
                Os.Windows$ windows$ = Os.Windows$.MODULE$;
                if (!(os == null ? windows$ != null : !os.equals(windows$)) || !this.isGraalvmNativeImage()) {
                    String string = ((Object)binaryPath).toString();
                    int status = Process$.MODULE$.apply((scala.collection.Seq)Predef$.MODULE$.wrapRefArray((Object[])args$1).toList().$colon$colon((Object)string), FileUtils$.MODULE$.cwd().toFile(), scala.sys.package$.MODULE$.env().toSeq()).$bang$less();
                    throw scala.sys.package$.MODULE$.exit(status);
                }
            }
            if (bl) {
                Path path = (Path)right.value();
                String string = ((Object)path).toString();
                Execve.execve((String)((Object)path).toString(), (String[])((String[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])args$1), (Object)string, ClassTag$.MODULE$.apply(String.class))), (String[])((String[])((IterableOnceOps)scala.sys.package$.MODULE$.env().map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringBuilder(1).append(k).append("=").append(v).toString();
                    return string;
                })).toArray(ClassTag$.MODULE$.apply(String.class))));
                throw scala.sys.package$.MODULE$.error("should not be reached");
            }
            throw new MatchError((Object)either);
        }
        throw fatal$.MODULE$.apply(new StringBuilder(0).append(new StringBuilder(106).append("No native image available for ").append(osArch).append(", so the bleep launcher cannot run the release requested by the build file. ").toString()).append("You can pass `--dev` to run the code you have and disregard the version wanted by the build. ").append("Otherwise see https://github.com/oyvindberg/bleep/issues/260 for how you can help out").toString(), logger$6);
    }

    public static final /* synthetic */ Text $anonfun$maybeRunWithDifferentVersion$2(String wantedVersion$1, BuildLoader.Existing x4$1) {
        return new Text((Object)new StringBuilder(70).append("Not launching Bleep version ").append(wantedVersion$1).append(" (from ").append(x4$1.bleepYaml()).append(") because you're running a snapshot").toString(), "s\"Not launching Bleep version ${wantedVersion.value} (from ${existing.bleepYaml}) because you're running a snapshot\"");
    }

    public static final /* synthetic */ Text $anonfun$maybeRunWithDifferentVersion$3(String wantedVersion$2, BuildLoader.Existing x4$1) {
        return new Text((Object)new StringBuilder(64).append("Not launching Bleep version ").append(wantedVersion$2).append(" (from ").append(x4$1.bleepYaml()).append(") because you specified --dev").toString(), "s\"Not launching Bleep version ${wantedVersion.value} (from ${existing.bleepYaml}) because you specified --dev\"");
    }

    public static final /* synthetic */ Text $anonfun$maybeRunWithDifferentVersion$4(String wantedVersion$3) {
        return new Text((Object)new StringBuilder(328).append("Launching Bleep version ").append(wantedVersion$3).append(" for ARM64 because you ran the AMD64 build. This is probably because you're running coursier compiled for AMD64. You can either try the coursier M1 runner at https://github.com/VirtusLab/coursier-m1 , or download and install bleep manually. Note that bleep will work this way, but startup will be slower.").toString(), "s\"Launching Bleep version ${wantedVersion.value} for ARM64 because you ran the AMD64 build. This is probably because you're running coursier compiled for AMD64. You can either try the coursier M1 runner at https://github.com/VirtusLab/coursier-m1 , or download and install bleep manually. Note that bleep will work this way, but startup will be slower.\"");
    }

    public static final /* synthetic */ Text $anonfun$maybeRunWithDifferentVersion$5(String wantedVersion$4, BuildLoader.Existing x4$1) {
        return new Text((Object)new StringBuilder(41).append("Launching Bleep version ").append(wantedVersion$4).append(" as requested in ").append(x4$1.bleepYaml()).toString(), "s\"Launching Bleep version ${wantedVersion.value} as requested in ${existing.bleepYaml}\"");
    }

    public static final /* synthetic */ void $anonfun$main$8(BuildLoader buildLoader$2, UserPaths userPaths$3, BuildPaths buildPaths$3, TypedLogger logger) {
        BoxedUnit boxedUnit;
        Either either = buildLoader$2.existing().map((Function1 & Serializable)existing -> new Prebootstrapped(logger, userPaths$3, buildPaths$3, existing));
        if (either instanceof Left) {
            Left left = (Left)either;
            BleepException be = (BleepException)left.value();
            throw fatal$.MODULE$.apply("", logger, (Throwable)be);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Prebootstrapped pre = (Prebootstrapped)right.value();
            try {
                BspImpl$.MODULE$.run(pre);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable th) {
                throw fatal$.MODULE$.apply("uncaught error", logger, th);
            }
        } else {
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final TypedLoggerResource stdoutAndFileLogging$1(BuildPaths buildPaths, boolean logAsJson$1, TypedLogger stdout$1) {
        TypedLoggerResource typedLoggerResource;
        if (logAsJson$1) {
            typedLoggerResource = package$.MODULE$.LoggerResource().pure(TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(stdout$1)));
        } else {
            TypedLoggerResource logFileResource = TypedLoggerResource.Ops$.MODULE$.map$extension(TypedLoggerResource$.MODULE$.Ops(package$.MODULE$.path(buildPaths.logFile(), (Pattern)LogPatterns.logFile$.MODULE$, package$.MODULE$.path$default$3())), (Function1 & Serializable)x$22 -> TypedLogger.LoggerFlushableSyntax$.MODULE$.flushing$extension(TypedLogger$.MODULE$.LoggerFlushableSyntax(x$22)));
            typedLoggerResource = TypedLoggerResource.Ops$.MODULE$.untyped$extension(TypedLoggerResource$.MODULE$.Ops(TypedLoggerResource.Ops$.MODULE$.zipWith$extension(TypedLoggerResource$.MODULE$.Ops(package$.MODULE$.LoggerResource().pure(stdout$1)), logFileResource)));
        }
        return typedLoggerResource;
    }

    public static final /* synthetic */ void $anonfun$main$13(UserPaths userPaths$3, BuildPaths buildPaths$4, BuildLoader.Existing x3$1, BleepConfig config$1, List restArgs$1, TypedLogger logger) {
        Prebootstrapped pre = new Prebootstrapped(logger, userPaths$3, buildPaths$4, x3$1);
        Either either = bootstrap$.MODULE$.from(pre, GenBloopFiles$.MODULE$.SyncToDisk(), (List)scala.package$.MODULE$.Nil(), config$1, (CoursierResolver.Factory)CoursierResolver.Factory$.default$.MODULE$, (ExecutionContext)ExecutionContext$.MODULE$.global());
        if (either instanceof Left) {
            Left left = (Left)either;
            BleepException th = (BleepException)left.value();
            throw fatal$.MODULE$.apply("Error while loading build", logger, (Throwable)th);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        Started started = (Started)right.value();
        MODULE$.run((TypedLogger<BoxedUnit>)logger, MODULE$.hasBuildOpts(started), started, (List<String>)restArgs$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Main$() {
    }
}

