/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BleepCacheLogger;
import bleep.BleepCommand;
import bleep.BleepConfigOps$;
import bleep.BleepException;
import bleep.BuildLoader;
import bleep.BuildLoader$;
import bleep.BuildPaths;
import bleep.BuildPaths$;
import bleep.CommonOpts;
import bleep.CommonOpts$;
import bleep.CoursierResolver;
import bleep.FetchBleepRelease$;
import bleep.GenBloopFiles$;
import bleep.Lazy;
import bleep.LogPatterns;
import bleep.Main$metavars$;
import bleep.Prebootstrapped;
import bleep.Started;
import bleep.UserPaths;
import bleep.UserPaths$;
import bleep.bootstrap$;
import bleep.bsp.BspImpl$;
import bleep.commands.BuildCreateDirectories;
import bleep.commands.BuildCreateNew;
import bleep.commands.BuildDiff;
import bleep.commands.BuildDiff$;
import bleep.commands.BuildMoveFilesIntoBleepLayout;
import bleep.commands.BuildReapplyTemplates;
import bleep.commands.BuildReinferTemplates;
import bleep.commands.BuildShow;
import bleep.commands.BuildUpdateDeps;
import bleep.commands.Clean;
import bleep.commands.Compile;
import bleep.commands.CompileServerSetMode;
import bleep.commands.CompileServerStopAll;
import bleep.commands.Dist;
import bleep.commands.Import;
import bleep.commands.Import$;
import bleep.commands.InstallTabCompletions;
import bleep.commands.PublishLocal;
import bleep.commands.Run;
import bleep.commands.Scalafmt;
import bleep.commands.Script;
import bleep.commands.SetupIde;
import bleep.commands.Test;
import bleep.constants$;
import bleep.internal.Os$;
import bleep.internal.fatal$;
import bleep.logging.Formatter$;
import bleep.logging.LogLevel;
import bleep.logging.LoggerFn;
import bleep.logging.LoggerFn$;
import bleep.logging.Pattern;
import bleep.logging.TypedLogger;
import bleep.logging.TypedLogger$;
import bleep.logging.TypedLoggerResource;
import bleep.logging.TypedLoggerResource$;
import bleep.logging.jsonEvents$;
import bleep.logging.package$;
import bleep.model.BleepVersion;
import bleep.model.BleepVersion$;
import bleep.model.BuildFile;
import bleep.model.CompileServerMode;
import bleep.model.CrossProjectName;
import bleep.model.PlatformId;
import bleep.model.PlatformId$;
import bleep.model.ProjectName;
import bleep.model.ScriptName;
import bleep.model.VersionScala;
import bleep.model.VersionScala$;
import bleep.package;
import bleep.packaging.PublishLayout;
import cats.Apply;
import cats.Foldable;
import cats.Functor;
import cats.MonoidK;
import cats.Semigroupal;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.syntax.NestedFoldableOps$;
import cats.syntax.package;
import com.monovore.decline.Argument;
import com.monovore.decline.Argument$;
import com.monovore.decline.Command$;
import com.monovore.decline.Completer;
import com.monovore.decline.Completer$;
import com.monovore.decline.Help;
import com.monovore.decline.Opts;
import com.monovore.decline.Opts$;
import com.monovore.decline.Visibility;
import coursier.cache.CacheLogger;
import coursier.jniutils.LoadWindowsLibrary;
import coursier.jvm.Execve;
import coursier.jvm.JvmIndex$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.Process$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Text;

public final class Main$ {
    public static final Main$ MODULE$ = new Main$();
    private static final Opts<List<String>> stringArgs;
    private static final Map<String, VersionScala> possibleScalaVersions;

    static {
        if (Properties$.MODULE$.isWin() && MODULE$.isGraalvmNativeImage()) {
            LoadWindowsLibrary.assumeInitialized();
        }
        stringArgs = Opts$.MODULE$.arguments(Opts$.MODULE$.arguments$default$1(), Argument$.MODULE$.readString()).orNone().map((Function1 & Serializable)args -> (List)args.fold((Function0 & Serializable)() -> scala.package$.MODULE$.List().empty(), (Function1 & Serializable)x$1 -> x$1.toList()));
        possibleScalaVersions = ((List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new VersionScala[]{VersionScala$.MODULE$.Scala3(), VersionScala$.MODULE$.Scala213(), VersionScala$.MODULE$.Scala212()}))).map((Function1 & Serializable)v -> new Tuple2((Object)v.binVersion().replace("\\.", ""), v)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean isGraalvmNativeImage() {
        return scala.sys.package$.MODULE$.props().contains("org.graalvm.nativeimage.imagecode");
    }

    public Opts<List<String>> stringArgs() {
        return stringArgs;
    }

    public Map<String, VersionScala> possibleScalaVersions() {
        return possibleScalaVersions;
    }

    public Opts<BleepCommand> noBuildOpts(TypedLogger<BoxedUnit> logger, BuildPaths buildPaths, BuildLoader.NonExisting buildLoader, UserPaths userPaths) {
        return (Opts)package.apply$.MODULE$.catsSyntaxApply(CommonOpts$.MODULE$.opts(), (Apply)Opts$.MODULE$.alternative()).$times$greater(NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("build", "create new build", Opts$.MODULE$.subcommand$default$3(), this.newCommand(logger, buildPaths.cwd())), this.importCmd((BuildLoader)buildLoader, buildPaths, logger), this.compileServerCmd(logger, userPaths), this.installTabCompletions(logger)})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative()));
    }

    public <A> Argument<A> argumentFrom(String defmeta, Option<Map<String, A>> nameToValue) {
        return Argument$.MODULE$.fromMap(defmeta, (Map)nameToValue.getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()));
    }

    public Opts<BleepCommand> hasBuildOpts(Started started) {
        LazyRef ret$lzy = new LazyRef();
        Opts projectNamesNoCross = Opts$.MODULE$.arguments(Main$metavars$.MODULE$.projectNameNoCross(), this.argumentFrom(Main$metavars$.MODULE$.projectNameNoCross(), (Option)new Some((Object)started.globs().projectNamesNoCrossMap())));
        Opts projectNames = Opts$.MODULE$.arguments(Main$metavars$.MODULE$.projectName(), this.argumentFrom(Main$metavars$.MODULE$.projectName(), (Option)new Some((Object)started.globs().projectNameMap()))).map((Function1 & Serializable)x$2 -> (CrossProjectName[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])x$2.toList().toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(CrossProjectName.class)))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(CrossProjectName.class))).orNone().map((Function1 & Serializable)maybeFromCommandLine -> started.chosenProjects(maybeFromCommandLine));
        Opts projectName = Opts$.MODULE$.argument(Main$metavars$.MODULE$.projectNameExact(), this.argumentFrom(Main$metavars$.MODULE$.projectNameExact(), (Option)new Some((Object)started.globs().exactProjectMap())));
        Opts testProjectNames = Opts$.MODULE$.arguments(Main$metavars$.MODULE$.testProjectName(), this.argumentFrom(Main$metavars$.MODULE$.testProjectName(), (Option)new Some((Object)started.globs().testProjectNameMap()))).map((Function1 & Serializable)x$3 -> (CrossProjectName[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])x$3.toList().toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(CrossProjectName.class)))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(CrossProjectName.class))).orNone().map((Function1 & Serializable)maybeFromCommandLine -> started.chosenTestProjects(maybeFromCommandLine));
        Opts mainClass = Opts$.MODULE$.option("class", "explicitly override main class. If not set, bleep will first look in the build file, then fall back to looking into compiled class files", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readString()).orNone();
        return this.ret$1(ret$lzy, started, projectNames, projectNamesNoCross, testProjectNames, projectName, mainClass);
    }

    public Opts<BleepCommand> compileServerCmd(TypedLogger<BoxedUnit> logger, UserPaths userPaths) {
        return Opts$.MODULE$.subcommand("compile-server", "You can speed up normal usage by keeping the bloop compile server running between invocations. This is where you control it", Opts$.MODULE$.subcommand$default$3(), (Opts)NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("auto-shutdown-disable", "leave compile servers running between bleep invocations. this gets much better performance at the cost of memory", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new CompileServerSetMode(logger, userPaths, (CompileServerMode)CompileServerMode.Shared$.MODULE$))), Opts$.MODULE$.subcommand("auto-shutdown-enable", "shuts down compile server after between bleep invocation. this is slower, but conserves memory", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new CompileServerSetMode(logger, userPaths, (CompileServerMode)CompileServerMode.NewEachInvocation$.MODULE$))), Opts$.MODULE$.subcommand("stop-all", "will stop all shared bloop compile servers", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new CompileServerStopAll(logger, userPaths)))})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative()));
    }

    public Opts<BleepCommand> importCmd(BuildLoader buildLoader, BuildPaths buildPaths, TypedLogger<BoxedUnit> logger) {
        return Opts$.MODULE$.subcommand("import", "import existing build from files in .bloop", Opts$.MODULE$.subcommand$default$3(), Import$.MODULE$.opts().map((Function1 & Serializable)opts -> {
            Option existingBuild = buildLoader.existing().flatMap((Function1 & Serializable)x$9 -> (Either)x$9.buildFile().forceGet()).toOption();
            return new Import((Option<BuildFile>)existingBuild, buildPaths.cwd(), buildPaths, logger, (Import.Options)opts, BleepVersion$.MODULE$.current());
        }));
    }

    public Opts<BleepCommand> installTabCompletions(TypedLogger<BoxedUnit> logger) {
        return Opts$.MODULE$.subcommand("install-tab-completions-bash", "Install tab completions for bash", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new InstallTabCompletions(logger)));
    }

    public Opts<BleepCommand> setupIdeCmd(BuildPaths buildPaths, TypedLogger<BoxedUnit> logger, Option<Map<String, CrossProjectName[]>> projectNameMap) {
        Opts projectNamesNoExpand = Opts$.MODULE$.arguments(Main$metavars$.MODULE$.projectName(), this.argumentFrom(Main$metavars$.MODULE$.projectName(), projectNameMap.map((Function1 & Serializable)x$10 -> (Map)x$10.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String s = (String)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)s, (Object)s);
            return tuple22;
        })))).map((Function1 & Serializable)x$11 -> x$11.toList()).orNone();
        return Opts$.MODULE$.subcommand("setup-ide", "generate ./bsp/bleep.json so IDEs can import build", Opts$.MODULE$.subcommand$default$3(), projectNamesNoExpand.map((Function1 & Serializable)projectNames -> new SetupIde(buildPaths, logger, (Option<List<String>>)projectNames)));
    }

    public Opts<BleepCommand> newCommand(TypedLogger<BoxedUnit> logger, Path cwd) {
        String x$1 = "platform";
        String x$2 = "specify wanted platform(s)";
        String x$3 = Main$metavars$.MODULE$.platformName();
        String x$4 = "p";
        Visibility x$5 = Opts$.MODULE$.options$default$5();
        Argument x$6 = Argument$.MODULE$.fromMap(Main$metavars$.MODULE$.platformName(), PlatformId$.MODULE$.All().map((Function1 & Serializable)p -> new Tuple2((Object)p.value(), p)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return Opts$.MODULE$.subcommand("new", "create new build in current directory", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3((Object)Opts$.MODULE$.options("platform", "specify wanted platform(s)", "p", x$3, x$5, x$6).withDefault((Object)NonEmptyList$.MODULE$.of((Object)PlatformId.Jvm$.MODULE$, (scala.collection.immutable.Seq)Nil$.MODULE$)), (Object)Opts$.MODULE$.options("scala", "specify scala version(s)", "s", Main$metavars$.MODULE$.scalaVersion(), Opts$.MODULE$.options$default$5(), Argument$.MODULE$.fromMap(Main$metavars$.MODULE$.scalaVersion(), this.possibleScalaVersions())).withDefault((Object)NonEmptyList$.MODULE$.of((Object)VersionScala$.MODULE$.Scala3(), (scala.collection.immutable.Seq)Nil$.MODULE$)), (Object)Opts$.MODULE$.argument("wanted project name", Argument$.MODULE$.readString()))).mapN((Function3 & Serializable)(x0$1, x1$1, x2$1) -> {
            Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            NonEmptyList platforms = (NonEmptyList)tuple3._1();
            NonEmptyList scalas = (NonEmptyList)tuple3._2();
            String name = (String)tuple3._3();
            BuildCreateNew buildCreateNew = new BuildCreateNew(logger, cwd, (NonEmptyList<PlatformId>)platforms, (NonEmptyList<VersionScala>)scalas, name, BleepVersion$.MODULE$.current(), (CoursierResolver.Factory)CoursierResolver.Factory$.default$.MODULE$);
            return buildCreateNew;
        }, (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path cwdFor(CommonOpts opts) {
        boolean bl = false;
        Some some = null;
        Option<String> option = opts.directory();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String str = (String)some.value();
            if (str.startsWith("/")) {
                return Paths.get(str, new String[0]);
            }
        }
        if (bl) {
            String str = (String)some.value();
            return package.PathOps$.MODULE$.$div$extension(bleep.package$.MODULE$.PathOps(Os$.MODULE$.cwd()), str);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return Os$.MODULE$.cwd();
    }

    /*
     * Unable to fully structure code
     */
    public void maybeRunWithDifferentVersion(String[] args, BuildLoader buildLoader, TypedLogger<BoxedUnit> logger, CommonOpts opts) {
        block9: {
            block10: {
                block13: {
                    block14: {
                        block11: {
                            block12: {
                                block8: {
                                    var8_5 = buildLoader;
                                    if (!(var8_5 instanceof BuildLoader.NonExisting)) break block8;
                                    var5_6 = BoxedUnit.UNIT;
                                    break block9;
                                }
                                if (!(var8_5 instanceof BuildLoader.Existing)) break block10;
                                var9_8 = (BuildLoader.Existing)var8_5;
                                var10_9 = false;
                                var11_10 = null;
                                var12_11 = (Either)var9_8.wantedVersion().forceGet();
                                if (!(var12_11 instanceof Right)) break block11;
                                var10_9 = true;
                                var11_10 = (Right)var12_11;
                                wantedVersion = ((BleepVersion)var11_10.value()).value();
                                v0 = BleepVersion$.MODULE$.current();
                                var14_13 = wantedVersion;
                                if (!(v0 == null ? var14_13 != null : v0.equals(var14_13) == false)) break block12;
                                v1 = wantedVersion;
                                var15_14 = BleepVersion$.MODULE$.dev();
                                if (v1 != null ? v1.equals(var15_14) == false : var15_14 != null) break block11;
                            }
                            var6_15 = BoxedUnit.UNIT;
                            break block13;
                        }
                        if (!var10_9) break block14;
                        wantedVersion = ((BleepVersion)var11_10.value()).value();
                        if (!BleepVersion$.MODULE$.isDevelopment$extension(BleepVersion$.MODULE$.current())) break block14;
                        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$maybeRunWithDifferentVersion$1(java.lang.String bleep.BuildLoader$Existing ), ()Lsourcecode/Text;)((String)wantedVersion, (BuildLoader.Existing)var9_8), Formatter$.MODULE$.StringFormatter(), new Line(294), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.maybeRunWithDifferentVersion"));
                        var6_16 = BoxedUnit.UNIT;
                        break block13;
                    }
                    if (!var10_9) ** GOTO lbl-1000
                    wantedVersion = ((BleepVersion)var11_10.value()).value();
                    if (opts.dev()) {
                        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$maybeRunWithDifferentVersion$2(java.lang.String bleep.BuildLoader$Existing ), ()Lsourcecode/Text;)((String)wantedVersion, (BuildLoader.Existing)var9_8), Formatter$.MODULE$.StringFormatter(), new Line(296), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.maybeRunWithDifferentVersion"));
                        var6_17 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (var10_9) {
                            wantedVersion = ((BleepVersion)var11_10.value()).value();
                            LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax(logger), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$maybeRunWithDifferentVersion$3(java.lang.String bleep.BuildLoader$Existing ), ()Lsourcecode/Text;)((String)wantedVersion, (BuildLoader.Existing)var9_8), Formatter$.MODULE$.StringFormatter(), new Line(298), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.maybeRunWithDifferentVersion"));
                            cacheLogger = new BleepCacheLogger(logger);
                            var20_22 = false;
                            var21_23 = null;
                            var22_24 = FetchBleepRelease$.MODULE$.apply(wantedVersion, (CacheLogger)cacheLogger, (ExecutionContext)ExecutionContext$.MODULE$.global());
                            if (var22_24 instanceof Left) {
                                var23_25 = (Left)var22_24;
                                buildException = (BleepException)var23_25.value();
                                throw fatal$.MODULE$.apply("", logger, (Throwable)buildException);
                            }
                            if (var22_24 instanceof Right) {
                                var20_22 = true;
                                var21_23 = (Right)var22_24;
                                binaryPath = (Path)var21_23.value();
                                if (JvmIndex$.MODULE$.currentOs().contains((Object)"windows")) {
                                    var27_28 = binaryPath.toString();
                                    status = Process$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])args).toList().$colon$colon((Object)var27_28), Os$.MODULE$.cwd().toFile(), scala.sys.package$.MODULE$.env().toSeq()).$bang$less();
                                    throw scala.sys.package$.MODULE$.exit(status);
                                }
                            }
                            if (var20_22) {
                                path = (Path)var21_23.value();
                                var29_31 = path.toString();
                                Execve.execve((String)path.toString(), (String[])((String[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Object)var29_31, ClassTag$.MODULE$.apply(String.class))), (String[])((String[])((IterableOnceOps)scala.sys.package$.MODULE$.env().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$maybeRunWithDifferentVersion$4(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/String;)())).toArray(ClassTag$.MODULE$.apply(String.class))));
                                throw scala.sys.package$.MODULE$.error("should not be reached");
                            }
                            throw new MatchError((Object)var22_24);
                        }
                        if (var12_11 instanceof Left) {
                            var30_32 = (Left)var12_11;
                            throwable = (Exception)var30_32.value();
                            throw fatal$.MODULE$.apply("Couldn't load build", logger, (Throwable)throwable);
                        }
                        throw new MatchError((Object)var12_11);
                    }
                }
                var5_7 = BoxedUnit.UNIT;
                break block9;
            }
            throw new MatchError((Object)var8_5);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void main(String[] _args) {
        TypedLogger typedLogger;
        UserPaths userPaths = UserPaths$.MODULE$.fromAppDirs();
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = Predef$.MODULE$.wrapRefArray((Object[])_args).toList();
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list2 = colon2.next$access$1();
            if ("_complete".equals(string) && list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                String compLine = (String)colon3.head();
                List list3 = colon3.next$access$1();
                if (list3 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list3;
                    String compCword = (String)colon4.head();
                    List list4 = colon4.next$access$1();
                    if (list4 instanceof .colon.colon) {
                        Completer.Res res;
                        CommonOpts commonOpts;
                        List restArgs;
                        .colon.colon colon5 = (.colon.colon)list4;
                        String compPoint = (String)colon5.head();
                        List<String> args = Completer$.MODULE$.bashToArgs(compLine, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(compCword)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(compPoint)));
                        Tuple2<CommonOpts, List<String>> tuple2 = CommonOpts$.MODULE$.parse(args);
                        if (tuple2 == null) throw new MatchError(tuple2);
                        List list5 = restArgs = (List)tuple2._2();
                        List restArgs2 = list5;
                        Tuple2<CommonOpts, List<String>> tuple22 = CommonOpts$.MODULE$.parse((List<String>)Predef$.MODULE$.wrapRefArray((Object[])compLine.split(" ")).toList());
                        if (tuple22 == null) throw new MatchError(tuple22);
                        CommonOpts commonOpts2 = commonOpts = (CommonOpts)tuple22._1();
                        CommonOpts commonOpts3 = commonOpts2;
                        Path cwd = this.cwdFor(commonOpts3);
                        TypedLogger logger2 = TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(TypedLogger.LoggerAuxSyntax$.MODULE$.filter$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(package$.MODULE$.stderr((Pattern)LogPatterns.logFile$.MODULE$, package$.MODULE$.stderr$default$2())), (LogLevel)LogLevel.warn$.MODULE$)));
                        BuildLoader buildLoader = BuildLoader$.MODULE$.find(cwd);
                        this.maybeRunWithDifferentVersion(_args, buildLoader, (TypedLogger<BoxedUnit>)logger2, commonOpts3);
                        BuildPaths buildPaths = BuildPaths$.MODULE$.apply(cwd, buildLoader, (BuildPaths.Mode)BuildPaths.Mode$.Normal$.MODULE$);
                        BuildLoader buildLoader2 = buildLoader;
                        if (buildLoader2 instanceof BuildLoader.NonExisting) {
                            BuildLoader.NonExisting nonExisting = (BuildLoader.NonExisting)buildLoader2;
                            Completer completer = new Completer((Function1<String, List<String>>)(Function1 & Serializable)x0$1 -> {
                                Object object;
                                String string = x0$1;
                                String string2 = Main$metavars$.MODULE$.platformName();
                                String string3 = string;
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    object = PlatformId$.MODULE$.All().map((Function1 & Serializable)x$12 -> x$12.value());
                                } else {
                                    String string4 = Main$metavars$.MODULE$.scalaVersion();
                                    String string5 = string;
                                    object = !(string4 != null ? !string4.equals(string5) : string5 != null) ? MODULE$.possibleScalaVersions().keys().toList() : scala.package$.MODULE$.Nil();
                                }
                                return object;
                            });
                            res = completer.completeOpts((List<String>)restArgs2, this.noBuildOpts((TypedLogger<BoxedUnit>)logger2, buildPaths, nonExisting, userPaths));
                        } else {
                            if (!(buildLoader2 instanceof BuildLoader.Existing)) throw new MatchError((Object)buildLoader2);
                            BuildLoader.Existing existing = (BuildLoader.Existing)buildLoader2;
                            Prebootstrapped pre = new Prebootstrapped(logger2, userPaths, buildPaths, existing);
                            Lazy bleepConfig = BleepConfigOps$.MODULE$.lazyForceLoad(pre.userPaths());
                            Either either = bootstrap$.MODULE$.from(pre, GenBloopFiles$.MODULE$.SyncToDisk(), (List)scala.package$.MODULE$.Nil(), bleepConfig, (CoursierResolver.Factory)CoursierResolver.Factory$.default$.MODULE$);
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                BleepException th = (BleepException)left.value();
                                throw fatal$.MODULE$.apply("couldn't load build", logger2, (Throwable)th);
                            }
                            if (!(either instanceof Right)) throw new MatchError((Object)either);
                            Right right = (Right)either;
                            Started started = (Started)right.value();
                            Completer completer = new Completer((Function1<String, List<String>>)(Function1 & Serializable)x0$2 -> {
                                Object object;
                                String string = x0$2;
                                String string2 = Main$metavars$.MODULE$.platformName();
                                String string3 = string;
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    object = PlatformId$.MODULE$.All().map((Function1 & Serializable)x$13 -> x$13.value());
                                } else {
                                    String string4 = Main$metavars$.MODULE$.scalaVersion();
                                    String string5 = string;
                                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                                        object = MODULE$.possibleScalaVersions().keys().toList();
                                    } else {
                                        String string6 = Main$metavars$.MODULE$.projectNameExact();
                                        String string7 = string;
                                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                                            object = started.globs().exactProjectMap().keys().toList();
                                        } else {
                                            String string8 = Main$metavars$.MODULE$.projectNameNoCross();
                                            String string9 = string;
                                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                                object = started.globs().projectNamesNoCrossMap().keys().toList();
                                            } else {
                                                String string10 = Main$metavars$.MODULE$.projectName();
                                                String string11 = string;
                                                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                                    object = started.globs().projectNameMap().keys().toList();
                                                } else {
                                                    String string12 = Main$metavars$.MODULE$.testProjectName();
                                                    String string13 = string;
                                                    object = !(string12 != null ? !string12.equals(string13) : string13 != null) ? started.globs().testProjectNameMap().keys().toList() : scala.package$.MODULE$.Nil();
                                                }
                                            }
                                        }
                                    }
                                }
                                return object;
                            });
                            Completer.Res res2 = completer.completeOpts((List<String>)restArgs2, this.hasBuildOpts(started));
                            res = res2;
                        }
                        Completer.Res completions = res;
                        completions.value().foreach((Function1 & Serializable)c -> {
                            Predef$.MODULE$.println((Object)c.value());
                            return BoxedUnit.UNIT;
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
        }
        if (bl) {
            String string = (String)colon2.head();
            List args = colon2.next$access$1();
            if ("bsp".equals(string)) {
                CommonOpts commonOpts;
                Tuple2<CommonOpts, List<String>> tuple2 = CommonOpts$.MODULE$.parse((List<String>)args);
                if (tuple2 == null) throw new MatchError(tuple2);
                CommonOpts commonOpts4 = commonOpts = (CommonOpts)tuple2._1();
                CommonOpts commonOpts5 = commonOpts4;
                Path cwd = this.cwdFor(commonOpts5);
                TypedLogger stderr = TypedLogger.LoggerAuxSyntax$.MODULE$.filter$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(package$.MODULE$.stderr((Pattern)LogPatterns.logFile$.MODULE$, package$.MODULE$.stderr$default$2())), (LogLevel)LogLevel.warn$.MODULE$);
                BuildLoader buildLoader = BuildLoader$.MODULE$.find(cwd);
                this.maybeRunWithDifferentVersion(_args, buildLoader, (TypedLogger<BoxedUnit>)TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(stderr)), commonOpts5);
                BuildPaths buildPaths = BuildPaths$.MODULE$.apply(cwd, buildLoader, (BuildPaths.Mode)BuildPaths.Mode$.BSP$.MODULE$);
                TypedLoggerResource logFileResource = package$.MODULE$.path(buildPaths.logFile(), (Pattern)LogPatterns.logFile$.MODULE$, package$.MODULE$.path$default$3());
                TypedLoggerResource logResource = TypedLoggerResource.Ops$.MODULE$.untyped$extension(TypedLoggerResource$.MODULE$.Ops(TypedLoggerResource.Ops$.MODULE$.map$extension(TypedLoggerResource$.MODULE$.Ops(logFileResource), (Function1 & Serializable)logFile -> TypedLogger.LoggerAuxSyntax$.MODULE$.zipWith$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(TypedLogger.LoggerFlushableSyntax$.MODULE$.flushing$extension(TypedLogger$.MODULE$.LoggerFlushableSyntax(logFile))), stderr))));
                BoxedUnit boxedUnit = (BoxedUnit)logResource.use((Function1 & Serializable)logger -> {
                    Main$.$anonfun$main$7(buildLoader, userPaths, buildPaths, logger);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        boolean logAsJson = scala.sys.package$.MODULE$.env().contains((Object)jsonEvents$.MODULE$.CallerProcessAcceptsJsonEvents());
        Tuple2<CommonOpts, List<String>> tuple2 = CommonOpts$.MODULE$.parse((List<String>)list);
        if (tuple2 == null) throw new MatchError(tuple2);
        CommonOpts commonOpts = (CommonOpts)tuple2._1();
        List restArgs = (List)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)commonOpts, (Object)restArgs);
        Tuple2 tuple24 = tuple23;
        CommonOpts commonOpts6 = (CommonOpts)tuple24._1();
        List restArgs3 = (List)tuple24._2();
        Path cwd = this.cwdFor(commonOpts6);
        if (logAsJson) {
            typedLogger = package$.MODULE$.stdoutJson(package$.MODULE$.stdoutJson$default$1());
        } else {
            LogPatterns.interface pattern = new LogPatterns.interface(Instant.now(), commonOpts6.noColor());
            typedLogger = TypedLogger.LoggerAuxSyntax$.MODULE$.filter$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(package$.MODULE$.stdout((Pattern)pattern, package$.MODULE$.stdout$default$2())), (LogLevel)(commonOpts6.debug() ? LogLevel.debug$.MODULE$ : LogLevel.info$.MODULE$));
        }
        TypedLogger stdout = typedLogger;
        BuildLoader buildLoader = BuildLoader$.MODULE$.find(cwd);
        this.maybeRunWithDifferentVersion(_args, buildLoader, (TypedLogger<BoxedUnit>)TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(stdout)), commonOpts6);
        BuildPaths buildPaths = BuildPaths$.MODULE$.apply(cwd, buildLoader, (BuildPaths.Mode)BuildPaths.Mode$.Normal$.MODULE$);
        BuildLoader buildLoader3 = buildLoader;
        if (buildLoader3 instanceof BuildLoader.NonExisting) {
            BuildLoader.NonExisting nonExisting = (BuildLoader.NonExisting)buildLoader3;
            BoxedUnit boxedUnit = (BoxedUnit)Main$.stdoutAndFileLogging$1(buildPaths, logAsJson, stdout).use((Function1 & Serializable)logger -> {
                Main$.MODULE$.run((TypedLogger<BoxedUnit>)logger, Main$.MODULE$.noBuildOpts((TypedLogger<BoxedUnit>)TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(stdout)), buildPaths, nonExisting, userPaths), (List<String>)restArgs3);
                return BoxedUnit.UNIT;
            });
        } else {
            if (!(buildLoader3 instanceof BuildLoader.Existing)) throw new MatchError((Object)buildLoader3);
            BuildLoader.Existing existing = (BuildLoader.Existing)buildLoader3;
            BoxedUnit boxedUnit = (BoxedUnit)Main$.stdoutAndFileLogging$1(buildPaths, logAsJson, stdout).use((Function1 & Serializable)logger -> {
                Main$.$anonfun$main$11(userPaths, buildPaths, existing, restArgs3, logger);
                return BoxedUnit.UNIT;
            });
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(TypedLogger<BoxedUnit> logger, Opts<BleepCommand> opts, List<String> restArgs) {
        Either either = Command$.MODULE$.apply("bleep", new StringBuilder(31).append("Bleeping fast build! (version ").append(BleepVersion$.MODULE$.current()).append(")").toString(), Command$.MODULE$.apply$default$3(), opts).parse(restArgs, scala.sys.package$.MODULE$.env());
        if (either instanceof Left) {
            Left left = (Left)either;
            Help help = (Help)left.value();
            System.err.println(help);
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Either either2;
            Right right = (Right)either;
            BleepCommand cmd = (BleepCommand)right.value();
            boolean bl = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> cmd.run());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable th = failure.exception();
                throw fatal$.MODULE$.apply("command failed", logger, th);
            }
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Either either3 = (Either)success.value();
                if (either3 instanceof Left) {
                    Left left = (Left)either3;
                    BleepException th = (BleepException)left.value();
                    throw fatal$.MODULE$.apply("command failed", logger, (Throwable)th);
                }
            }
            if (!bl || !((either2 = (Either)success.value()) instanceof Right)) {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ BleepCommand $anonfun$hasBuildOpts$31(Started started$1, String x0$2, String x1$2, Option x2$2, boolean x3$1, CrossProjectName[] x4$1) {
        PublishLocal.LocalIvy$ localIvy$;
        Tuple5 tuple5 = new Tuple5((Object)x0$2, (Object)x1$2, (Object)x2$2, (Object)BoxesRunTime.boxToBoolean((boolean)x3$1), (Object)x4$1);
        if (tuple5 == null) throw new MatchError((Object)tuple5);
        String groupId = (String)tuple5._1();
        String version = (String)tuple5._2();
        Option to = (Option)tuple5._3();
        boolean mavenLayout = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        CrossProjectName[] projects = (CrossProjectName[])tuple5._5();
        Option option = to;
        if (option instanceof Some) {
            Some some = (Some)option;
            Path path = (Path)some.value();
            PublishLayout.Ivy$ publishLayout = mavenLayout ? new PublishLayout.Maven(PublishLayout.Maven$.MODULE$.apply$default$1()) : PublishLayout.Ivy$.MODULE$;
            localIvy$ = new PublishLocal.Custom(path, (PublishLayout)publishLayout);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            if (mavenLayout) {
                throw new BleepException.Text("cannot provide --maven-layout without specifying --to");
            }
            localIvy$ = PublishLocal.LocalIvy$.MODULE$;
        }
        PublishLocal.LocalIvy$ publishTarget = localIvy$;
        PublishLocal.Options options = new PublishLocal.Options(groupId, version, (PublishLocal.PublishTarget)publishTarget, Predef$.MODULE$.wrapRefArray((Object[])projects).toList());
        return new PublishLocal(started$1, options);
    }

    public static final /* synthetic */ Scalafmt $anonfun$hasBuildOpts$33(Started started$1, boolean check) {
        return new Scalafmt(started$1, check);
    }

    private final /* synthetic */ Opts ret$lzycompute$1(LazyRef ret$lzy$1, Started started$1, Opts projectNames$1, Opts projectNamesNoCross$1, Opts testProjectNames$1, Opts projectName$1, Opts mainClass$1) {
        Opts opts2;
        LazyRef lazyRef = ret$lzy$1;
        synchronized (lazyRef) {
            Opts opts3;
            if (ret$lzy$1.initialized()) {
                opts3 = (Opts)ret$lzy$1.value();
            } else {
                List allCommands = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{(Iterable)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("build", "rewrite build", Opts$.MODULE$.subcommand$default$3(), (Opts)NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{this.newCommand((TypedLogger<BoxedUnit>)started$1.logger(), started$1.buildPaths().cwd()), Opts$.MODULE$.subcommand("create-directories", "create all source and resource folders for project(s)", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)names -> new BuildCreateDirectories(started$1, (CrossProjectName[])names))), Opts$.MODULE$.subcommand("templates-reapply", "apply existing templates again", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new BuildReapplyTemplates(started$1))), Opts$.MODULE$.subcommand("templates-generate-new", "throw away existing templates and infer new", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new BuildReinferTemplates(started$1, (Set<ProjectName>)Predef$.MODULE$.Set().empty()))), Opts$.MODULE$.subcommand("update-deps", "updates to newest versions of all dependencies", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new BuildUpdateDeps(started$1))), Opts$.MODULE$.subcommand("move-files-into-bleep-layout", "move source files around from sbt file layout to bleep layout. Your build will no longer have any `sbt-scope` or `folder` set.", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.apply((Function0 & Serializable)() -> new BuildMoveFilesIntoBleepLayout(started$1))), Opts$.MODULE$.subcommand("diff", "diff exploded projects compared to git HEAD or wanted revision", Opts$.MODULE$.subcommand$default$3(), BuildDiff$.MODULE$.opts().map((Function1 & Serializable)opts -> new BuildDiff(started$1, (BuildDiff.Options)opts))), Opts$.MODULE$.subcommand("show", "show projects in their different versions.", Opts$.MODULE$.subcommand$default$3(), (Opts)NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opts[]{Opts$.MODULE$.subcommand("short", "the projects as you wrote it in YAML", Opts$.MODULE$.subcommand$default$3(), projectNamesNoCross$1.map((Function1 & Serializable)names -> new BuildShow.Short(started$1, (NonEmptyList<ProjectName>)names))), Opts$.MODULE$.subcommand("exploded", "the cross projects as you wrote it in YAML after templates have been applied", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)names -> new BuildShow.Exploded(started$1, (CrossProjectName[])names))), Opts$.MODULE$.subcommand("bloop", "the cross projects as they appear to bloop, that is with all absolute paths and so on", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)names -> new BuildShow.Bloop(started$1, (CrossProjectName[])names)))})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative()))})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("compile", "compile projects", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)projectNames -> new Compile(started$1, projectNames))), Opts$.MODULE$.subcommand("test", "test projects", Opts$.MODULE$.subcommand$default$3(), testProjectNames$1.map((Function1 & Serializable)projectNames -> new Test(started$1, projectNames))), Opts$.MODULE$.subcommand("run", "run project", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3((Object)projectName$1, (Object)mainClass$1, (Object)Opts$.MODULE$.arguments("arguments", Argument$.MODULE$.readString()).map((Function1 & Serializable)x$4 -> x$4.toList()).withDefault((Object)scala.package$.MODULE$.List().empty()))).mapN((Function3 & Serializable)(x0$1, x1$1, x2$1) -> {
                    Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    CrossProjectName projectName = (CrossProjectName)tuple3._1();
                    Option mainClass = (Option)tuple3._2();
                    List arguments = (List)tuple3._3();
                    Run run = new Run(started$1, projectName, mainClass, arguments);
                    return run;
                }, (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative())), this.setupIdeCmd(started$1.buildPaths(), (TypedLogger<BoxedUnit>)started$1.logger(), (Option<Map<String, CrossProjectName[]>>)new Some((Object)started$1.globs().projectNameMap())), Opts$.MODULE$.subcommand("clean", "clean", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)projectNames -> new Clean(started$1, projectNames))), Opts$.MODULE$.subcommand("projects", "show projects under current directory", Opts$.MODULE$.subcommand$default$3(), projectNames$1.map((Function1 & Serializable)projectNames -> () -> {
                    Right$ right$ = scala.package$.MODULE$.Right();
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])projectNames), (Function1 & Serializable)x$5 -> x$5.value(), ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)x$6 -> {
                        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)started$1.logger()), (Function0 & Serializable)() -> new Text((Object)x$6, "_"), Formatter$.MODULE$.StringFormatter(), new Line(147), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.hasBuildOpts ret allCommands"));
                        return BoxedUnit.UNIT;
                    });
                    return right$.apply((Object)BoxedUnit.UNIT);
                })), Opts$.MODULE$.subcommand("projects-test", "show test projects under current directory", Opts$.MODULE$.subcommand$default$3(), testProjectNames$1.map((Function1 & Serializable)projectNames -> () -> {
                    Right$ right$ = scala.package$.MODULE$.Right();
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])projectNames), (Function1 & Serializable)x$7 -> x$7.value(), ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)x$8 -> {
                        LoggerFn.Syntax$.MODULE$.info$extension(LoggerFn$.MODULE$.Syntax((LoggerFn)started$1.logger()), (Function0 & Serializable)() -> new Text((Object)x$8, "_"), Formatter$.MODULE$.StringFormatter(), new Line(150), new File("/home/runner/work/bleep/bleep/bleep-cli/src/scala/bleep/Main.scala"), new Enclosing("bleep.Main.hasBuildOpts ret allCommands"));
                        return BoxedUnit.UNIT;
                    });
                    return right$.apply((Object)BoxedUnit.UNIT);
                })), this.importCmd((BuildLoader)started$1.prebootstrapped().existingBuild(), started$1.buildPaths(), (TypedLogger<BoxedUnit>)started$1.logger()), this.compileServerCmd((TypedLogger<BoxedUnit>)started$1.prebootstrapped().logger(), started$1.prebootstrapped().userPaths()), this.installTabCompletions((TypedLogger<BoxedUnit>)started$1.prebootstrapped().logger()), Opts$.MODULE$.subcommand("publish-local", "publishes your project locally", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple5Semigroupal(new Tuple5((Object)Opts$.MODULE$.option("groupId", "organization you will publish under", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readString()), (Object)Opts$.MODULE$.option("version", "version you will publish", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readString()), (Object)Opts$.MODULE$.option("to", new StringBuilder(28).append("specify a folder other than ").append(constants$.MODULE$.ivy2Path()).toString(), Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readPath()).orNone(), (Object)Opts$.MODULE$.flag("maven-layout", "publish with maven layout instead of ivy", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4()).orFalse((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)projectNames$1)).mapN((Function5 & Serializable)(x0$2, x1$2, x2$2, x3$1, x4$1) -> Main$.$anonfun$hasBuildOpts$31(started$1, x0$2, x1$2, x2$2, BoxesRunTime.unboxToBoolean((Object)x3$1), x4$1), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("dist", "creates a folder with a runnable distribution", Opts$.MODULE$.subcommand$default$3(), (Opts)package.apply$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3((Object)projectName$1, (Object)mainClass$1, (Object)Opts$.MODULE$.argument("path", Argument$.MODULE$.readPath()).orNone())).mapN((Function3 & Serializable)(x0$3, x1$3, x2$3) -> {
                    Tuple3 tuple3 = new Tuple3(x0$3, x1$3, x2$3);
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    CrossProjectName projectName = (CrossProjectName)tuple3._1();
                    Option mainClass = (Option)tuple3._2();
                    Option overridePath = (Option)tuple3._3();
                    Dist.Options options = new Dist.Options(projectName, mainClass, overridePath);
                    Dist dist = new Dist(started$1, options);
                    return dist;
                }, (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative())), Opts$.MODULE$.subcommand("fmt", "runs scalafmt", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.flag("check", "ensure that all files are already formatted", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4()).orFalse((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)check -> Main$.$anonfun$hasBuildOpts$33(started$1, BoxesRunTime.unboxToBoolean((Object)check))))})), (Iterable)started$1.build().scripts().map((Function1 & Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String scriptName = ((ScriptName)tuple2._1()).value();
                    Opts opts = Opts$.MODULE$.subcommand(scriptName, new StringBuilder(11).append("run script ").append(scriptName).toString(), Opts$.MODULE$.subcommand$default$3(), MODULE$.stringArgs().map((Function1 & Serializable)args -> new Script(started$1, scriptName, args)));
                    return opts;
                })}));
                opts3 = (Opts)ret$lzy$1.initialize(package.apply$.MODULE$.catsSyntaxApply(CommonOpts$.MODULE$.opts(), (Apply)Opts$.MODULE$.alternative()).$times$greater(NestedFoldableOps$.MODULE$.foldK$extension(package.foldable$.MODULE$.catsSyntaxNestedFoldable(allCommands.flatten(Predef$.MODULE$.$conforms()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList(), (MonoidK)Opts$.MODULE$.alternative())));
            }
            opts2 = opts3;
        }
        return opts2;
    }

    private final Opts ret$1(LazyRef ret$lzy$1, Started started$1, Opts projectNames$1, Opts projectNamesNoCross$1, Opts testProjectNames$1, Opts projectName$1, Opts mainClass$1) {
        return ret$lzy$1.initialized() ? (Opts)ret$lzy$1.value() : this.ret$lzycompute$1(ret$lzy$1, started$1, projectNames$1, projectNamesNoCross$1, testProjectNames$1, projectName$1, mainClass$1);
    }

    public static final /* synthetic */ Text $anonfun$maybeRunWithDifferentVersion$1(String wantedVersion$1, BuildLoader.Existing x4$1) {
        return new Text((Object)new StringBuilder(70).append("Not launching Bleep version ").append(wantedVersion$1).append(" (from ").append(x4$1.bleepYaml()).append(") because you're running a snapshot").toString(), "s\"Not launching Bleep version ${wantedVersion.value} (from ${existing.bleepYaml}) because you're running a snapshot\"");
    }

    public static final /* synthetic */ Text $anonfun$maybeRunWithDifferentVersion$2(String wantedVersion$2, BuildLoader.Existing x4$1) {
        return new Text((Object)new StringBuilder(64).append("Not launching Bleep version ").append(wantedVersion$2).append(" (from ").append(x4$1.bleepYaml()).append(") because you specified --dev").toString(), "s\"Not launching Bleep version ${wantedVersion.value} (from ${existing.bleepYaml}) because you specified --dev\"");
    }

    public static final /* synthetic */ Text $anonfun$maybeRunWithDifferentVersion$3(String wantedVersion$3, BuildLoader.Existing x4$1) {
        return new Text((Object)new StringBuilder(41).append("Launching Bleep version ").append(wantedVersion$3).append(" as requested in ").append(x4$1.bleepYaml()).toString(), "s\"Launching Bleep version ${wantedVersion.value} as requested in ${existing.bleepYaml}\"");
    }

    public static final /* synthetic */ String $anonfun$maybeRunWithDifferentVersion$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        String string = new StringBuilder(1).append(k).append("=").append(v).toString();
        return string;
    }

    public static final /* synthetic */ void $anonfun$main$7(BuildLoader buildLoader$2, UserPaths userPaths$2, BuildPaths buildPaths$3, TypedLogger logger) {
        BoxedUnit boxedUnit;
        Either either = buildLoader$2.existing().map((Function1 & Serializable)existing -> new Prebootstrapped(logger, userPaths$2, buildPaths$3, existing));
        if (either instanceof Left) {
            Left left = (Left)either;
            BleepException be = (BleepException)left.value();
            throw fatal$.MODULE$.apply("", logger, (Throwable)be);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Prebootstrapped pre = (Prebootstrapped)right.value();
            try {
                BspImpl$.MODULE$.run(pre);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable th) {
                throw fatal$.MODULE$.apply("uncaught error", logger, th);
            }
        } else {
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final TypedLoggerResource stdoutAndFileLogging$1(BuildPaths buildPaths, boolean logAsJson$1, TypedLogger stdout$1) {
        TypedLoggerResource typedLoggerResource;
        if (logAsJson$1) {
            typedLoggerResource = package$.MODULE$.LoggerResource().pure(TypedLogger.LoggerAuxSyntax$.MODULE$.untyped$extension(TypedLogger$.MODULE$.LoggerAuxSyntax(stdout$1)));
        } else {
            TypedLoggerResource logFileResource = TypedLoggerResource.Ops$.MODULE$.map$extension(TypedLoggerResource$.MODULE$.Ops(package$.MODULE$.path(buildPaths.logFile(), (Pattern)LogPatterns.logFile$.MODULE$, package$.MODULE$.path$default$3())), (Function1 & Serializable)x$15 -> TypedLogger.LoggerFlushableSyntax$.MODULE$.flushing$extension(TypedLogger$.MODULE$.LoggerFlushableSyntax(x$15)));
            typedLoggerResource = TypedLoggerResource.Ops$.MODULE$.untyped$extension(TypedLoggerResource$.MODULE$.Ops(TypedLoggerResource.Ops$.MODULE$.zipWith$extension(TypedLoggerResource$.MODULE$.Ops(package$.MODULE$.LoggerResource().pure(stdout$1)), logFileResource)));
        }
        return typedLoggerResource;
    }

    public static final /* synthetic */ void $anonfun$main$11(UserPaths userPaths$2, BuildPaths buildPaths$4, BuildLoader.Existing x3$1, List restArgs$1, TypedLogger logger) {
        Prebootstrapped pre = new Prebootstrapped(logger, userPaths$2, buildPaths$4, x3$1);
        Lazy bleepConfig = BleepConfigOps$.MODULE$.lazyForceLoad(pre.userPaths());
        Either either = bootstrap$.MODULE$.from(pre, GenBloopFiles$.MODULE$.SyncToDisk(), (List)scala.package$.MODULE$.Nil(), bleepConfig, (CoursierResolver.Factory)CoursierResolver.Factory$.default$.MODULE$);
        if (either instanceof Left) {
            Left left = (Left)either;
            BleepException th = (BleepException)left.value();
            throw fatal$.MODULE$.apply("Error while loading build", logger, (Throwable)th);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        Started started = (Started)right.value();
        MODULE$.run((TypedLogger<BoxedUnit>)logger, MODULE$.hasBuildOpts(started), (List<String>)restArgs$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Main$() {
    }
}

