/*
 * Decompiled with CFR 0.152.
 */
package bleep;

import bleep.BuildException$;
import bleep.BuildException$ResolveError$;
import bleep.constants$;
import bleep.logging.TypedLogger;
import bleep.model;
import coursier.error.CoursierError;
import java.nio.file.Path;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public abstract class BuildException
extends Exception {
    private final String message;

    public static Nothing$ fatal(String string, TypedLogger<BoxedUnit> typedLogger, Throwable throwable) {
        return BuildException$.MODULE$.fatal(string, typedLogger, throwable);
    }

    public static Throwable $lessinit$greater$default$2() {
        return BuildException$.MODULE$.$lessinit$greater$default$2();
    }

    public BuildException(String message, Throwable cause) {
        this.message = message;
        super(message, cause);
    }

    public String message() {
        return this.message;
    }

    public static class BuildNotFound
    extends BuildException {
        public BuildNotFound(Path cwd) {
            super(new StringBuilder(42).append("Couldn't find ").append(constants$.MODULE$.BuildFileName()).append(" in directories in or above ").append(cwd).toString(), BuildException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static class Cause
    extends BuildException {
        private final Throwable cause;
        private final String error;

        public Cause(Throwable cause, String error) {
            this.cause = cause;
            this.error = error;
            super(error, cause);
        }

        public Throwable cause() {
            return this.cause;
        }

        public String error() {
            return this.error;
        }
    }

    public static class InvalidJson
    extends BuildException {
        public InvalidJson(Path file, Throwable e) {
            super(new StringBuilder(25).append("Couldn't parse json file ").append(file).toString(), e);
        }
    }

    public static class ModuleFormatError
    extends BuildException {
        private final String moduleString;
        private final String error;

        public ModuleFormatError(String moduleString, String error) {
            this.moduleString = moduleString;
            this.error = error;
            super(new StringBuilder(25).append("Error parsing module '").append(moduleString).append("': ").append(error).toString(), BuildException$.MODULE$.$lessinit$greater$default$2());
        }

        public String moduleString() {
            return this.moduleString;
        }

        public String error() {
            return this.error;
        }
    }

    public static class ResolveError
    extends BuildException {
        public static ResolveError apply(CoursierError coursierError, model.CrossProjectName crossProjectName) {
            return BuildException$ResolveError$.MODULE$.apply(coursierError, crossProjectName);
        }

        public ResolveError(CoursierError cause, String context) {
            super(new StringBuilder(33).append("Error resolving dependencies for ").append(context).toString(), (Throwable)cause);
        }
    }

    public static class TargetFolderNotDetermined
    extends BuildException {
        public TargetFolderNotDetermined(model.CrossProjectName projectName) {
            super(new StringBuilder(56).append("Couldn't determine original output directory of project ").append(new model.ProjectName(projectName.name())).toString(), BuildException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static class Text
    extends BuildException {
        public Text(Option<model.CrossProjectName> maybeProject, String str) {
            String string;
            Option<model.CrossProjectName> option = maybeProject;
            if (option instanceof Some) {
                model.CrossProjectName project = (model.CrossProjectName)((Some)option).value();
                string = new StringBuilder(2).append(project.value()).append(": ").append(str).toString();
            } else if (None$.MODULE$.equals(option)) {
                string = str;
            } else {
                throw new MatchError(option);
            }
            super(string, BuildException$.MODULE$.$lessinit$greater$default$2());
        }

        public Text(String str) {
            this((Option<model.CrossProjectName>)None$.MODULE$, str);
        }

        public Text(model.CrossProjectName project, String str) {
            this((Option<model.CrossProjectName>)Some$.MODULE$.apply((Object)project), str);
        }
    }
}

