/*
 * Decompiled with CFR 0.152.
 */
package blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger.builder;

import blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger.valuefields.SwaggerFields;
import io.swagger.models.Model;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.internal.DslProperty;

public final class ValuePropertyBuilder {
    private ValuePropertyBuilder() {
    }

    public static DslProperty createDslValueForProperty(String key, Property property, Map<String, Model> definitions) {
        Object value = ValuePropertyBuilder.createValueForProperty(key, property, definitions);
        return new DslProperty((Object)String.valueOf(value));
    }

    private static Object createValueForProperty(String key, Property property, Map<String, Model> definitions) {
        StringProperty stringProperty;
        if (property.getExample() != null) {
            return ValuePropertyBuilder.postFormatNumericValue(property, property.getExample());
        }
        if (property.getVendorExtensions() != null && property.getVendorExtensions().get(SwaggerFields.X_EXAMPLE.getField()) != null) {
            return ValuePropertyBuilder.postFormatNumericValue(property, property.getVendorExtensions().get(SwaggerFields.X_EXAMPLE.getField()));
        }
        Object defaultValue = ValuePropertyBuilder.getDefaultValue(property);
        if (defaultValue != null) {
            return defaultValue;
        }
        if (property instanceof RefProperty) {
            RefProperty refProperty = (RefProperty)RefProperty.class.cast(property);
            return ValuePropertyBuilder.getJsonForPropertiesConstruct(refProperty.get$ref(), definitions);
        }
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)ArrayProperty.class.cast(property);
            if (arrayProperty.getItems() == null) {
                return new ArrayList<Integer>(Collections.singleton(1));
            }
            return new ArrayList<Object>(Collections.singletonList(ValuePropertyBuilder.createValueForProperty(key, arrayProperty.getItems(), definitions)));
        }
        if (property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numeric = (AbstractNumericProperty)property;
            BigDecimal numericPropertyValue = null;
            if (numeric.getMinimum() != null) {
                numericPropertyValue = numeric.getExclusiveMinimum() != false ? numeric.getMinimum().add(new BigDecimal(1)) : numeric.getMinimum();
            }
            if (numeric.getMaximum() != null) {
                numericPropertyValue = numeric.getExclusiveMaximum() != null ? numeric.getMaximum().subtract(new BigDecimal(1)) : numeric.getMaximum();
            }
            if (numeric instanceof DoubleProperty || numeric instanceof FloatProperty) {
                if (numericPropertyValue != null) {
                    return numericPropertyValue.doubleValue();
                }
                return 1.1;
            }
            if (numeric instanceof LongProperty || numeric instanceof DecimalProperty || numeric instanceof IntegerProperty || numeric instanceof BaseIntegerProperty) {
                if (numericPropertyValue != null) {
                    return numericPropertyValue.longValue();
                }
                return 1;
            }
            return 1;
        }
        if (property instanceof BooleanProperty) {
            return true;
        }
        if (property instanceof StringProperty && (stringProperty = (StringProperty)StringProperty.class.cast(property)).getEnum() != null) {
            return stringProperty.getEnum().get(0);
        }
        return key;
    }

    static Map<String, Object> getJsonForPropertiesConstruct(String reference, Map<String, Model> definitions) {
        String referenceName = reference.substring(reference.lastIndexOf(47) + 1);
        return definitions.get(referenceName).getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ValuePropertyBuilder.createValueForProperty((String)entry.getKey(), (Property)entry.getValue(), definitions)));
    }

    private static Object postFormatNumericValue(Property property, Object value) {
        if (property.getFormat() == null) {
            return value;
        }
        if (value instanceof Double && (property.getFormat().equals(SwaggerFields.INT_32.getField()) || property.getFormat().equals(SwaggerFields.INT_64.getField()))) {
            return ((Double)Double.class.cast(value)).intValue();
        }
        return value;
    }

    private static Object getDefaultValue(Property property) {
        if (property instanceof DoubleProperty) {
            return ((DoubleProperty)DoubleProperty.class.cast(property)).getDefault();
        }
        if (property instanceof FloatProperty) {
            return ((FloatProperty)FloatProperty.class.cast(property)).getDefault();
        }
        if (property instanceof LongProperty) {
            return ((LongProperty)LongProperty.class.cast(property)).getDefault();
        }
        if (property instanceof IntegerProperty) {
            return ((IntegerProperty)IntegerProperty.class.cast(property)).getDefault();
        }
        if (property instanceof BooleanProperty) {
            return ((BooleanProperty)BooleanProperty.class.cast(property)).getDefault();
        }
        if (property instanceof StringProperty) {
            return ((StringProperty)StringProperty.class.cast(property)).getDefault();
        }
        return null;
    }
}

