/*
 * Decompiled with CFR 0.152.
 */
package blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger.builder;

import blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger.valuefields.SwaggerFields;
import io.swagger.models.parameters.AbstractSerializableParameter;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.DslProperty;

public final class DslValueBuilder {
    private DslValueBuilder() {
    }

    public static DslProperty<Object> createDslValueForParameter(AbstractSerializableParameter param) {
        Object value = DslValueBuilder.createServerValueForParameter(param);
        if (value == null) {
            value = DslValueBuilder.createDefaultValueForType(param);
            if (param.pattern == null) {
                Pattern pattern = DslValueBuilder.createPatternForDefaultValue(param);
                return new DslProperty((Object)pattern, value);
            }
        }
        DslProperty dslProperty = param.pattern != null ? new DslProperty((Object)Pattern.compile(param.pattern), value) : new DslProperty(value);
        return dslProperty;
    }

    private static Object createServerValueForParameter(AbstractSerializableParameter param) {
        if (param.getExample() != null) {
            return param.getExample();
        }
        if (param.getVendorExtensions() != null && param.getVendorExtensions().get(SwaggerFields.X_EXAMPLE.getField()) != null) {
            return param.getVendorExtensions().get(SwaggerFields.X_EXAMPLE.getField());
        }
        if (param.getDefaultValue() != null) {
            return param.getDefaultValue();
        }
        if (param.getEnum() != null && param.getEnum().get(0) != null) {
            return param.getEnum().get(0);
        }
        return null;
    }

    private static Pattern createPatternForDefaultValue(AbstractSerializableParameter param) {
        String regex = DslValueBuilder.createRegexForDefaultValue(param);
        return Pattern.compile(regex);
    }

    private static String createRegexForDefaultValue(AbstractSerializableParameter param) {
        String type = param.getType();
        String format = param.getFormat();
        if (SwaggerFields.STRING.getField().equals(type)) {
            return ".+";
        }
        if (SwaggerFields.NUMBER.getField().equals(type) && (SwaggerFields.DOUBLE.getField().equals(format) || SwaggerFields.FLOAT.getField().equals(format))) {
            return "[0-9]+\\.[0-9]+";
        }
        if (SwaggerFields.NUMBER.getField().equals(type)) {
            return "[0-9]+";
        }
        if (SwaggerFields.BOOLEAN.getField().equals(type)) {
            return "(true|false)";
        }
        return ".+";
    }

    private static Object createDefaultValueForType(AbstractSerializableParameter param) {
        String type = param.getType();
        String format = param.getFormat();
        if (SwaggerFields.STRING.getField().equals(type)) {
            if (param.getName() != null && !param.getName().isEmpty()) {
                return param.getName();
            }
            return SwaggerFields.STRING.getField();
        }
        if (SwaggerFields.NUMBER.getField().equals(type) && (SwaggerFields.DOUBLE.getField().equals(format) || SwaggerFields.FLOAT.getField().equals(format))) {
            return 1.1;
        }
        if (SwaggerFields.NUMBER.getField().equals(type)) {
            return 1;
        }
        if (SwaggerFields.BOOLEAN.getField().equals(type)) {
            return true;
        }
        return 1;
    }
}

