/*
 * Decompiled with CFR 0.152.
 */
package blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger;

import blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger.builder.DslValueBuilder;
import blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger.builder.RequestBodyParamBuilder;
import blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger.builder.ResponseBodyBuilder;
import blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger.builder.ValuePropertyBuilder;
import blog.svenbayer.springframework.cloud.contract.verifier.spec.swagger.valuefields.SwaggerFields;
import groovy.lang.Closure;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.QueryParameters;
import org.springframework.cloud.contract.spec.internal.Request;

public final class SwaggerContractConverter
implements ContractConverter<Swagger> {
    public boolean isAccepted(File file) {
        try {
            Swagger swagger = new SwaggerParser().read(file.getPath());
            return swagger != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<Contract> convertFrom(File file) {
        Swagger swagger = new SwaggerParser().read(file.getPath());
        if (swagger == null || swagger.getPaths() == null) {
            return Collections.emptyList();
        }
        AtomicInteger priority = new AtomicInteger();
        return swagger.getPaths().entrySet().stream().flatMap(pathEntry -> {
            String pathLink = (String)pathEntry.getKey();
            return ((Path)pathEntry.getValue()).getOperationMap().entrySet().stream().map(operationEntry -> this.createContract(swagger, priority, pathLink, (Map.Entry<HttpMethod, Operation>)operationEntry));
        }).filter(contract -> !contract.isIgnored()).collect(Collectors.toList());
    }

    private Contract createContract(Swagger swagger, AtomicInteger priority, String pathLink, Map.Entry<HttpMethod, Operation> operationEntry) {
        Contract contract = Contract.make((Closure)Closure.IDENTITY);
        Operation operation = this.createMetaData(priority, operationEntry, contract);
        this.createRequest(swagger, pathLink, operationEntry, contract, operation);
        this.createResponse(swagger, contract, operation);
        return contract;
    }

    private Operation createMetaData(AtomicInteger priority, Map.Entry<HttpMethod, Operation> operationEntry, Contract contract) {
        Operation operation = operationEntry.getValue();
        if (operation.getDescription() != null) {
            contract.description(operation.getDescription());
        }
        if (operation.getTags() != null) {
            contract.setLabel(String.join((CharSequence)"_", operation.getTags()));
        }
        if (operation.getSummary() != null) {
            contract.setName(operation.getSummary());
        }
        contract.setPriority(Integer.valueOf(priority.getAndIncrement()));
        if (operation.getVendorExtensions() != null && operation.getVendorExtensions().get(SwaggerFields.X_IGNORE.getField()) != null && ((Boolean)Boolean.class.cast(operation.getVendorExtensions().get(SwaggerFields.X_IGNORE.getField()))).booleanValue()) {
            contract.setIgnored(true);
        } else {
            contract.setIgnored(false);
        }
        return operation;
    }

    private void createResponse(Swagger swagger, Contract contract, Operation operation) {
        org.springframework.cloud.contract.spec.internal.Response response = new org.springframework.cloud.contract.spec.internal.Response();
        contract.setResponse(response);
        Map.Entry responseEntry = operation.getResponses().entrySet().iterator().next();
        String responseStatus = (String)responseEntry.getKey();
        response.status(Integer.valueOf(responseStatus).intValue());
        response.headers(Closure.IDENTITY);
        Headers responseHeaders = response.getHeaders();
        if (((Response)responseEntry.getValue()).getHeaders() != null) {
            ((Response)responseEntry.getValue()).getHeaders().forEach((key, value) -> {
                if (key != null) {
                    DslProperty serverValue = ValuePropertyBuilder.createDslValueForProperty(key, value, swagger.getDefinitions());
                    responseHeaders.header(key, (Object)serverValue);
                }
            });
        }
        if (operation.getProduces() != null) {
            operation.getProduces().forEach(contentType -> {
                if (contentType.equals("*/*")) {
                    responseHeaders.contentType("");
                } else {
                    responseHeaders.contentType(contentType);
                }
            });
        }
        if (((Response)responseEntry.getValue()).getResponseSchema() != null) {
            String bodyValue = ResponseBodyBuilder.createValueForResponseBody((Response)responseEntry.getValue(), swagger.getDefinitions());
            response.body((Object)bodyValue);
        }
    }

    private void createRequest(Swagger swagger, String pathLink, Map.Entry<HttpMethod, Operation> operationEntry, Contract contract, Operation operation) {
        Request request = new Request();
        contract.setRequest(request);
        HttpMethod httpMethod = operationEntry.getKey();
        if (httpMethod != null) {
            request.method(httpMethod.name());
        }
        if (pathLink != null) {
            request.urlPath(swagger.getBasePath() + pathLink);
            if (operation.getParameters() != null) {
                operation.getParameters().stream().filter(param -> param instanceof PathParameter).map(AbstractSerializableParameter.class::cast).forEach(param -> request.urlPath(request.getUrlPath().getClientValue().toString().replace("{" + param.getName() + "}", param.getName())));
                QueryParameters queryParameters = new QueryParameters();
                request.getUrlPath().setQueryParameters(queryParameters);
                operation.getParameters().stream().filter(param -> param instanceof QueryParameter).map(AbstractSerializableParameter.class::cast).forEach(param -> queryParameters.parameter(param.getName(), DslValueBuilder.createDslValueForParameter(param)));
            }
        }
        request.headers(Closure.IDENTITY);
        Headers requestHeaders = request.getHeaders();
        if (operation.getParameters() != null) {
            operation.getParameters().forEach(param -> {
                BodyParameter bodyParameter;
                Object value;
                if (param instanceof HeaderParameter) {
                    HeaderParameter headerParameter = (HeaderParameter)HeaderParameter.class.cast(param);
                    DslProperty<Object> clientValue = DslValueBuilder.createDslValueForParameter((AbstractSerializableParameter)headerParameter);
                    if (headerParameter.getName() != null) {
                        requestHeaders.header(headerParameter.getName(), clientValue);
                    }
                }
                if (param instanceof BodyParameter && (value = RequestBodyParamBuilder.createDefaultValueForRequestBodyParameter(bodyParameter = (BodyParameter)BodyParameter.class.cast(param), swagger.getDefinitions())) != null) {
                    request.body(value);
                }
            });
        }
        if (operation.getConsumes() != null) {
            operation.getConsumes().forEach(contentType -> {
                if (contentType.equals("*/*")) {
                    requestHeaders.contentType("");
                } else {
                    requestHeaders.contentType(contentType);
                }
            });
        }
    }

    public Swagger convertTo(Collection<Contract> contract) {
        return new Swagger();
    }
}

