/*
 * Decompiled with CFR 0.152.
 */
package blog.svenbayer.cache.refresh.ahead.task;

import blog.svenbayer.cache.refresh.ahead.config.ReloadAheadProperties;
import blog.svenbayer.cache.refresh.ahead.service.ReloadAheadService;
import blog.svenbayer.cache.refresh.ahead.task.ReloadAheadCacheRefreshAheadScheduler;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public class SelectiveCacheRefreshAheadScheduler
implements ReloadAheadCacheRefreshAheadScheduler {
    private ReloadAheadProperties reloadAheadProperties;
    private ReloadAheadService reloadAheadService;

    public SelectiveCacheRefreshAheadScheduler(ReloadAheadProperties reloadAheadProperties, ReloadAheadService reloadAheadService) {
        this.reloadAheadProperties = reloadAheadProperties;
        this.reloadAheadService = reloadAheadService;
    }

    @Override
    @EventListener
    public void refreshCaches(ContextRefreshedEvent event) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        Map<String, Duration> intervalCaches = this.reloadAheadProperties.getRefreshAheadIntervalCaches();
        intervalCaches.forEach((key, value) -> executorService.scheduleAtFixedRate(() -> this.reloadAheadService.reloadAheadValuesOfCache((String)key), 0L, value.getSeconds(), TimeUnit.SECONDS));
    }
}

