/*
 * Decompiled with CFR 0.152.
 */
package blog.svenbayer.cache.refresh.ahead.service;

import blog.svenbayer.cache.refresh.ahead.exception.ReloadAheadException;
import blog.svenbayer.cache.refresh.ahead.model.ReloadAheadKey;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.BeanFactory;

public class ReloadAheadValueReloader {
    private static final Logger logger = LoggerFactory.getLogger(ReloadAheadValueReloader.class);
    private BeanFactory beanFactory;

    public ReloadAheadValueReloader(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object reloadCacheForKey(ReloadAheadKey key) {
        try {
            logger.info("Starting re-population for parameters '{}'", key.getParameters());
            Object proxyBean = this.beanFactory.getBean(Class.forName(key.getInstanceName()));
            Object bean = proxyBean instanceof Advised ? ((Advised)proxyBean).getTargetSource().getTarget() : proxyBean;
            if (bean == null) {
                logger.warn("Bean for cache could not be resolved!");
                return null;
            }
            Class[] methodClazzes = (Class[])Arrays.stream(key.getParameterClazzNames()).map(clazzName -> {
                try {
                    return Class.forName(clazzName);
                }
                catch (ClassNotFoundException ex) {
                    throw new ReloadAheadException("Could not find Class '" + clazzName + "' for parameter!", ex);
                }
            }).toArray(Class[]::new);
            Method method = bean.getClass().getMethod(key.getMethodName(), methodClazzes);
            Object cacheValue = method.invoke(bean, key.getParameters());
            logger.info("Finished re-population for parameters '{}' with value '{}'", (Object)key.getParameters(), cacheValue);
            return cacheValue;
        }
        catch (Exception ex) {
            throw new ReloadAheadException("ReloadError for key " + key, ex);
        }
    }
}

