/*
 * Decompiled with CFR 0.152.
 */
package blog.svenbayer.cache.refresh.ahead.service;

import blog.svenbayer.cache.refresh.ahead.model.ReloadAheadKey;
import blog.svenbayer.cache.refresh.ahead.service.ReloadAheadCacheRetriever;
import blog.svenbayer.cache.refresh.ahead.service.ReloadAheadKeyRetriever;
import blog.svenbayer.cache.refresh.ahead.service.ReloadAheadValueReloader;
import blog.svenbayer.cache.refresh.ahead.service.ReloadAheadValueUpdater;
import java.util.stream.Stream;
import org.springframework.cache.Cache;

public class ReloadAheadService {
    private ReloadAheadCacheRetriever cacheRetriever;
    private ReloadAheadKeyRetriever keyRetriever;
    private ReloadAheadValueReloader valueReloader;
    private ReloadAheadValueUpdater valueUpdater;

    public ReloadAheadService(ReloadAheadCacheRetriever cacheRetriever, ReloadAheadKeyRetriever keyRetriever, ReloadAheadValueReloader valueReloader, ReloadAheadValueUpdater valueUpdater) {
        this.cacheRetriever = cacheRetriever;
        this.keyRetriever = keyRetriever;
        this.valueReloader = valueReloader;
        this.valueUpdater = valueUpdater;
    }

    public void reloadAheadValuesOfCache(String cacheName) {
        Stream<Cache> cacheStream = this.cacheRetriever.retrieveCaches().filter(cache -> cache.getName().equals(cacheName));
        this.reloadAheadCachValuesForStream(cacheStream);
    }

    public void reloadAheadValuesOfCaches() {
        Stream<Cache> cacheStream = this.cacheRetriever.retrieveCaches();
        this.reloadAheadCachValuesForStream(cacheStream);
    }

    private void reloadAheadCachValuesForStream(Stream<Cache> cacheStream) {
        cacheStream.forEach(cache -> this.keyRetriever.retrieveKeysForCache((Cache)cache).forEach(key -> {
            Object value = this.valueReloader.reloadCacheForKey((ReloadAheadKey)key);
            this.valueUpdater.writeValueToCache((Cache)cache, (ReloadAheadKey)key, value);
        }));
    }
}

