/*
 * Decompiled with CFR 0.152.
 */
package blog.softwaretester.properties.propertysource;

import blog.softwaretester.properties.PropertyConverter;
import blog.softwaretester.properties.propertysource.PropertySource;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public final class PropertiesFileSource
extends PropertySource {
    private final String propertiesFilePath;

    public PropertiesFileSource(String propertiesFile, boolean showLogs) {
        super(showLogs);
        this.propertiesFilePath = propertiesFile;
    }

    @Override
    public Map<String, String> getProperties() {
        Properties properties = new Properties();
        this.logInfo("Loading " + this.propertiesFilePath + "...");
        try (FileInputStream propertiesFileInputStream = new FileInputStream(this.propertiesFilePath);){
            properties.load(propertiesFileInputStream);
            this.logInfo("...loaded successfully");
        }
        catch (IOException e) {
            this.logWarning("...ignored: " + e.getMessage());
        }
        return PropertyConverter.propertiesToMap(properties);
    }
}

