/*
 * Decompiled with CFR 0.152.
 */
package blog.softwaretester.properties;

import blog.softwaretester.properties.propertysource.EnvironmentPropertiesSource;
import blog.softwaretester.properties.propertysource.PropertiesClassPathSource;
import blog.softwaretester.properties.propertysource.PropertiesFileSource;
import blog.softwaretester.properties.propertysource.SystemPropertiesSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PropertyAggregator {
    private static final Log LOGGER = LogFactory.getLog(PropertyAggregator.class);
    private final Map<String, String> finalProperties;

    private PropertyAggregator(Builder builder) {
        Map<String, String> processedProperties = this.filterPropertyKeys(builder);
        processedProperties = this.applyCustomPredicates(builder, processedProperties);
        this.addDefaultValues(builder, processedProperties);
        this.finalProperties = processedProperties;
    }

    private void addDefaultValues(Builder builder, Map<String, String> processedProperties) {
        for (Map.Entry<String, String> entry : builder.propertyDefaultValues.entrySet()) {
            if (processedProperties.containsKey(entry.getKey())) continue;
            processedProperties.put(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> applyCustomPredicates(Builder builder, Map<String, String> filteredProperties) {
        Map processedProperties = filteredProperties;
        for (Predicate<? super Map.Entry<String, String>> predicate : builder.predicates) {
            processedProperties = processedProperties.entrySet().stream().filter(predicate).collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
        }
        return processedProperties;
    }

    private Map<String, String> filterPropertyKeys(Builder builder) {
        HashMap<String, String> processedProperties = new HashMap<String, String>();
        builder.finalProperties.forEach((key, value) -> {
            if (builder.filteredKeys.size() == 0 || builder.filteredKeys.contains(key)) {
                processedProperties.put((String)key, (String)value);
            }
        });
        return processedProperties;
    }

    public String getProperty(String key) {
        return this.finalProperties.get(key);
    }

    public int getPropertiesCount() {
        return this.getAllProperties().size();
    }

    public Map<String, String> getAllProperties() {
        return this.finalProperties;
    }

    public Map<String, String> getPropertiesWithCustomPredicate(Predicate<? super Map.Entry<String, String>> predicate) {
        return this.finalProperties.entrySet().stream().filter(predicate).collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    public void logFinalProperties() {
        LOGGER.info((Object)"Properties:");
        this.getAllProperties().keySet().stream().sorted().forEach(key -> LOGGER.info((Object)("- " + key + " => " + this.getProperty((String)key))));
    }

    public static final class Builder {
        private final Map<String, String> finalProperties = new HashMap<String, String>();
        private final List<Predicate<? super Map.Entry<String, String>>> predicates = new ArrayList<Predicate<? super Map.Entry<String, String>>>();
        private List<String> filteredKeys = Collections.emptyList();
        private Map<String, String> propertyDefaultValues = Collections.emptyMap();
        private boolean loggineEnabled;

        public Builder(boolean loggingEnabled) {
            this.loggineEnabled = loggingEnabled;
        }

        public Builder withSystemProperties() {
            this.finalProperties.putAll(new SystemPropertiesSource(this.loggineEnabled).getProperties());
            return this;
        }

        public Builder withEnvironmentProperties() {
            this.finalProperties.putAll(new EnvironmentPropertiesSource(this.loggineEnabled).getProperties());
            return this;
        }

        public Builder withPropertiesFile(String propertiesFilePath) {
            PropertiesFileSource propertiesFileSource = new PropertiesFileSource(propertiesFilePath, this.loggineEnabled);
            this.finalProperties.putAll(propertiesFileSource.getProperties());
            return this;
        }

        public Builder withPropertiesFileInClassPath(String propertiesFilePath) {
            PropertiesClassPathSource propertiesFileSource = new PropertiesClassPathSource(propertiesFilePath, this.loggineEnabled);
            this.finalProperties.putAll(propertiesFileSource.getProperties());
            return this;
        }

        public Builder withFilteredKeys(List<String> keys) {
            this.filteredKeys = keys;
            return this;
        }

        public Builder withCustomPredicate(Predicate<? super Map.Entry<String, String>> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public Builder withDefaultValues(Map<String, String> defaultValues) {
            this.propertyDefaultValues = defaultValues;
            return this;
        }

        public PropertyAggregator build() {
            return new PropertyAggregator(this);
        }
    }
}

