/*
 * Decompiled with CFR 0.152.
 */
package blog.softwaretester.properties.propertysource;

import blog.softwaretester.properties.PropertyConverter;
import blog.softwaretester.properties.propertysource.PropertySource;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PropertiesFileSource
implements PropertySource {
    private static final Log LOGGER = LogFactory.getLog(PropertiesFileSource.class);
    private final String propertiesFilePath;

    public PropertiesFileSource(String propertiesFile) {
        this.propertiesFilePath = propertiesFile;
    }

    @Override
    public Map<String, String> getProperties() {
        Properties properties = new Properties();
        try (FileInputStream propertiesFileInputStream = new FileInputStream(this.propertiesFilePath);){
            properties.load(propertiesFileInputStream);
            LOGGER.info((Object)"...loaded successfully");
        }
        catch (IOException e) {
            LOGGER.warn((Object)("...ignored: " + e.getMessage()));
        }
        return PropertyConverter.propertiesToMap(properties);
    }
}

