/*
 * Decompiled with CFR 0.152.
 */
package blog.softwaretester.properties.propertysource;

import blog.softwaretester.properties.propertysource.PropertiesFileSource;
import blog.softwaretester.properties.propertysource.PropertySource;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PropertiesClassPathSource
implements PropertySource {
    private static final Log LOGGER = LogFactory.getLog(PropertiesClassPathSource.class);
    private final String propertiesFilePath;

    public PropertiesClassPathSource(String propertiesFile) {
        this.propertiesFilePath = propertiesFile;
    }

    @Override
    public Map<String, String> getProperties() {
        URL resource = this.getClass().getClassLoader().getResource(this.propertiesFilePath);
        if (resource == null) {
            LOGGER.warn((Object)("...ignored: " + this.propertiesFilePath + " not found in class path."));
            return Collections.emptyMap();
        }
        return new PropertiesFileSource(resource.getPath()).getProperties();
    }
}

