/*
 * Decompiled with CFR 0.152.
 */
package blog.softwaretester.properties;

import blog.softwaretester.properties.propertysource.EnvironmentPropertiesSource;
import blog.softwaretester.properties.propertysource.PropertiesClassPathSource;
import blog.softwaretester.properties.propertysource.PropertiesFileSource;
import blog.softwaretester.properties.propertysource.SystemPropertiesSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PropertyAggregator {
    private static final Log LOGGER = LogFactory.getLog(PropertyAggregator.class);
    private final Map<String, String> finalProperties;

    private PropertyAggregator(Builder builder) {
        HashMap<String, String> tmpProperties = new HashMap<String, String>();
        builder.finalProperties.forEach((key, value) -> {
            if (builder.filteredKeys.size() == 0 || builder.filteredKeys.contains(key)) {
                tmpProperties.put((String)key, (String)value);
            }
        });
        for (Map.Entry<String, String> entry : builder.propertyDefaultValues.entrySet()) {
            if (tmpProperties.containsKey(entry.getKey())) continue;
            tmpProperties.put(entry.getKey(), entry.getValue());
        }
        this.finalProperties = tmpProperties;
    }

    public String getProperty(String key) {
        return this.finalProperties.get(key);
    }

    public int getPropertiesCount() {
        return this.getAllProperties().size();
    }

    public Map<String, String> getAllProperties() {
        return this.finalProperties;
    }

    public Map<String, String> getPropertiesWithCustomPredicate(Predicate<? super Map.Entry<String, String>> predicate) {
        return this.finalProperties.entrySet().stream().filter(predicate).collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    public void logFinalProperties() {
        LOGGER.info((Object)"Properties:");
        this.getAllProperties().keySet().stream().sorted().forEach(key -> LOGGER.info((Object)("- " + key + " => " + this.getProperty((String)key))));
    }

    public static final class Builder {
        private final Map<String, String> finalProperties = new HashMap<String, String>();
        private List<String> filteredKeys = Collections.emptyList();
        private Map<String, String> propertyDefaultValues = Collections.emptyMap();

        public Builder withSystemProperties() {
            LOGGER.info((Object)"Added system properties source.");
            this.finalProperties.putAll(new SystemPropertiesSource().getProperties());
            return this;
        }

        public Builder withEnvironmentProperties() {
            LOGGER.info((Object)"Added environment properties source.");
            this.finalProperties.putAll(new EnvironmentPropertiesSource().getProperties());
            return this;
        }

        public Builder withPropertiesFile(String propertiesFilePath) {
            PropertiesFileSource propertiesFileSource = new PropertiesFileSource(propertiesFilePath);
            LOGGER.info((Object)("Added properties file " + propertiesFilePath + "."));
            this.finalProperties.putAll(propertiesFileSource.getProperties());
            return this;
        }

        public Builder withPropertiesFileInClassPath(String propertiesFilePath) {
            PropertiesClassPathSource propertiesFileSource = new PropertiesClassPathSource(propertiesFilePath);
            LOGGER.info((Object)("Added properties file in classpath " + propertiesFilePath + "."));
            this.finalProperties.putAll(propertiesFileSource.getProperties());
            return this;
        }

        public Builder withFilteredKeys(List<String> keys) {
            this.filteredKeys = keys;
            return this;
        }

        public Builder withDefaultValues(Map<String, String> defaultValues) {
            this.propertyDefaultValues = defaultValues;
            return this;
        }

        public PropertyAggregator build() {
            return new PropertyAggregator(this);
        }
    }
}

