/*
 * Decompiled with CFR 0.152.
 */
package blog.softwaretester.properties;

import blog.softwaretester.properties.propertysource.EnvironmentPropertiesSource;
import blog.softwaretester.properties.propertysource.PropertiesClassPathSource;
import blog.softwaretester.properties.propertysource.PropertiesFileSource;
import blog.softwaretester.properties.propertysource.SystemPropertiesSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.tinylog.Logger;

public final class PropertyAggregator {
    private final Properties finalProperties;

    private PropertyAggregator(Builder builder) {
        Properties tmpProperties = new Properties();
        builder.finalProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (builder.filteredKeys.size() == 0 || builder.filteredKeys.contains((String)key)) {
                tmpProperties.put(key, value);
            }
        }));
        for (Map.Entry<String, String> entry : builder.propertyDefaultValues.entrySet()) {
            if (tmpProperties.contains(entry.getKey()) || !builder.filteredKeys.contains(entry.getKey())) continue;
            tmpProperties.put(entry.getKey(), entry.getValue());
        }
        this.finalProperties = tmpProperties;
    }

    public String getProperty(String key) {
        return this.finalProperties.getProperty(key);
    }

    public int getPropertiesCount() {
        return this.getAllProperties().stringPropertyNames().size();
    }

    public Properties getAllProperties() {
        return this.finalProperties;
    }

    public Properties getPropertiesWithCustomPredicate(Predicate<? super Map.Entry<String, String>> predicate) {
        HashMap propertyMap = this.finalProperties.entrySet().stream().filter(predicate).collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
        Properties filteredProperties = new Properties();
        filteredProperties.putAll((Map<?, ?>)propertyMap);
        return filteredProperties;
    }

    public void logFinalProperties() {
        Logger.info((Object)"Properties:");
        this.getAllProperties().stringPropertyNames().stream().sorted().forEach(key -> Logger.info((String)"- {} => {}", (Object[])new Object[]{key, this.getProperty((String)key)}));
    }

    public static final class Builder {
        private final Properties finalProperties = new Properties();
        private List<String> filteredKeys = Collections.emptyList();
        private Map<String, String> propertyDefaultValues = Collections.emptyMap();

        public Builder withSystemProperties() {
            Logger.info((Object)"Added system properties source.");
            this.finalProperties.putAll((Map<?, ?>)new SystemPropertiesSource().getProperties());
            return this;
        }

        public Builder withEnvironmentProperties() {
            Logger.info((Object)"Added environment properties source.");
            this.finalProperties.putAll((Map<?, ?>)new EnvironmentPropertiesSource().getProperties());
            return this;
        }

        public Builder withPropertiesFile(String propertiesFilePath) {
            PropertiesFileSource propertiesFileSource = new PropertiesFileSource(propertiesFilePath);
            Logger.info((String)"Added properties file {}.", (Object[])new Object[]{propertiesFilePath});
            this.finalProperties.putAll((Map<?, ?>)propertiesFileSource.getProperties());
            return this;
        }

        public Builder withPropertiesFileInClassPath(String propertiesFilePath) {
            PropertiesClassPathSource propertiesFileSource = new PropertiesClassPathSource(propertiesFilePath);
            Logger.info((String)"Added properties file in classpath {}.", (Object[])new Object[]{propertiesFilePath});
            this.finalProperties.putAll((Map<?, ?>)propertiesFileSource.getProperties());
            return this;
        }

        public Builder withFilteredKeys(List<String> keys) {
            this.filteredKeys = keys;
            return this;
        }

        public Builder withDefaultValues(Map<String, String> defaultValues) {
            this.propertyDefaultValues = defaultValues;
            return this;
        }

        public PropertyAggregator build() {
            return new PropertyAggregator(this);
        }
    }
}

