/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import jep.ClassEnquirer;
import jep.Jep;
import jep.JepException;

public class JepConfig {
    protected boolean interactive = false;
    protected StringBuilder includePath = null;
    protected ClassLoader classLoader = null;
    protected ClassEnquirer classEnquirer = null;
    protected boolean redirectOutputStreams = false;
    protected Set<String> sharedModules = null;

    public JepConfig setInteractive(boolean bl) {
        this.interactive = bl;
        return this;
    }

    public JepConfig setIncludePath(String string) {
        this.includePath = null;
        if (string != null) {
            this.includePath = new StringBuilder(string);
        }
        return this;
    }

    public JepConfig addIncludePaths(String ... stringArray) {
        if (this.includePath == null) {
            this.includePath = new StringBuilder();
        }
        for (String string : stringArray) {
            if (this.includePath.length() > 0) {
                this.includePath.append(File.pathSeparator);
            }
            this.includePath.append(string);
        }
        return this;
    }

    public JepConfig setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public JepConfig setClassEnquirer(ClassEnquirer classEnquirer) {
        this.classEnquirer = classEnquirer;
        return this;
    }

    public JepConfig setRedirectOutputStreams(boolean bl) {
        this.redirectOutputStreams = bl;
        return this;
    }

    public JepConfig setSharedModules(Set<String> set) {
        this.sharedModules = set;
        return this;
    }

    public JepConfig addSharedModules(String ... stringArray) {
        if (this.sharedModules == null) {
            this.sharedModules = new HashSet<String>();
        }
        for (String string : stringArray) {
            this.sharedModules.add(string);
        }
        return this;
    }

    public Jep createJep() throws JepException {
        return new Jep(this);
    }
}

