/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import jep.ClassEnquirer;

public class NamingConventionClassEnquirer
implements ClassEnquirer {
    protected static final List<String> TOP_LEVEL = Collections.unmodifiableList(Arrays.asList("java", "javax", "com", "gov", "org", "edu", "mil", "net"));
    protected Set<String> javaNames;

    public NamingConventionClassEnquirer() {
        this(true);
    }

    public NamingConventionClassEnquirer(boolean bl) {
        this(bl, false);
    }

    public NamingConventionClassEnquirer(boolean bl, boolean bl2) {
        if (bl2) {
            String[] stringArray = Locale.getISOCountries();
            if (bl) {
                this.javaNames = new HashSet<String>(stringArray.length + TOP_LEVEL.size());
                this.javaNames.addAll(TOP_LEVEL);
            } else {
                this.javaNames = new HashSet<String>(stringArray.length);
            }
            for (String string : stringArray) {
                this.javaNames.add(string.toLowerCase());
            }
            for (String string : ClassEnquirer.RESTRICTED_PKG_NAMES) {
                this.javaNames.remove(string);
            }
        } else {
            this.javaNames = bl ? new HashSet<String>(TOP_LEVEL) : new HashSet<String>();
        }
    }

    public void addTopLevelPackageName(String string) {
        this.javaNames.add(string);
    }

    @Override
    public boolean isJavaPackage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (this.javaNames.contains(string)) {
            return true;
        }
        String[] stringArray = string.split("\\.");
        int n = stringArray.length;
        return n > 0 && this.javaNames.contains(stringArray[0]) && Character.isLowerCase(stringArray[n - 1].charAt(0));
    }

    @Override
    public String[] getClassNames(String string) {
        return null;
    }

    @Override
    public String[] getSubPackages(String string) {
        return null;
    }
}

