package biz.turnonline.ecosystem.widget.billing;

import biz.turnonline.ecosystem.widget.billing.presenter.EditInvoicePresenter;
import biz.turnonline.ecosystem.widget.billing.presenter.EditInvoicePresenter_Factory;
import biz.turnonline.ecosystem.widget.billing.presenter.EditOrderPresenter;
import biz.turnonline.ecosystem.widget.billing.presenter.EditOrderPresenter_Factory;
import biz.turnonline.ecosystem.widget.billing.presenter.InvoicesPresenter;
import biz.turnonline.ecosystem.widget.billing.presenter.InvoicesPresenter_Factory;
import biz.turnonline.ecosystem.widget.billing.presenter.OrdersPresenter;
import biz.turnonline.ecosystem.widget.billing.presenter.OrdersPresenter_Factory;
import biz.turnonline.ecosystem.widget.billing.view.EditInvoiceView;
import biz.turnonline.ecosystem.widget.billing.view.EditInvoiceView_Factory;
import biz.turnonline.ecosystem.widget.billing.view.EditOrderView;
import biz.turnonline.ecosystem.widget.billing.view.EditOrderView_Factory;
import biz.turnonline.ecosystem.widget.billing.view.InvoicesView;
import biz.turnonline.ecosystem.widget.billing.view.InvoicesView_Factory;
import biz.turnonline.ecosystem.widget.billing.view.OrdersView;
import biz.turnonline.ecosystem.widget.billing.view.OrdersView_Factory;
import biz.turnonline.ecosystem.widget.shared.AddressLookupListener;
import biz.turnonline.ecosystem.widget.shared.AppEventBus;
import biz.turnonline.ecosystem.widget.shared.AppEventBus_Factory;
import biz.turnonline.ecosystem.widget.shared.Configuration;
import biz.turnonline.ecosystem.widget.shared.rest.account.AccountStewardFacade;
import biz.turnonline.ecosystem.widget.shared.rest.bill.BillFacade;
import biz.turnonline.ecosystem.widget.shared.rest.billing.ProductBillingFacade;
import biz.turnonline.ecosystem.widget.shared.rest.payment.PaymentProcessorFacade;
import biz.turnonline.ecosystem.widget.shared.rest.search.SearchFacade;
import biz.turnonline.ecosystem.widget.shared.ui.ScaffoldBreadcrumb;
import com.google.gwt.activity.shared.ActivityManager;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import dagger.internal.DoubleCheck;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerBillingComponent implements BillingComponent {
  private Provider<AccountStewardFacade> provideContactFacadeProvider;

  private Provider<ProductBillingFacade> provideProductBillingProvider;

  private Provider<SearchFacade> provideSearchFacadeProvider;

  private Provider<BillFacade> provideBillFacadeProvider;

  private Provider<PaymentProcessorFacade> providePaymentProcessorProvider;

  private Provider<Configuration> provideConfigurationProvider;

  private Provider<AppEventBus> appEventBusProvider;

  private Provider<PlaceController> providePlaceControllerProvider;

  private Provider<PlaceHistoryHandler> providePlaceHistoryHandlerProvider;

  private Provider<ScaffoldBreadcrumb> provideOrdersBreadcrumbProvider;

  private Provider<OrdersView> ordersViewProvider;

  private Provider<OrdersPresenter.IView> provideOrdersViewProvider;

  private Provider<OrdersPresenter> ordersPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideEditOrderBreadcrumbProvider;

  private Provider<AddressLookupListener> provideAddressLookupListenerProvider;

  private Provider<EditOrderView> editOrderViewProvider;

  private Provider<EditOrderPresenter.IView> provideEditOrderViewProvider;

  private Provider<EditOrderPresenter> editOrderPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideInvoicesBreadcrumbProvider;

  private Provider<InvoicesView> invoicesViewProvider;

  private Provider<InvoicesPresenter.IView> provideInvoicesViewProvider;

  private Provider<InvoicesPresenter> invoicesPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideEditInvoiceBreadcrumbProvider;

  private Provider<EditInvoiceView> editInvoiceViewProvider;

  private Provider<EditInvoicePresenter.IView> provideEditInvoiceViewProvider;

  private Provider<EditInvoicePresenter> editInvoicePresenterProvider;

  private Provider<BillingController> billingControllerProvider;

  private Provider<ActivityMapper> provideActivityMapperProvider;

  private Provider<ActivityManager> provideActivityManagerProvider;

  private DaggerBillingComponent() {

    initialize();
  }

  public static Builder builder() {
    return new Builder();
  }

  public static BillingComponent create() {
    return new Builder().build();
  }

  @SuppressWarnings("unchecked")
  private void initialize() {
    this.provideContactFacadeProvider = DoubleCheck.provider(BillingModule_ProvideContactFacadeFactory.create());
    this.provideProductBillingProvider = DoubleCheck.provider(BillingModule_ProvideProductBillingFactory.create());
    this.provideSearchFacadeProvider = DoubleCheck.provider(BillingModule_ProvideSearchFacadeFactory.create());
    this.provideBillFacadeProvider = DoubleCheck.provider(BillingModule_ProvideBillFacadeFactory.create());
    this.providePaymentProcessorProvider = DoubleCheck.provider(BillingModule_ProvidePaymentProcessorFactory.create());
    this.provideConfigurationProvider = DoubleCheck.provider(BillingModule_ProvideConfigurationFactory.create());
    this.appEventBusProvider = DoubleCheck.provider(AppEventBus_Factory.create(provideContactFacadeProvider, provideProductBillingProvider, provideSearchFacadeProvider, provideBillFacadeProvider, providePaymentProcessorProvider, provideConfigurationProvider));
    this.providePlaceControllerProvider = DoubleCheck.provider(BillingModule_ProvidePlaceControllerFactory.create((Provider) appEventBusProvider));
    this.providePlaceHistoryHandlerProvider = DoubleCheck.provider(BillingModule_ProvidePlaceHistoryHandlerFactory.create(BillingModule_ProvidePlaceHistoryMapperFactory.create(), BillingModule_ProvideHistorianFactory.create(), providePlaceControllerProvider, (Provider) appEventBusProvider));
    this.provideOrdersBreadcrumbProvider = DoubleCheck.provider(BillingModule_ProvideOrdersBreadcrumbFactory.create(providePlaceControllerProvider));
    this.ordersViewProvider = OrdersView_Factory.create(provideOrdersBreadcrumbProvider);
    this.provideOrdersViewProvider = DoubleCheck.provider((Provider) ordersViewProvider);
    this.ordersPresenterProvider = OrdersPresenter_Factory.create(provideOrdersViewProvider, providePlaceControllerProvider);
    this.provideEditOrderBreadcrumbProvider = DoubleCheck.provider(BillingModule_ProvideEditOrderBreadcrumbFactory.create(providePlaceControllerProvider));
    this.provideAddressLookupListenerProvider = DoubleCheck.provider(BillingModule_ProvideAddressLookupListenerFactory.create(provideConfigurationProvider));
    this.editOrderViewProvider = EditOrderView_Factory.create(providePlaceControllerProvider, provideEditOrderBreadcrumbProvider, provideAddressLookupListenerProvider);
    this.provideEditOrderViewProvider = DoubleCheck.provider((Provider) editOrderViewProvider);
    this.editOrderPresenterProvider = EditOrderPresenter_Factory.create(provideEditOrderViewProvider, providePlaceControllerProvider);
    this.provideInvoicesBreadcrumbProvider = DoubleCheck.provider(BillingModule_ProvideInvoicesBreadcrumbFactory.create(providePlaceControllerProvider));
    this.invoicesViewProvider = InvoicesView_Factory.create(provideInvoicesBreadcrumbProvider);
    this.provideInvoicesViewProvider = DoubleCheck.provider((Provider) invoicesViewProvider);
    this.invoicesPresenterProvider = InvoicesPresenter_Factory.create(provideInvoicesViewProvider, providePlaceControllerProvider);
    this.provideEditInvoiceBreadcrumbProvider = DoubleCheck.provider(BillingModule_ProvideEditInvoiceBreadcrumbFactory.create(providePlaceControllerProvider));
    this.editInvoiceViewProvider = EditInvoiceView_Factory.create(providePlaceControllerProvider, provideEditInvoiceBreadcrumbProvider, provideAddressLookupListenerProvider);
    this.provideEditInvoiceViewProvider = DoubleCheck.provider((Provider) editInvoiceViewProvider);
    this.editInvoicePresenterProvider = EditInvoicePresenter_Factory.create(provideEditInvoiceViewProvider, providePlaceControllerProvider);
    this.billingControllerProvider = BillingController_Factory.create(ordersPresenterProvider, editOrderPresenterProvider, invoicesPresenterProvider, editInvoicePresenterProvider);
    this.provideActivityMapperProvider = DoubleCheck.provider((Provider) billingControllerProvider);
    this.provideActivityManagerProvider = DoubleCheck.provider(BillingModule_ProvideActivityManagerFactory.create(provideActivityMapperProvider, (Provider) appEventBusProvider));
  }

  @Override
  public AppEventBus getEventBus() {
    return appEventBusProvider.get();}

  @Override
  public PlaceHistoryHandler placeHistoryHandler() {
    return providePlaceHistoryHandlerProvider.get();}

  @Override
  public ActivityManager getActivityManager() {
    return provideActivityManagerProvider.get();}

  public static final class Builder {
    private Builder() {
    }

    public BillingComponent build() {
      return new DaggerBillingComponent();
    }
  }
}
