/*
 *  Copyright (c) 2020 TurnOnline.biz s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package biz.turnonline.ecosystem.widget.shared.rest.account;

import biz.turnonline.ecosystem.widget.shared.rest.RelevantNullChecker;

import java.util.function.Consumer;

public class AccountBusiness
        implements RelevantNullChecker
{
    private String businessName;

    private String legalForm;

    private String street;

    private String city;

    private String domicile;

    private String postcode;

    private Double latitude;

    private Double longitude;

    private String companyId;

    private String taxId;

    private Boolean vatPayer;

    private String vatId;

    private Domain domain;

    private Image logo;

    /**
     * The company business name. It's mandatory for business account sign-up.
     **/
    public AccountBusiness businessName( String businessName )
    {
        this.businessName = businessName;
        return this;
    }

    public String getBusinessName()
    {
        return businessName;
    }

    public void setBusinessName( String businessName )
    {
        this.businessName = businessName;
    }

    /**
     * The company legal form. It's case insensitive.
     **/
    public AccountBusiness legalForm( String legalForm )
    {
        this.legalForm = legalForm;
        return this;
    }

    public String getLegalForm()
    {
        return legalForm;
    }

    public void setLegalForm( String legalForm )
    {
        this.legalForm = legalForm;
    }

    /**
     * The company street and street number.
     **/
    public AccountBusiness street( String street )
    {
        this.street = street;
        return this;
    }

    public String getStreet()
    {
        return street;
    }

    public void setStreet( String street )
    {
        this.street = street;
    }

    /**
     * The company domicile city.
     **/
    public AccountBusiness city( String city )
    {
        this.city = city;
        return this;
    }

    public String getCity()
    {
        return city;
    }

    public void setCity( String city )
    {
        this.city = city;
    }

    /**
     * The country of residence of the company, ISO 3166 alpha-2 country code. It's case insensitive. Technically it's same as country but the supported list is limited.  If the account represents a STANDARD one, the country list is not limited. The effective check would be performed in case, the account is supposed to be converted to SELLER one.   It's mandatory for business account sign-up.
     **/
    public AccountBusiness domicile( String domicile )
    {
        this.domicile = domicile;
        return this;
    }

    public String getDomicile()
    {
        return domicile;
    }

    public void setDomicile( String domicile )
    {
        this.domicile = domicile;
    }

    /**
     * The company postal code.
     **/
    public AccountBusiness postcode( String postcode )
    {
        this.postcode = postcode;
        return this;
    }

    public String getPostcode()
    {
        return postcode;
    }

    public void setPostcode( String postcode )
    {
        this.postcode = postcode;
    }

    /**
     * The company address latitude geographic coordinate, generated by the service.
     **/
    public AccountBusiness latitude( Double latitude )
    {
        this.latitude = latitude;
        return this;
    }

    public Double getLatitude()
    {
        return latitude;
    }

    public void setLatitude( Double latitude )
    {
        this.latitude = latitude;
    }

    /**
     * The company address longitude geographic coordinate, generated by the service.
     **/
    public AccountBusiness longitude( Double longitude )
    {
        this.longitude = longitude;
        return this;
    }

    public Double getLongitude()
    {
        return longitude;
    }

    public void setLongitude( Double longitude )
    {
        this.longitude = longitude;
    }

    /**
     * The company business identification number.
     **/
    public AccountBusiness companyId( String companyId )
    {
        this.companyId = companyId;
        return this;
    }

    public String getCompanyId()
    {
        return companyId;
    }

    public void setCompanyId( String companyId )
    {
        this.companyId = companyId;
    }

    /**
     * The company tax payer identification number.
     **/
    public AccountBusiness taxId( String taxId )
    {
        this.taxId = taxId;
        return this;
    }

    public String getTaxId()
    {
        return taxId;
    }

    public void setTaxId( String taxId )
    {
        this.taxId = taxId;
    }

    /**
     * The boolean indication whether company is registered as VAT payer. The missing value or false means company it's not a VAT payer.
     **/
    public AccountBusiness vatPayer( Boolean vatPayer )
    {
        this.vatPayer = vatPayer;
        return this;
    }

    public Boolean getVatPayer()
    {
        return vatPayer;
    }

    public void setVatPayer( Boolean vatPayer )
    {
        this.vatPayer = vatPayer;
    }

    /**
     * The company value added tax identification number (VAT ID). Mandatory if vatPayer property is true.
     **/
    public AccountBusiness vatId( String vatId )
    {
        this.vatId = vatId;
        return this;
    }

    public String getVatId()
    {
        return vatId;
    }

    public void setVatId( String vatId )
    {
        this.vatId = vatId;
    }

    /**
     * The account default domain. It might be selected only from existing list of domains, otherwise validation error will be thrown.  In order to set an account default domain (POST), provide a domain unique name from an existing list (Domain.name property).
     **/
    public AccountBusiness domain( Domain domain )
    {
        this.domain = domain;
        return this;
    }

    public Domain getDomain()
    {
        return domain;
    }

    public void setDomain( Domain domain )
    {
        this.domain = domain;
    }

    /**
     * The company logo.
     **/
    public AccountBusiness logo( Image logo )
    {
        this.logo = logo;
        return this;
    }

    public Image getLogo()
    {
        return logo;
    }

    public void setLogo( Image logo )
    {
        this.logo = logo;
    }

    /**
     * @see #setIfNotAllNull(Consumer, RelevantNullChecker)
     */
    public boolean setLogoIf( Image logo )
    {
        return setIfNotAllNull( this::setLogo, logo );
    }

    @Override
    public boolean allNull()
    {
        return allNull( businessName, legalForm, companyId, taxId, vatPayer, vatId, domain, logo, street, city,
                postcode, domicile );
    }
}

