package biz.turnonline.ecosystem.widget.purchase;

import biz.turnonline.ecosystem.widget.purchase.presenter.BillsPresenter;
import biz.turnonline.ecosystem.widget.purchase.presenter.BillsPresenter_Factory;
import biz.turnonline.ecosystem.widget.purchase.presenter.EditBillPresenter;
import biz.turnonline.ecosystem.widget.purchase.presenter.EditBillPresenter_Factory;
import biz.turnonline.ecosystem.widget.purchase.presenter.ExpensesPresenter;
import biz.turnonline.ecosystem.widget.purchase.presenter.ExpensesPresenter_Factory;
import biz.turnonline.ecosystem.widget.purchase.presenter.IncomingInvoiceDetailsPresenter;
import biz.turnonline.ecosystem.widget.purchase.presenter.IncomingInvoiceDetailsPresenter_Factory;
import biz.turnonline.ecosystem.widget.purchase.presenter.PurchaseOrderDetailsPresenter;
import biz.turnonline.ecosystem.widget.purchase.presenter.PurchaseOrderDetailsPresenter_Factory;
import biz.turnonline.ecosystem.widget.purchase.presenter.PurchaseOrdersPresenter;
import biz.turnonline.ecosystem.widget.purchase.presenter.PurchaseOrdersPresenter_Factory;
import biz.turnonline.ecosystem.widget.purchase.view.BillsView;
import biz.turnonline.ecosystem.widget.purchase.view.BillsView_Factory;
import biz.turnonline.ecosystem.widget.purchase.view.EditBillView;
import biz.turnonline.ecosystem.widget.purchase.view.EditBillView_Factory;
import biz.turnonline.ecosystem.widget.purchase.view.ExpensesView;
import biz.turnonline.ecosystem.widget.purchase.view.ExpensesView_Factory;
import biz.turnonline.ecosystem.widget.purchase.view.IncomingInvoiceDetailsView;
import biz.turnonline.ecosystem.widget.purchase.view.IncomingInvoiceDetailsView_Factory;
import biz.turnonline.ecosystem.widget.purchase.view.PurchaseOrderDetailsView;
import biz.turnonline.ecosystem.widget.purchase.view.PurchaseOrderDetailsView_Factory;
import biz.turnonline.ecosystem.widget.purchase.view.PurchaseOrdersView;
import biz.turnonline.ecosystem.widget.purchase.view.PurchaseOrdersView_Factory;
import biz.turnonline.ecosystem.widget.shared.AddressLookupListener;
import biz.turnonline.ecosystem.widget.shared.AppEventBus;
import biz.turnonline.ecosystem.widget.shared.AppEventBus_Factory;
import biz.turnonline.ecosystem.widget.shared.Configuration;
import biz.turnonline.ecosystem.widget.shared.rest.account.AccountStewardFacade;
import biz.turnonline.ecosystem.widget.shared.rest.bill.BillFacade;
import biz.turnonline.ecosystem.widget.shared.rest.billing.ProductBillingFacade;
import biz.turnonline.ecosystem.widget.shared.rest.payment.PaymentProcessorFacade;
import biz.turnonline.ecosystem.widget.shared.rest.search.SearchFacade;
import biz.turnonline.ecosystem.widget.shared.ui.ScaffoldBreadcrumb;
import com.google.gwt.activity.shared.ActivityManager;
import com.google.gwt.activity.shared.ActivityMapper;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import dagger.internal.DoubleCheck;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerPurchaseComponent implements PurchaseComponent {
  private Provider<AccountStewardFacade> provideAccountStewardProvider;

  private Provider<ProductBillingFacade> provideProductBillingProvider;

  private Provider<SearchFacade> provideSearchFacadeProvider;

  private Provider<BillFacade> provideBillFacadeProvider;

  private Provider<PaymentProcessorFacade> providePaymentProcessorProvider;

  private Provider<Configuration> provideConfigurationProvider;

  private Provider<AppEventBus> appEventBusProvider;

  private Provider<PlaceController> providePlaceControllerProvider;

  private Provider<PlaceHistoryHandler> providePlaceHistoryHandlerProvider;

  private Provider<ScaffoldBreadcrumb> providePurchaseOrdersBreadcrumbProvider;

  private Provider<PurchaseOrdersView> purchaseOrdersViewProvider;

  private Provider<PurchaseOrdersPresenter.IView> providePurchaseOrdersViewProvider;

  private Provider<PurchaseOrdersPresenter> purchaseOrdersPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideViewPurchaseOrderBreadcrumbProvider;

  private Provider<PurchaseOrderDetailsView> purchaseOrderDetailsViewProvider;

  private Provider<PurchaseOrderDetailsPresenter.IView> providePurchaseOrderDetailsViewProvider;

  private Provider<PurchaseOrderDetailsPresenter> purchaseOrderDetailsPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideIncomingInvoicesBreadcrumbProvider;

  private Provider<ExpensesView> expensesViewProvider;

  private Provider<ExpensesPresenter.IView> provideIncomingInvoicesViewProvider;

  private Provider<ExpensesPresenter> expensesPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideViewIncomingInvoiceBreadcrumbProvider;

  private Provider<IncomingInvoiceDetailsView> incomingInvoiceDetailsViewProvider;

  private Provider<IncomingInvoiceDetailsPresenter.IView> provideIncomingInvoiceDetailsViewProvider;

  private Provider<IncomingInvoiceDetailsPresenter> incomingInvoiceDetailsPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideBillsBreadcrumbProvider;

  private Provider<BillsView> billsViewProvider;

  private Provider<BillsPresenter.IView> provideBillsViewProvider;

  private Provider<BillsPresenter> billsPresenterProvider;

  private Provider<ScaffoldBreadcrumb> provideEditBillBreadcrumbProvider;

  private Provider<AddressLookupListener> provideAddressLookupListenerProvider;

  private Provider<EditBillView> editBillViewProvider;

  private Provider<EditBillPresenter.IView> provideEditBillViewProvider;

  private Provider<EditBillPresenter> editBillPresenterProvider;

  private Provider<PurchaseController> purchaseControllerProvider;

  private Provider<ActivityMapper> provideActivityMapperProvider;

  private Provider<ActivityManager> provideActivityManagerProvider;

  private DaggerPurchaseComponent() {

    initialize();
  }

  public static Builder builder() {
    return new Builder();
  }

  public static PurchaseComponent create() {
    return new Builder().build();
  }

  @SuppressWarnings("unchecked")
  private void initialize() {
    this.provideAccountStewardProvider = DoubleCheck.provider(PurchaseModule_ProvideAccountStewardFactory.create());
    this.provideProductBillingProvider = DoubleCheck.provider(PurchaseModule_ProvideProductBillingFactory.create());
    this.provideSearchFacadeProvider = DoubleCheck.provider(PurchaseModule_ProvideSearchFacadeFactory.create());
    this.provideBillFacadeProvider = DoubleCheck.provider(PurchaseModule_ProvideBillFacadeFactory.create());
    this.providePaymentProcessorProvider = DoubleCheck.provider(PurchaseModule_ProvidePaymentProcessorFactory.create());
    this.provideConfigurationProvider = DoubleCheck.provider(PurchaseModule_ProvideConfigurationFactory.create());
    this.appEventBusProvider = DoubleCheck.provider(AppEventBus_Factory.create(provideAccountStewardProvider, provideProductBillingProvider, provideSearchFacadeProvider, provideBillFacadeProvider, providePaymentProcessorProvider, provideConfigurationProvider));
    this.providePlaceControllerProvider = DoubleCheck.provider(PurchaseModule_ProvidePlaceControllerFactory.create((Provider) appEventBusProvider));
    this.providePlaceHistoryHandlerProvider = DoubleCheck.provider(PurchaseModule_ProvidePlaceHistoryHandlerFactory.create(PurchaseModule_ProvidePlaceHistoryMapperFactory.create(), PurchaseModule_ProvideHistorianFactory.create(), providePlaceControllerProvider, (Provider) appEventBusProvider));
    this.providePurchaseOrdersBreadcrumbProvider = DoubleCheck.provider(PurchaseModule_ProvidePurchaseOrdersBreadcrumbFactory.create(providePlaceControllerProvider));
    this.purchaseOrdersViewProvider = PurchaseOrdersView_Factory.create(providePurchaseOrdersBreadcrumbProvider);
    this.providePurchaseOrdersViewProvider = DoubleCheck.provider((Provider) purchaseOrdersViewProvider);
    this.purchaseOrdersPresenterProvider = PurchaseOrdersPresenter_Factory.create(providePurchaseOrdersViewProvider, providePlaceControllerProvider);
    this.provideViewPurchaseOrderBreadcrumbProvider = DoubleCheck.provider(PurchaseModule_ProvideViewPurchaseOrderBreadcrumbFactory.create(providePlaceControllerProvider));
    this.purchaseOrderDetailsViewProvider = PurchaseOrderDetailsView_Factory.create(provideViewPurchaseOrderBreadcrumbProvider);
    this.providePurchaseOrderDetailsViewProvider = DoubleCheck.provider((Provider) purchaseOrderDetailsViewProvider);
    this.purchaseOrderDetailsPresenterProvider = PurchaseOrderDetailsPresenter_Factory.create(providePurchaseOrderDetailsViewProvider, providePlaceControllerProvider);
    this.provideIncomingInvoicesBreadcrumbProvider = DoubleCheck.provider(PurchaseModule_ProvideIncomingInvoicesBreadcrumbFactory.create(providePlaceControllerProvider));
    this.expensesViewProvider = ExpensesView_Factory.create(provideIncomingInvoicesBreadcrumbProvider);
    this.provideIncomingInvoicesViewProvider = DoubleCheck.provider((Provider) expensesViewProvider);
    this.expensesPresenterProvider = ExpensesPresenter_Factory.create(provideIncomingInvoicesViewProvider, providePlaceControllerProvider);
    this.provideViewIncomingInvoiceBreadcrumbProvider = DoubleCheck.provider(PurchaseModule_ProvideViewIncomingInvoiceBreadcrumbFactory.create(providePlaceControllerProvider));
    this.incomingInvoiceDetailsViewProvider = IncomingInvoiceDetailsView_Factory.create(provideViewIncomingInvoiceBreadcrumbProvider);
    this.provideIncomingInvoiceDetailsViewProvider = DoubleCheck.provider((Provider) incomingInvoiceDetailsViewProvider);
    this.incomingInvoiceDetailsPresenterProvider = IncomingInvoiceDetailsPresenter_Factory.create(provideIncomingInvoiceDetailsViewProvider, providePlaceControllerProvider);
    this.provideBillsBreadcrumbProvider = DoubleCheck.provider(PurchaseModule_ProvideBillsBreadcrumbFactory.create(providePlaceControllerProvider));
    this.billsViewProvider = BillsView_Factory.create(provideBillsBreadcrumbProvider);
    this.provideBillsViewProvider = DoubleCheck.provider((Provider) billsViewProvider);
    this.billsPresenterProvider = BillsPresenter_Factory.create(provideBillsViewProvider, providePlaceControllerProvider);
    this.provideEditBillBreadcrumbProvider = DoubleCheck.provider(PurchaseModule_ProvideEditBillBreadcrumbFactory.create(providePlaceControllerProvider));
    this.provideAddressLookupListenerProvider = DoubleCheck.provider(PurchaseModule_ProvideAddressLookupListenerFactory.create(provideConfigurationProvider));
    this.editBillViewProvider = EditBillView_Factory.create(provideEditBillBreadcrumbProvider, providePlaceControllerProvider, provideAddressLookupListenerProvider);
    this.provideEditBillViewProvider = DoubleCheck.provider((Provider) editBillViewProvider);
    this.editBillPresenterProvider = EditBillPresenter_Factory.create(provideEditBillViewProvider, providePlaceControllerProvider);
    this.purchaseControllerProvider = PurchaseController_Factory.create(purchaseOrdersPresenterProvider, purchaseOrderDetailsPresenterProvider, expensesPresenterProvider, incomingInvoiceDetailsPresenterProvider, billsPresenterProvider, editBillPresenterProvider);
    this.provideActivityMapperProvider = DoubleCheck.provider((Provider) purchaseControllerProvider);
    this.provideActivityManagerProvider = DoubleCheck.provider(PurchaseModule_ProvideActivityManagerFactory.create(provideActivityMapperProvider, (Provider) appEventBusProvider));
  }

  @Override
  public AppEventBus getEventBus() {
    return appEventBusProvider.get();}

  @Override
  public PlaceHistoryHandler placeHistoryHandler() {
    return providePlaceHistoryHandlerProvider.get();}

  @Override
  public ActivityManager getActivityManager() {
    return provideActivityManagerProvider.get();}

  public static final class Builder {
    private Builder() {
    }

    public PurchaseComponent build() {
      return new DaggerPurchaseComponent();
    }
  }
}
